/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.MemorySizeConfiguratorService;
import com.intellij.diagnostic.VMOptions;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/diagnostic/MemorySizeConfigurator;", "Lcom/intellij/openapi/startup/StartupActivity;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.platform.ide.impl"})
public final class MemorySizeConfigurator
implements StartupActivity {
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    public void runActivity(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return;
        }
        int currentXmx = VMOptions.readOption(VMOptions.MemoryKind.HEAP, true);
        if (currentXmx < 0) {
            currentXmx = VMOptions.readOption(VMOptions.MemoryKind.HEAP, false);
        }
        if (currentXmx < 0) {
            return;
        }
        if (currentXmx > 750) {
            return;
        }
        boolean memoryAdjusted = PropertiesComponent.getInstance().isTrueValue("ide.memory.adjusted");
        if (memoryAdjusted) {
            return;
        }
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystemMXBean == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.sun.management.OperatingSystemMXBean");
        }
        OperatingSystemMXBean osMxBean = (OperatingSystemMXBean)operatingSystemMXBean;
        long totalPhysicalMemory = osMxBean.getTotalPhysicalMemorySize() >> 20;
        int newXmx = MemorySizeConfiguratorService.Companion.getInstance().getSuggestedMemorySize(currentXmx, (int)totalPhysicalMemory);
        int currentXms = VMOptions.readOption(VMOptions.MemoryKind.MIN_HEAP, true);
        if (currentXms < 0) {
            currentXms = VMOptions.readOption(VMOptions.MemoryKind.MIN_HEAP, false);
        }
        if (currentXms < 0 || newXmx < currentXms) {
            return;
        }
        VMOptions.writeOption(VMOptions.MemoryKind.HEAP, newXmx);
        PropertiesComponent.getInstance().setValue("ide.memory.adjusted", true);
        LOG.info("Physical memory " + totalPhysicalMemory + "M, minimum memory size " + currentXms + "M, -Xmx adjusted from " + currentXmx + "M to " + newXmx + 'M');
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(MemorySizeConfigurator.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Memor\u2026Configurator::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/diagnostic/MemorySizeConfigurator$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

