/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithRangeAdjuster;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.SurroundWithLogger;
import com.intellij.codeInsight.template.impl.SurroundWithTemplateHandler;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageSurrounders;
import com.intellij.lang.folding.CustomFoldingSurroundDescriptor;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SurroundWithHandler
implements CodeInsightActionHandler {
    private static final String CHOOSER_TITLE = CodeInsightBundle.message((String)"surround.with.chooser.title", (Object[])new Object[0]);
    public static final TextRange CARET_IS_OK = new TextRange(0, 0);

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            SurroundWithHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            SurroundWithHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            SurroundWithHandler.$$$reportNull$$$0(2);
        }
        SurroundWithHandler.invoke(project, editor, file2, null);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, Surrounder surrounder) {
        if (project == null) {
            SurroundWithHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            SurroundWithHandler.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            SurroundWithHandler.$$$reportNull$$$0(5);
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
            return;
        }
        if (file2 instanceof PsiCompiledElement) {
            HintManager.getInstance().showErrorHint(editor, "Can't modify decompiled code");
            return;
        }
        List<AnAction> applicable = SurroundWithHandler.buildSurroundActions(project, editor, file2, surrounder);
        if (applicable != null) {
            SurroundWithHandler.showPopup(editor, applicable);
        } else if (!ApplicationManager.getApplication().isUnitTestMode()) {
            HintManager.getInstance().showErrorHint(editor, "Couldn't find Surround With variants applicable to the current context");
        }
    }

    @Nullable
    public static List<AnAction> buildSurroundActions(Project project, Editor editor, PsiFile file2, @Nullable Surrounder surrounder) {
        SelectionModel selectionModel = editor.getSelectionModel();
        boolean hasSelection = selectionModel.hasSelection();
        if (!hasSelection) {
            SurroundWithHandler.selectLogicalLineContentsAtCaret(editor);
        }
        int startOffset = selectionModel.getSelectionStart();
        int endOffset = selectionModel.getSelectionEnd();
        PsiElement element1 = file2.findElementAt(startOffset);
        PsiElement element2 = file2.findElementAt(endOffset - 1);
        if (element1 == null || element2 == null) {
            return null;
        }
        TextRange textRange = new TextRange(startOffset, endOffset);
        for (SurroundWithRangeAdjuster adjuster : SurroundWithRangeAdjuster.EP_NAME.getExtensionList()) {
            textRange = adjuster.adjustSurroundWithRange(file2, textRange, hasSelection);
            if (textRange != null) continue;
            return null;
        }
        startOffset = textRange.getStartOffset();
        endOffset = textRange.getEndOffset();
        element1 = file2.findElementAt(startOffset);
        Language baseLanguage = file2.getViewProvider().getBaseLanguage();
        assert (element1 != null);
        Language l = element1.getParent().getLanguage();
        ArrayList<CustomFoldingSurroundDescriptor> surroundDescriptors = new ArrayList<CustomFoldingSurroundDescriptor>(LanguageSurrounders.INSTANCE.allForLanguage(l));
        if (l != baseLanguage) {
            surroundDescriptors.addAll(LanguageSurrounders.INSTANCE.allForLanguage(baseLanguage));
        }
        surroundDescriptors.add(CustomFoldingSurroundDescriptor.INSTANCE);
        int exclusiveCount = 0;
        ArrayList<SurroundDescriptor> exclusiveSurroundDescriptors = new ArrayList<SurroundDescriptor>();
        for (SurroundDescriptor surroundDescriptor : surroundDescriptors) {
            if (!surroundDescriptor.isExclusive()) continue;
            ++exclusiveCount;
            exclusiveSurroundDescriptors.add(surroundDescriptor);
        }
        if (exclusiveCount > 0) {
            surroundDescriptors = exclusiveSurroundDescriptors;
        }
        if (surrounder != null) {
            SurroundWithHandler.invokeSurrounderInTests(project, editor, file2, surrounder, startOffset, endOffset, surroundDescriptors);
            return null;
        }
        LinkedHashMap<Surrounder, PsiElement[]> surrounders = new LinkedHashMap<Surrounder, PsiElement[]>();
        for (SurroundDescriptor surroundDescriptor : surroundDescriptors) {
            PsiElement[] elements2 = surroundDescriptor.getElementsToSurround(file2, startOffset, endOffset);
            if (elements2.length <= 0) continue;
            for (PsiElement psiElement : elements2) {
                assert (psiElement != null) : "descriptor " + surroundDescriptor + " returned null element";
                assert (psiElement.isValid()) : surroundDescriptor;
            }
            for (PsiElement psiElement : surroundDescriptor.getSurrounders()) {
                surrounders.put((Surrounder)psiElement, elements2);
            }
        }
        return SurroundWithHandler.doBuildSurroundActions(project, editor, file2, surrounders);
    }

    public static void selectLogicalLineContentsAtCaret(Editor editor) {
        int caretOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        CharSequence text2 = document.getImmutableCharSequence();
        editor.getSelectionModel().setSelection(CharArrayUtil.shiftForward((CharSequence)text2, (int)DocumentUtil.getLineStartOffset(caretOffset, document), (String)" \t"), CharArrayUtil.shiftBackward((CharSequence)text2, (int)(DocumentUtil.getLineEndOffset(caretOffset, document) - 1), (String)" \t") + 1);
    }

    private static void invokeSurrounderInTests(Project project, Editor editor, PsiFile file2, Surrounder surrounder, int startOffset, int endOffset, List<? extends SurroundDescriptor> surroundDescriptors) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        for (SurroundDescriptor surroundDescriptor : surroundDescriptors) {
            PsiElement[] elements2 = surroundDescriptor.getElementsToSurround(file2, startOffset, endOffset);
            if (elements2.length <= 0) continue;
            for (Surrounder descriptorSurrounder : surroundDescriptor.getSurrounders()) {
                if (!surrounder.getClass().equals(descriptorSurrounder.getClass())) continue;
                WriteCommandAction.runWriteCommandAction((Project)project, () -> SurroundWithHandler.doSurround(project, editor, surrounder, elements2));
                return;
            }
        }
    }

    private static void showPopup(Editor editor, List<AnAction> applicable) {
        DataContext context = DataManager.getInstance().getDataContext((Component)editor.getContentComponent());
        JBPopupFactory.ActionSelectionAid mnemonics = JBPopupFactory.ActionSelectionAid.MNEMONICS;
        DefaultActionGroup group = new DefaultActionGroup(applicable.toArray(AnAction.EMPTY_ARRAY));
        JBPopupFactory.getInstance().createActionGroupPopup(CHOOSER_TITLE, (ActionGroup)group, context, mnemonics, true).showInBestPositionFor(editor);
    }

    static void doSurround(Project project, Editor editor, Surrounder surrounder, PsiElement[] elements2) {
        TextRange range2;
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int col = editor.getCaretModel().getLogicalPosition().column;
        int line2 = editor.getCaretModel().getLogicalPosition().line;
        if (!editor.getCaretModel().supportsMultipleCarets()) {
            LogicalPosition pos = new LogicalPosition(0, 0);
            editor.getCaretModel().moveToLogicalPosition(pos);
        }
        if ((range2 = surrounder.surroundElements(project, editor, elements2)) != CARET_IS_OK) {
            if (TemplateManager.getInstance(project).getActiveTemplate(editor) == null && InplaceRefactoring.getActiveInplaceRenamer(editor) == null) {
                LogicalPosition pos1 = new LogicalPosition(line2, col);
                editor.getCaretModel().moveToLogicalPosition(pos1);
            }
            if (range2 != null) {
                int offset = range2.getStartOffset();
                editor.getCaretModel().removeSecondaryCarets();
                editor.getCaretModel().moveToOffset(offset);
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor.getSelectionModel().setSelection(range2.getStartOffset(), range2.getEndOffset());
            }
        }
    }

    @Nullable
    private static List<AnAction> doBuildSurroundActions(Project project, Editor editor, PsiFile file2, Map<Surrounder, PsiElement[]> surrounders) {
        ArrayList<AnAction> applicable = new ArrayList<AnAction>();
        HashSet<Character> usedMnemonicsSet = new HashSet<Character>();
        int index = 0;
        for (Map.Entry<Surrounder, PsiElement[]> entry : surrounders.entrySet()) {
            PsiElement[] elements2;
            Surrounder surrounder = entry.getKey();
            if (!surrounder.isApplicable(elements2 = entry.getValue())) continue;
            char mnemonic = index < 9 ? (char)((char)(48 + index + 1)) : (index == 9 ? (char)'0' : (char)(65 + index - 10));
            ++index;
            usedMnemonicsSet.add(Character.valueOf(Character.toUpperCase(mnemonic)));
            applicable.add(new InvokeSurrounderAction(surrounder, project, editor, elements2, mnemonic));
        }
        List<AnAction> templateGroup = SurroundWithTemplateHandler.createActionGroup(editor, file2, usedMnemonicsSet);
        if (!templateGroup.isEmpty()) {
            applicable.add((AnAction)new Separator("Live templates"));
            applicable.addAll(templateGroup);
            applicable.add((AnAction)Separator.getInstance());
            applicable.add(new ConfigureTemplatesAction());
        }
        return applicable.isEmpty() ? null : applicable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/generation/surroundWith/SurroundWithHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ConfigureTemplatesAction
    extends AnAction {
        private ConfigureTemplatesAction() {
            super("Configure Live Templates...");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ConfigureTemplatesAction.$$$reportNull$$$0(0);
            }
            ShowSettingsUtil.getInstance().showSettingsDialog((Project)e.getData(CommonDataKeys.PROJECT), "Live Templates");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/generation/surroundWith/SurroundWithHandler$ConfigureTemplatesAction", "actionPerformed"));
        }
    }

    private static class InvokeSurrounderAction
    extends AnAction {
        private final Surrounder mySurrounder;
        private final Project myProject;
        private final Editor myEditor;
        private final PsiElement[] myElements;

        InvokeSurrounderAction(Surrounder surrounder, Project project, Editor editor, PsiElement[] elements2, char mnemonic) {
            super('\u001b' + String.valueOf(mnemonic) + ". " + surrounder.getTemplateDescription());
            this.mySurrounder = surrounder;
            this.myProject = project;
            this.myEditor = editor;
            this.myElements = elements2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                InvokeSurrounderAction.$$$reportNull$$$0(0);
            }
            if (!FileDocumentManager.getInstance().requestWriting(this.myEditor.getDocument(), this.myProject)) {
                return;
            }
            Language language = Language.ANY;
            if (this.myElements != null && this.myElements.length != 0) {
                language = this.myElements[0].getLanguage();
            }
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> SurroundWithHandler.doSurround(this.myProject, this.myEditor, this.mySurrounder, this.myElements));
            SurroundWithLogger.logSurrounder(this.mySurrounder, language, this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/generation/surroundWith/SurroundWithHandler$InvokeSurrounderAction", "actionPerformed"));
        }
    }
}

