/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LanguageWordCompletion;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.util.PsiTreeUtil;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class WordCompletionContributor
extends CompletionContributor
implements DumbAware {
    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            WordCompletionContributor.$$$reportNull$$$0(0);
        }
        if (context.getCompletionType() == CompletionType.BASIC && WordCompletionContributor.isWordCompletionDefinitelyEnabled(context.getFile())) {
            context.setDummyIdentifier("");
        }
    }

    private static boolean isWordCompletionDefinitelyEnabled(@NotNull PsiFile file2) {
        if (file2 == null) {
            WordCompletionContributor.$$$reportNull$$$0(1);
        }
        return DumbService.isDumb((Project)file2.getProject()) || file2 instanceof PsiPlainTextFile && file2.getViewProvider().getLanguages().size() == 1;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            WordCompletionContributor.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            WordCompletionContributor.$$$reportNull$$$0(3);
        }
        if (parameters.getCompletionType() == CompletionType.BASIC && WordCompletionContributor.shouldPerformWordCompletion(parameters)) {
            WordCompletionContributor.addWordCompletionVariants(result2, parameters, Collections.emptySet());
        }
    }

    public static void addWordCompletionVariants(CompletionResultSet result2, CompletionParameters parameters, Set<String> excludes) {
        WordCompletionContributor.addWordCompletionVariants(result2, parameters, excludes, false);
    }

    public static void addWordCompletionVariants(CompletionResultSet result2, CompletionParameters parameters, Set<String> excludes, boolean allowEmptyPrefix) {
        HashSet<String> realExcludes = new HashSet<String>(excludes);
        for (String exclude : excludes) {
            String[] words = exclude.split("[ .-]");
            if (words.length <= 0 || !StringUtil.isNotEmpty((String)words[0])) continue;
            realExcludes.add(words[0]);
        }
        int startOffset = parameters.getOffset();
        PsiElement position = parameters.getPosition();
        CompletionResultSet javaResultSet = result2.withPrefixMatcher(CompletionUtil.findJavaIdentifierPrefix(parameters));
        CompletionResultSet plainResultSet = result2.withPrefixMatcher(CompletionUtil.findAlphanumericPrefix(parameters));
        WordCompletionContributor.consumeAllWords(position, startOffset, word -> {
            if (!realExcludes.contains(word)) {
                LookupElementBuilder item = LookupElementBuilder.create((String)word);
                javaResultSet.addElement((LookupElement)item);
                plainResultSet.addElement((LookupElement)item);
            }
        }, allowEmptyPrefix);
        WordCompletionContributor.addValuesFromOtherStringLiterals(result2, parameters, realExcludes, position);
    }

    private static void addValuesFromOtherStringLiterals(CompletionResultSet result2, CompletionParameters parameters, Set<String> realExcludes, PsiElement position) {
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(position.getLanguage());
        if (definition == null) {
            return;
        }
        PsiElementPattern pattern = PlatformPatterns.psiElement().withElementType(definition.getStringLiteralElements());
        final PsiElement localString = PsiTreeUtil.findFirstParent((PsiElement)position, (boolean)false, arg_0 -> WordCompletionContributor.lambda$addValuesFromOtherStringLiterals$1((ElementPattern)pattern, arg_0));
        if (localString == null) {
            return;
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)localString);
        if (manipulator == null) {
            return;
        }
        int valueStart = manipulator.getRangeInElement(localString).getStartOffset() + localString.getTextRange().getStartOffset();
        if (valueStart > parameters.getOffset()) {
            return;
        }
        PsiFile file2 = position.getContainingFile();
        String prefix = file2.getViewProvider().getContents().subSequence(valueStart, parameters.getOffset()).toString();
        CompletionResultSet fullStringResult = result2.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(prefix));
        file2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((ElementPattern)pattern, realExcludes, fullStringResult){
            final /* synthetic */ ElementPattern val$pattern;
            final /* synthetic */ Set val$realExcludes;
            final /* synthetic */ CompletionResultSet val$fullStringResult;
            {
                this.val$pattern = elementPattern;
                this.val$realExcludes = set;
                this.val$fullStringResult = completionResultSet;
            }

            public void visitElement(PsiElement element) {
                if (element == localString) {
                    return;
                }
                if (this.val$pattern.accepts((Object)element)) {
                    element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                        public void visitElement(PsiElement each) {
                            String valueText = ElementManipulators.getValueText((PsiElement)each);
                            if (StringUtil.isNotEmpty((String)valueText) && !val$realExcludes.contains(valueText)) {
                                LookupElementBuilder item = LookupElementBuilder.create((String)valueText);
                                val$fullStringResult.addElement((LookupElement)item);
                            }
                        }
                    });
                    return;
                }
                super.visitElement(element);
            }
        });
    }

    private static boolean shouldPerformWordCompletion(CompletionParameters parameters) {
        ASTNode textContainer;
        int startOffset;
        PsiReference reference2;
        if (parameters.getInvocationCount() == 0) {
            return false;
        }
        PsiElement insertedElement = parameters.getPosition();
        PsiFile file2 = insertedElement.getContainingFile();
        if (WordCompletionContributor.isWordCompletionDefinitelyEnabled(file2)) {
            return true;
        }
        CompletionData data = CompletionUtil.getCompletionDataByElement(insertedElement, file2);
        if (data != null) {
            HashSet toAdd = new HashSet();
            data.addKeywordVariants(toAdd, insertedElement, file2);
            for (CompletionVariant completionVariant : toAdd) {
                if (!completionVariant.hasKeywordCompletions()) continue;
                return false;
            }
        }
        if ((reference2 = file2.findReferenceAt(startOffset = parameters.getOffset())) != null) {
            return false;
        }
        PsiElement element = file2.findElementAt(startOffset - 1);
        ASTNode aSTNode = textContainer = element != null ? element.getNode() : null;
        while (textContainer != null) {
            if (LanguageWordCompletion.INSTANCE.isEnabledIn(textContainer.getElementType())) {
                return true;
            }
            textContainer = textContainer.getTreeParent();
        }
        return false;
    }

    private static void consumeAllWords(@NotNull PsiElement context, int offset, @NotNull Consumer<? super String> consumer, boolean allowEmptyPrefix) {
        if (context == null) {
            WordCompletionContributor.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            WordCompletionContributor.$$$reportNull$$$0(5);
        }
        if (!allowEmptyPrefix && StringUtil.isEmpty((String)CompletionUtil.findJavaIdentifierPrefix(context, offset))) {
            return;
        }
        CharSequence chars = context.getContainingFile().getViewProvider().getContents();
        THashSet words = new THashSet(chars.length() / 8);
        IdTableBuilding.scanWords((arg_0, arg_1, arg_2, arg_3) -> WordCompletionContributor.lambda$consumeAllWords$2(offset, (Set)words, consumer, arg_0, arg_1, arg_2, arg_3), chars, 0, chars.length());
    }

    private static /* synthetic */ void lambda$consumeAllWords$2(int offset, Set words, Consumer consumer, CharSequence charSeq, char[] charsArray, int start2, int end) {
        CharSequence sequence;
        String str;
        if ((start2 > offset || offset > end) && words.add(str = (sequence = charSeq.subSequence(start2, end)).toString())) {
            consumer.accept(str);
        }
    }

    private static /* synthetic */ boolean lambda$addValuesFromOtherStringLiterals$1(ElementPattern pattern, PsiElement element) {
        return pattern.accepts((Object)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/WordCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCompletion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isWordCompletionDefinitelyEnabled";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "consumeAllWords";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

