/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusFactory;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChangelistConflictFileStatusProvider
implements FileStatusProvider {
    public static final FileStatus MODIFIED_OUTSIDE = FileStatusFactory.getInstance().createFileStatus("modifiedOutside", "Modified in not active changelist");
    public static final FileStatus ADDED_OUTSIDE = FileStatusFactory.getInstance().createFileStatus("addedOutside", "Added in not active changelist");
    public static final FileStatus CHANGELIST_CONFLICT = FileStatusFactory.getInstance().createFileStatus("changelistConflict", "Changelist conflict");
    private final ChangeListManagerImpl myChangeListManager;

    public ChangelistConflictFileStatusProvider(@NotNull Project project) {
        if (project == null) {
            ChangelistConflictFileStatusProvider.$$$reportNull$$$0(0);
        }
        this.myChangeListManager = ChangeListManagerImpl.getInstanceImpl(project);
    }

    @Nullable
    public FileStatus getFileStatus(@NotNull VirtualFile virtualFile) {
        FileStatus status;
        if (virtualFile == null) {
            ChangelistConflictFileStatusProvider.$$$reportNull$$$0(1);
        }
        ChangelistConflictTracker conflictTracker = this.myChangeListManager.getConflictTracker();
        ChangelistConflictTracker.Options options = conflictTracker.getOptions();
        if (options.HIGHLIGHT_CONFLICTS && conflictTracker.hasConflict(virtualFile)) {
            return CHANGELIST_CONFLICT;
        }
        if (options.HIGHLIGHT_NON_ACTIVE_CHANGELIST && ((status = this.myChangeListManager.getStatus(virtualFile)) == FileStatus.MODIFIED || status == FileStatus.ADDED) && !conflictTracker.isFromActiveChangelist(virtualFile)) {
            return status == FileStatus.MODIFIED ? MODIFIED_OUTSIDE : ADDED_OUTSIDE;
        }
        return null;
    }

    public void refreshFileStatusFromDocument(@NotNull VirtualFile virtualFile, @NotNull Document doc) {
        if (virtualFile == null) {
            ChangelistConflictFileStatusProvider.$$$reportNull$$$0(2);
        }
        if (doc == null) {
            ChangelistConflictFileStatusProvider.$$$reportNull$$$0(3);
        }
    }

    @NotNull
    public ThreeState getNotChangedDirectoryParentingStatus(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            ChangelistConflictFileStatusProvider.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException("Shouldn't be called");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictFileStatusProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileStatus";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshFileStatusFromDocument";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getNotChangedDirectoryParentingStatus";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

