#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc
version: 2.8
id: pandoc-2.8-J5xEuB58nacCBdKJHpUv0l
key: pandoc-2.8-J5xEuB58nacCBdKJHpUv0l
license: GPL-2.0-only
copyright: (c) 2006-2019 John MacFarlane
maintainer: John MacFarlane <jgm@berkeley.edu>
author: John MacFarlane <jgm@berkeley.edu>
stability: alpha
homepage: https://pandoc.org
synopsis: Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another, and a command-line tool that uses
    this library. It can read several dialects of Markdown and
    (subsets of) HTML, reStructuredText, LaTeX, DocBook, JATS,
    MediaWiki markup, DokuWiki markup, TWiki markup,
    TikiWiki markup, Creole 1.0, Haddock markup, OPML,
    Emacs Org-Mode, Emacs Muse, txt2tags, ipynb (Jupyter
    notebooks), Vimwiki, Word Docx, ODT, EPUB, FictionBook2,
    roff man, and Textile, and it can write Markdown,
    reStructuredText, XHTML, HTML 5, LaTeX, ConTeXt, DocBook,
    JATS, OPML, TEI, OpenDocument, ODT, Word docx,
    PowerPoint pptx, RTF, MediaWiki, DokuWiki, XWiki,
    ZimWiki, Textile, Jira, roff man, roff ms, plain text,
    Emacs Org-Mode, AsciiDoc, Haddock markup,
    EPUB (v2 and v3), ipynb, FictionBook2,
    InDesign ICML, Muse, LaTeX beamer slides,
    and several kinds of HTML/JavaScript slide shows
    (S5, Slidy, Slideous, DZSlides, reveal.js).
    .
    In contrast to most existing tools for converting Markdown
    to HTML, pandoc has a modular design: it consists of a set of
    readers, which parse text in a given format and produce a
    native representation of the document, and a set of writers,
    which convert this native representation into a target
    format. Thus, adding an input or output format requires
    only adding a reader or writer.
category: Text
abi: 4ff60a9da4a9cc93170d9543b375b8f4
exposed: True
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.BCP47
    Text.Pandoc.Class Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Filter Text.Pandoc.Highlighting
    Text.Pandoc.ImageSize Text.Pandoc.Logging Text.Pandoc.Lua
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Process
    Text.Pandoc.Readers Text.Pandoc.Readers.CommonMark
    Text.Pandoc.Readers.Creole Text.Pandoc.Readers.DocBook
    Text.Pandoc.Readers.Docx Text.Pandoc.Readers.DokuWiki
    Text.Pandoc.Readers.EPUB Text.Pandoc.Readers.FB2
    Text.Pandoc.Readers.HTML Text.Pandoc.Readers.Haddock
    Text.Pandoc.Readers.Ipynb Text.Pandoc.Readers.JATS
    Text.Pandoc.Readers.LaTeX Text.Pandoc.Readers.LaTeX.Types
    Text.Pandoc.Readers.Man Text.Pandoc.Readers.Markdown
    Text.Pandoc.Readers.MediaWiki Text.Pandoc.Readers.Muse
    Text.Pandoc.Readers.Native Text.Pandoc.Readers.OPML
    Text.Pandoc.Readers.Odt Text.Pandoc.Readers.Org
    Text.Pandoc.Readers.RST Text.Pandoc.Readers.TWiki
    Text.Pandoc.Readers.Textile Text.Pandoc.Readers.TikiWiki
    Text.Pandoc.Readers.Txt2Tags Text.Pandoc.Readers.Vimwiki
    Text.Pandoc.SelfContained Text.Pandoc.Shared Text.Pandoc.Templates
    Text.Pandoc.UTF8 Text.Pandoc.Writers Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.CommonMark Text.Pandoc.Writers.ConTeXt
    Text.Pandoc.Writers.Custom Text.Pandoc.Writers.Docbook
    Text.Pandoc.Writers.Docx Text.Pandoc.Writers.DokuWiki
    Text.Pandoc.Writers.EPUB Text.Pandoc.Writers.FB2
    Text.Pandoc.Writers.HTML Text.Pandoc.Writers.Haddock
    Text.Pandoc.Writers.ICML Text.Pandoc.Writers.Ipynb
    Text.Pandoc.Writers.JATS Text.Pandoc.Writers.Jira
    Text.Pandoc.Writers.LaTeX Text.Pandoc.Writers.Man
    Text.Pandoc.Writers.Markdown Text.Pandoc.Writers.Math
    Text.Pandoc.Writers.MediaWiki Text.Pandoc.Writers.Ms
    Text.Pandoc.Writers.Muse Text.Pandoc.Writers.Native
    Text.Pandoc.Writers.ODT Text.Pandoc.Writers.OOXML
    Text.Pandoc.Writers.OPML Text.Pandoc.Writers.OpenDocument
    Text.Pandoc.Writers.Org Text.Pandoc.Writers.Powerpoint
    Text.Pandoc.Writers.RST Text.Pandoc.Writers.RTF
    Text.Pandoc.Writers.Shared Text.Pandoc.Writers.TEI
    Text.Pandoc.Writers.Texinfo Text.Pandoc.Writers.Textile
    Text.Pandoc.Writers.XWiki Text.Pandoc.Writers.ZimWiki
    Text.Pandoc.XML
hidden-modules: Text.Pandoc.App.CommandLineOptions
                Text.Pandoc.App.FormatHeuristics Text.Pandoc.App.Opt
                Text.Pandoc.App.OutputSettings Text.Pandoc.Filter.JSON
                Text.Pandoc.Filter.Lua Text.Pandoc.Filter.Path
                Text.Pandoc.Readers.Docx.Lists Text.Pandoc.Readers.Docx.Combine
                Text.Pandoc.Readers.Docx.Parse
                Text.Pandoc.Readers.Docx.Parse.Styles Text.Pandoc.Readers.Docx.Util
                Text.Pandoc.Readers.Docx.Fields Text.Pandoc.Readers.LaTeX.Parsing
                Text.Pandoc.Readers.LaTeX.Lang Text.Pandoc.Readers.Odt.Base
                Text.Pandoc.Readers.Odt.Namespaces
                Text.Pandoc.Readers.Odt.StyleReader
                Text.Pandoc.Readers.Odt.ContentReader
                Text.Pandoc.Readers.Odt.Generic.Fallible
                Text.Pandoc.Readers.Odt.Generic.SetMap
                Text.Pandoc.Readers.Odt.Generic.Utils
                Text.Pandoc.Readers.Odt.Generic.Namespaces
                Text.Pandoc.Readers.Odt.Generic.XMLConverter
                Text.Pandoc.Readers.Odt.Arrows.State
                Text.Pandoc.Readers.Odt.Arrows.Utils
                Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
                Text.Pandoc.Readers.Org.DocumentTree
                Text.Pandoc.Readers.Org.ExportSettings
                Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
                Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
                Text.Pandoc.Readers.Org.Shared Text.Pandoc.Readers.Roff
                Text.Pandoc.Writers.Docx.StyleMap Text.Pandoc.Writers.Roff
                Text.Pandoc.Writers.Powerpoint.Presentation
                Text.Pandoc.Writers.Powerpoint.Output Text.Pandoc.Lua.Filter
                Text.Pandoc.Lua.Global Text.Pandoc.Lua.Init
                Text.Pandoc.Lua.Marshaling Text.Pandoc.Lua.Marshaling.AST
                Text.Pandoc.Lua.Marshaling.AnyValue
                Text.Pandoc.Lua.Marshaling.CommonState
                Text.Pandoc.Lua.Marshaling.MediaBag
                Text.Pandoc.Lua.Marshaling.ReaderOptions
                Text.Pandoc.Lua.Marshaling.Context
                Text.Pandoc.Lua.Marshaling.Version Text.Pandoc.Lua.Module.MediaBag
                Text.Pandoc.Lua.Module.Pandoc Text.Pandoc.Lua.Module.System
                Text.Pandoc.Lua.Module.Types Text.Pandoc.Lua.Module.Utils
                Text.Pandoc.Lua.Packages Text.Pandoc.Lua.Util Text.Pandoc.Lua.Walk
                Text.Pandoc.CSS Text.Pandoc.CSV Text.Pandoc.RoffChar
                Text.Pandoc.UUID Text.Pandoc.Translations Text.Pandoc.Slides
                Paths_pandoc
import-dirs: /usr/lib/ghc-8.6.5/site-local/pandoc-2.8
library-dirs: /usr/lib/ghc-8.6.5/site-local/pandoc-2.8
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/pandoc
hs-libraries: HSpandoc-2.8-J5xEuB58nacCBdKJHpUv0l
depends:
    Glob-0.10.0-EEdwRH9tB8t70GBaojJ2yl
    HTTP-4000.3.14-47d8FtjHMEj6sLoAJwwCGh
    HsYAML-0.2.1.0-ImyjARoaWV71MTtmF9DhwY
    JuicyPixels-3.3.4-Firmm877qNXHMQPPVNVl8h
    SHA-1.6.4.4-1GMMHy6WdrlGpMrtGTWHUv
    aeson-1.4.6.0-IYkWE2kAqOg3BtypRoad0s
    aeson-pretty-0.8.8-5a4uAQxPioc7WoNGm6e0qR
    attoparsec-0.13.2.3-7zk58GWWjTj9W2Qd2JktwB base-4.12.0.0
    base64-bytestring-1.0.0.2-2qZIU8NhrUrEe5vir8mbZ5 binary-0.8.6.0
    blaze-html-0.9.1.2-3rCj4yYYlH244V10MP4Bb5
    blaze-markup-0.8.2.3-ATcS0IRQcDMCxhB8vW9N1d bytestring-0.10.8.2
    case-insensitive-1.2.1.0-L7BR5PaOPZy5cAHpLYQKhk
    cmark-gfm-0.2.1-CUzEzrWgwwF9I3WyyQ4y42 containers-0.6.0.1
    data-default-0.7.1.1-BJebZgJOe7bK46yzXrFmEt deepseq-1.4.4.0
    directory-1.3.3.0 doclayout-0.2.0.1-QaV6Vjo41CLxujHKsTBZ7
    doctemplates-0.7.1-HoKdwahTPPM59KLpAG3Yaw
    exceptions-0.10.3-C2fkKAVjk4AA6i9Cl1i116 filepath-1.4.2.1
    haddock-library-1.8.0-Fqj0XKcEtWOFHAI8TZEIga
    hslua-1.0.3.2-2Si3U5CCYPv3P6HZtLHMkP
    hslua-module-system-0.2.1-LAyr828UFfDI0JX8gOSLVU
    hslua-module-text-0.2.1-1XXwxnvTHqhCkVNEMyN3eS
    http-client-0.6.4-4odVXPkg4QsE7p9MqSf1aB
    http-client-tls-0.3.5.3-29z7xHwsto0AxvhJCibNmP
    http-types-0.12.3-2tcDIAoQ8De6A4nb7F3Iw
    ipynb-0.1-CeSUvYRQ2Xt4JchW9seidt mtl-2.2.2
    network-2.8.0.0-LvSlvEKiGr81Yl4BCXERfa
    network-uri-2.6.1.0-K75fCYvLQE41EntOQ30cqK
    pandoc-types-1.20-3v6NVh3WwLFqRY2PqzH3K parsec-3.1.13.0
    process-1.6.5.0 random-1.1-3ypV4EIycgb35PKjTYYr5q
    safe-0.3.18-LtdH37oJsulDSBmeOJDMc3
    scientific-0.3.6.2-L1dtV0bHm4E7J1We1UVw6b
    skylighting-0.8.3-8sPdDcpjsr55oodRejWP60
    skylighting-core-0.8.3-JhCqeSM0eUoKhwGBfiEfUy
    split-0.2.3.3-1w4zrR7dIaa99Lgjh3h1bs
    syb-0.7.1-1gO4OjQOULM8usUjWwwEyW
    tagsoup-0.14.8-TxxcffRINhDkf2zJaQ0gs
    temporary-1.3-8Deby0QWlukGFQqD4SQr91
    texmath-0.12-IV3GECFpqSr2x55mtgt3Sn text-1.2.3.1
    text-conversions-0.3.0-FwUU2REY9R1RiDdvaSZqv time-1.8.0.2
    unicode-transforms-0.3.6-8605YU3Kxnm9V56PWkgPCT unix-2.7.2.2
    unordered-containers-0.2.10.0-98MsUmwXpKo1DE5wGxzrlx
    vector-0.12.0.3-2LEYu9M2i7lERDtz76XG3n
    xml-1.3.14-ESp8cJy4XJ8BJKfvGeNymT
    zip-archive-0.4.1-5qyYzzxT1ThKcxFf3waqkJ
    zlib-0.6.2.1-Aknvu72a6qHHNTLcHtkXd
haddock-interfaces: /usr/share/doc/pandoc/html/pandoc.haddock
haddock-html: /usr/share/doc/pandoc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

