/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.views;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import net.osmand.data.FavouritePoint;
import net.osmand.data.LatLon;
import net.osmand.data.LocationPoint;
import net.osmand.data.PointDescription;
import net.osmand.data.QuadRect;
import net.osmand.data.QuadTree;
import net.osmand.data.RotatedTileBox;
import net.osmand.plus.FavouritesDbHelper;
import net.osmand.plus.OsmandSettings;
import net.osmand.plus.base.FavoriteImageDrawable;
import net.osmand.plus.views.MapTextLayer;
import net.osmand.plus.views.OsmandMapLayer;
import net.sourceforge.offroad.ui.IContextMenuProvider;
import net.sourceforge.offroad.ui.OsmBitmapPanel;
import net.sourceforge.offroad.ui.PorterDuffMultiplyFilter;

public class FavoritesLayer
extends OsmandMapLayer
implements IContextMenuProvider,
MapTextLayer.MapTextProvider<LocationPoint> {
    public static final int DEFAULT_COLOR = 1437252556;
    public static final int DEFAULT_OUTER_COLOR = -2007673515;
    protected int startZoom = 6;
    protected OsmBitmapPanel view;
    private FavouritesDbHelper favorites;
    protected List<LocationPoint> cache = new ArrayList<LocationPoint>();
    private MapTextLayer textLayer;
    private BufferedImage pointSmall;
    private int defaultColor;
    private OsmandSettings settings;

    protected Class<? extends LocationPoint> getFavoriteClass() {
        return FavouritePoint.class;
    }

    protected String getObjName() {
        return this.view.getContext().getString(735);
    }

    protected List<? extends LocationPoint> getPoints() {
        return this.favorites.getFavouritePoints();
    }

    @Override
    public void initLayer(OsmBitmapPanel view) {
        this.view = view;
        this.settings = view.getApplication().getSettings();
        this.favorites = view.getApplication().getFavorites();
        this.textLayer = view.getLayerByClass(MapTextLayer.class);
        this.pointSmall = this.readImage("map_white_shield_small", view);
        this.defaultColor = 1437252556;
    }

    private boolean calculateBelongs(int ex, int ey, int objx, int objy, int radius) {
        return Math.abs(objx - ex) <= radius * 2 && Math.abs(objy - ey) <= radius * 2;
    }

    @Override
    public void destroyLayer() {
    }

    @Override
    public boolean drawInScreenPixels() {
        return true;
    }

    @Override
    public void onDraw(Graphics2D canvas, RotatedTileBox tileBox, OsmandMapLayer.DrawSettings settings) {
    }

    @Override
    public void onPrepareBufferImage(Graphics2D canvas, RotatedTileBox tileBox, OsmandMapLayer.DrawSettings settings) {
        this.cache.clear();
        if (this.settings.SHOW_FAVORITES.get().booleanValue() && tileBox.getZoom() >= this.startZoom) {
            float iconSize = (float)(FavoriteImageDrawable.getOrCreate(this.view.getContext(), 0, true).getIntrinsicWidth() * 3) / 2.5f;
            QuadTree<QuadRect> boundIntersections = this.initBoundIntersections(tileBox);
            QuadRect latLonBounds = tileBox.getLatLonBounds();
            ArrayList<LocationPoint> fullObjects = new ArrayList<LocationPoint>();
            ArrayList<LatLon> fullObjectsLatLon = new ArrayList<LatLon>();
            ArrayList<LatLon> smallObjectsLatLon = new ArrayList<LatLon>();
            for (LocationPoint locationPoint : this.getPoints()) {
                int y;
                if (!locationPoint.isVisible()) continue;
                int x = (int)tileBox.getPixXFromLatLon(locationPoint.getLatitude(), locationPoint.getLongitude());
                if (this.intersects(boundIntersections, x, y = (int)tileBox.getPixYFromLatLon(locationPoint.getLatitude(), locationPoint.getLongitude()), iconSize, iconSize)) {
                    int col = locationPoint.getColor() == 0 ? this.defaultColor : locationPoint.getColor();
                    Graphics2D ng = (Graphics2D)canvas.create();
                    ng.setComposite(new PorterDuffMultiplyFilter(new Color(col, true)));
                    ng.drawImage((Image)this.pointSmall, x - this.pointSmall.getWidth() / 2, y - this.pointSmall.getHeight() / 2, null);
                    ng.dispose();
                    smallObjectsLatLon.add(new LatLon(locationPoint.getLatitude(), locationPoint.getLongitude()));
                    continue;
                }
                fullObjects.add(locationPoint);
                fullObjectsLatLon.add(new LatLon(locationPoint.getLatitude(), locationPoint.getLongitude()));
            }
            for (LocationPoint locationPoint : fullObjects) {
                this.drawPoint(canvas, tileBox, latLonBounds, locationPoint);
            }
            this.fullObjectsLatLon = fullObjectsLatLon;
            this.smallObjectsLatLon = smallObjectsLatLon;
        }
        if (this.textLayer.isVisible()) {
            this.textLayer.putData(this, this.cache);
        }
    }

    private void drawPoint(Graphics2D canvas, RotatedTileBox tileBox, QuadRect latLonBounds, LocationPoint o) {
        if (o.isVisible() && o.getLatitude() >= latLonBounds.bottom && o.getLatitude() <= latLonBounds.top && o.getLongitude() >= latLonBounds.left && o.getLongitude() <= latLonBounds.right) {
            this.cache.add(o);
            int x = (int)tileBox.getPixXFromLatLon(o.getLatitude(), o.getLongitude());
            int y = (int)tileBox.getPixYFromLatLon(o.getLatitude(), o.getLongitude());
            FavoriteImageDrawable fid = FavoriteImageDrawable.getOrCreate(this.view.getContext(), o.getColor(), true);
            fid.drawBitmapInCenter(canvas, x, y);
        }
    }

    @Override
    public boolean onLongPressEvent(Point2D point, RotatedTileBox tileBox) {
        return false;
    }

    public void getFavoriteFromPoint(RotatedTileBox tb, Point2D point, List<? super LocationPoint> res) {
        int r = (int)(15.0f * tb.getDensity());
        int ex = (int)point.getX();
        int ey = (int)point.getY();
        for (LocationPoint locationPoint : this.getPoints()) {
            this.getFavFromPoint(tb, res, r, ex, ey, locationPoint);
        }
    }

    private void getFavFromPoint(RotatedTileBox tb, List<? super LocationPoint> res, int r, int ex, int ey, LocationPoint n) {
        int y;
        int x;
        if (n.isVisible() && this.calculateBelongs(ex, ey, x = (int)tb.getPixXFromLatLon(n.getLatitude(), n.getLongitude()), y = (int)tb.getPixYFromLatLon(n.getLatitude(), n.getLongitude()), r)) {
            res.add(n);
        }
    }

    @Override
    public String getObjectDescription(Object o) {
        Class<? extends LocationPoint> fcl = this.getFavoriteClass();
        if (o != null && fcl.isInstance(o)) {
            return PointDescription.getSimpleName((LocationPoint)o, this.view.getContext());
        }
        return null;
    }

    @Override
    public PointDescription getObjectName(Object o) {
        if (o instanceof LocationPoint) {
            return ((LocationPoint)o).getPointDescription(this.view.getContext());
        }
        return null;
    }

    @Override
    public boolean disableSingleTap() {
        return false;
    }

    @Override
    public boolean disableLongPressOnMap() {
        return false;
    }

    @Override
    public boolean isObjectClickable(Object o) {
        return o instanceof LocationPoint;
    }

    @Override
    public void collectObjectsFromPoint(Point2D point, RotatedTileBox tileBox, List<Object> res) {
        if (this.settings.SHOW_FAVORITES.get().booleanValue() && tileBox.getZoom() >= this.startZoom) {
            this.getFavoriteFromPoint(tileBox, point, res);
        }
    }

    @Override
    public LatLon getObjectLocation(Object o) {
        if (o instanceof LocationPoint) {
            return new LatLon(((LocationPoint)o).getLatitude(), ((LocationPoint)o).getLongitude());
        }
        return null;
    }

    @Override
    public LatLon getTextLocation(LocationPoint o) {
        return new LatLon(o.getLatitude(), o.getLongitude());
    }

    @Override
    public int getTextShift(LocationPoint o, RotatedTileBox rb) {
        return (int)(16.0f * rb.getDensity());
    }

    @Override
    public String getText(LocationPoint o) {
        return PointDescription.getSimpleName(o, this.view.getContext());
    }
}

