#!/usr/bin/env ruby
# -*- coding: binary -*-
def help
  puts "Usage:"
  puts "#{__FILE__} [weight] [source code path] [output path]"
  puts
  puts "Example:"
  puts "#{__FILE__} 80 /tmp/helloworld.c /tmp/helloworld.exe"
  exit
end

help if ARGV.empty? || ARGV.include?('-h')

msfbase = __FILE__
while File.symlink?(msfbase)
  msfbase = File.expand_path(File.readlink(msfbase), File.dirname(msfbase))
end
$:.unshift(File.expand_path(File.join(File.dirname(msfbase), '..', '..', 'lib')))

require 'msf/core'
require 'metasploit/framework/compiler/windows'

weight = ARGV.shift
source_code_path = ARGV.shift
out_path = ARGV.shift

if source_code_path.nil? || source_code_path.empty? || !File.exists?(source_code_path)
  puts "Please set the source code path"
  exit
elsif out_path.nil? || out_path.empty?
  puts "Please set the destination path"
  exit
end

source_code = File.read(source_code_path)
Metasploit::Framework::Compiler::Windows.compile_random_c_to_file(out_path, source_code, weight: weight.to_i)
if File.exists?(out_path)
  puts "File saved as #{out_path}"
end
