"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.__reset__ = __reset__;
exports.__setup__ = __setup__;
exports.__start__ = __start__;
exports.legacyAppRegister = exports.npStart = exports.npSetup = void 0;

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var npSetup = {
  core: null,
  plugins: {}
};
exports.npSetup = npSetup;
var npStart = {
  core: null,
  plugins: {}
};
/**
 * Only used by unit tests
 * @internal
 */

exports.npStart = npStart;

function __reset__() {
  npSetup.core = null;
  npSetup.plugins = {};
  npStart.core = null;
  npStart.plugins = {};
  legacyAppRegistered = false;
}

function __setup__(coreSetup, plugins) {
  npSetup.core = coreSetup;
  npSetup.plugins = plugins; // Setup compatibility layer for AppService in legacy platform

  npSetup.core.application.register = legacyAppRegister;
}

function __start__(coreStart, plugins) {
  npStart.core = coreStart;
  npStart.plugins = plugins;
}
/** Flag used to ensure `legacyAppRegister` is only called once. */


var legacyAppRegistered = false;
/**
 * Exported for testing only. Use `npSetup.core.application.register` in legacy apps.
 * @internal
 */

var legacyAppRegister = function legacyAppRegister(app) {
  if (legacyAppRegistered) {
    throw new Error("core.application.register may only be called once for legacy plugins.");
  }

  legacyAppRegistered = true;

  require('ui/chrome').setRootController(app.id, function ($scope, $element) {
    var element = $element[0]; // Root controller cannot return a Promise so use an internal async function and call it immediately

    _asyncToGenerator(
    /*#__PURE__*/
    regeneratorRuntime.mark(function _callee() {
      var unmount;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return app.mount({
                core: npStart.core
              }, {
                element: element,
                appBasePath: ''
              });

            case 2:
              unmount = _context.sent;
              $scope.$on('$destroy', function () {
                unmount();
              });

            case 4:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }))();
  });
};

exports.legacyAppRegister = legacyAppRegister;