"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStaticLookupFormat = createStaticLookupFormat;

var _common = require("../../../../../../plugins/data/common/");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function convertLookupEntriesToMap(lookupEntries) {
  return lookupEntries.reduce((lookupMap, lookupEntry) => {
    lookupMap[lookupEntry.key] = lookupEntry.value;
    return lookupMap;
  }, {});
}

function createStaticLookupFormat() {
  var _class, _temp;

  return _temp = _class = class StaticLookupFormat extends _common.FieldFormat {
    constructor(...args) {
      super(...args);

      _defineProperty(this, "textConvert", val => {
        const lookupEntries = this.param('lookupEntries');
        const unknownKeyValue = this.param('unknownKeyValue');
        const lookupMap = convertLookupEntriesToMap(lookupEntries);
        return lookupMap[val] || unknownKeyValue || val;
      });
    }

    getParamDefaults() {
      return {
        lookupEntries: [{}],
        unknownKeyValue: null
      };
    }

  }, _defineProperty(_class, "id", 'static_lookup'), _defineProperty(_class, "title", 'Static Lookup'), _defineProperty(_class, "fieldType", [_common.KBN_FIELD_TYPES.STRING, _common.KBN_FIELD_TYPES.NUMBER, _common.KBN_FIELD_TYPES.IP, _common.KBN_FIELD_TYPES.BOOLEAN]), _temp;
}