"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualization = void 0;

var _chrome = _interopRequireDefault(require("ui/chrome"));

var _visualization_loader = require("ui/visualize/loader/visualization_loader");

var _vis = require("ui/visualize/loader/vis");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var visualization = function visualization() {
  return {
    name: 'visualization',
    displayName: 'visualization',
    reuseDomNode: true,
    render: function () {
      var _render = _asyncToGenerator(
      /*#__PURE__*/
      regeneratorRuntime.mark(function _callee(domNode, config, handlers) {
        var visData, visConfig, params, visType, $injector, Private, Vis, uiState;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                visData = config.visData, visConfig = config.visConfig, params = config.params;
                visType = config.visType || visConfig.type;
                _context.next = 4;
                return _chrome.default.dangerouslyGetActiveInjector();

              case 4:
                $injector = _context.sent;
                Private = $injector.get('Private');
                Vis = Private(_vis.VisProvider);

                if (handlers.vis) {
                  // special case in visualize, we need to render first (without executing the expression), for maps to work
                  if (visConfig) {
                    handlers.vis.setCurrentState({
                      type: visType,
                      params: visConfig
                    });
                  }
                } else {
                  handlers.vis = new Vis({
                    type: visType,
                    params: visConfig
                  });
                  handlers.vis.eventsSubject = handlers.eventsSubject;
                }

                uiState = handlers.uiState || handlers.vis.getUiState();
                handlers.onDestroy(function () {
                  return _visualization_loader.visualizationLoader.destroy();
                });
                _context.next = 12;
                return _visualization_loader.visualizationLoader.render(domNode, handlers.vis, visData, handlers.vis.params, uiState, params).then(function () {
                  if (handlers.done) handlers.done();
                });

              case 12:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      function render(_x, _x2, _x3) {
        return _render.apply(this, arguments);
      }

      return render;
    }()
  };
};

exports.visualization = visualization;