"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Main = Main;

var _react = _interopRequireWildcard(require("react"));

var _lodash = require("lodash");

var _eui = require("@elastic/eui");

var _editor = require("../editor");

var _settings = require("../settings");

var _components = require("../../components");

var _context = require("../../context");

var _services = require("../../../services");

var _get_top_nav = require("./get_top_nav");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var INITIAL_PANEL_WIDTH = 50;
var PANEL_MIN_WIDTH = '100px';

function Main() {
  var _useAppContext = (0, _context.useAppContext)(),
      storage = _useAppContext.services.storage;

  var _useEditorReadContext = (0, _editor.useEditorReadContext)(),
      editorsReady = _useEditorReadContext.editorsReady;

  var _useState = (0, _react.useState)(function () {
    return storage.get('version_welcome_shown') !== '@@SENSE_REVISION';
  }),
      _useState2 = _slicedToArray(_useState, 2),
      showWelcome = _useState2[0],
      setShowWelcomePanel = _useState2[1];

  var _useState3 = (0, _react.useState)(false),
      _useState4 = _slicedToArray(_useState3, 2),
      showingHistory = _useState4[0],
      setShowHistory = _useState4[1];

  var _useState5 = (0, _react.useState)(false),
      _useState6 = _slicedToArray(_useState5, 2),
      showSettings = _useState6[0],
      setShowSettings = _useState6[1];

  var _useState7 = (0, _react.useState)(false),
      _useState8 = _slicedToArray(_useState7, 2),
      showHelp = _useState8[0],
      setShowHelp = _useState8[1];

  var _storage$get = storage.get(_services.StorageKeys.WIDTH, [INITIAL_PANEL_WIDTH, INITIAL_PANEL_WIDTH]),
      _storage$get2 = _slicedToArray(_storage$get, 2),
      firstPanelWidth = _storage$get2[0],
      secondPanelWidth = _storage$get2[1];

  var onPanelWidthChange = (0, _react.useCallback)((0, _lodash.debounce)(function (widths) {
    storage.set(_services.StorageKeys.WIDTH, widths);
  }, 300), []);

  var renderConsoleHistory = function renderConsoleHistory() {
    return editorsReady ? _react.default.createElement(_editor.ConsoleHistory, {
      close: function close() {
        return setShowHistory(false);
      }
    }) : null;
  };

  return _react.default.createElement(_react.default.Fragment, null, _react.default.createElement(_eui.EuiFlexGroup, {
    className: "consoleContainer",
    gutterSize: "none",
    direction: "column",
    responsive: false
  }, _react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, _react.default.createElement(_components.TopNavMenu, {
    items: (0, _get_top_nav.getTopNavConfig)({
      onClickHistory: function onClickHistory() {
        return setShowHistory(!showingHistory);
      },
      onClickSettings: function onClickSettings() {
        return setShowSettings(true);
      },
      onClickHelp: function onClickHelp() {
        return setShowHelp(!showHelp);
      }
    })
  })), showingHistory ? _react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, renderConsoleHistory()) : null, _react.default.createElement(_eui.EuiFlexItem, null, _react.default.createElement(_components.PanelsContainer, {
    onPanelWidthChange: onPanelWidthChange
  }, _react.default.createElement(_components.Panel, {
    style: {
      height: '100%',
      position: 'relative',
      minWidth: PANEL_MIN_WIDTH
    },
    initialWidth: firstPanelWidth + '%'
  }, _react.default.createElement(_editor.Editor, null)), _react.default.createElement(_components.Panel, {
    style: {
      height: '100%',
      position: 'relative',
      minWidth: PANEL_MIN_WIDTH
    },
    initialWidth: secondPanelWidth + '%'
  }, _react.default.createElement(_editor.EditorOutput, null))))), showWelcome ? _react.default.createElement(_components.WelcomePanel, {
    onDismiss: function onDismiss() {
      storage.set('version_welcome_shown', '@@SENSE_REVISION');
      setShowWelcomePanel(false);
    }
  }) : null, showSettings ? _react.default.createElement(_settings.Settings, {
    onClose: function onClose() {
      return setShowSettings(false);
    }
  }) : null, showHelp ? _react.default.createElement(_components.HelpPanel, {
    onClose: function onClose() {
      return setShowHelp(false);
    }
  }) : null);
}