"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendCurrentRequestToES = sendCurrentRequestToES;

var _mappings = _interopRequireDefault(require("../../../../../../../public/quarantined/src/mappings"));

var _utils = _interopRequireDefault(require("../../../../../../../public/quarantined/src/utils"));

var es = _interopRequireWildcard(require("../../../../../../../public/quarantined/src/es"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// @ts-ignore
// @ts-ignore
// @ts-ignore
var CURRENT_REQ_ID = 0;

function sendCurrentRequestToES(_ref) {
  var callback = _ref.callback,
      input = _ref.input,
      output = _ref.output,
      isPolling = _ref.isPolling,
      isUsingTripleQuotes = _ref.isUsingTripleQuotes;
  var reqId = ++CURRENT_REQ_ID;
  input.getRequestsInRange(function (requests) {
    if (reqId !== CURRENT_REQ_ID) {
      return;
    }

    if (output) {
      output.update('');
    }

    if (requests.length === 0) {
      return;
    }

    var isMultiRequest = requests.length > 1;

    var finishChain = function finishChain() {
      /* noop */
    };

    var isFirstRequest = true;

    var sendNextRequest = function sendNextRequest() {
      if (reqId !== CURRENT_REQ_ID) {
        return;
      }

      if (requests.length === 0) {
        finishChain();
        return;
      }

      var req = requests.shift();
      var esPath = req.url;
      var esMethod = req.method;

      var esData = _utils.default.collapseLiteralStrings(req.data.join('\n'));

      if (esData) {
        esData += '\n';
      } // append a new line for bulk requests.


      es.send(esMethod, esPath, esData).always(function (dataOrjqXHR, textStatus, jqXhrORerrorThrown) {
        if (reqId !== CURRENT_REQ_ID) {
          return;
        }

        var xhr = dataOrjqXHR.promise ? dataOrjqXHR : jqXhrORerrorThrown;

        function modeForContentType(contentType) {
          if (contentType.indexOf('text/plain') >= 0) {
            return 'ace/mode/text';
          } else if (contentType.indexOf('application/yaml') >= 0) {
            return 'ace/mode/yaml';
          }

          return null;
        }

        var isSuccess = typeof xhr.status === 'number' && ( // Things like DELETE index where the index is not there are OK.
        xhr.status >= 200 && xhr.status < 300 || xhr.status === 404);

        if (isSuccess) {
          if (xhr.status !== 404 && isPolling) {
            // If the user has submitted a request against ES, something in the fields, indices, aliases,
            // or templates may have changed, so we'll need to update this data. Assume that if
            // the user disables polling they're trying to optimize performance or otherwise
            // preserve resources, so they won't want this request sent either.
            _mappings.default.retrieveAutoCompleteInfo();
          }

          var value = xhr.responseText;
          var mode = modeForContentType(xhr.getAllResponseHeaders('Content-Type') || ''); // Apply triple quotes to output.

          if (isUsingTripleQuotes && mode === null) {
            // assume json - auto pretty
            try {
              value = _utils.default.expandLiteralStrings(value);
            } catch (e) {// nothing to do here
            }
          }

          var warnings = xhr.getResponseHeader('warning');

          if (warnings) {
            var deprecationMessages = _utils.default.extractDeprecationMessages(warnings);

            value = deprecationMessages.join('\n') + '\n' + value;
          }

          if (isMultiRequest) {
            value = '# ' + req.method + ' ' + req.url + '\n' + value;
          }

          if (output) {
            if (isFirstRequest) {
              output.update(value, mode);
            } else {
              output.append('\n' + value);
            }
          }

          isFirstRequest = false; // single request terminate via sendNextRequest as well

          callback(esPath, esMethod, esData);
          sendNextRequest();
        } else {
          var _value;

          var _mode;

          if (xhr.responseText) {
            _value = xhr.responseText; // ES error should be shown

            _mode = modeForContentType(xhr.getAllResponseHeaders('Content-Type') || '');

            if (_value[0] === '{') {
              try {
                _value = JSON.stringify(JSON.parse(_value), null, 2);
              } catch (e) {// nothing to do here
              }
            }
          } else {
            _value = 'Request failed to get to the server (status code: ' + xhr.status + ')';
            _mode = 'ace/mode/text';
          }

          if (isMultiRequest) {
            _value = '# ' + req.method + ' ' + req.url + '\n' + _value;
          }

          if (output) {
            if (isFirstRequest) {
              output.update(_value, _mode);
            } else {
              output.append('\n' + _value);
            }
          }

          finishChain();
        }
      });
    };

    sendNextRequest();
  });
}