"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditorOutput = void 0;

var _react = _interopRequireWildcard(require("react"));

var _jquery = _interopRequireDefault(require("jquery"));

var _output = require("../../../../../../../public/quarantined/src/output");

var _context = require("../../../../context");

var _context2 = require("../../context");

var _subscribe_console_resize_checker = require("../subscribe_console_resize_checker");

var _apply_editor_settings = require("./apply_editor_settings");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// @ts-ignore
function _EditorOuput() {
  var editorRef = (0, _react.useRef)(null);
  var editorInstanceRef = (0, _react.useRef)(null);

  var _useAppContext = (0, _context.useAppContext)(),
      settings = _useAppContext.services.settings,
      ResizeChecker = _useAppContext.ResizeChecker;

  var dispatch = (0, _context2.useEditorActionContext)();

  var _useEditorReadContext = (0, _context2.useEditorReadContext)(),
      readOnlySettings = _useEditorReadContext.settings;

  (0, _react.useEffect)(function () {
    var editor$ = (0, _jquery.default)(editorRef.current);
    editorInstanceRef.current = (0, _output.initializeOutput)(editor$, settings);
    editorInstanceRef.current.update('');
    var unsubscribe = (0, _subscribe_console_resize_checker.subscribeResizeChecker)(ResizeChecker, editorRef.current, editorInstanceRef.current);
    dispatch({
      type: 'setOutputEditor',
      value: editorInstanceRef.current
    });
    return function () {
      unsubscribe();
    };
  }, []);
  (0, _react.useEffect)(function () {
    (0, _apply_editor_settings.applyCurrentSettings)(editorInstanceRef.current, readOnlySettings);
  }, [readOnlySettings]);
  return _react.default.createElement("div", {
    ref: editorRef,
    className: "conApp__output",
    "data-test-subj": "response-editor"
  }, _react.default.createElement("div", {
    className: "conApp__outputContent",
    id: "ConAppOutput"
  }));
}

var EditorOutput = _react.default.memo(_EditorOuput);

exports.EditorOutput = EditorOutput;