"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reducer = void 0;

var _editor_registry = require("./editor_registry");

var _restore_request_from_history = require("../legacy/console_history/restore_request_from_history");

var _send_current_request_to_es = require("../legacy/console_editor/send_current_request_to_es");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var reducer = function reducer(state, action) {
  var nextState = _objectSpread({}, state);

  if (action.type === 'setInputEditor') {
    _editor_registry.instance.setInputEditor(action.value);

    if (_editor_registry.instance.getOutputEditor()) {
      nextState.editorsReady = true;
    }
  }

  if (action.type === 'setOutputEditor') {
    _editor_registry.instance.setOutputEditor(action.value);

    if (_editor_registry.instance.getInputEditor()) {
      nextState.editorsReady = true;
    }
  }

  if (action.type === 'restoreRequest') {
    (0, _restore_request_from_history.restoreRequestFromHistory)(_editor_registry.instance.getInputEditor(), action.value);
  }

  if (action.type === 'updateSettings') {
    nextState.settings = action.value;
  }

  if (action.type === 'sendRequestToEs') {
    var _action$value = action.value,
        callback = _action$value.callback,
        isPolling = _action$value.isPolling,
        isUsingTripleQuotes = _action$value.isUsingTripleQuotes;
    (0, _send_current_request_to_es.sendCurrentRequestToES)({
      input: _editor_registry.instance.getInputEditor(),
      output: _editor_registry.instance.getOutputEditor(),
      callback: callback,
      isUsingTripleQuotes: isUsingTripleQuotes,
      isPolling: isPolling
    });
  }

  return nextState;
};

exports.reducer = reducer;