"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UiSettingsService = void 0;

var _operators = require("rxjs/operators");

var _ui_settings_client = require("./ui_settings_client");

var _utils = require("../../utils/");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/** @internal */
class UiSettingsService {
  constructor(coreContext) {
    this.coreContext = coreContext;

    _defineProperty(this, "log", void 0);

    _defineProperty(this, "config$", void 0);

    _defineProperty(this, "uiSettingsDefaults", new Map());

    this.log = coreContext.logger.get('ui-settings-service');
    this.config$ = coreContext.configService.atPath('uiSettings');
  }

  async setup(deps) {
    this.log.debug('Setting up ui settings service');
    const overrides = await this.getOverrides(deps);
    const {
      version,
      buildNum
    } = this.coreContext.env.packageInfo;
    return {
      setDefaults: this.setDefaults.bind(this),
      asScopedToClient: savedObjectsClient => {
        return new _ui_settings_client.UiSettingsClient({
          type: 'config',
          id: version,
          buildNum,
          savedObjectsClient,
          defaults: (0, _utils.mapToObject)(this.uiSettingsDefaults),
          overrides,
          log: this.log
        });
      }
    };
  }

  async start() {}

  async stop() {}

  setDefaults(values = {}) {
    Object.entries(values).forEach(([key, value]) => {
      if (this.uiSettingsDefaults.has(key)) {
        throw new Error(`uiSettings defaults for key [${key}] has been already set`);
      }

      this.uiSettingsDefaults.set(key, value);
    });
  }

  async getOverrides(deps) {
    const config = await this.config$.pipe((0, _operators.first)()).toPromise();
    const overrides = config.overrides; // manually implemented deprecation until New platform Config service
    // supports them https://github.com/elastic/kibana/issues/40255

    if (typeof deps.http.config.defaultRoute !== 'undefined') {
      overrides.defaultRoute = deps.http.config.defaultRoute;
      this.log.warn('Config key "server.defaultRoute" is deprecated. It has been replaced with "uiSettings.overrides.defaultRoute"');
    }

    return overrides;
  }

}

exports.UiSettingsService = UiSettingsService;