/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import javax.json.JsonObjectBuilder;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.management.impl.view.ActiveMQAbstractView;
import org.apache.activemq.artemis.core.management.impl.view.predicate.QueueFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.utils.JsonLoader;

public class QueueView
extends ActiveMQAbstractView<QueueControl> {
    private static final String defaultSortColumn = "name";
    private ActiveMQServer server;

    public QueueView(ActiveMQServer server) {
        this.predicate = new QueueFilterPredicate(server);
        this.server = server;
    }

    @Override
    public Class getClassT() {
        return QueueControl.class;
    }

    @Override
    public JsonObjectBuilder toJson(QueueControl queue) {
        Queue q = this.server.locateQueue(new SimpleString(queue.getName()));
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add("id", this.toString(queue.getID())).add(defaultSortColumn, this.toString(queue.getName())).add("address", this.toString(queue.getAddress())).add("filter", this.toString(queue.getFilter())).add("rate", this.toString(Float.valueOf(q.getRate()))).add("durable", this.toString(queue.isDurable())).add("paused", this.toString(q.isPaused())).add("temporary", this.toString(queue.isTemporary())).add("purgeOnNoConsumers", this.toString(queue.isPurgeOnNoConsumers())).add("consumerCount", this.toString(queue.getConsumerCount())).add("maxConsumers", this.toString(queue.getMaxConsumers())).add("autoCreated", this.toString(q.isAutoCreated())).add("user", this.toString(q.getUser())).add("routingType", this.toString(queue.getRoutingType())).add("messagesAdded", this.toString(queue.getMessagesAdded())).add("messageCount", this.toString(queue.getMessageCount())).add("messagesAcked", this.toString(queue.getMessagesAcknowledged())).add("deliveringCount", this.toString(queue.getDeliveringCount())).add("messagesKilled", this.toString(queue.getMessagesKilled())).add("deliverDeliver", this.toString(q.isDirectDeliver())).add("exclusive", this.toString(queue.isExclusive())).add("lastValue", this.toString(queue.isLastValue())).add("scheduledCount", this.toString(queue.getScheduledCount()));
        return obj;
    }

    @Override
    public Object getField(QueueControl queue, String fieldName) {
        Queue q = this.server.locateQueue(new SimpleString(queue.getName()));
        switch (fieldName) {
            case "id": {
                return queue.getID();
            }
            case "name": {
                return queue.getName();
            }
            case "address": {
                return queue.getAddress();
            }
            case "filter": {
                return queue.getFilter();
            }
            case "rate": {
                return Float.valueOf(q.getRate());
            }
            case "durable": {
                return queue.isDurable();
            }
            case "paused": {
                return q.isPaused();
            }
            case "temporary": {
                return queue.isTemporary();
            }
            case "purgeOnNoConsumers": {
                return queue.isPurgeOnNoConsumers();
            }
            case "consumerCount": {
                return queue.getConsumerCount();
            }
            case "maxConsumers": {
                return queue.getMaxConsumers();
            }
            case "autoCreated": {
                return q.isAutoCreated();
            }
            case "user": {
                return q.getUser();
            }
            case "routingType": {
                return queue.getRoutingType();
            }
            case "messagesAdded": {
                return queue.getMessagesAdded();
            }
            case "messageCount": {
                return queue.getMessageCount();
            }
            case "messagesAcked": {
                return queue.getMessagesAcknowledged();
            }
            case "deliveringCount": {
                return queue.getDeliveringCount();
            }
            case "messagesKilled": {
                return queue.getMessagesKilled();
            }
            case "deliverDeliver": {
                return q.isDirectDeliver();
            }
            case "exclusive": {
                return q.isExclusive();
            }
            case "lastValue": {
                return q.isLastValue();
            }
            case "scheduledCount": {
                return q.getScheduledCount();
            }
        }
        throw new IllegalArgumentException("Unsupported field, " + fieldName);
    }

    @Override
    public String getDefaultOrderColumn() {
        return defaultSortColumn;
    }
}

