/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.drools;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderAdminService;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.drools.DroolsPolicy;
import org.keycloak.authorization.policy.provider.drools.DroolsPolicyAdminResource;
import org.keycloak.authorization.policy.provider.drools.DroolsPolicyProvider;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.RulePolicyRepresentation;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;

public class DroolsPolicyProviderFactory
implements PolicyProviderFactory<RulePolicyRepresentation>,
EnvironmentDependentProviderFactory {
    private KieServices ks;
    private final Map<String, DroolsPolicy> containers = Collections.synchronizedMap(new HashMap());
    private DroolsPolicyProvider provider = new DroolsPolicyProvider(policy -> {
        if (!this.containers.containsKey(policy.getId())) {
            Map<String, DroolsPolicy> map = this.containers;
            synchronized (map) {
                this.update((Policy)policy);
            }
        }
        return this.containers.get(policy.getId());
    });

    public String getName() {
        return "Rules";
    }

    public String getGroup() {
        return "Rule Based";
    }

    public PolicyProvider create(AuthorizationProvider authorization) {
        return this.provider;
    }

    public RulePolicyRepresentation toRepresentation(Policy policy, AuthorizationProvider authorization) {
        RulePolicyRepresentation representation = new RulePolicyRepresentation();
        representation.setArtifactGroupId((String)policy.getConfig().get("mavenArtifactGroupId"));
        representation.setArtifactId((String)policy.getConfig().get("mavenArtifactId"));
        representation.setArtifactVersion((String)policy.getConfig().get("mavenArtifactVersion"));
        representation.setScannerPeriod((String)policy.getConfig().get("scannerPeriod"));
        representation.setScannerPeriodUnit((String)policy.getConfig().get("scannerPeriodUnit"));
        representation.setSessionName((String)policy.getConfig().get("sessionName"));
        representation.setModuleName((String)policy.getConfig().get("moduleName"));
        return representation;
    }

    public PolicyProviderAdminService getAdminResource(ResourceServer resourceServer, AuthorizationProvider authorization) {
        return new DroolsPolicyAdminResource(this);
    }

    public PolicyProvider create(KeycloakSession session) {
        return null;
    }

    public void onCreate(Policy policy, RulePolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updateConfig(policy, representation);
        this.update(policy);
    }

    public void onUpdate(Policy policy, RulePolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updateConfig(policy, representation);
        this.update(policy);
    }

    public void onImport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorization) {
        this.update(policy);
    }

    public void onRemove(Policy policy, AuthorizationProvider authorization) {
        this.remove(policy);
    }

    public Class<RulePolicyRepresentation> getRepresentationType() {
        return RulePolicyRepresentation.class;
    }

    public void init(Config.Scope config) {
        this.ks = KieServices.get();
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
        this.containers.values().forEach(DroolsPolicy::dispose);
        this.containers.clear();
    }

    public String getId() {
        return "rules";
    }

    private void updateConfig(Policy policy, RulePolicyRepresentation representation) {
        policy.putConfig("mavenArtifactGroupId", representation.getArtifactGroupId());
        policy.putConfig("mavenArtifactId", representation.getArtifactId());
        policy.putConfig("mavenArtifactVersion", representation.getArtifactVersion());
        policy.putConfig("scannerPeriod", representation.getScannerPeriod());
        policy.putConfig("scannerPeriodUnit", representation.getScannerPeriodUnit());
        policy.putConfig("sessionName", representation.getSessionName());
        policy.putConfig("moduleName", representation.getModuleName());
    }

    void update(Policy policy) {
        this.remove(policy);
        this.containers.put(policy.getId(), new DroolsPolicy(this.ks, policy));
    }

    void remove(Policy policy) {
        DroolsPolicy holder = this.containers.remove(policy.getId());
        if (holder != null) {
            holder.dispose();
        }
    }

    KieContainer getKieContainer(String groupId, String artifactId, String version) {
        return this.ks.newKieContainer(this.ks.newReleaseId(groupId, artifactId, version));
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.AUTHZ_DROOLS_POLICY);
    }
}

