/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.IOException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.marshall.WrappedByteArray;

public class BinaryEncoder
implements Encoder {
    private final StreamingMarshaller marshaller;

    public BinaryEncoder(StreamingMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public Object toStorage(Object content) {
        try {
            return this.skipEncoding(content) ? content : (Object)this.marshall(content);
        }
        catch (IOException | InterruptedException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public Object fromStorage(Object stored) {
        try {
            if (BinaryEncoder.isTypeExcluded(stored.getClass())) {
                return stored;
            }
            return stored instanceof byte[] ? this.marshaller.objectFromByteBuffer((byte[])stored) : stored;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public boolean isStorageFormatFilterable() {
        return false;
    }

    @Override
    public MediaType getStorageFormat() {
        return MediaType.APPLICATION_INFINISPAN_BINARY;
    }

    @Override
    public short id() {
        return 2;
    }

    private static boolean isTypeExcluded(Class<?> type) {
        return type.equals(String.class) || type.isPrimitive() || type.equals(Boolean.class) || type.equals(Character.class) || type.equals(Byte.class) || type.equals(Short.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Float.class) || type.equals(Double.class) || type.equals(WrappedByteArray.class);
    }

    private boolean skipEncoding(Object source) {
        return BinaryEncoder.isTypeExcluded(source.getClass());
    }

    protected Object unmarshall(byte[] source) throws IOException, ClassNotFoundException {
        return this.marshaller.objectFromByteBuffer(source);
    }

    protected byte[] marshall(Object source) throws IOException, InterruptedException {
        return this.marshaller.objectToByteBuffer(source);
    }
}

