/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.service;

import java.util.concurrent.TimeUnit;
import org.glassfish.enterprise.concurrent.AbstractManagedExecutorService;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedScheduledExecutorServiceAdapter;
import org.jboss.as.ee.concurrent.ManagedScheduledExecutorServiceImpl;
import org.jboss.as.ee.concurrent.ManagedThreadFactoryImpl;
import org.jboss.as.ee.concurrent.service.EEConcurrentAbstractService;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RequestController;

public class ManagedScheduledExecutorServiceService
extends EEConcurrentAbstractService<ManagedScheduledExecutorServiceAdapter> {
    private volatile ManagedScheduledExecutorServiceImpl executorService;
    private final String name;
    private final InjectedValue<ManagedThreadFactoryImpl> managedThreadFactoryInjectedValue;
    private final long hungTaskThreshold;
    private final boolean longRunningTasks;
    private final int corePoolSize;
    private final long keepAliveTime;
    private final TimeUnit keepAliveTimeUnit;
    private final long threadLifeTime;
    private final InjectedValue<ContextServiceImpl> contextService;
    private final AbstractManagedExecutorService.RejectPolicy rejectPolicy;
    private final InjectedValue<RequestController> requestController = new InjectedValue();
    private ControlPoint controlPoint;

    public ManagedScheduledExecutorServiceService(String name, String jndiName, long hungTaskThreshold, boolean longRunningTasks, int corePoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, long threadLifeTime, AbstractManagedExecutorService.RejectPolicy rejectPolicy) {
        super(jndiName);
        this.name = name;
        this.managedThreadFactoryInjectedValue = new InjectedValue();
        this.hungTaskThreshold = hungTaskThreshold;
        this.longRunningTasks = longRunningTasks;
        this.corePoolSize = corePoolSize;
        this.keepAliveTime = keepAliveTime;
        this.keepAliveTimeUnit = keepAliveTimeUnit;
        this.threadLifeTime = threadLifeTime;
        this.contextService = new InjectedValue();
        this.rejectPolicy = rejectPolicy;
    }

    @Override
    void startValue(StartContext context) throws StartException {
        ManagedThreadFactoryImpl managedThreadFactory = (ManagedThreadFactoryImpl)((Object)this.managedThreadFactoryInjectedValue.getOptionalValue());
        int priority = managedThreadFactory != null ? managedThreadFactory.getPriority() : 5;
        managedThreadFactory = new ManagedThreadFactoryImpl("EE-ManagedScheduledExecutorService-" + this.name, null, 5);
        if (this.requestController.getOptionalValue() != null) {
            this.controlPoint = ((RequestController)this.requestController.getValue()).getControlPoint(this.name, "managed-scheduled-executor-service");
        }
        this.executorService = new ManagedScheduledExecutorServiceImpl(this.name, managedThreadFactory, this.hungTaskThreshold, this.longRunningTasks, this.corePoolSize, this.keepAliveTime, this.keepAliveTimeUnit, this.threadLifeTime, (ContextServiceImpl)this.contextService.getOptionalValue(), this.rejectPolicy, this.controlPoint);
    }

    @Override
    void stopValue(StopContext context) {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService.getManagedThreadFactory().stop();
            this.executorService = null;
        }
        if (this.controlPoint != null) {
            ((RequestController)this.requestController.getValue()).removeControlPoint(this.controlPoint);
        }
    }

    public ManagedScheduledExecutorServiceAdapter getValue() throws IllegalStateException {
        if (this.executorService == null) {
            throw EeLogger.ROOT_LOGGER.concurrentServiceValueUninitialized();
        }
        return this.executorService.getAdapter();
    }

    public Injector<ManagedThreadFactoryImpl> getManagedThreadFactoryInjector() {
        return this.managedThreadFactoryInjectedValue;
    }

    public Injector<ContextServiceImpl> getContextServiceInjector() {
        return this.contextService;
    }

    public InjectedValue<RequestController> getRequestController() {
        return this.requestController;
    }
}

