/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.common.util.Base64Url;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.account.AccountLinkUriRepresentation;
import org.keycloak.representations.account.LinkedAccountRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.validation.Validation;

public class LinkedAccountsResource {
    private static final Logger logger = Logger.getLogger(LinkedAccountsResource.class);
    private final KeycloakSession session;
    private final HttpRequest request;
    private final ClientModel client;
    private final EventBuilder event;
    private final UserModel user;
    private final RealmModel realm;
    private final Auth auth;

    public LinkedAccountsResource(KeycloakSession session, HttpRequest request, ClientModel client, Auth auth, EventBuilder event, UserModel user) {
        this.session = session;
        this.request = request;
        this.client = client;
        this.auth = auth;
        this.event = event;
        this.user = user;
        this.realm = session.getContext().getRealm();
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response linkedAccounts() {
        this.auth.requireOneOf("manage-account", "view-profile");
        SortedSet<LinkedAccountRepresentation> linkedAccounts = this.getLinkedAccounts(this.session, this.realm, this.user);
        return Cors.add(this.request, Response.ok(linkedAccounts)).auth().allowedOrigins(this.auth.getToken()).build();
    }

    private Set<String> findSocialIds() {
        HashSet<String> socialIds = new HashSet<String>();
        List providerFactories = this.session.getKeycloakSessionFactory().getProviderFactories(SocialIdentityProvider.class);
        for (ProviderFactory factory : providerFactories) {
            socialIds.add(factory.getId());
        }
        return socialIds;
    }

    public SortedSet<LinkedAccountRepresentation> getLinkedAccounts(KeycloakSession session, RealmModel realm, UserModel user) {
        List identityProviders = realm.getIdentityProviders();
        TreeSet<LinkedAccountRepresentation> linkedAccounts = new TreeSet<LinkedAccountRepresentation>();
        if (identityProviders == null || identityProviders.isEmpty()) {
            return linkedAccounts;
        }
        Set<String> socialIds = this.findSocialIds();
        Set identities = session.users().getFederatedIdentities(user, realm);
        for (IdentityProviderModel provider : identityProviders) {
            if (!provider.isEnabled()) continue;
            String providerId = provider.getAlias();
            FederatedIdentityModel identity = this.getIdentity(identities, providerId);
            String displayName = KeycloakModelUtils.getIdentityProviderDisplayName((KeycloakSession)session, (IdentityProviderModel)provider);
            String guiOrder = provider.getConfig() != null ? (String)provider.getConfig().get("guiOrder") : null;
            LinkedAccountRepresentation rep = new LinkedAccountRepresentation();
            rep.setConnected(identity != null);
            rep.setSocial(socialIds.contains(provider.getProviderId()));
            rep.setProviderAlias(providerId);
            rep.setDisplayName(displayName);
            rep.setGuiOrder(guiOrder);
            rep.setProviderName(provider.getAlias());
            if (identity != null) {
                rep.setLinkedUsername(identity.getUserName());
            }
            linkedAccounts.add(rep);
        }
        return linkedAccounts;
    }

    private FederatedIdentityModel getIdentity(Set<FederatedIdentityModel> identities, String providerId) {
        for (FederatedIdentityModel link : identities) {
            if (!providerId.equals(link.getIdentityProvider())) continue;
            return link;
        }
        return null;
    }

    @GET
    @Path(value="/{providerId}")
    @Produces(value={"application/json"})
    @Deprecated
    public Response buildLinkedAccountURI(@PathParam(value="providerId") String providerId, @QueryParam(value="redirectUri") String redirectUri) {
        String errorMessage;
        this.auth.require("manage-account");
        if (redirectUri == null) {
            ErrorResponse.error("invalidRedirectUriMessage", Response.Status.BAD_REQUEST);
        }
        if ((errorMessage = this.checkCommonPreconditions(providerId)) != null) {
            return ErrorResponse.error(errorMessage, Response.Status.BAD_REQUEST);
        }
        try {
            String nonce = UUID.randomUUID().toString();
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            String input = nonce + this.auth.getSession().getId() + this.client.getClientId() + providerId;
            byte[] check = md.digest(input.getBytes(StandardCharsets.UTF_8));
            String hash = Base64Url.encode((byte[])check);
            URI linkUri = Urls.identityProviderLinkRequest(this.session.getContext().getUri().getBaseUri(), providerId, this.realm.getName());
            linkUri = UriBuilder.fromUri((URI)linkUri).queryParam("nonce", new Object[]{nonce}).queryParam("hash", new Object[]{hash}).queryParam("client_id", new Object[]{this.client.getClientId()}).queryParam("redirect_uri", new Object[]{redirectUri}).build(new Object[0]);
            AccountLinkUriRepresentation rep = new AccountLinkUriRepresentation();
            rep.setAccountLinkUri(linkUri);
            rep.setHash(hash);
            rep.setNonce(nonce);
            return Cors.add(this.request, Response.ok((Object)rep)).auth().allowedOrigins(this.auth.getToken()).build();
        }
        catch (Exception spe) {
            spe.printStackTrace();
            return ErrorResponse.error("failedToProcessResponseMessage", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Path(value="/{providerId}")
    @Produces(value={"application/json"})
    public Response removeLinkedAccount(@PathParam(value="providerId") String providerId) {
        this.auth.require("manage-account");
        String errorMessage = this.checkCommonPreconditions(providerId);
        if (errorMessage != null) {
            return ErrorResponse.error(errorMessage, Response.Status.BAD_REQUEST);
        }
        FederatedIdentityModel link = this.session.users().getFederatedIdentity(this.user, providerId, this.realm);
        if (link == null) {
            return ErrorResponse.error("federatedIdentityLinkNotActiveMessage", Response.Status.BAD_REQUEST);
        }
        if (this.session.users().getFederatedIdentities(this.user, this.realm).size() <= 1 && this.user.getFederationLink() == null && !this.isPasswordSet()) {
            return ErrorResponse.error("federatedIdentityRemovingLastProviderMessage", Response.Status.BAD_REQUEST);
        }
        this.session.users().removeFederatedIdentity(this.realm, this.user, providerId);
        logger.debugv("Social provider {0} removed successfully from user {1}", (Object)providerId, (Object)this.user.getUsername());
        this.event.event(EventType.REMOVE_FEDERATED_IDENTITY).client(this.auth.getClient()).user(this.auth.getUser()).detail("username", this.auth.getUser().getUsername()).detail("identity_provider", link.getIdentityProvider()).detail("identity_provider_identity", link.getUserName()).success();
        return Cors.add(this.request, Response.ok()).auth().allowedOrigins(this.auth.getToken()).build();
    }

    private String checkCommonPreconditions(String providerId) {
        this.auth.require("manage-account");
        if (Validation.isEmpty(providerId)) {
            return "missingIdentityProviderMessage";
        }
        if (!this.isValidProvider(providerId)) {
            return "identityProviderNotFoundMessage";
        }
        if (!this.user.isEnabled()) {
            return "accountDisabledMessage";
        }
        return null;
    }

    private boolean isPasswordSet() {
        return this.session.userCredentialManager().isConfiguredFor(this.realm, this.user, "password");
    }

    private boolean isValidProvider(String providerId) {
        for (IdentityProviderModel model : this.realm.getIdentityProviders()) {
            if (!model.getAlias().equals(providerId)) continue;
            return true;
        }
        return false;
    }
}

