/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.authenticator;

import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.ExtensionAuthenticatorOutput;
import com.webauthn4j.util.ArrayUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class AuthenticatorData<T extends ExtensionAuthenticatorOutput>
implements Serializable {
    public static final byte BIT_UP = 1;
    public static final byte BIT_UV = 4;
    public static final byte BIT_AT = 64;
    public static final byte BIT_ED = -128;
    private final byte[] rpIdHash;
    private final byte flags;
    private final long signCount;
    private final AttestedCredentialData attestedCredentialData;
    private final AuthenticationExtensionsAuthenticatorOutputs<T> extensions;

    public AuthenticatorData(byte[] rpIdHash, byte flags, long counter, AttestedCredentialData attestedCredentialData, AuthenticationExtensionsAuthenticatorOutputs<T> extensions) {
        this.rpIdHash = rpIdHash;
        this.flags = flags;
        this.signCount = counter;
        this.attestedCredentialData = attestedCredentialData;
        this.extensions = extensions;
    }

    public AuthenticatorData(byte[] rpIdHash, byte flags, long counter, AttestedCredentialData attestedCredentialData) {
        this.rpIdHash = rpIdHash;
        this.flags = flags;
        this.signCount = counter;
        this.attestedCredentialData = attestedCredentialData;
        this.extensions = new AuthenticationExtensionsAuthenticatorOutputs();
    }

    public AuthenticatorData(byte[] rpIdHash, byte flags, long counter, AuthenticationExtensionsAuthenticatorOutputs<T> extensions) {
        this.rpIdHash = rpIdHash;
        this.flags = flags;
        this.signCount = counter;
        this.attestedCredentialData = null;
        this.extensions = extensions;
    }

    public AuthenticatorData(byte[] rpIdHash, byte flags, long counter) {
        this.rpIdHash = rpIdHash;
        this.flags = flags;
        this.signCount = counter;
        this.attestedCredentialData = null;
        this.extensions = new AuthenticationExtensionsAuthenticatorOutputs();
    }

    public static boolean checkFlagUP(byte flags) {
        return (flags & 1) != 0;
    }

    public static boolean checkFlagUV(byte flags) {
        return (flags & 4) != 0;
    }

    public static boolean checkFlagAT(byte flags) {
        return (flags & 0x40) != 0;
    }

    public static boolean checkFlagED(byte flags) {
        return (flags & 0xFFFFFF80) != 0;
    }

    public byte[] getRpIdHash() {
        return ArrayUtil.clone((byte[])this.rpIdHash);
    }

    public byte getFlags() {
        return this.flags;
    }

    public boolean isFlagUP() {
        return AuthenticatorData.checkFlagUP(this.flags);
    }

    public boolean isFlagUV() {
        return AuthenticatorData.checkFlagUV(this.flags);
    }

    public boolean isFlagAT() {
        return AuthenticatorData.checkFlagAT(this.flags);
    }

    public boolean isFlagED() {
        return AuthenticatorData.checkFlagED(this.flags);
    }

    public long getSignCount() {
        return this.signCount;
    }

    public AttestedCredentialData getAttestedCredentialData() {
        return this.attestedCredentialData;
    }

    public AuthenticationExtensionsAuthenticatorOutputs<T> getExtensions() {
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorData that = (AuthenticatorData)o;
        return this.flags == that.flags && this.signCount == that.signCount && Arrays.equals(this.rpIdHash, that.rpIdHash) && Objects.equals(this.attestedCredentialData, that.attestedCredentialData) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        int result = Objects.hash(this.flags, this.signCount, this.attestedCredentialData, this.extensions);
        result = 31 * result + Arrays.hashCode(this.rpIdHash);
        return result;
    }
}

