/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionTypeCalculator;
import org.openstreetmap.josm.tools.I18n;

public class PublicTransportRouteTest
extends Test {
    private final WayConnectionTypeCalculator connectionTypeCalculator = new WayConnectionTypeCalculator();

    public PublicTransportRouteTest() {
        super(I18n.tr("Public Transport Route", new Object[0]));
    }

    @Override
    public void visit(Relation r) {
        boolean skip;
        boolean bl = skip = r.hasIncompleteMembers() || !r.hasTag("type", "route") || !r.hasKey("route") || !r.hasTag("public_transport:version", "2");
        if (skip) {
            return;
        }
        ArrayList<RelationMember> membersToCheck = new ArrayList<RelationMember>();
        HashSet<Node> routeNodes = new HashSet<Node>();
        for (RelationMember member : r.getMembers()) {
            if (member.hasRole("forward", "backward", "alternate")) {
                this.errors.add(TestError.builder(this, Severity.ERROR, 3601).message(I18n.tr("Route relation contains a ''{0}'' role", "forward/backward/alternate")).primitives(r).build());
                return;
            }
            if (!member.hasRole("", "hail_and_ride") || OsmPrimitiveType.WAY != member.getType()) continue;
            membersToCheck.add(member);
            routeNodes.addAll(member.getWay().getNodes());
        }
        if (membersToCheck.isEmpty()) {
            return;
        }
        List<WayConnectionType> links = this.connectionTypeCalculator.updateLinks(membersToCheck);
        for (int i = 0; i < links.size(); ++i) {
            boolean hasError;
            WayConnectionType link = links.get(i);
            boolean bl2 = hasError = i != 0 && !link.linkPrev || i != links.size() - 1 && !link.linkNext || link.direction == null || WayConnectionType.Direction.NONE == link.direction;
            if (!hasError) continue;
            this.errors.add(TestError.builder(this, Severity.WARNING, 3602).message(I18n.tr("Route relation contains a gap", new Object[0])).primitives(r).build());
            return;
        }
        for (RelationMember member : r.getMembers()) {
            if (!member.hasRole("stop", "stop_exit_only", "stop_entry_only") || OsmPrimitiveType.NODE != member.getType() || routeNodes.contains(member.getNode())) continue;
            this.errors.add(TestError.builder(this, Severity.WARNING, 3603).message(I18n.tr("Stop position not part of route", new Object[0])).primitives(member.getMember(), r).build());
        }
    }

    @Override
    public void clear() {
        this.connectionTypeCalculator.clear();
        super.clear();
    }
}

