#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tamarin-prover-theory
version: 1.4.1
id: tamarin-prover-theory-1.4.1-9zhQaBJWO3S7YCjy7pbGmu
key: tamarin-prover-theory-1.4.1-9zhQaBJWO3S7YCjy7pbGmu
license: LicenseRef-GPL
copyright: Benedikt Schmidt, Simon Meier, Jannik Dreier, Ralf Sasse, ETH Zurich, 2010-2018
maintainer: Simon Meier <simon.meier@inf.ethz.ch>,
            Jannik Dreier <research@jannikdreier.net>,
            Ralf Sasse <ralf.sasse@gmail.com>
author: Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
        Simon Meier <simon.meier@inf.ethz.ch>,
        Jannik Dreier <research@jannikdreier.net>,
        Ralf Sasse <ralf.sasse@gmail.com>
homepage: https://tamarin-prover.github.io/
synopsis: Security protocol types and constraint solver library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).
    .
    This library provides the types to represent security
    protocol, and it implements the constraint solver.
category: Theorem Provers
abi: 8d88819f3f2c1de95cfe79677a66e135
exposed: True
exposed-modules:
    Theory Theory.Constraint.Solver
    Theory.Constraint.Solver.Contradictions
    Theory.Constraint.Solver.Goals Theory.Constraint.Solver.Heuristics
    Theory.Constraint.Solver.ProofMethod
    Theory.Constraint.Solver.Reduction
    Theory.Constraint.Solver.Simplify Theory.Constraint.Solver.Sources
    Theory.Constraint.System Theory.Constraint.System.Constraints
    Theory.Constraint.System.Dot Theory.Constraint.System.Guarded
    Theory.Constraint.System.JSON Theory.Model Theory.Model.Atom
    Theory.Model.Fact Theory.Model.Formula Theory.Model.Rule
    Theory.Model.Signature Theory.Proof Theory.Text.Parser
    Theory.Text.Parser.Token Theory.Text.Pretty
    Theory.Tools.AbstractInterpretation Theory.Tools.EquationStore
    Theory.Tools.InjectiveFactInstances Theory.Tools.IntruderRules
    Theory.Tools.LoopBreakers Theory.Tools.RuleVariants
    Theory.Tools.Wellformedness
import-dirs: /usr/lib/ghc-8.6.5/site-local/tamarin-prover-theory-1.4.1
library-dirs: /usr/lib/ghc-8.6.5/site-local/tamarin-prover-theory-1.4.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.5/tamarin-prover-theory-1.4.1
hs-libraries: HStamarin-prover-theory-1.4.1-9zhQaBJWO3S7YCjy7pbGmu
depends:
    aeson-1.4.6.0-IYkWE2kAqOg3BtypRoad0s
    aeson-pretty-0.8.8-5a4uAQxPioc7WoNGm6e0qR base-4.12.0.0
    binary-0.8.6.0 bytestring-0.10.8.2 containers-0.6.0.1
    deepseq-1.4.4.0 dlist-0.8.0.7-9IDoNbvEdvB71Nf8e7qTot
    fclabels-2.0.3.3-HOyKDsjMEMPLME2kWUFOry mtl-2.2.2
    parallel-3.2.2.0-EGl5SOk48TWHAD161C93aQ parsec-3.1.13.0
    process-1.6.5.0 safe-0.3.18-LtdH37oJsulDSBmeOJDMc3
    tamarin-prover-term-1.4.1-FWLErBEpcMHLmGgOrFCE5
    tamarin-prover-utils-1.4.1-CJFk8E2cTljJzzJzyzsyIr text-1.2.3.1
    transformers-0.5.6.2 uniplate-1.6.12-728qixY9X6X7DLfIoKBNaj
haddock-interfaces: /usr/share/doc/haskell-tamarin-prover-theory/html/tamarin-prover-theory.haddock
haddock-html: /usr/share/doc/haskell-tamarin-prover-theory/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

