/*
 * Decompiled with CFR 0.152.
 */
package grails.io;

import grails.util.BuildSettings;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.io.support.Resource;
import org.grails.io.support.SpringIOUtils;
import org.grails.io.support.UrlResource;

public class IOUtils
extends SpringIOUtils
implements GroovyObject {
    public static final String RESOURCE_JAR_PREFIX = ".jar!";
    public static final String RESOURCE_WAR_PREFIX = ".war!";
    private static String applicationDirectory;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final Closure memoizedMethodClosure$findApplicationDirectoryFile;
    private static final Closure memoizedMethodClosure$findSourceFileString;
    private static final Closure memoizedMethodClosure$findApplicationDirectory;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public IOUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static BufferedInputStream openStream(File file) {
        if (!file.exists()) {
            throw (Throwable)new FileNotFoundException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file}, new String[]{"File ", " does not exist"})));
        }
        if (file.isDirectory()) {
            throw (Throwable)new IOException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file}, new String[]{"File ", " exists but is a directory"})));
        }
        if (!file.canRead()) {
            throw (Throwable)new IOException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file}, new String[]{"File ", " cannot be read"})));
        }
        return ResourceGroovyMethods.newInputStream((File)file);
    }

    public static String toString(Reader reader) {
        StringWriter writer = new StringWriter();
        SpringIOUtils.copy(reader, (Writer)writer);
        return writer.toString();
    }

    public static String toString(InputStream stream, String encoding) {
        StringWriter writer = new StringWriter();
        IOUtils.copy(stream, writer, encoding);
        return writer.toString();
    }

    public static void copy(InputStream input, Writer output, String encoding) {
        InputStreamReader reader = DefaultTypeTransformation.booleanUnbox((Object)encoding) ? new InputStreamReader(input, encoding) : new InputStreamReader(input);
        SpringIOUtils.copy(reader, output);
    }

    public static File findJarFile(Class targetClass) {
        URL resource = IOUtils.findClassResource(targetClass);
        return IOUtils.findJarFile(resource);
    }

    public static boolean isWithinBinary(URL url) {
        String protocol = url.getProtocol();
        return protocol == null || ScriptBytecodeAdapter.compareNotEqual((Object)protocol, (Object)"file");
    }

    public static File findJarFile(Resource resource) {
        Resource resource2 = resource;
        String absolutePath = resource2 != null ? resource2.getFilename() : null;
        if (DefaultTypeTransformation.booleanUnbox((Object)absolutePath)) {
            String jarPath = absolutePath.substring("file:".length(), absolutePath.lastIndexOf("!"));
            new File(jarPath);
        }
        return (File)ScriptBytecodeAdapter.castToType(null, File.class);
    }

    public static File findJarFile(URL resource) {
        URL uRL = resource;
        if (ScriptBytecodeAdapter.compareEqual((Object)(uRL != null ? uRL.getProtocol() : null), (Object)"jar")) {
            URL uRL2 = resource;
            String absolutePath = uRL2 != null ? uRL2.getPath() : null;
            if (DefaultTypeTransformation.booleanUnbox((Object)absolutePath)) {
                File file = Paths.get(new URL(absolutePath.substring(0, absolutePath.lastIndexOf("!"))).toURI()).toFile();
                try {
                    return file;
                }
                catch (MalformedURLException e) {
                    File file2 = (File)ScriptBytecodeAdapter.castToType(null, File.class);
                    return file2;
                }
            }
        }
        return (File)ScriptBytecodeAdapter.castToType(null, File.class);
    }

    public static URL findClassResource(Class targetClass) {
        return targetClass.getResource(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"/", (CharSequence)targetClass.getName().replace(".", "/")), (CharSequence)".class"));
    }

    public static URL findRootResource(Class targetClass) {
        String pathToClassFile = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"/", (CharSequence)targetClass.getName().replace(".", "/")), (CharSequence)".class");
        URL classRes = targetClass.getResource(pathToClassFile);
        if (classRes != null) {
            String rootPath = StringGroovyMethods.minus((CharSequence)classRes.toString(), (Object)pathToClassFile);
            return new URL(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{rootPath}, new String[]{"", "/"})));
        }
        throw (Throwable)new IllegalStateException("Root classpath resource not found! Check your disk permissions");
    }

    public static URL findRootResourcesURL(Class targetClass) {
        String pathToClassFile = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"/", (CharSequence)targetClass.getName().replace(".", "/")), (CharSequence)".class");
        URL classRes = targetClass.getResource(pathToClassFile);
        if (classRes != null) {
            String rootPath = StringGroovyMethods.minus((CharSequence)classRes.toString(), (Object)pathToClassFile);
            if (rootPath.endsWith(BuildSettings.BUILD_CLASSES_PATH)) {
                String string;
                rootPath = string = rootPath.replace("/build/classes/groovy/", "/build/resources/");
            } else {
                GStringImpl gStringImpl = new GStringImpl(new Object[]{rootPath}, new String[]{"", "/"});
                rootPath = ShortTypeHandling.castToString((Object)gStringImpl);
            }
            return new URL(rootPath);
        }
        return (URL)ScriptBytecodeAdapter.castToType(null, URL.class);
    }

    public static URL findJarResource(Class targetClass) {
        URL classUrl = IOUtils.findClassResource(targetClass);
        if (classUrl != null) {
            String urlPath = classUrl.toString();
            int bang = urlPath.lastIndexOf("!");
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)bang, (Object)-1)) {
                String newPath = urlPath.substring(0, bang);
                return new URL(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{newPath}, new String[]{"", "!/"})));
            }
        }
        return (URL)ScriptBytecodeAdapter.castToType(null, URL.class);
    }

    public static URL findResourceRelativeToClass(Class targetClass, String path) {
        String pathToClassFile = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"/", (CharSequence)targetClass.getName().replace(".", "/")), (CharSequence)".class");
        URL classRes = targetClass.getResource(pathToClassFile);
        if (classRes != null) {
            String rootPath = StringGroovyMethods.minus((CharSequence)classRes.toString(), (Object)pathToClassFile);
            if (rootPath.endsWith(BuildSettings.BUILD_CLASSES_PATH)) {
                String string;
                rootPath = string = rootPath.replace("/build/classes/groovy/", "/build/resources/");
            }
            return new URL(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{rootPath, path}, new String[]{"", "", ""})));
        }
        return (URL)ScriptBytecodeAdapter.castToType(null, URL.class);
    }

    public static File findApplicationDirectoryFile() {
        return (File)ScriptBytecodeAdapter.castToType((Object)memoizedMethodClosure$findApplicationDirectoryFile.call(), File.class);
    }

    public static File findApplicationDirectoryFile(Class targetClass) {
        block10: {
            URL rootResource = IOUtils.findRootResource(targetClass);
            if (rootResource != null) {
                File rootFile;
                block9: {
                    rootFile = new UrlResource(rootResource).getFile().getCanonicalFile();
                    String rootPath = rootFile.getPath();
                    String buildClassespath = BuildSettings.BUILD_CLASSES_PATH.replace("/", File.separator);
                    if (!rootPath.contains(buildClassespath)) break block9;
                    File file = new File(StringGroovyMethods.minus((CharSequence)rootPath, (Object)buildClassespath));
                    return file;
                }
                File appDir = IOUtils.findGrailsApp(rootFile);
                if (!(appDir != null)) break block10;
                File file = appDir;
                try {
                    return file;
                }
                catch (FileNotFoundException fnfe) {
                    File file2 = (File)ScriptBytecodeAdapter.castToType(null, File.class);
                    return file2;
                }
            }
        }
        return (File)ScriptBytecodeAdapter.castToType(null, File.class);
    }

    public static File findSourceFile(String className) {
        return (File)ScriptBytecodeAdapter.castToType((Object)memoizedMethodClosure$findSourceFileString.call((Object)className), File.class);
    }

    public static String findApplicationDirectory() {
        return ShortTypeHandling.castToString((Object)memoizedMethodClosure$findApplicationDirectory.call());
    }

    private static File findGrailsApp(File file) {
        File parent = file.getParentFile();
        while (parent != null) {
            File file2;
            File grailsApp = new File(parent, "grails-app");
            if (grailsApp.isDirectory()) {
                return parent;
            }
            parent = file2 = parent.getParentFile();
        }
        return (File)ScriptBytecodeAdapter.castToType(null, File.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != IOUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    private static File memoizedMethodPriv$findApplicationDirectoryFile() {
        String directory = IOUtils.findApplicationDirectory();
        if (DefaultTypeTransformation.booleanUnbox((Object)directory)) {
            File f = new File(directory);
            if (f.exists()) {
                return f;
            }
        }
        return (File)ScriptBytecodeAdapter.castToType(null, File.class);
    }

    @Generated
    private static File memoizedMethodPriv$findSourceFileString(String className) {
        File applicationDir = BuildSettings.BASE_DIR;
        File file = null;
        if (applicationDir != null) {
            String fileName = StringGroovyMethods.plus((String)className.replace(DefaultTypeTransformation.charUnbox((Object)ScriptBytecodeAdapter.asType((Object)".", Character.TYPE)), File.separatorChar), (CharSequence)".groovy");
            List allFiles = ScriptBytecodeAdapter.createList((Object[])new Object[]{new File(applicationDir, "src/main/groovy")});
            File[] files = new File(applicationDir, "grails-app").listFiles(new FileFilter(IOUtils.class){
                public /* synthetic */ Class this$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private transient /* synthetic */ MetaClass metaClass;
                {
                    MetaClass metaClass;
                    Class clazz;
                    this.this$0 = clazz = p0;
                    this.metaClass = metaClass = this.$getStaticMetaClass();
                }

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() && !f.isHidden() && !f.getName().startsWith(".");
                }

                public /* synthetic */ Object methodMissing(String name, Object args) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, IOUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, IOUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public /* synthetic */ void propertyMissing(String name, Object val) {
                    Object object = val;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, IOUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                    Object object = val;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, IOUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object propertyMissing(String name) {
                    return ScriptBytecodeAdapter.getProperty(1.class, IOUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public static /* synthetic */ Object $static_propertyMissing(String name) {
                    return ScriptBytecodeAdapter.getProperty(1.class, IOUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != 1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }

                @Generated
                @Internal
                public /* synthetic */ MetaClass getMetaClass() {
                    MetaClass metaClass = this.metaClass;
                    if (metaClass != null) {
                        return metaClass;
                    }
                    this.metaClass = this.$getStaticMetaClass();
                    return this.metaClass;
                }

                @Generated
                @Internal
                public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                    this.metaClass = metaClass;
                }

                @Generated
                @Internal
                public /* synthetic */ Object invokeMethod(String string, Object object) {
                    return this.getMetaClass().invokeMethod((Object)this, string, object);
                }

                @Generated
                @Internal
                public /* synthetic */ Object getProperty(String string) {
                    return this.getMetaClass().getProperty((Object)this, string);
                }

                @Generated
                @Internal
                public /* synthetic */ void setProperty(String string, Object object) {
                    this.getMetaClass().setProperty((Object)this, string, object);
                }
            });
            if (files != null) {
                allFiles.addAll(Arrays.asList((Object[])ScriptBytecodeAdapter.castToType((Object)files, Object[].class)));
            }
            File dir = null;
            Iterator iterator = allFiles.iterator();
            while (iterator.hasNext()) {
                File file2;
                dir = (File)ScriptBytecodeAdapter.castToType(iterator.next(), File.class);
                File possibleFile = new File(dir, fileName);
                if (!possibleFile.exists()) continue;
                file = file2 = possibleFile;
                break;
            }
        }
        return file;
    }

    @Generated
    private static String memoizedMethodPriv$findApplicationDirectory() {
        String string;
        if (DefaultTypeTransformation.booleanUnbox((Object)applicationDirectory)) {
            return applicationDirectory;
        }
        String location = null;
        try {
            String mainClassName = System.getProperty(BuildSettings.MAIN_CLASS_NAME);
            if (!DefaultTypeTransformation.booleanUnbox((Object)mainClassName)) {
                List stackTraceElements = DefaultGroovyMethods.reverse(Arrays.asList((Object[])ScriptBytecodeAdapter.castToType((Object)Thread.currentThread().getStackTrace(), Object[].class)));
                if (DefaultTypeTransformation.booleanUnbox((Object)stackTraceElements)) {
                    StackTraceElement lastElement = null;
                    Iterator iterator = stackTraceElements.iterator();
                    while (iterator.hasNext()) {
                        String string2;
                        lastElement = (StackTraceElement)ScriptBytecodeAdapter.castToType(iterator.next(), StackTraceElement.class);
                        String className = lastElement.getClassName();
                        String methodName = lastElement.getMethodName();
                        if (!(className.endsWith(".Application") && ScriptBytecodeAdapter.compareEqual((Object)methodName, (Object)"<clinit>"))) continue;
                        mainClassName = string2 = className;
                        break;
                    }
                }
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)mainClassName)) {
                Class<?> mainClass = Thread.currentThread().getContextClassLoader().loadClass(mainClassName);
                URL classResource = (URL)ScriptBytecodeAdapter.castToType((Object)(mainClass != null ? IOUtils.findClassResource(mainClass) : null), URL.class);
                if (classResource != null) {
                    File file = new UrlResource(classResource).getFile();
                    String path = file.getCanonicalPath();
                    String buildClassesPath = BuildSettings.BUILD_CLASSES_PATH.replace("/", File.separator);
                    if (path.contains(buildClassesPath)) {
                        String string3;
                        location = string3 = path.substring(0, path.indexOf(buildClassesPath) - 1);
                    } else {
                        File appDir = IOUtils.findGrailsApp(file);
                        if (appDir != null) {
                            String string4;
                            location = string4 = appDir.getCanonicalPath();
                        }
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (IOException e) {
        }
        applicationDirectory = string = location;
        return location;
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(IOUtils.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, IOUtils.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(IOUtils.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    public static String toString(InputStream stream) {
        return IOUtils.toString(stream, null);
    }

    @Generated
    public static void copy(InputStream input, Writer output) {
        IOUtils.copy(input, output, null);
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Closure closure;
        Closure closure2;
        Closure closure3;
        public final class __clinit__closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IOUtils.memoizedMethodPriv$findApplicationDirectoryFile();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        memoizedMethodClosure$findApplicationDirectoryFile = closure3 = new __clinit__closure1(IOUtils.class, IOUtils.class).memoize();
        public final class __clinit__closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String className) {
                return IOUtils.memoizedMethodPriv$findSourceFileString(className);
            }

            public Object call(String className) {
                return this.doCall(className);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        memoizedMethodClosure$findSourceFileString = closure2 = new __clinit__closure2(IOUtils.class, IOUtils.class).memoize();
        public final class __clinit__closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IOUtils.memoizedMethodPriv$findApplicationDirectory();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        memoizedMethodClosure$findApplicationDirectory = closure = new __clinit__closure3(IOUtils.class, IOUtils.class).memoize();
    }
}

