/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.filters.library;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.Icon;
import org.gephi.desktop.filters.library.CategoryChildFactory;
import org.gephi.desktop.filters.library.FiltersExplorer;
import org.gephi.desktop.filters.query.QueryNode;
import org.gephi.filters.api.FilterController;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.spi.Category;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class CategoryNode
extends AbstractNode {
    private Category category;

    public CategoryNode(FiltersExplorer.Utils utils, Category category) {
        super(utils.isLeaf(category) ? Children.LEAF : Children.create((ChildFactory)new CategoryChildFactory(utils, category), (boolean)true));
        this.category = category;
        if (category != null) {
            this.setName(category.getName());
        } else {
            this.setName(NbBundle.getMessage(CategoryNode.class, (String)"RootNode.name"));
        }
    }

    public Image getIcon(int type) {
        try {
            if (this.category.getIcon() != null) {
                return ImageUtilities.icon2Image((Icon)this.category.getIcon());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.category == null) {
            return ImageUtilities.loadImage((String)"org/gephi/desktop/filters/library/resources/library.png");
        }
        return ImageUtilities.loadImage((String)"org/gephi/desktop/filters/library/resources/folder.png");
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        if (this.category == null || !this.category.equals((Object)FiltersExplorer.QUERIES)) {
            return null;
        }
        final Node dropNode = NodeTransfer.node((Transferable)t, (int)3);
        if (dropNode != null && dropNode instanceof QueryNode) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    QueryNode queryNode = (QueryNode)dropNode;
                    FilterController filterController = (FilterController)Lookup.getDefault().lookup(FilterController.class);
                    FilterLibrary library = filterController.getModel().getLibrary();
                    library.saveQuery(queryNode.getQuery());
                    return null;
                }
            };
        }
        return null;
    }

    public Category getCategory() {
        return this.category;
    }

    public Action[] getActions(boolean context) {
        return new Action[0];
    }
}

