/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import freemind.main.FreeMindMain;
import freemind.main.Resources;
import freemind.main.Tools;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class EditServer
extends Thread {
    protected static Logger logger = null;
    private final FreeMindMain mFrame;
    private String portFile;
    private ServerSocket socket;
    private int authKey;
    private boolean ok;
    private boolean abort;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EditServer(String portFile, FreeMindMain pFrame) {
        super("FreeMind server daemon [" + portFile + "]");
        this.mFrame = pFrame;
        if (logger == null) {
            logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
        this.setDaemon(true);
        this.portFile = portFile;
        try {
            if (Tools.isUnix()) {
                new File(portFile).createNewFile();
                Tools.setPermissions(portFile, 384);
            }
            this.socket = new ServerSocket(0, 2, InetAddress.getByName("127.0.0.1"));
            this.authKey = new Random().nextInt(Integer.MAX_VALUE);
            int port = this.socket.getLocalPort();
            FileWriter out = new FileWriter(portFile);
            try {
                out.write("b\n");
                out.write(String.valueOf(port));
                out.write("\n");
                out.write(String.valueOf(this.authKey));
                out.write("\n");
            }
            finally {
                out.close();
            }
            this.ok = true;
            logger.info("FreeMind server started on port " + this.socket.getLocalPort());
            logger.info("Authorization key is " + this.authKey);
        }
        catch (IOException io) {
            logger.info("" + io);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.abort) {
            Socket client = null;
            try {
                client = this.socket.accept();
                client.setSoTimeout(1000);
                logger.info(client + ": connected");
                DataInputStream in = new DataInputStream(client.getInputStream());
                if (this.handleClient(client, in)) continue;
                this.abort = true;
            }
            catch (Exception e) {
                if (!this.abort) {
                    logger.info("" + e);
                }
                this.abort = true;
            }
        }
        return;
    }

    boolean isOK() {
        return this.ok;
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    void stopServer() {
        this.abort = true;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        new File(this.portFile).delete();
    }

    private boolean handleClient(Socket client, DataInputStream in) throws Exception {
        int key = in.readInt();
        if (key != this.authKey) {
            logger.info(client + ": wrong" + " authorization key (got " + key + ", expected " + this.authKey + ")");
            in.close();
            client.close();
            return false;
        }
        client.setSoTimeout(0);
        logger.info(client + ": authenticated" + " successfully");
        final String script = in.readUTF();
        logger.info(script);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Vector urls = Tools.urlStringToUrls(script);
                    for (URL urli : urls) {
                        EditServer.this.mFrame.getController().getModeController().load(urli);
                    }
                }
                catch (MalformedURLException e) {
                    Resources.getInstance().logException(e);
                }
                catch (Exception e) {
                    Resources.getInstance().logException(e);
                }
            }
        });
        in.close();
        client.close();
        return true;
    }
}

