define(["events","layoutManager","connectionManager","globalize","dom","appRouter","cardBuilder","apphost"],function(events,layoutManager,connectionManager,globalize,dom,appRouter,cardBuilder,appHost){"use strict";var navDrawerElement,currentServerId,newInnerHtml,currentViewEvent,appHeader,currentDrawerType=0,enableLazyLoadingDrawerContents=!1;function getNavDrawerElement(){return navDrawerElement||(navDrawerElement=document.querySelector(".mainDrawer"),dom.addEventListener(navDrawerElement,"click",onNavDrawerClick,{passive:!0})),navDrawerElement}function onNavDrawerClick(e){var navMenuOption=dom.parentWithClass(e.target,"navMenuOption");navMenuOption&&"logout"===navMenuOption.getAttribute("data-onclick")&&appRouter.logout()}function createAdminMenuList(pluginItems,apiClient){var links=[{name:globalize.translate("Server")},{name:globalize.translate("Dashboard"),href:"/dashboard.html",icon:"dashboard"},{name:globalize.translate("Settings"),href:"/dashboardgeneral.html",icon:"settings"},{name:globalize.translate("Users"),href:"/users/users.html",icon:"people"},{name:"Emby Premiere",href:"/supporterkey.html",icon:"star"},{name:globalize.translate("Library"),href:"/librarysetup/library.html",icon:"folder"},{name:globalize.translate("Network"),icon:"wifi",href:"/network/network.html"},{name:globalize.translate("Transcoding"),icon:"transform",href:"/encodingsettings.html"}];return apiClient.isMinServerVersion("4.3.0.7")&&links.push({name:globalize.translate("Conversions"),icon:"transform",href:"/syncactivity.html?mode=convert"}),addPluginPagesToMainMenu(links,pluginItems,"server"),links.push({divider:!0,name:globalize.translate("Devices")}),links.push({name:globalize.translate("Devices"),href:"/devices/devices.html",icon:"devices"}),links.push({name:globalize.translate("Downloads"),icon:"cloud_download",href:"/syncactivity.html"}),links.push({name:globalize.translate("HeaderCameraUpload"),href:"/devices/cameraupload.html",icon:"photo_camera"}),addPluginPagesToMainMenu(links,pluginItems,"devices"),links.push({divider:!0,name:globalize.translate("LiveTV")}),links.push({name:globalize.translate("LiveTV"),href:"/livetvsetup/livetvstatus.html",icon:"&#xE639;"}),links.push({name:"DVR",href:"/livetvsetup/livetvsettings.html",icon:"dvr"}),links.push({divider:!0,name:globalize.translate("Advanced")}),links.push({name:globalize.translate("Logs"),href:"/logs/logs.html",icon:"folder_open"}),links.push({name:globalize.translate("Notifications"),icon:"notifications",href:"/notificationsettings.html"}),links.push({name:globalize.translate("Plugins"),icon:"add_shopping_cart",href:"/plugins/plugins.html"}),links.push({name:globalize.translate("TabScheduledTasks"),href:"/scheduledtasks/scheduledtasks.html",icon:"schedule"}),links.push({name:globalize.translate("HeaderApiKeys"),href:"/apikeys/apikeys.html",icon:"vpn_key"}),links.push({name:globalize.translate("MetadataManager"),href:"/edititemmetadata.html",icon:"edit"}),addPluginPagesToMainMenu(links,pluginItems),links}function addPluginPagesToMainMenu(links,pluginItems,section){for(var i=0,length=pluginItems.length;i<length;i++){var pluginItem=pluginItems[i];Dashboard.allowPluginPages(pluginItem.PluginId)&&pluginItem.EnableInMainMenu&&pluginItem.MenuSection===section&&links.push({name:pluginItem.DisplayName,icon:pluginItem.MenuIcon||"folder",href:Dashboard.getConfigurationPageUrl(pluginItem.Name),navMenuId:"/"+Dashboard.getConfigurationPageUrl(pluginItem.Name)})}}function getNavMenuLinkHtml(item){var menuHtml="",navMenuId=item.navMenuId;if(!navMenuId&&item.href){var routeInfo=appRouter.getRouteInfo(item.href);navMenuId=routeInfo&&routeInfo.navMenuId||item.href}return navMenuId=navMenuId?' data-navmenuid="'+navMenuId+'"':"",item.onclick&&(navMenuId+=' data-onclick="'+item.onclick+'"'),menuHtml+="<a"+navMenuId+' is="emby-linkbutton" class="navMenuOption" href="'+item.href+'">',item.icon&&(menuHtml+='<i class="md-icon navMenuOptionIcon">'+item.icon+"</i>"),menuHtml+='<span class="navMenuOptionText">',menuHtml+=item.name,menuHtml+="</span>",menuHtml+="</a>"}function getAdminMenuLinks(apiClient){return apiClient.getJSON(apiClient.getUrl("web/configurationpages")+"?pageType=PluginConfiguration&EnableInMainMenu=true").then(function(items){return createAdminMenuList(items,apiClient)},function(err){return createAdminMenuList([],apiClient)})}function getItemsHtml(items){var i,length,item,menuHtml="";for(i=0,length=items.length;i<length;i++)(item=items[i]).href?menuHtml+=getNavMenuLinkHtml(item):item.name&&(menuHtml+='<h3 class="navMenuHeader secondaryText">',menuHtml+=item.name,menuHtml+="</h3>");return menuHtml}function getLibraryDrawerHtml(apiClient){return apiClient.getCurrentUser().then(function(user){return function(apiClient){return apiClient.getUserViews({},apiClient.getCurrentUserId()).then(function(result){for(var items=result.Items,list=[],i=0,length=items.length;i<length;i++){var view=items[i];if(list.push(view),"livetv"===view.CollectionType){var guideView=Object.assign({},view);guideView.Name=globalize.translate("Guide"),guideView.ImageTags={},guideView.icon="dvr",guideView.url=appRouter.getRouteUrl("livetv",{section:"guide",serverId:apiClient.serverId()}),list.push(guideView)}}return list})}(apiClient).then(function(result){var items=result,menuItems=[];menuItems.push({name:globalize.translate("Home"),icon:"&#xE88A;",href:appRouter.getRouteUrl("home")}),user.Policy.EnableContentDownloading&&appHost.supports("sync")&&(menuItems.push({name:globalize.translate("HeaderMyDownloads")}),menuItems.push({name:globalize.translate("Downloads"),href:appRouter.getRouteUrl("downloads"),icon:"&#xE2C7;"}),menuItems.push({name:globalize.translate("Manage"),href:appRouter.getRouteUrl("managedownloads"),icon:"&#xE3C9;"})),menuItems.push({name:globalize.translate("HeaderMyMedia")});for(var iconOptions={defaultCardImageIcon:"folder"},i=0,length=items.length;i<length;i++){var item=items[i],url=appRouter.getRouteUrl(item,{context:item.CollectionType});menuItems.push({name:item.Name,href:url,icon:item.icon||cardBuilder.getDefaultIcon(item,iconOptions)})}return user.Policy.IsAdministrator&&self.Dashboard&&(menuItems.push({name:globalize.translate("Admin")}),menuItems.push({name:globalize.translate("ManageEmbyServer"),href:"/dashboard.html",icon:"&#xE8B8;"}),menuItems.push({name:globalize.translate("MetadataManager"),href:"/edititemmetadata.html",icon:"&#xE2C7;"})),menuItems.push({name:globalize.translate("Settings"),href:appRouter.getRouteUrl("settings",{serverId:apiClient.serverId()}),icon:"&#xE8B8;"}),appHost.supports("multiserver")&&menuItems.push({name:globalize.translate("HeaderSelectServer"),href:appRouter.getRouteUrl("selectserver"),icon:"router"}),user.EnableAutoLogin||menuItems.push({name:globalize.translate("HeaderSignOut"),href:"#",icon:"&#xE879;",onclick:"logout"}),getItemsHtml(menuItems)})})}function getDrawerHtml(type){return 1===type&&currentServerId?getLibraryDrawerHtml(connectionManager.getApiClient(currentServerId)):2===type?function(apiClient){return getAdminMenuLinks(apiClient).then(function(items){return getItemsHtml(items)})}(ApiClient):Promise.resolve("")}function onSetInnerHtmlCallback(){var html=newInnerHtml;if(null!=html){newInnerHtml=null;var elem=getNavDrawerElement();elem.innerHTML=html,elem.scrollTop=0,html&&currentViewEvent&&updateSelectedItem(currentViewEvent)}}function updateSelectedItem(e){var currentNavMenuId=e.detail.navMenuId;currentNavMenuId=currentNavMenuId||(currentNavMenuId=window.location.href.toString()).substring(currentNavMenuId.indexOf("#!")+2);var navDrawerElement=getNavDrawerElement(),newSelectedOption=currentNavMenuId?navDrawerElement.querySelector('.navMenuOption[data-navmenuid="'+currentNavMenuId+'"]'):null;if(!newSelectedOption||!newSelectedOption.classList.contains("navMenuOption-selected")){var currentSelectedOption=navDrawerElement.querySelector(".navMenuOption-selected");currentSelectedOption&&currentSelectedOption.classList.remove("navMenuOption-selected"),newSelectedOption&&(newSelectedOption.classList.add("navMenuOption-selected"),e.detail.dashboardTheme&&function(newSelectedOption){var link=newSelectedOption.querySelector("span")||newSelectedOption,title=(link.innerText||link.textContent).trim();appHeader?appHeader.setTitle(title):function(title){require(["appHeader"]).then(function(responses){(appHeader=responses[0]).setTitle(title)})}(title)}(newSelectedOption))}}function onViewShowInternal(e,loadContent){var drawerType=function(e){var detail=e.detail;return currentServerId&&!1!==detail.drawer?detail.dashboardTheme?2:1:0}(e);drawerType!==currentDrawerType?loadContent?function(e,type){getDrawerHtml(currentDrawerType=type).then(function(itemsHtml){var html='<div class="drawerLogo" loading="lazy"></div>';newInnerHtml=html+=itemsHtml,requestAnimationFrame(onSetInnerHtmlCallback)})}(0,drawerType):(newInnerHtml="",requestAnimationFrame(onSetInnerHtmlCallback)):currentDrawerType&&loadContent&&updateSelectedItem(e)}return events.on(connectionManager,"localusersignedin",function(e,serverId,userId){currentServerId=serverId,currentDrawerType=0}),events.on(connectionManager,"localusersignedout",function(){currentServerId=null}),getNavDrawerElement().addEventListener("drawer-opening",function(){enableLazyLoadingDrawerContents&&onViewShowInternal(currentViewEvent,!0)}),{onViewShow:function(e){onViewShowInternal(currentViewEvent=e,!(enableLazyLoadingDrawerContents=!e.detail.drawerInline&&layoutManager.tv))},getAdminMenuLinks:getAdminMenuLinks}});