define(["apphost","htmlMediaHelper","connectionManager"],function(appHost,htmlMediaHelper,connectionManager){"use strict";function BaseHtmlPlayer(){this.type="mediaplayer"}function onShakaError(event){var error=event.detail;console.error("Error code",error.code,"object",error)}function setCurrentTimeIfNeeded(element,seconds,allowance){Math.abs((element.currentTime||0)-seconds)>=allowance&&(element.currentTime=seconds)}return BaseHtmlPlayer.prototype.canPlayMediaType=function(mediaType){return(mediaType||"").toLowerCase()===this.mediaType},BaseHtmlPlayer.prototype.currentSrc=function(){return this._currentSrc},BaseHtmlPlayer.prototype.getDeviceProfile=function(item,options){return htmlMediaHelper.getDeviceProfile(this,appHost,item,options)},BaseHtmlPlayer.prototype.currentTime=function(val){var mediaElement=this._mediaElement;if(mediaElement){if(null!=val)return void(mediaElement.currentTime=val/1e3);var currentTime=this._currentTime;return currentTime?1e3*currentTime:1e3*(mediaElement.currentTime||0)}},BaseHtmlPlayer.prototype.duration=function(val){var mediaElement=this._mediaElement;if(mediaElement){var duration=mediaElement.duration;if(htmlMediaHelper.isValidDuration(duration))return 1e3*duration}return null},BaseHtmlPlayer.prototype.getBufferedRanges=function(){var mediaElement=this._mediaElement;return mediaElement?htmlMediaHelper.getBufferedRanges(this,mediaElement):[]},BaseHtmlPlayer.prototype.pause=function(){var mediaElement=this._mediaElement;mediaElement&&mediaElement.pause()},BaseHtmlPlayer.prototype.resume=function(){var mediaElement=this._mediaElement;mediaElement&&mediaElement.play()},BaseHtmlPlayer.prototype.unpause=function(){var mediaElement=this._mediaElement;mediaElement&&mediaElement.play()},BaseHtmlPlayer.prototype.paused=function(){var mediaElement=this._mediaElement;return!!mediaElement&&mediaElement.paused},BaseHtmlPlayer.prototype.setVolume=function(val){var mediaElement=this._mediaElement;mediaElement&&(mediaElement.volume=val/100)},BaseHtmlPlayer.prototype.getVolume=function(){var mediaElement=this._mediaElement;if(mediaElement)return Math.min(Math.round(100*mediaElement.volume),100)},BaseHtmlPlayer.prototype.volumeUp=function(){this.setVolume(Math.min(this.getVolume()+2,100))},BaseHtmlPlayer.prototype.volumeDown=function(){this.setVolume(Math.max(this.getVolume()-2,0))},BaseHtmlPlayer.prototype.setMute=function(mute){var mediaElement=this._mediaElement;mediaElement&&(mediaElement.muted=mute)},BaseHtmlPlayer.prototype.isMuted=function(){var mediaElement=this._mediaElement;return!!mediaElement&&mediaElement.muted},BaseHtmlPlayer.prototype.seekable=function(){var mediaElement=this._mediaElement;if(mediaElement){var seekable=mediaElement.seekable;if(seekable&&seekable.length){var start=seekable.start(0),end=seekable.end(0);return htmlMediaHelper.isValidDuration(start)||(start=0),htmlMediaHelper.isValidDuration(end)||(end=0),0<end-start}return!1}},BaseHtmlPlayer.prototype.setSrcWithShakaPlayer=function(elem,options,url){var instance=this;return new Promise(function(resolve,reject){require(["shaka"],function(){var player=new shaka.Player(elem);player.addEventListener("error",onShakaError),player.load(url).then(resolve,reject),instance._shakaPlayer=player,instance._currentSrc=url})})},BaseHtmlPlayer.prototype.setCurrentSrcChromecast=function(mediaManager,elem,options,url,hasHlsTextTracks,tracksHtml){elem.autoplay=!0;var lrd=new cast.receiver.MediaManager.LoadRequestData;lrd.currentTime=(options.playerStartPositionTicks||0)/1e7,lrd.autoplay=!0,lrd.media=new cast.receiver.media.MediaInformation,lrd.media.contentId=url,lrd.media.contentType=options.mimeType,lrd.media.streamType=cast.receiver.media.StreamType.NONE,lrd.media.customData={options:options,hasHlsTextTracks:hasHlsTextTracks,tracksHtml:tracksHtml},console.log("loading media url into mediaManager");try{return mediaManager.load(lrd),this._currentSrc=url,Promise.resolve()}catch(err){return console.log("mediaManager error: "+err),Promise.reject()}},BaseHtmlPlayer.prototype.setSrcWithFlvJs=function(elem,options,url){var instance=this;return new Promise(function(resolve,reject){require(["flvjs"],function(flvjs){var flvPlayer=flvjs.createPlayer({type:"flv",url:url},{seekType:"range",lazyLoad:!1,rangeLoadZeroStart:!0});flvPlayer.attachMediaElement(elem),flvPlayer.load(),flvPlayer.play().then(resolve,reject),instance._flvPlayer=flvPlayer,instance._currentSrc=url})})},BaseHtmlPlayer.prototype.setSrcWithHlsJs=function(elem,options,url,onError){var instance=this;return new Promise(function(resolve,reject){!function(callback){require(["hlsjs"],function(hls){window.Hls=hls,callback()})}(function(){var hls=new Hls({manifestLoadingTimeOut:2e4,maxBufferSize:"audio"===instance.mediaType?12:null});hls.loadSource(url),hls.attachMedia(elem),htmlMediaHelper.bindEventsToHlsPlayer(instance,hls,elem,onError,resolve,reject),instance._hlsPlayer=hls,instance._currentSrc=url})})},BaseHtmlPlayer.prototype.seekOnPlaybackStart=function(element,ticks){var seconds=(ticks||0)/1e7;if(seconds){setCurrentTimeIfNeeded(element,seconds,5);var item=this._currentPlayOptions?this._currentPlayOptions.item:null,apiClient=item?connectionManager.getApiClient(item):null;apiClient&&!apiClient.isMinServerVersion("4.3.0.19")&&function(element,seconds,allowance){setTimeout(function(){setCurrentTimeIfNeeded(element,seconds,allowance)},2500)}(element,seconds,10)}},BaseHtmlPlayer});