define(["playbackManager","serverNotifications","events"],function(playbackManager,serverNotifications,events){"use strict";function onUserDataChanged(e,apiClient,userData){var eventsToMonitor=getEventsToMonitor(this);-1!==eventsToMonitor.indexOf("markfavorite")?this.notifyRefreshNeeded():-1!==eventsToMonitor.indexOf("markplayed")&&this.notifyRefreshNeeded()}function getEventsToMonitor(instance){var options=instance.options,monitor=options?options.monitorEvents:null;return monitor?monitor.split(","):[]}function onTimerCreated(e,apiClient,data){-1===getEventsToMonitor(this).indexOf("timers")||this.notifyRefreshNeeded()}function onSeriesTimerCreated(e,apiClient,data){-1===getEventsToMonitor(this).indexOf("seriestimers")||this.notifyRefreshNeeded()}function onTimerCancelled(e,apiClient,data){-1===getEventsToMonitor(this).indexOf("timers")||this.notifyRefreshNeeded()}function onSeriesTimerCancelled(e,apiClient,data){-1===getEventsToMonitor(this).indexOf("seriestimers")||this.notifyRefreshNeeded()}function onLibraryChanged(e,apiClient,data){var eventsToMonitor=getEventsToMonitor(this);if(-1===eventsToMonitor.indexOf("seriestimers")&&-1===eventsToMonitor.indexOf("timers")){var itemsAdded=data.ItemsAdded||[],itemsRemoved=data.ItemsRemoved||[];if(itemsAdded.length||itemsRemoved.length){var parentId=(this.options||{}).parentId;if(parentId){var foldersAddedTo=data.FoldersAddedTo||[],foldersRemovedFrom=data.FoldersRemovedFrom||[],collectionFolders=data.CollectionFolders||[];if(-1===foldersAddedTo.indexOf(parentId)&&-1===foldersRemovedFrom.indexOf(parentId)&&-1===collectionFolders.indexOf(parentId))return}this.notifyRefreshNeeded()}}}function onPlaybackStopped(e,stopInfo){var state=stopInfo.state,eventsToMonitor=getEventsToMonitor(this);if(state.NowPlayingItem&&"Video"===state.NowPlayingItem.MediaType){if(-1!==eventsToMonitor.indexOf("videoplayback"))return void this.notifyRefreshNeeded(!0)}else if(state.NowPlayingItem&&"Audio"===state.NowPlayingItem.MediaType&&-1!==eventsToMonitor.indexOf("audioplayback"))return void this.notifyRefreshNeeded(!0)}function addNotificationEvent(instance,name,handler,owner){var localHandler=handler.bind(instance);owner=owner||serverNotifications,events.on(owner,name,localHandler),instance["event_"+name]=localHandler}function removeNotificationEvent(instance,name,owner){var handler=instance["event_"+name];handler&&(owner=owner||serverNotifications,events.off(owner,name,handler),instance["event_"+name]=null)}function ItemsRefresher(options){this.options=options||{},addNotificationEvent(this,"UserDataChanged",onUserDataChanged),addNotificationEvent(this,"TimerCreated",onTimerCreated),addNotificationEvent(this,"SeriesTimerCreated",onSeriesTimerCreated),addNotificationEvent(this,"TimerCancelled",onTimerCancelled),addNotificationEvent(this,"SeriesTimerCancelled",onSeriesTimerCancelled),addNotificationEvent(this,"LibraryChanged",onLibraryChanged),addNotificationEvent(this,"playbackstop",onPlaybackStopped,playbackManager)}function clearRefreshInterval(instance,isPausing){instance.refreshInterval&&(clearInterval(instance.refreshInterval),instance.refreshInterval=null,isPausing||(instance.refreshIntervalEndTime=null))}function resetRefreshInterval(instance,intervalMs){if(clearRefreshInterval(instance),!intervalMs){var options=instance.options;options&&(intervalMs=options.refreshIntervalMs)}intervalMs&&(instance.refreshInterval=setInterval(instance.notifyRefreshNeeded.bind(instance),intervalMs),instance.refreshIntervalEndTime=Date.now()+intervalMs)}return ItemsRefresher.prototype.pause=function(){clearRefreshInterval(this,!0),this.paused=!0},ItemsRefresher.prototype.resume=function(options){this.paused=!1;var refreshIntervalEndTime=this.refreshIntervalEndTime;if(refreshIntervalEndTime){var remainingMs=refreshIntervalEndTime-Date.now();0<remainingMs&&!this.needsRefresh?resetRefreshInterval(this,remainingMs):(this.needsRefresh=!0,this.refreshIntervalEndTime=null)}return this.needsRefresh||options&&options.refresh?this.refreshItems():Promise.resolve()},ItemsRefresher.prototype.refreshItems=function(){return this.fetchData?this.paused?(this.needsRefresh=!0,Promise.resolve()):(this.needsRefresh=!1,this.fetchData().then(function(result){resetRefreshInterval(this),this.afterRefresh&&this.afterRefresh(result)}.bind(this))):Promise.resolve()},ItemsRefresher.prototype.notifyRefreshNeeded=function(isInForeground){if(this.paused)this.needsRefresh=!0;else{var timeout=this.refreshTimeout;timeout&&clearTimeout(timeout),!0===isInForeground?this.refreshItems():this.refreshTimeout=setTimeout(this.refreshItems.bind(this),1e4)}},ItemsRefresher.prototype.destroy=function(){clearRefreshInterval(this),removeNotificationEvent(this,"UserDataChanged"),removeNotificationEvent(this,"TimerCreated"),removeNotificationEvent(this,"SeriesTimerCreated"),removeNotificationEvent(this,"TimerCancelled"),removeNotificationEvent(this,"SeriesTimerCancelled"),removeNotificationEvent(this,"LibraryChanged"),removeNotificationEvent(this,"playbackstop",playbackManager),this.fetchData=null,this.options=null},ItemsRefresher});