/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.ILambda;
import org.objectweb.asm.Type;

final class PSubDefCall
extends AExpression {
    private final String name;
    private final List<AExpression> arguments;
    private StringBuilder recipe = null;
    private List<String> pointers = new ArrayList<String>();

    PSubDefCall(Location location, String name, List<AExpression> arguments) {
        super(location);
        this.name = Objects.requireNonNull(name);
        this.arguments = Objects.requireNonNull(arguments);
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        throw this.createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        this.recipe = new StringBuilder();
        int totalCaptures = 0;
        for (int argument = 0; argument < this.arguments.size(); ++argument) {
            AExpression expression = this.arguments.get(argument);
            expression.internal = true;
            expression.analyze(scriptRoot, locals);
            if (expression instanceof ILambda) {
                ILambda lambda = (ILambda)((Object)expression);
                this.pointers.add(lambda.getPointer());
                char ch = (char)(argument + totalCaptures);
                this.recipe.append(ch);
                totalCaptures += lambda.getCaptureCount();
            }
            if (expression.actual == Void.TYPE) {
                throw this.createError(new IllegalArgumentException("Argument(s) cannot be of [void] type when calling method [" + this.name + "]."));
            }
            expression.expected = expression.actual;
            this.arguments.set(argument, expression.cast(scriptRoot, locals));
        }
        this.actual = this.expected == null || this.expected == ZonedDateTime.class || this.explicit ? def.class : this.expected;
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        ArrayList<Type> parameterTypes = new ArrayList<Type>();
        parameterTypes.add(Type.getType(Object.class));
        for (AExpression argument : this.arguments) {
            parameterTypes.add(MethodWriter.getType(argument.actual));
            if (argument instanceof ILambda) {
                ILambda lambda = (ILambda)((Object)argument);
                Collections.addAll(parameterTypes, lambda.getCaptures());
            }
            argument.write(classWriter, methodWriter, globals);
        }
        Type methodType = Type.getMethodType((Type)MethodWriter.getType(this.actual), (Type[])parameterTypes.toArray(new Type[0]));
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.recipe.toString());
        args.addAll(this.pointers);
        methodWriter.invokeDefCall(this.name, methodType, 0, args.toArray());
    }

    @Override
    public String toString() {
        return this.singleLineToStringWithOptionalArgs(this.arguments, this.prefix, this.name);
    }
}

