/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JptJpaUiMakePersistentMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SelectCascadeDialog
extends Dialog {
    private Button allCheckbox;
    private Button persistCheckbox;
    private Button mergeCheckbox;
    private Button removeCheckbox;
    private Button refreshCheckbox;
    private List<String> cascadeValues = new ArrayList<String>();

    public SelectCascadeDialog(Shell shell, List<String> initialValues) {
        super(shell);
        this.cascadeValues.addAll(initialValues);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(JptJpaUiMakePersistentMessages.SELECT_CASCADE_DLG_TITLE);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = 250;
        gd.heightHint = 200;
        composite.setLayoutData((Object)gd);
        this.allCheckbox = new Button(composite, 32);
        this.allCheckbox.setText("cascade-all");
        this.persistCheckbox = new Button(composite, 32);
        this.persistCheckbox.setText("cascade-persist");
        this.mergeCheckbox = new Button(composite, 32);
        this.mergeCheckbox.setText("cascade-merge");
        this.removeCheckbox = new Button(composite, 32);
        this.removeCheckbox.setText("cascade-remove");
        this.refreshCheckbox = new Button(composite, 32);
        this.refreshCheckbox.setText("cascade-refresh");
        SelectionAdapter selectionAdapater = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectCascadeDialog.this.selectOtherCascade();
            }
        };
        SelectionAdapter selectionAdapater2 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectCascadeDialog.this.selectAllCascade();
            }
        };
        this.persistCheckbox.addSelectionListener((SelectionListener)selectionAdapater);
        this.mergeCheckbox.addSelectionListener((SelectionListener)selectionAdapater);
        this.removeCheckbox.addSelectionListener((SelectionListener)selectionAdapater);
        this.refreshCheckbox.addSelectionListener((SelectionListener)selectionAdapater);
        this.allCheckbox.addSelectionListener((SelectionListener)selectionAdapater2);
        this.init();
        return composite;
    }

    private void init() {
        if (this.cascadeValues.contains("cascade-all")) {
            this.allCheckbox.setSelection(true);
        }
        if (this.cascadeValues.contains("cascade-persist")) {
            this.persistCheckbox.setSelection(true);
        }
        if (this.cascadeValues.contains("cascade-merge")) {
            this.mergeCheckbox.setSelection(true);
        }
        if (this.cascadeValues.contains("cascade-merge")) {
            this.removeCheckbox.setSelection(true);
        }
        if (this.cascadeValues.contains("cascade-refresh")) {
            this.refreshCheckbox.setSelection(true);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    public List<String> getAllCascades() {
        return this.cascadeValues;
    }

    private void selectAllCascade() {
        this.cascadeValues.clear();
        if (this.allCheckbox.getSelection()) {
            this.cascadeValues.add("cascade-all");
            this.persistCheckbox.setSelection(false);
            this.mergeCheckbox.setSelection(false);
            this.removeCheckbox.setSelection(false);
            this.refreshCheckbox.setSelection(false);
        }
    }

    private void selectOtherCascade() {
        this.cascadeValues.clear();
        if (this.persistCheckbox.getSelection()) {
            this.cascadeValues.add("cascade-persist");
            this.allCheckbox.setSelection(false);
        }
        if (this.mergeCheckbox.getSelection()) {
            this.cascadeValues.add("cascade-merge");
            this.allCheckbox.setSelection(false);
        }
        if (this.removeCheckbox.getSelection()) {
            this.cascadeValues.add("cascade-remove");
            this.allCheckbox.setSelection(false);
        }
        if (this.refreshCheckbox.getSelection()) {
            this.cascadeValues.add("cascade-refresh");
            this.allCheckbox.setSelection(false);
        }
    }
}

