/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.dialogs;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.WorkingSets;
import org.eclipse.m2e.core.ui.internal.components.NestedProjectsComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AssignWorkingSetDialog
extends TitleAreaDialog {
    private final IProject[] initialSelection;
    NestedProjectsComposite selectedProjects;
    Set<IProject> allWorkingSetProjects = new HashSet<IProject>(WorkingSets.getProjects());
    Combo workingSetCombo;
    String workingSetName;

    public AssignWorkingSetDialog(Shell parentShell, IProject[] initialSelection) {
        super(parentShell);
        this.initialSelection = initialSelection;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.AssignWorkingSetDialog_title);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(area, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite filtersComposite = new Composite(composite, 0);
        filtersComposite.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        GridLayout gl_filtersComposite = new GridLayout(4, false);
        gl_filtersComposite.verticalSpacing = 0;
        gl_filtersComposite.marginWidth = 0;
        gl_filtersComposite.marginHeight = 0;
        filtersComposite.setLayout((Layout)gl_filtersComposite);
        final Button btnFilterAssignedProjects = new Button(filtersComposite, 32);
        btnFilterAssignedProjects.setText(Messages.AssignWorkingSetDialog_btnFilterAssignedProjects_text);
        btnFilterAssignedProjects.setSelection(true);
        btnFilterAssignedProjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AssignWorkingSetDialog.this.selectedProjects.refresh();
            }
        });
        final Button btnFilterClosedProjects = new Button(filtersComposite, 32);
        btnFilterClosedProjects.setText(Messages.AssignWorkingSetDialog_btnFilterClosedProjects_text);
        btnFilterClosedProjects.setSelection(true);
        btnFilterClosedProjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AssignWorkingSetDialog.this.selectedProjects.refresh();
            }
        });
        this.selectedProjects = new NestedProjectsComposite(composite, 0, this.initialSelection, false){

            @Override
            protected boolean isInteresting(IProject project) throws CoreException {
                if (btnFilterClosedProjects.getSelection() && !project.isAccessible()) {
                    return false;
                }
                if (project.isAccessible() && !project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                    return false;
                }
                return !btnFilterAssignedProjects.getSelection() || !AssignWorkingSetDialog.this.allWorkingSetProjects.contains(project);
            }
        };
        this.selectedProjects.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        Composite workingSetComposite = new Composite(composite, 0);
        workingSetComposite.setLayout((Layout)new GridLayout(3, false));
        workingSetComposite.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        Label lblNewLabel = new Label(workingSetComposite, 0);
        lblNewLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        lblNewLabel.setText(Messages.AssignWorkingSetDialog_lblWorkingSet);
        this.workingSetCombo = new Combo(workingSetComposite, 2048);
        this.workingSetCombo.addModifyListener(e -> {
            String string = this.workingSetName = this.workingSetCombo.getText();
        });
        GridData gd_workingSetName = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_workingSetName.horizontalIndent = 10;
        this.workingSetCombo.setLayoutData((Object)gd_workingSetName);
        this.workingSetCombo.setItems(WorkingSets.getWorkingSets());
        this.selectedProjects.addSelectionChangeListener(event -> {
            IProject selection = this.selectedProjects.getSelection();
            if (selection != null && this.workingSetCombo.getSelectionIndex() < 0) {
                this.workingSetCombo.setText(selection.getName());
            }
        });
        Button btnAssign = new Button(workingSetComposite, 0);
        btnAssign.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnAssign.setText(Messages.AssignWorkingSetDialog_btnAssign_text);
        btnAssign.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AssignWorkingSetDialog.this.assignWorkingSets();
                AssignWorkingSetDialog.this.selectedProjects.reset();
            }
        });
        return area;
    }

    public void assignWorkingSets() {
        IProject[] projects = this.selectedProjects.getSelectedProjects();
        if (projects != null && projects.length > 0 && this.workingSetName != null && !this.workingSetName.isEmpty()) {
            WorkingSets.addToWorkingSet(projects, this.workingSetName);
            this.allWorkingSetProjects.addAll(Arrays.asList(projects));
        }
    }
}

