/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.TypeWriter;
import org.apache.poi.hpsf.UnsupportedVariantTypeException;
import org.apache.poi.hpsf.VariantSupport;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.util.CodePageUtil;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class Property {
    private long id;
    private long type;
    private Object value;

    public Property() {
    }

    public Property(Property p) {
        this(p.id, p.type, p.value);
    }

    public Property(long id, long type, Object value) {
        this.id = id;
        this.type = type;
        this.value = value;
    }

    public Property(long id, byte[] src, long offset, int length, int codepage) throws UnsupportedEncodingException {
        this.id = id;
        if (id == 0L) {
            this.value = this.readDictionary(src, offset, length, codepage);
            return;
        }
        int o = (int)offset;
        this.type = LittleEndian.getUInt(src, o);
        o += 4;
        try {
            this.value = VariantSupport.read(src, o, length, (int)this.type, codepage);
        }
        catch (UnsupportedVariantTypeException ex) {
            VariantSupport.writeUnsupportedTypeMessage(ex);
            this.value = ex.getValue();
        }
    }

    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }

    public long getType() {
        return this.type;
    }

    public void setType(long type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    protected Map<?, ?> readDictionary(byte[] src, long offset, int length, int codepage) throws UnsupportedEncodingException {
        if (offset < 0L || offset > (long)src.length) {
            throw new HPSFRuntimeException("Illegal offset " + offset + " while HPSF stream contains " + length + " bytes.");
        }
        int o = (int)offset;
        long nrEntries = LittleEndian.getUInt(src, o);
        o += 4;
        LinkedHashMap<Long, String> m = new LinkedHashMap<Long, String>((int)nrEntries, 1.0f);
        try {
            int i = 0;
            while ((long)i < nrEntries) {
                Long id = LittleEndian.getUInt(src, o);
                long sLength = LittleEndian.getUInt(src, o += 4);
                o += 4;
                StringBuffer b = new StringBuffer();
                switch (codepage) {
                    case -1: {
                        b.append(new String(src, o, (int)sLength, Charset.forName("ASCII")));
                        break;
                    }
                    case 1200: {
                        int nrBytes = (int)(sLength * 2L);
                        byte[] h = new byte[nrBytes];
                        for (int i2 = 0; i2 < nrBytes; i2 += 2) {
                            h[i2] = src[o + i2 + 1];
                            h[i2 + 1] = src[o + i2];
                        }
                        b.append(new String(h, 0, nrBytes, CodePageUtil.codepageToEncoding(codepage)));
                        break;
                    }
                    default: {
                        b.append(new String(src, o, (int)sLength, CodePageUtil.codepageToEncoding(codepage)));
                    }
                }
                while (b.length() > 0 && b.charAt(b.length() - 1) == '\u0000') {
                    b.setLength(b.length() - 1);
                }
                if (codepage == 1200) {
                    if (sLength % 2L == 1L) {
                        ++sLength;
                    }
                    o = (int)((long)o + (sLength + sLength));
                } else {
                    o = (int)((long)o + sLength);
                }
                m.put(id, b.toString());
                ++i;
            }
        }
        catch (RuntimeException ex) {
            POILogger l = POILogFactory.getLogger(this.getClass());
            l.log(5, "The property set's dictionary contains bogus data. All dictionary entries starting with the one with ID " + this.id + " will be ignored.", ex);
        }
        return m;
    }

    protected int getSize() throws WritingNotSupportedException {
        int length = VariantSupport.getVariantLength(this.type);
        if (length >= 0) {
            return length;
        }
        if (length == -2) {
            throw new WritingNotSupportedException(this.type, null);
        }
        int PADDING = 4;
        switch ((int)this.type) {
            case 30: {
                int l = ((String)this.value).length() + 1;
                int r = l % 4;
                if (r > 0) {
                    l += 4 - r;
                }
                length += l;
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new WritingNotSupportedException(this.type, this.value);
            }
        }
        return length;
    }

    public boolean equals(Object o) {
        Class<?> pValueClass;
        if (!(o instanceof Property)) {
            return false;
        }
        Property p = (Property)o;
        Object pValue = p.getValue();
        long pId = p.getID();
        if (this.id != pId || this.id != 0L && !this.typesAreEqual(this.type, p.getType())) {
            return false;
        }
        if (this.value == null && pValue == null) {
            return true;
        }
        if (this.value == null || pValue == null) {
            return false;
        }
        Class<?> valueClass = this.value.getClass();
        if (!valueClass.isAssignableFrom(pValueClass = pValue.getClass()) && !pValueClass.isAssignableFrom(valueClass)) {
            return false;
        }
        if (this.value instanceof byte[]) {
            return Arrays.equals((byte[])this.value, (byte[])pValue);
        }
        return this.value.equals(pValue);
    }

    private boolean typesAreEqual(long t1, long t2) {
        return t1 == t2 || t1 == 30L && t2 == 31L || t2 == 30L && t1 == 31L;
    }

    public int hashCode() {
        long hashCode = 0L;
        hashCode += this.id;
        hashCode += this.type;
        if (this.value != null) {
            hashCode += (long)this.value.hashCode();
        }
        return (int)(hashCode & 0xFFFFFFFFL);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.getClass().getName());
        b.append('[');
        b.append("id: ");
        b.append(this.getID());
        b.append(", type: ");
        b.append(this.getType());
        Object value = this.getValue();
        b.append(", value: ");
        if (value instanceof String) {
            b.append(value.toString());
            String s = (String)value;
            int l = s.length();
            byte[] bytes = new byte[l * 2];
            for (int i = 0; i < l; ++i) {
                char c = s.charAt(i);
                byte high = (byte)((c & 0xFF00) >> 8);
                byte low = (byte)((c & 0xFF) >> 0);
                bytes[i * 2] = high;
                bytes[i * 2 + 1] = low;
            }
            b.append(" [");
            if (bytes.length > 0) {
                String hex = HexDump.dump(bytes, 0L, 0);
                b.append(hex);
            }
            b.append("]");
        } else if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            if (bytes.length > 0) {
                String hex = HexDump.dump(bytes, 0L, 0);
                b.append(hex);
            }
        } else {
            b.append(value.toString());
        }
        b.append(']');
        return b.toString();
    }

    public int write(OutputStream out, int codepage) throws IOException, WritingNotSupportedException {
        int length = 0;
        long variantType = this.getType();
        if (codepage == 1200 && variantType == 30L) {
            variantType = 31L;
        }
        length += TypeWriter.writeUIntToStream(out, variantType);
        return length += VariantSupport.write(out, variantType, this.getValue(), codepage);
    }
}

