/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class BaseAuthDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.BaseAuthDialog";
    private boolean passwordOnly;
    private boolean showSavePassword;
    private DBPAuthInfo authInfo = new DBPAuthInfo();
    private Text usernameText;
    private Text passwordText;
    private Button savePasswordCheck;

    public BaseAuthDialog(Shell parentShell, String title, boolean passwordOnly, boolean showSavePassword) {
        super(parentShell, title, (DBPImage)DBIcon.TREE_USER);
        this.passwordOnly = passwordOnly;
        this.showSavePassword = showSavePassword;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    public DBPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public String getUserName() {
        return this.authInfo.getUserName();
    }

    public void setUserName(String userName) {
        this.authInfo.setUserName(userName);
    }

    public String getUserPassword() {
        return this.authInfo.getUserPassword();
    }

    public void setUserPassword(String userPassword) {
        this.authInfo.setUserPassword(userPassword);
    }

    public boolean isSavePassword() {
        return this.authInfo.isSavePassword();
    }

    public void setSavePassword(boolean savePassword) {
        this.authInfo.setSavePassword(savePassword);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite addrGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        addrGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        addrGroup.setLayoutData((Object)gd);
        Group credGroup = new Group(addrGroup, 0);
        credGroup.setText(UIConnectionMessages.dialog_connection_auth_group_user_cridentials);
        gl = new GridLayout(2, false);
        gl.marginHeight = 5;
        gl.marginWidth = 5;
        credGroup.setLayout((Layout)gl);
        gd = new GridData(1808);
        credGroup.setLayoutData((Object)gd);
        if (!this.passwordOnly) {
            Label usernameLabel = new Label((Composite)credGroup, 0);
            usernameLabel.setText(UIConnectionMessages.dialog_connection_auth_label_username);
            usernameLabel.setLayoutData((Object)new GridData(128));
            this.usernameText = new Text((Composite)credGroup, 2048);
            gd = new GridData(768);
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint = 120;
            this.usernameText.setLayoutData((Object)gd);
            if (this.authInfo.getUserName() != null) {
                this.usernameText.setText(this.authInfo.getUserName());
            }
        }
        Label passwordLabel = new Label((Composite)credGroup, 0);
        passwordLabel.setText(UIConnectionMessages.dialog_connection_auth_label_password);
        passwordLabel.setLayoutData((Object)new GridData(128));
        this.passwordText = new Text((Composite)credGroup, 0x400800);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.passwordText.setLayoutData((Object)gd);
        if (this.authInfo.getUserPassword() != null && this.authInfo.isSavePassword()) {
            this.passwordText.setText(this.authInfo.getUserPassword());
        }
        this.savePasswordCheck = new Button(addrGroup, 32);
        this.savePasswordCheck.setEnabled(this.showSavePassword);
        this.savePasswordCheck.setText(UIConnectionMessages.dialog_connection_auth_checkbox_save_password);
        gd = new GridData(32);
        this.savePasswordCheck.setLayoutData((Object)gd);
        this.savePasswordCheck.setSelection(this.authInfo.isSavePassword());
        if (this.passwordOnly || !CommonUtils.isEmpty((String)this.usernameText.getText())) {
            this.passwordText.setFocus();
        }
        return addrGroup;
    }

    protected void okPressed() {
        if (!this.passwordOnly) {
            this.authInfo.setUserName(this.usernameText.getText());
        }
        this.authInfo.setUserPassword(this.passwordText.getText());
        if (this.showSavePassword) {
            this.authInfo.setSavePassword(this.savePasswordCheck.getSelection());
        }
        super.okPressed();
    }
}

