/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis.panel;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.gis.GisAttribute;
import org.jkiss.dbeaver.model.gis.GisTransformRequest;
import org.jkiss.dbeaver.model.gis.GisTransformUtils;
import org.jkiss.dbeaver.model.gis.SpatialDataProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.data.IAttributeController;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.gis.GeometryDataUtils;
import org.jkiss.dbeaver.ui.gis.IGeometryValueEditor;
import org.jkiss.dbeaver.ui.gis.internal.GISViewerActivator;
import org.jkiss.dbeaver.ui.gis.panel.GISBrowserViewerConstants;
import org.jkiss.dbeaver.ui.gis.panel.GISEditorUtils;
import org.jkiss.dbeaver.ui.gis.panel.SelectCRSAction;
import org.jkiss.dbeaver.ui.gis.panel.SelectTilesAction;
import org.jkiss.dbeaver.ui.gis.registry.GeometryViewerRegistry;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;
import org.locationtech.jts.geom.Geometry;

public class GISLeafletViewer
implements IGeometryValueEditor {
    private static final Log log = Log.getLog(GISLeafletViewer.class);
    private static final String PREF_RECENT_SRID_LIST = "srid.list.recent";
    private static final String[] SUPPORTED_FORMATS = new String[]{"png", "gif", "bmp"};
    private static final String PROP_FLIP_COORDINATES = "gis.flipCoords";
    private static final String PROP_SRID = "gis.srid";
    private static final Gson gson = new GsonBuilder().create();
    private final IValueController valueController;
    private final Browser browser;
    private DBGeometry[] lastValue;
    private int sourceSRID;
    private int actualSourceSRID;
    private File scriptFile;
    private final ToolBarManager toolBarManager;
    private int defaultSRID;
    private boolean toolsVisible = true;
    private boolean flipCoordinates = false;
    private final Composite composite;

    public GISLeafletViewer(Composite parent, IValueController valueController, SpatialDataProvider spatialDataProvider) {
        DBVEntityAttribute vAttr;
        DBVEntity vEntity;
        DBDAttributeBinding binding;
        this.valueController = valueController;
        this.flipCoordinates = spatialDataProvider != null && spatialDataProvider.isFlipCoordinates();
        this.composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        CSSUtils.setCSSClass((Widget)this.composite, (String)"coloredByConnectionType");
        this.browser = new Browser(this.composite, 0);
        this.browser.addDisposeListener(e -> this.cleanupFiles());
        this.browser.setLayoutData((Object)new GridData(1808));
        Composite bottomPanel = UIUtils.createPlaceholder((Composite)this.composite, (int)1);
        bottomPanel.setLayoutData((Object)new GridData(768));
        CSSUtils.setCSSClass((Widget)bottomPanel, (String)"coloredByConnectionType");
        ToolBar bottomToolbar = new ToolBar(bottomPanel, 8519936);
        this.toolBarManager = new ToolBarManager(bottomToolbar);
        String recentSRIDString = GISViewerActivator.getDefault().getPreferences().getString(PREF_RECENT_SRID_LIST);
        if (!CommonUtils.isEmpty((String)recentSRIDString)) {
            String[] stringArray = recentSRIDString.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String sridStr = stringArray[n2];
                int recentSRID = CommonUtils.toInt((Object)sridStr);
                if (recentSRID != 0 && recentSRID != GeometryDataUtils.getDefaultSRID() && recentSRID != 3857) {
                    GISEditorUtils.addRecentSRID(recentSRID);
                }
                ++n2;
            }
        }
        if (valueController instanceof IAttributeController && (binding = ((IAttributeController)valueController).getBinding()).getEntityAttribute() != null && (vEntity = DBVUtils.getVirtualEntity((DBDAttributeBinding)binding, (boolean)false)) != null && (vAttr = vEntity.getVirtualAttribute(binding, false)) != null) {
            this.flipCoordinates = CommonUtils.getBoolean((Object)vAttr.getProperty(PROP_FLIP_COORDINATES), (boolean)this.flipCoordinates);
            this.sourceSRID = CommonUtils.toInt((Object)vAttr.getProperty(PROP_SRID), (int)this.sourceSRID);
        }
    }

    @Override
    public Control getEditorControl() {
        return this.composite;
    }

    @Override
    public int getValueSRID() {
        return this.actualSourceSRID;
    }

    @Override
    public void setValueSRID(int srid) {
        int oldSRID = this.sourceSRID;
        this.sourceSRID = srid;
        try {
            this.reloadGeometryData(this.lastValue, true);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Setting SRID", "Can't change source SRID to " + srid, (Throwable)e);
            this.sourceSRID = oldSRID;
        }
        if (srid != GeometryDataUtils.getDefaultSRID() && srid != 3857) {
            GISEditorUtils.addRecentSRID(srid);
        }
        GISEditorUtils.curRecentSRIDs();
        StringBuilder sridListStr = new StringBuilder();
        for (Integer sridInt : GISEditorUtils.getRecentSRIDs()) {
            if (sridListStr.length() > 0) {
                sridListStr.append(",");
            }
            sridListStr.append(sridInt);
        }
        GISViewerActivator.getDefault().getPreferences().setValue(PREF_RECENT_SRID_LIST, sridListStr.toString());
        this.saveAttributeSettings();
    }

    @Override
    public void refresh() {
        try {
            this.reloadGeometryData(this.lastValue, true);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Refresh", "Can't refresh value viewer", (Throwable)e);
        }
    }

    public void setGeometryData(@Nullable DBGeometry[] values) throws DBException {
        this.reloadGeometryData(values, false);
    }

    public void reloadGeometryData(@Nullable DBGeometry[] values, boolean force) throws DBException {
        if (!force && CommonUtils.equalObjects((Object)this.lastValue, (Object)values)) {
            return;
        }
        int maxObjects = GISViewerActivator.getDefault().getPreferences().getInt("gis.view.maxObjectsRender");
        if (maxObjects <= 0) {
            maxObjects = 10000;
        }
        if (values != null && values.length > maxObjects) {
            DBGeometry[] truncValues = new DBGeometry[maxObjects];
            System.arraycopy(values, 0, truncValues, 0, maxObjects);
            values = truncValues;
        }
        if (this.browser != null) {
            try {
                if (ArrayUtils.isEmpty((Object[])values)) {
                    this.browser.setUrl("about:blank");
                } else {
                    File file = this.generateViewScript(values);
                    this.browser.setUrl(file.toURI().toURL().toString());
                }
            }
            catch (IOException e) {
                throw new DBException("Error generating viewer script", (Throwable)e);
            }
        }
        this.lastValue = values;
        this.updateToolbar();
    }

    private File generateViewScript(DBGeometry[] values) throws IOException {
        if (this.scriptFile == null) {
            File tempDir = DBWorkbench.getPlatform().getTempFolder((DBRProgressMonitor)new VoidProgressMonitor(), "gis-viewer-files");
            this.checkIncludesExistence(tempDir);
            this.scriptFile = File.createTempFile("view", "gis.html", tempDir);
        }
        ArrayList<String> geomValues = new ArrayList<String>();
        ArrayList<String> geomTipValues = new ArrayList<String>();
        boolean showMap = false;
        int i = 0;
        while (i < values.length) {
            DBGeometry value = values[i];
            if (!DBUtils.isNullValue((Object)value)) {
                int srid;
                if (this.flipCoordinates) {
                    try {
                        value = value.flipCoordinates();
                    }
                    catch (DBException e) {
                        log.error((Object)e);
                    }
                }
                Object targetValue = value.getRawValue();
                int n = srid = this.sourceSRID == 0 ? value.getSRID() : this.sourceSRID;
                if (srid == 0) {
                    showMap = false;
                    this.actualSourceSRID = srid;
                } else if (srid == 4326) {
                    showMap = true;
                    this.actualSourceSRID = srid;
                } else {
                    Geometry geometry = value.getGeometry();
                    if (geometry != null) {
                        try {
                            GisTransformRequest request = new GisTransformRequest(geometry, srid, 4326);
                            GisTransformUtils.transformGisData((GisTransformRequest)request);
                            targetValue = request.getTargetValue();
                            srid = request.getTargetSRID();
                            this.actualSourceSRID = request.getSourceSRID();
                            showMap = request.isShowOnMap();
                        }
                        catch (DBException e) {
                            log.debug((Object)"Error transforming CRS", (Throwable)e);
                            this.actualSourceSRID = srid;
                            showMap = false;
                        }
                    } else {
                        this.actualSourceSRID = srid;
                    }
                }
                if (targetValue != null) {
                    geomValues.add("'" + targetValue + "'");
                    if (CommonUtils.isEmpty((Map)value.getProperties())) {
                        geomTipValues.add("null");
                    } else {
                        geomTipValues.add(gson.toJson((Object)value.getProperties()));
                    }
                }
            }
            ++i;
        }
        if (this.actualSourceSRID == 0 && this.valueController != null && this.valueController.getValueType() instanceof GisAttribute) {
            try {
                this.actualSourceSRID = ((GisAttribute)this.valueController.getValueType()).getAttributeGeometrySRID((DBRProgressMonitor)new VoidProgressMonitor());
            }
            catch (DBCException e) {
                log.error((Object)e);
            }
        }
        this.defaultSRID = this.actualSourceSRID;
        String geomValuesString = String.join((CharSequence)",", geomValues);
        String geomTipValuesString = String.join((CharSequence)",", geomTipValues);
        String geomCRS = this.actualSourceSRID == 0 ? "Simple" : "EPSG3857";
        boolean isShowMap = showMap;
        InputStream fis = GISViewerActivator.getDefault().getResourceStream("web/view_template.html");
        if (fis == null) {
            throw new IOException("View template file not found (web/view_template.html)");
        }
        try {
            Throwable throwable = null;
            Object var11_16 = null;
            try (InputStreamReader isr = new InputStreamReader(fis);){
                String viewTemplate = IOUtils.readToString((Reader)isr);
                viewTemplate = GeneralUtils.replaceVariables((String)viewTemplate, name -> {
                    switch (name) {
                        case "geomValues": {
                            return geomValuesString;
                        }
                        case "geomTipValues": {
                            return String.valueOf(geomTipValuesString);
                        }
                        case "geomSRID": {
                            return String.valueOf(this.defaultSRID);
                        }
                        case "showMap": {
                            return String.valueOf(isShowMap);
                        }
                        case "showTools": {
                            return String.valueOf(this.toolsVisible);
                        }
                        case "geomCRS": {
                            return geomCRS;
                        }
                        case "defaultTiles": {
                            return GeometryViewerRegistry.getInstance().getDefaultLeafletTiles().getLayersDefinition();
                        }
                    }
                    return null;
                });
                Throwable throwable2 = null;
                Object var15_22 = null;
                try (FileOutputStream fos = new FileOutputStream(this.scriptFile);){
                    fos.write(viewTemplate.getBytes(GeneralUtils.UTF8_CHARSET));
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            ContentUtils.close((Closeable)fis);
        }
        return this.scriptFile;
    }

    private void checkIncludesExistence(File scriptDir) throws IOException {
        File incFolder = new File(scriptDir, "inc");
        if (!incFolder.exists()) {
            if (!incFolder.mkdirs()) {
                throw new IOException("Can't create inc folder '" + incFolder.getAbsolutePath() + "'");
            }
            String[] stringArray = GISBrowserViewerConstants.INC_FILES;
            int n = GISBrowserViewerConstants.INC_FILES.length;
            int n2 = 0;
            while (n2 < n) {
                block18: {
                    String fileName = stringArray[n2];
                    InputStream fis = GISViewerActivator.getDefault().getResourceStream("web/inc/" + fileName);
                    if (fis != null) {
                        Throwable throwable = null;
                        Object var9_10 = null;
                        try (FileOutputStream fos = new FileOutputStream(new File(incFolder, fileName));){
                            try {
                                try {
                                    IOUtils.copyStream((InputStream)fis, (OutputStream)fos);
                                }
                                catch (Exception e) {
                                    log.warn((Object)("Error copying inc file " + fileName), (Throwable)e);
                                    ContentUtils.close((Closeable)fis);
                                    break block18;
                                }
                            }
                            catch (Throwable throwable2) {
                                ContentUtils.close((Closeable)fis);
                                throw throwable2;
                            }
                            ContentUtils.close((Closeable)fis);
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private void cleanupFiles() {
        if (this.scriptFile != null && !this.scriptFile.delete()) {
            log.debug((Object)("Can't delete temp script file '" + this.scriptFile.getAbsolutePath() + "'"));
        }
    }

    public Composite getBrowserComposite() {
        return this.composite;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public DBGeometry[] getCurrentValue() {
        return this.lastValue;
    }

    private void updateToolbar() {
        this.toolBarManager.removeAll();
        this.toolBarManager.add((IAction)new Action("Open in browser", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.BROWSER)){

            public void run() {
                UIUtils.launchProgram((String)GISLeafletViewer.this.scriptFile.getAbsolutePath());
            }
        });
        this.toolBarManager.add((IAction)new Action("Copy as picture", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PICTURE)){

            public void run() {
                Image image = new Image((Device)Display.getDefault(), GISLeafletViewer.this.browser.getBounds());
                GC gc = new GC((Drawable)image);
                try {
                    GISLeafletViewer.this.browser.print(gc);
                }
                finally {
                    gc.dispose();
                }
                ImageTransfer imageTransfer = ImageTransfer.getInstance();
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                clipboard.setContents(new Object[]{image.getImageData()}, new Transfer[]{imageTransfer});
            }
        });
        this.toolBarManager.add((IAction)new Action("Save as picture", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PICTURE_SAVE)){

            public void run() {
                Shell shell = GISLeafletViewer.this.browser.getShell();
                FileDialog saveDialog = new FileDialog(shell, 8192);
                String[] extensions = new String[SUPPORTED_FORMATS.length];
                String[] filterNames = new String[SUPPORTED_FORMATS.length];
                int i = 0;
                while (i < SUPPORTED_FORMATS.length) {
                    extensions[i] = "*." + SUPPORTED_FORMATS[i];
                    filterNames[i] = String.valueOf(SUPPORTED_FORMATS[i].toUpperCase()) + " (*." + SUPPORTED_FORMATS[i] + ")";
                    ++i;
                }
                saveDialog.setFilterExtensions(extensions);
                saveDialog.setFilterNames(filterNames);
                String filePath = DialogUtils.openFileDialog((FileDialog)saveDialog);
                if (filePath == null) {
                    return;
                }
                int imageType = 0;
                String filePathLower = filePath.toLowerCase();
                if (filePathLower.endsWith(".png")) {
                    imageType = 5;
                } else if (filePathLower.endsWith(".gif")) {
                    imageType = 2;
                }
                Image image = new Image((Device)Display.getDefault(), GISLeafletViewer.this.browser.getBounds());
                GC gc = new GC((Drawable)image);
                try {
                    GISLeafletViewer.this.browser.print(gc);
                }
                finally {
                    gc.dispose();
                }
                ImageLoader imageLoader = new ImageLoader();
                imageLoader.data = new ImageData[1];
                imageLoader.data[0] = image.getImageData();
                File outFile = new File(filePath);
                try {
                    Throwable throwable = null;
                    Object var12_16 = null;
                    try (FileOutputStream fos = new FileOutputStream(outFile);){
                        imageLoader.save((OutputStream)fos, imageType);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    DBWorkbench.getPlatformUI().showError("Image save error", "Error saving as picture", (Throwable)e);
                }
                UIUtils.launchProgram((String)outFile.getAbsolutePath());
            }
        });
        this.toolBarManager.add((IAction)new Action("Print", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PRINT)){

            public void run() {
                GC gc = new GC((Drawable)GISLeafletViewer.this.browser.getDisplay());
                try {
                    GISLeafletViewer.this.browser.execute("javascript:window.print();");
                }
                finally {
                    gc.dispose();
                }
            }
        });
        this.toolBarManager.add((IContributionItem)new Separator());
        SelectCRSAction crsSelectorAction = new SelectCRSAction(this);
        this.toolBarManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)crsSelectorAction, (boolean)true));
        SelectTilesAction tilesSelectorAction = new SelectTilesAction(this);
        this.toolBarManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)tilesSelectorAction, (boolean)true));
        this.toolBarManager.add((IAction)new Action("Flip coordinates", 2){
            {
                this.setToolTipText("Flip latitude/longitude coordinates in source data");
                this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.LINK_TO_EDITOR));
            }

            public boolean isChecked() {
                return GISLeafletViewer.this.flipCoordinates;
            }

            public void run() {
                GISLeafletViewer.this.flipCoordinates = !GISLeafletViewer.this.flipCoordinates;
                try {
                    GISLeafletViewer.this.reloadGeometryData(GISLeafletViewer.this.lastValue, true);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Render error", "Error rendering geometry", (Throwable)e);
                }
                GISLeafletViewer.this.saveAttributeSettings();
                GISLeafletViewer.this.updateToolbar();
            }
        });
        this.toolBarManager.add((IContributionItem)new Separator());
        this.toolBarManager.add((IAction)new Action("Show/Hide controls", 2){
            {
                this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PALETTE));
            }

            public boolean isChecked() {
                return GISLeafletViewer.this.toolsVisible;
            }

            public void run() {
                GISLeafletViewer.this.toolsVisible = !GISLeafletViewer.this.toolsVisible;
                GISLeafletViewer.this.updateControlsVisibility();
                GISLeafletViewer.this.updateToolbar();
            }
        });
        this.toolBarManager.update(true);
    }

    private void saveAttributeSettings() {
        DBDAttributeBinding binding;
        if (this.valueController instanceof IAttributeController && (binding = ((IAttributeController)this.valueController).getBinding()).getEntityAttribute() != null) {
            DBVEntity vEntity = DBVUtils.getVirtualEntity((DBDAttributeBinding)binding, (boolean)true);
            DBVEntityAttribute vAttr = vEntity.getVirtualAttribute(binding, true);
            if (vAttr != null) {
                vAttr.setProperty(PROP_FLIP_COORDINATES, (Object)String.valueOf(this.flipCoordinates));
                vAttr.setProperty(PROP_SRID, (Object)String.valueOf(this.getValueSRID()));
            }
            this.valueController.getExecutionContext().getDataSource().getContainer().getRegistry().flushConfig();
        }
    }

    private void updateControlsVisibility() {
        GC gc = new GC((Drawable)this.browser.getDisplay());
        try {
            this.browser.execute("javascript:showTools(" + this.toolsVisible + ");");
        }
        finally {
            gc.dispose();
        }
    }
}

