﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/frauddetector/FraudDetector_EXPORTS.h>
#include <aws/frauddetector/model/ModelVersion.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace FraudDetector
{
namespace Model
{

  /**
   * <p>The fraud prediction scores.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ModelScores">AWS
   * API Reference</a></p>
   */
  class AWS_FRAUDDETECTOR_API ModelScores
  {
  public:
    ModelScores();
    ModelScores(Aws::Utils::Json::JsonView jsonValue);
    ModelScores& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The model version.</p>
     */
    inline const ModelVersion& GetModelVersion() const{ return m_modelVersion; }

    /**
     * <p>The model version.</p>
     */
    inline bool ModelVersionHasBeenSet() const { return m_modelVersionHasBeenSet; }

    /**
     * <p>The model version.</p>
     */
    inline void SetModelVersion(const ModelVersion& value) { m_modelVersionHasBeenSet = true; m_modelVersion = value; }

    /**
     * <p>The model version.</p>
     */
    inline void SetModelVersion(ModelVersion&& value) { m_modelVersionHasBeenSet = true; m_modelVersion = std::move(value); }

    /**
     * <p>The model version.</p>
     */
    inline ModelScores& WithModelVersion(const ModelVersion& value) { SetModelVersion(value); return *this;}

    /**
     * <p>The model version.</p>
     */
    inline ModelScores& WithModelVersion(ModelVersion&& value) { SetModelVersion(std::move(value)); return *this;}


    /**
     * <p>The model's fraud prediction scores.</p>
     */
    inline const Aws::Map<Aws::String, double>& GetScores() const{ return m_scores; }

    /**
     * <p>The model's fraud prediction scores.</p>
     */
    inline bool ScoresHasBeenSet() const { return m_scoresHasBeenSet; }

    /**
     * <p>The model's fraud prediction scores.</p>
     */
    inline void SetScores(const Aws::Map<Aws::String, double>& value) { m_scoresHasBeenSet = true; m_scores = value; }

    /**
     * <p>The model's fraud prediction scores.</p>
     */
    inline void SetScores(Aws::Map<Aws::String, double>&& value) { m_scoresHasBeenSet = true; m_scores = std::move(value); }

    /**
     * <p>The model's fraud prediction scores.</p>
     */
    inline ModelScores& WithScores(const Aws::Map<Aws::String, double>& value) { SetScores(value); return *this;}

    /**
     * <p>The model's fraud prediction scores.</p>
     */
    inline ModelScores& WithScores(Aws::Map<Aws::String, double>&& value) { SetScores(std::move(value)); return *this;}

    /**
     * <p>The model's fraud prediction scores.</p>
     */
    inline ModelScores& AddScores(const Aws::String& key, double value) { m_scoresHasBeenSet = true; m_scores.emplace(key, value); return *this; }

    /**
     * <p>The model's fraud prediction scores.</p>
     */
    inline ModelScores& AddScores(Aws::String&& key, double value) { m_scoresHasBeenSet = true; m_scores.emplace(std::move(key), value); return *this; }

    /**
     * <p>The model's fraud prediction scores.</p>
     */
    inline ModelScores& AddScores(const char* key, double value) { m_scoresHasBeenSet = true; m_scores.emplace(key, value); return *this; }

  private:

    ModelVersion m_modelVersion;
    bool m_modelVersionHasBeenSet;

    Aws::Map<Aws::String, double> m_scores;
    bool m_scoresHasBeenSet;
  };

} // namespace Model
} // namespace FraudDetector
} // namespace Aws
