(function() {
  var PathReplacer;

  PathReplacer = require('scandal').PathReplacer;

  module.exports = function(filePaths, regexSource, regexFlags, replacementText) {
    var callback, regex, replacer;
    callback = this.async();
    replacer = new PathReplacer();
    regex = new RegExp(regexSource, regexFlags);
    replacer.on('file-error', function(arg) {
      var code, message, path;
      code = arg.code, path = arg.path, message = arg.message;
      return emit('replace:file-error', {
        code: code,
        path: path,
        message: message
      });
    });
    replacer.on('path-replaced', function(result) {
      return emit('replace:path-replaced', result);
    });
    return replacer.replacePaths(regex, replacementText, filePaths, function() {
      return callback();
    });
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2J1aWxkL2F0b20vc3JjL2F0b20vb3V0L2FwcC9zcmMvcmVwbGFjZS1oYW5kbGVyLmNvZmZlZSJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUFBLE1BQUE7O0VBQUMsZUFBZ0IsT0FBQSxDQUFRLFNBQVI7O0VBRWpCLE1BQU0sQ0FBQyxPQUFQLEdBQWlCLFNBQUMsU0FBRCxFQUFZLFdBQVosRUFBeUIsVUFBekIsRUFBcUMsZUFBckM7QUFDZixRQUFBO0lBQUEsUUFBQSxHQUFXLElBQUMsQ0FBQSxLQUFELENBQUE7SUFFWCxRQUFBLEdBQVcsSUFBSSxZQUFKLENBQUE7SUFDWCxLQUFBLEdBQVEsSUFBSSxNQUFKLENBQVcsV0FBWCxFQUF3QixVQUF4QjtJQUVSLFFBQVEsQ0FBQyxFQUFULENBQVksWUFBWixFQUEwQixTQUFDLEdBQUQ7QUFDeEIsVUFBQTtNQUQwQixpQkFBTSxpQkFBTTthQUN0QyxJQUFBLENBQUssb0JBQUwsRUFBMkI7UUFBQyxNQUFBLElBQUQ7UUFBTyxNQUFBLElBQVA7UUFBYSxTQUFBLE9BQWI7T0FBM0I7SUFEd0IsQ0FBMUI7SUFHQSxRQUFRLENBQUMsRUFBVCxDQUFZLGVBQVosRUFBNkIsU0FBQyxNQUFEO2FBQzNCLElBQUEsQ0FBSyx1QkFBTCxFQUE4QixNQUE5QjtJQUQyQixDQUE3QjtXQUdBLFFBQVEsQ0FBQyxZQUFULENBQXNCLEtBQXRCLEVBQTZCLGVBQTdCLEVBQThDLFNBQTlDLEVBQXlELFNBQUE7YUFBRyxRQUFBLENBQUE7SUFBSCxDQUF6RDtFQVplO0FBRmpCIiwic291cmNlc0NvbnRlbnQiOlsie1BhdGhSZXBsYWNlcn0gPSByZXF1aXJlICdzY2FuZGFsJ1xuXG5tb2R1bGUuZXhwb3J0cyA9IChmaWxlUGF0aHMsIHJlZ2V4U291cmNlLCByZWdleEZsYWdzLCByZXBsYWNlbWVudFRleHQpIC0+XG4gIGNhbGxiYWNrID0gQGFzeW5jKClcblxuICByZXBsYWNlciA9IG5ldyBQYXRoUmVwbGFjZXIoKVxuICByZWdleCA9IG5ldyBSZWdFeHAocmVnZXhTb3VyY2UsIHJlZ2V4RmxhZ3MpXG5cbiAgcmVwbGFjZXIub24gJ2ZpbGUtZXJyb3InLCAoe2NvZGUsIHBhdGgsIG1lc3NhZ2V9KSAtPlxuICAgIGVtaXQoJ3JlcGxhY2U6ZmlsZS1lcnJvcicsIHtjb2RlLCBwYXRoLCBtZXNzYWdlfSlcblxuICByZXBsYWNlci5vbiAncGF0aC1yZXBsYWNlZCcsIChyZXN1bHQpIC0+XG4gICAgZW1pdCgncmVwbGFjZTpwYXRoLXJlcGxhY2VkJywgcmVzdWx0KVxuXG4gIHJlcGxhY2VyLnJlcGxhY2VQYXRocyhyZWdleCwgcmVwbGFjZW1lbnRUZXh0LCBmaWxlUGF0aHMsIC0+IGNhbGxiYWNrKCkpXG4iXX0=
