(function() {
  var ElementResizeDetector, OverlayManager, elementResizeDetector;

  ElementResizeDetector = require('element-resize-detector');

  elementResizeDetector = null;

  module.exports = OverlayManager = (function() {
    function OverlayManager(presenter, container, views) {
      this.presenter = presenter;
      this.container = container;
      this.views = views;
      this.overlaysById = {};
    }

    OverlayManager.prototype.render = function(state) {
      var decorationId, id, overlay, overlayNode, ref, ref1, results;
      ref = state.content.overlays;
      for (decorationId in ref) {
        overlay = ref[decorationId];
        if (this.shouldUpdateOverlay(decorationId, overlay)) {
          this.renderOverlay(state, decorationId, overlay);
        }
      }
      ref1 = this.overlaysById;
      results = [];
      for (id in ref1) {
        overlayNode = ref1[id].overlayNode;
        if (!state.content.overlays.hasOwnProperty(id)) {
          delete this.overlaysById[id];
          overlayNode.remove();
          results.push(elementResizeDetector.uninstall(overlayNode));
        } else {
          results.push(void 0);
        }
      }
      return results;
    };

    OverlayManager.prototype.shouldUpdateOverlay = function(decorationId, overlay) {
      var cachedOverlay, ref, ref1, ref2, ref3;
      cachedOverlay = this.overlaysById[decorationId];
      if (cachedOverlay == null) {
        return true;
      }
      return ((ref = cachedOverlay.pixelPosition) != null ? ref.top : void 0) !== ((ref1 = overlay.pixelPosition) != null ? ref1.top : void 0) || ((ref2 = cachedOverlay.pixelPosition) != null ? ref2.left : void 0) !== ((ref3 = overlay.pixelPosition) != null ? ref3.left : void 0);
    };

    OverlayManager.prototype.measureOverlay = function(decorationId, itemView) {
      var contentMargin, ref;
      contentMargin = (ref = parseInt(getComputedStyle(itemView)['margin-left'])) != null ? ref : 0;
      return this.presenter.setOverlayDimensions(decorationId, itemView.offsetWidth, itemView.offsetHeight, contentMargin);
    };

    OverlayManager.prototype.renderOverlay = function(state, decorationId, arg) {
      var cachedOverlay, item, itemView, klass, overlayNode, pixelPosition;
      item = arg.item, pixelPosition = arg.pixelPosition, klass = arg["class"];
      itemView = this.views.getView(item);
      cachedOverlay = this.overlaysById[decorationId];
      if (!(overlayNode = cachedOverlay != null ? cachedOverlay.overlayNode : void 0)) {
        overlayNode = document.createElement('atom-overlay');
        if (klass != null) {
          overlayNode.classList.add(klass);
        }
        if (elementResizeDetector == null) {
          elementResizeDetector = ElementResizeDetector({
            strategy: 'scroll'
          });
        }
        elementResizeDetector.listenTo(overlayNode, (function(_this) {
          return function() {
            if (overlayNode.parentElement != null) {
              return _this.measureOverlay(decorationId, itemView);
            }
          };
        })(this));
        this.container.appendChild(overlayNode);
        this.overlaysById[decorationId] = cachedOverlay = {
          overlayNode: overlayNode,
          itemView: itemView
        };
      }
      if (!overlayNode.contains(itemView)) {
        overlayNode.appendChild(itemView);
      }
      cachedOverlay.pixelPosition = pixelPosition;
      overlayNode.style.top = pixelPosition.top + 'px';
      overlayNode.style.left = pixelPosition.left + 'px';
      return this.measureOverlay(decorationId, itemView);
    };

    return OverlayManager;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
