(function() {
  var SpellCheckTask, idCounter;

  idCounter = 0;

  module.exports = SpellCheckTask = (function() {
    SpellCheckTask.handler = null;

    SpellCheckTask.jobs = [];

    function SpellCheckTask(manager) {
      this.manager = manager;
      this.id = idCounter++;
    }

    SpellCheckTask.prototype.terminate = function() {
      return this.constructor.removeFromArray(this.constructor.jobs, function(j) {
        return j.args.id === this.id;
      });
    };

    SpellCheckTask.prototype.start = function(editor, onDidSpellCheck) {
      var buffer, job, projectPath, ref, ref1, relativePath;
      buffer = editor.getBuffer();
      projectPath = null;
      relativePath = null;
      if (buffer != null ? (ref = buffer.file) != null ? ref.path : void 0 : void 0) {
        ref1 = atom.project.relativizePath(buffer.file.path), projectPath = ref1[0], relativePath = ref1[1];
      }
      this.constructor.removeFromArray(this.constructor.jobs, function(j) {
        return j.args.id === this.id;
      });
      job = {
        manager: this.manager,
        callbacks: [onDidSpellCheck],
        editorId: editor.id,
        args: {
          id: this.id,
          projectPath: projectPath,
          relativePath: relativePath,
          text: buffer.getText()
        }
      };
      if (this.constructor.piggybackExistingJob(job)) {
        return;
      }
      this.constructor.jobs.unshift(job);
      if (this.constructor.jobs.length === 1) {
        return this.constructor.startNextJob();
      }
    };

    SpellCheckTask.piggybackExistingJob = function(newJob) {
      var job, k, len, ref;
      if (this.jobs.length > 0) {
        ref = this.jobs;
        for (k = 0, len = ref.length; k < len; k++) {
          job = ref[k];
          if (this.isDuplicateRequest(job, newJob)) {
            job.callbacks = job.callbacks.concat(newJob.callbacks);
            return true;
          }
        }
      }
      return false;
    };

    SpellCheckTask.isDuplicateRequest = function(a, b) {
      return a.args.projectPath === b.args.projectPath && a.args.relativePath === b.args.relativePath;
    };

    SpellCheckTask.removeFromArray = function(array, predicate) {
      var found, i, k, ref;
      if (array.length > 0) {
        for (i = k = 0, ref = array.length - 1; 0 <= ref ? k <= ref : k >= ref; i = 0 <= ref ? ++k : --k) {
          if (predicate(array[i])) {
            found = array[i];
            array.splice(i, 1);
            return found;
          }
        }
      }
    };

    SpellCheckTask.startNextJob = function() {
      var activeEditorId, job, ref;
      activeEditorId = (ref = atom.workspace.getActiveTextEditor()) != null ? ref.id : void 0;
      job = this.jobs.find(function(j) {
        return j.editorId === activeEditorId;
      }) || this.jobs[0];
      return job.manager.check(job.args, job.args.text).then((function(_this) {
        return function(results) {
          var callback, k, len, ref1;
          _this.removeFromArray(_this.jobs, function(j) {
            return j.args.id === job.args.id;
          });
          ref1 = job.callbacks;
          for (k = 0, len = ref1.length; k < len; k++) {
            callback = ref1[k];
            callback(results.misspellings);
          }
          if (_this.jobs.length > 0) {
            return _this.startNextJob();
          }
        };
      })(this));
    };

    SpellCheckTask.clear = function() {
      return this.jobs = [];
    };

    return SpellCheckTask;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
