Object.defineProperty(exports, '__esModule', {
  value: true
});
var _bind = Function.prototype.bind;

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x2, _x3, _x4) { var _again = true; _function: while (_again) { var object = _x2, property = _x3, receiver = _x4; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x2 = parent; _x3 = property; _x4 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/** @babel */

var _atom = require('atom');

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _collapsibleSectionPanel = require('./collapsible-section-panel');

var _collapsibleSectionPanel2 = _interopRequireDefault(_collapsibleSectionPanel);

var _richDescription = require('./rich-description');

var SCOPED_SETTINGS = ['autoIndent', 'autoIndentOnPaste', 'invisibles', 'nonWordCharacters', 'preferredLineLength', 'scrollPastEnd', 'showIndentGuide', 'showInvisibles', 'softWrap', 'softWrapAtPreferredLineLength', 'softWrapHangingIndent', 'tabLength', 'tabType'];

var SettingsPanel = (function (_CollapsibleSectionPanel) {
  _inherits(SettingsPanel, _CollapsibleSectionPanel);

  function SettingsPanel() {
    var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    _classCallCheck(this, SettingsPanel);

    _get(Object.getPrototypeOf(SettingsPanel.prototype), 'constructor', this).call(this);
    var namespace = options.namespace;
    this.element = document.createElement('section');
    this.element.classList.add('section', 'settings-panel');
    this.options = options;
    this.disposables = new _atom.CompositeDisposable();
    var settings = undefined;
    if (this.options.scopeName) {
      namespace = 'editor';
      settings = {};
      for (var _name of SCOPED_SETTINGS) {
        settings[_name] = atom.config.get(_name, { scope: [this.options.scopeName] });
      }
    } else {
      settings = atom.config.get(namespace);
    }

    this.element.appendChild(this.elementForSettings(namespace, settings));

    this.disposables.add(this.bindInputFields());
    this.disposables.add(this.bindSelectFields());
    this.disposables.add(this.bindEditors());
    this.disposables.add(this.bindTooltips());
    this.disposables.add(this.handleEvents());
  }

  /*
   * Space Pen Helpers
   */

  _createClass(SettingsPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.element.remove();
    }
  }, {
    key: 'elementForSettings',
    value: function elementForSettings(namespace, settings) {
      if (_underscorePlus2['default'].isEmpty(settings)) {
        return document.createDocumentFragment();
      }

      var title = this.options.title;

      var includeTitle = this.options.includeTitle != null ? this.options.includeTitle : true;
      if (includeTitle) {
        if (title == null) {
          title = _underscorePlus2['default'].undasherize(_underscorePlus2['default'].uncamelcase(namespace)) + ' Settings';
        }
      } else {
        if (title == null) {
          title = 'Settings';
        }
      }

      var icon = this.options.icon != null ? this.options.icon : 'gear';
      var note = this.options.note;

      var sortedSettings = this.sortSettings(namespace, settings);

      var container = document.createElement('div');
      container.classList.add('section-container');

      var heading = document.createElement('div');
      heading.classList.add('block', 'section-heading', 'icon', 'icon-' + icon);
      heading.textContent = title;
      container.appendChild(heading);

      if (note) {
        container.insertAdjacentHTML('beforeend', note);
      }

      var body = document.createElement('div');
      body.classList.add('section-body');
      for (var _name2 of sortedSettings) {
        body.appendChild(elementForSetting(namespace, _name2, settings[_name2]));
      }
      container.appendChild(body);

      return container;
    }
  }, {
    key: 'sortSettings',
    value: function sortSettings(namespace, settings) {
      return _sortSettings(namespace, settings);
    }
  }, {
    key: 'bindInputFields',
    value: function bindInputFields() {
      var _this = this;

      var disposables = Array.from(this.element.querySelectorAll('input[id]')).map(function (input) {
        var type = input.type;
        var name = type === 'radio' ? input.name : input.id;

        _this.observe(name, function (value) {
          if (type === 'checkbox') {
            input.checked = value;
          } else if (type === 'radio') {
            input.checked = value === _this.parseValue(atom.config.getSchema(name).type, input.value);
          } else {
            if (type === 'color') {
              if (value && value.toHexString && value.toHexString()) {
                value = value.toHexString();
              }
            }

            if (value) {
              input.value = value;
            }
          }
        });

        var changeHandler = function changeHandler() {
          var value = input.value;
          if (type === 'checkbox') {
            value = input.checked;
          } else if (type === 'radio') {
            value = _this.parseValue(atom.config.getSchema(name).type, value);
          } else {
            value = _this.parseValue(type, value);
          }

          if (type === 'color') {
            // This is debounced since the color wheel fires lots of events
            // as you are dragging it around
            clearTimeout(_this.colorDebounceTimeout);
            _this.colorDebounceTimeout = setTimeout(function () {
              _this.set(name, value);
            }, 100);
          } else {
            _this.set(name, value);
          }
        };

        input.addEventListener('change', changeHandler);
        return new _atom.Disposable(function () {
          return input.removeEventListener('change', changeHandler);
        });
      });

      return new (_bind.apply(_atom.CompositeDisposable, [null].concat(_toConsumableArray(disposables))))();
    }
  }, {
    key: 'observe',
    value: function observe(name, callback) {
      var params = { sources: [atom.config.getUserConfigPath()] };
      if (this.options.scopeName != null) {
        params.scope = [this.options.scopeName];
      }
      this.disposables.add(atom.config.observe(name, params, callback));
    }
  }, {
    key: 'isDefault',
    value: function isDefault(name) {
      var params = { sources: [atom.config.getUserConfigPath()] };
      if (this.options.scopeName != null) {
        params.scope = [this.options.scopeName];
      }
      var defaultValue = this.getDefault(name);
      var value = atom.config.get(name, params);
      return value == null || defaultValue === value;
    }
  }, {
    key: 'getDefault',
    value: function getDefault(name) {
      var params = { excludeSources: [atom.config.getUserConfigPath()] };
      if (this.options.scopeName != null) {
        params.scope = [this.options.scopeName];
      }

      var defaultValue = atom.config.get(name, params);
      if (this.options.scopeName != null) {
        // If the unscoped default is the same as the scoped default, check the actual config.cson
        // to make sure that there isn't a non-default value that is overriding the scoped value
        // For example: the default editor.tabLength is 2, but if someone sets it to 4
        // the above check still returns 2 and not 4 for a scoped editor.tabLength,
        // because it bypasses config.cson.
        if (atom.config.get(name, { excludeSources: [atom.config.getUserConfigPath()] }) === defaultValue) {
          defaultValue = atom.config.get(name);
        }
      }
      return defaultValue;
    }
  }, {
    key: 'set',
    value: function set(name, value) {
      if (this.options.scopeName) {
        if (value === undefined) {
          atom.config.unset(name, { scopeSelector: this.options.scopeName });
          return true;
        } else {
          return atom.config.set(name, value, { scopeSelector: this.options.scopeName });
        }
      } else {
        return atom.config.set(name, value);
      }
    }
  }, {
    key: 'setText',
    value: function setText(editor, name, type, value) {
      var stringValue = undefined;
      if (this.isDefault(name)) {
        stringValue = '';
      } else {
        stringValue = this.valueToString(value) || '';
      }

      if (stringValue === editor.getText() || _underscorePlus2['default'].isEqual(value, this.parseValue(type, editor.getText()))) {
        return;
      }

      editor.setText(stringValue);
      editor.moveToEndOfLine();
    }
  }, {
    key: 'bindSelectFields',
    value: function bindSelectFields() {
      var _this2 = this;

      var disposables = Array.from(this.element.querySelectorAll('select[id]')).map(function (select) {
        var name = select.id;
        _this2.observe(name, function (value) {
          select.value = value;
        });
        var changeHandler = function changeHandler() {
          _this2.set(name, select.value);
        };
        select.addEventListener('change', changeHandler);
        return new _atom.Disposable(function () {
          return select.removeEventListener('change', changeHandler);
        });
      });

      return new (_bind.apply(_atom.CompositeDisposable, [null].concat(_toConsumableArray(disposables))))();
    }
  }, {
    key: 'bindEditors',
    value: function bindEditors() {
      var _this3 = this;

      var disposables = Array.from(this.element.querySelectorAll('atom-text-editor')).map(function (editorElement) {
        var editor = editorElement.getModel();
        var name = editorElement.id;
        var type = editorElement.getAttribute('type');
        var defaultValue = _this3.valueToString(_this3.getDefault(name));

        if (defaultValue != null) {
          editor.setPlaceholderText('Default: ' + defaultValue);
        }

        var subscriptions = new _atom.CompositeDisposable();

        var focusHandler = function focusHandler() {
          if (_this3.isDefault(name)) {
            editor.setText(_this3.valueToString(_this3.getDefault(name)) || '');
          }
        };
        editorElement.addEventListener('focus', focusHandler);
        subscriptions.add(new _atom.Disposable(function () {
          return editorElement.removeEventListener('focus', focusHandler);
        }));

        var blurHandler = function blurHandler() {
          if (_this3.isDefault(name)) {
            editor.setText('');
          }
        };
        editorElement.addEventListener('blur', blurHandler);
        subscriptions.add(new _atom.Disposable(function () {
          return editorElement.removeEventListener('blur', blurHandler);
        }));

        _this3.observe(name, function (value) {
          _this3.setText(editor, name, type, value);
        });

        subscriptions.add(editor.onDidStopChanging(function () {
          var _atom$config$getSchema = atom.config.getSchema(name);

          var minimum = _atom$config$getSchema.minimum;
          var maximum = _atom$config$getSchema.maximum;

          var value = _this3.parseValue(type, editor.getText());
          if (minimum != null && value < minimum) {
            _this3.set(name, minimum);
            _this3.setText(editor, name, type, minimum);
          } else if (maximum != null && value > maximum) {
            _this3.set(name, maximum);
            _this3.setText(editor, name, type, maximum);
          } else if (!_this3.set(name, value)) {
            _this3.setText(editor, name, type, atom.config.get(name));
          }
        }));

        return subscriptions;
      });

      return new (_bind.apply(_atom.CompositeDisposable, [null].concat(_toConsumableArray(disposables))))();
    }
  }, {
    key: 'bindTooltips',
    value: function bindTooltips() {
      var _this4 = this;

      var disposables = Array.from(this.element.querySelectorAll('input[id], select[id], atom-text-editor[id]')).map(function (element) {
        var schema = atom.config.getSchema(element.id);
        var defaultValue = _this4.valueToString(_this4.getDefault(element.id));
        if (defaultValue != null) {
          if (schema['enum'] && _underscorePlus2['default'].findWhere(schema['enum'], { value: defaultValue })) {
            defaultValue = _underscorePlus2['default'].findWhere(schema['enum'], { value: defaultValue }).description;
          }
          return atom.tooltips.add(element, {
            title: 'Default: ' + defaultValue,
            delay: { show: 100 },
            placement: 'auto left'
          });
        } else {
          return new _atom.Disposable(function () {}); // no-op
        }
      });

      return new (_bind.apply(_atom.CompositeDisposable, [null].concat(_toConsumableArray(disposables))))();
    }
  }, {
    key: 'valueToString',
    value: function valueToString(value) {
      if (Array.isArray(value)) {
        if (value.length === 0) {
          return null;
        }
        return value.map(function (val) {
          return val.toString().replace(/,/g, '\\,');
        }).join(', ');
      } else if (value != null) {
        return value.toString();
      } else {
        return null;
      }
    }
  }, {
    key: 'parseValue',
    value: function parseValue(type, value) {
      if (value === '') {
        return undefined;
      } else if (type === 'number') {
        var floatValue = parseFloat(value);
        if (isNaN(floatValue)) {
          return value;
        } else {
          return floatValue;
        }
      } else if (type === 'integer') {
        var intValue = parseInt(value);
        if (isNaN(intValue)) {
          return value;
        } else {
          return intValue;
        }
      } else if (type === 'array') {
        var arrayValue = (value || '').split(',');
        arrayValue = arrayValue.reduce(function (values, val) {
          var last = values.length - 1;
          if (last >= 0 && values[last].endsWith('\\')) {
            values[last] = values[last].replace(/\\$/, ',') + val;
          } else {
            values.push(val);
          }
          return values;
        }, []);
        return arrayValue.filter(function (val) {
          return val;
        }).map(function (val) {
          return val.trim();
        });
      } else {
        return value;
      }
    }
  }]);

  return SettingsPanel;
})(_collapsibleSectionPanel2['default']);

exports['default'] = SettingsPanel;
var isEditableArray = function isEditableArray(array) {
  for (var item of array) {
    if (!_underscorePlus2['default'].isString(item)) {
      return false;
    }
  }
  return true;
};

function _sortSettings(namespace, settings) {
  return _underscorePlus2['default'].chain(settings).keys().sortBy(function (name) {
    return name;
  }).sortBy(function (name) {
    var schema = atom.config.getSchema(namespace + '.' + name);
    return schema ? schema.order : null;
  }).value();
}

function elementForSetting(namespace, name, value) {
  if (namespace === 'core') {
    if (name === 'themes') {
      return document.createDocumentFragment();
    } // Handled in the Themes panel
    if (name === 'disabledPackages') {
      return document.createDocumentFragment();
    } // Handled in the Packages panel
    if (name === 'customFileTypes') {
      return document.createDocumentFragment();
    }
    if (name === 'uriHandlerRegistration') {
      return document.createDocumentFragment();
    } // Handled in the URI Handler panel
  }

  if (namespace === 'editor') {
    // There's no global default for these, they are defined by language packages
    if (['commentStart', 'commentEnd', 'increaseIndentPattern', 'decreaseIndentPattern', 'foldEndPattern'].includes(name)) {
      return document.createDocumentFragment();
    }
  }

  var controlGroup = document.createElement('div');
  controlGroup.classList.add('control-group');

  var controls = document.createElement('div');
  controls.classList.add('controls');
  controlGroup.appendChild(controls);

  var schema = atom.config.getSchema(namespace + '.' + name);
  if (schema && schema['enum']) {
    controls.appendChild(elementForOptions(namespace, name, value, { radio: schema.radio }));
  } else if (schema && schema.type === 'color') {
    controls.appendChild(elementForColor(namespace, name, value));
  } else if (_underscorePlus2['default'].isBoolean(value) || schema && schema.type === 'boolean') {
    controls.appendChild(elementForCheckbox(namespace, name, value));
  } else if (_underscorePlus2['default'].isArray(value) || schema && schema.type === 'array') {
    if (isEditableArray(value)) {
      controls.appendChild(elementForArray(namespace, name, value));
    }
  } else if (_underscorePlus2['default'].isObject(value) || schema && schema.type === 'object') {
    controls.appendChild(elementForObject(namespace, name, value));
  } else {
    controls.appendChild(elementForEditor(namespace, name, value));
  }

  return controlGroup;
}

function getSettingTitle(keyPath, name) {
  if (name == null) {
    name = '';
  }
  var schema = atom.config.getSchema(keyPath);
  var title = schema != null ? schema.title : null;
  return title || _underscorePlus2['default'].uncamelcase(name).split('.').map(_underscorePlus2['default'].capitalize).join(' ');
}

function elementForOptions(namespace, name, value, _ref) {
  var _ref$radio = _ref.radio;
  var radio = _ref$radio === undefined ? false : _ref$radio;

  var keyPath = namespace + '.' + name;
  var schema = atom.config.getSchema(keyPath);
  var options = schema && schema['enum'] ? schema['enum'] : [];

  var fragment = document.createDocumentFragment();

  var label = document.createElement('label');
  label.classList.add('control-label');

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  label.appendChild(descriptionDiv);

  fragment.appendChild(label);
  fragment.appendChild(enumOptions(options, { keyPath: keyPath, radio: radio }));

  return fragment;
}

function elementForCheckbox(namespace, name, value) {
  var keyPath = namespace + '.' + name;

  var div = document.createElement('div');
  div.classList.add('checkbox');

  var label = document.createElement('label');
  label['for'] = keyPath;

  var input = document.createElement('input');
  input.id = keyPath;
  input.type = 'checkbox';
  input.classList.add('input-checkbox');
  label.appendChild(input);

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);
  div.appendChild(label);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  div.appendChild(descriptionDiv);

  return div;
}

function elementForColor(namespace, name, value) {
  var keyPath = namespace + '.' + name;

  var div = document.createElement('div');
  div.classList.add('color');

  var label = document.createElement('label');
  label['for'] = keyPath;

  var input = document.createElement('input');
  input.id = keyPath;
  input.type = 'color';
  label.appendChild(input);

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);
  div.appendChild(label);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  div.appendChild(descriptionDiv);

  return div;
}

function elementForEditor(namespace, name, value) {
  var keyPath = namespace + '.' + name;
  var type = _underscorePlus2['default'].isNumber(value) ? 'number' : 'string';

  var fragment = document.createDocumentFragment();

  var label = document.createElement('label');
  label.classList.add('control-label');

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  label.appendChild(descriptionDiv);
  fragment.appendChild(label);

  var controls = document.createElement('div');
  controls.classList.add('controls');

  var editorContainer = document.createElement('div');
  editorContainer.classList.add('editor-container');

  var editor = new _atom.TextEditor({ mini: true });
  editor.element.id = keyPath;
  editor.element.setAttribute('type', type);
  editorContainer.appendChild(editor.element);
  controls.appendChild(editorContainer);
  fragment.appendChild(controls);

  return fragment;
}

function elementForArray(namespace, name, value) {
  var keyPath = namespace + '.' + name;

  var fragment = document.createDocumentFragment();

  var label = document.createElement('label');
  label.classList.add('control-label');

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  label.appendChild(descriptionDiv);
  fragment.appendChild(label);

  var controls = document.createElement('div');
  controls.classList.add('controls');

  var editorContainer = document.createElement('div');
  editorContainer.classList.add('editor-container');

  var editor = new _atom.TextEditor({ mini: true });
  editor.element.id = keyPath;
  editor.element.setAttribute('type', 'array');
  editorContainer.appendChild(editor.element);
  controls.appendChild(editorContainer);
  fragment.appendChild(controls);

  return fragment;
}

function elementForObject(namespace, name, value) {
  if (_underscorePlus2['default'].keys(value).length === 0) {
    return document.createDocumentFragment();
  } else {
    var keyPath = namespace + '.' + name;
    var schema = atom.config.getSchema(keyPath);
    var isCollapsed = schema.collapsed === true;

    var section = document.createElement('section');
    section.classList.add('sub-section');
    if (isCollapsed) {
      section.classList.add('collapsed');
    }

    var h3 = document.createElement('h3');
    h3.classList.add('sub-section-heading', 'has-items');
    h3.textContent = getSettingTitle(keyPath, name);
    section.appendChild(h3);

    var descriptionDiv = document.createElement('div');
    descriptionDiv.classList.add('setting-description');
    descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
    section.appendChild(descriptionDiv);

    var div = document.createElement('div');
    div.classList.add('sub-section-body');
    for (var key of _sortSettings(keyPath, value)) {
      div.appendChild(elementForSetting(namespace, name + '.' + key, value[key]));
    }
    section.appendChild(div);

    return section;
  }
}

function enumOptions(options, _ref2) {
  var keyPath = _ref2.keyPath;
  var radio = _ref2.radio;

  var containerTag = radio ? 'fieldset' : 'select';
  var container = document.createElement(containerTag);
  container.id = keyPath;
  var containerClass = radio ? 'input-radio-group' : 'form-control';
  container.classList.add(containerClass);

  var conversion = radio ? optionToRadio : optionToSelect;
  var optionElements = options.map(function (option) {
    return conversion(option, keyPath);
  });

  for (var optionElement of optionElements) {
    container.appendChild(optionElement);
  }

  return container;
}

function optionToRadio(option, keyPath) {
  var button = document.createElement('input');
  var label = document.createElement('label');
  label.classList.add('input-label');
  var value = undefined;
  var description = '';
  if (option.hasOwnProperty('value')) {
    value = option.value;
    description = option.description;
  } else {
    value = option;
    description = option;
  }
  button.classList.add('input-radio');
  button.id = keyPath + '[' + value + ']';
  button.name = keyPath;
  button.type = 'radio';
  button.value = value;
  label.appendChild(button);
  label.appendChild(document.createTextNode(description));
  return label;
}

function optionToSelect(option, keyPath) {
  var optionElement = document.createElement('option');
  if (option.hasOwnProperty('value')) {
    optionElement.value = option.value;
    optionElement.textContent = option.description;
  } else {
    optionElement.value = option;
    optionElement.textContent = option;
  }
  return optionElement;
}
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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