Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _electron = require('electron');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _utils = require('./utils');

var marked = null;

var PackageCard = (function () {
  function PackageCard(pack, settingsView, packageManager) {
    var options = arguments.length <= 3 || arguments[3] === undefined ? {} : arguments[3];

    _classCallCheck(this, PackageCard);

    this.pack = pack;
    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.disposables = new _atom.CompositeDisposable();

    // It might be useful to either wrap this.pack in a class that has a
    // ::validate method, or add a method here. At the moment I think all cases
    // of malformed package metadata are handled here and in ::content but belt
    // and suspenders, you know
    this.client = this.packageManager.getClient();
    this.type = this.pack.theme ? 'theme' : 'package';
    this.name = this.pack.name;
    this.onSettingsView = options.onSettingsView;

    if (this.pack.latestVersion !== this.pack.version) {
      this.newVersion = this.pack.latestVersion;
    }

    if (this.pack.apmInstallSource && this.pack.apmInstallSource.type === 'git') {
      if (this.pack.apmInstallSource.sha !== this.pack.latestSha) {
        this.newSha = this.pack.latestSha;
      }
    }

    // Default to displaying the download count
    if (!options.stats) {
      options.stats = { downloads: true };
    }

    _etch2['default'].initialize(this);

    this.displayStats(options);
    this.handlePackageEvents();
    this.handleButtonEvents(options);
    this.loadCachedMetadata();

    // themes have no status and cannot be dis/enabled
    if (this.type === 'theme') {
      this.refs.statusIndicator.remove();
      this.refs.enablementButton.remove();
    }

    if (atom.packages.isBundledPackage(this.pack.name)) {
      this.refs.installButtonGroup.remove();
      this.refs.uninstallButton.remove();
    }

    if (!this.newVersion && !this.newSha) {
      this.refs.updateButtonGroup.style.display = 'none';
    }

    this.hasCompatibleVersion = true;
    this.updateInterfaceState();
  }

  _createClass(PackageCard, [{
    key: 'render',
    value: function render() {
      var displayName = (this.pack.gitUrlInfo ? this.pack.gitUrlInfo.project : this.pack.name) || '';
      var owner = (0, _utils.ownerFromRepository)(this.pack.repository);
      var description = this.pack.description || '';

      return _etch2['default'].dom(
        'div',
        { className: 'package-card col-lg-8' },
        _etch2['default'].dom(
          'div',
          { ref: 'statsContainer', className: 'stats pull-right' },
          _etch2['default'].dom(
            'span',
            { ref: 'packageStars', className: 'stats-item' },
            _etch2['default'].dom('span', { ref: 'stargazerIcon', className: 'icon icon-star' }),
            _etch2['default'].dom('span', { ref: 'stargazerCount', className: 'value' })
          ),
          _etch2['default'].dom(
            'span',
            { ref: 'packageDownloads', className: 'stats-item' },
            _etch2['default'].dom('span', { ref: 'downloadIcon', className: 'icon icon-cloud-download' }),
            _etch2['default'].dom('span', { ref: 'downloadCount', className: 'value' })
          )
        ),
        _etch2['default'].dom(
          'div',
          { className: 'body' },
          _etch2['default'].dom(
            'h4',
            { className: 'card-name' },
            _etch2['default'].dom(
              'a',
              { className: 'package-name', ref: 'packageName' },
              displayName
            ),
            _etch2['default'].dom(
              'span',
              { className: 'package-version' },
              _etch2['default'].dom(
                'span',
                { ref: 'versionValue', className: 'value' },
                String(this.pack.version)
              )
            ),
            _etch2['default'].dom(
              'span',
              { className: 'deprecation-badge highlight-warning inline-block' },
              'Deprecated'
            )
          ),
          _etch2['default'].dom(
            'span',
            { ref: 'packageDescription', className: 'package-description' },
            description
          ),
          _etch2['default'].dom('div', { ref: 'packageMessage', className: 'package-message' })
        ),
        _etch2['default'].dom(
          'div',
          { className: 'meta' },
          _etch2['default'].dom(
            'div',
            { ref: 'metaUserContainer', className: 'meta-user' },
            _etch2['default'].dom(
              'a',
              { ref: 'avatarLink', href: 'https://atom.io/users/' + owner },
              _etch2['default'].dom('img', { ref: 'avatar', className: 'avatar', src: 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7' })
            ),
            _etch2['default'].dom(
              'a',
              { ref: 'loginLink', className: 'author', href: 'https://atom.io/users/' + owner },
              owner
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'meta-controls' },
            _etch2['default'].dom(
              'div',
              { className: 'btn-toolbar' },
              _etch2['default'].dom(
                'div',
                { ref: 'updateButtonGroup', className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn btn-info icon icon-cloud-download install-button', ref: 'updateButton' },
                  'Update'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'installAlternativeButtonGroup', className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn btn-info icon icon-cloud-download install-button', ref: 'installAlternativeButton' },
                  'Install Alternative'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'installButtonGroup', className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn btn-info icon icon-cloud-download install-button', ref: 'installButton' },
                  'Install'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'packageActionButtonGroup', className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn icon icon-gear settings', ref: 'settingsButton' },
                  'Settings'
                ),
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn icon icon-trashcan uninstall-button', ref: 'uninstallButton' },
                  'Uninstall'
                ),
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn icon icon-playback-pause enablement', ref: 'enablementButton' },
                  _etch2['default'].dom(
                    'span',
                    { className: 'disable-text' },
                    'Disable'
                  )
                ),
                _etch2['default'].dom('button', { type: 'button', className: 'btn status-indicator', tabIndex: '-1', ref: 'statusIndicator' })
              )
            )
          )
        )
      );
    }
  }, {
    key: 'locateCompatiblePackageVersion',
    value: function locateCompatiblePackageVersion(callback) {
      var _this = this;

      this.packageManager.loadCompatiblePackageVersion(this.pack.name, function (err, pack) {
        if (err != null) {
          console.error(err);
        }

        var packageVersion = pack.version;

        // A compatible version exist, we activate the install button and
        // set this.installablePack so that the install action installs the
        // compatible version of the package.
        if (packageVersion) {
          _this.refs.versionValue.textContent = packageVersion;
          if (packageVersion !== _this.pack.version) {
            _this.refs.versionValue.classList.add('text-warning');
            _this.refs.packageMessage.classList.add('text-warning');
            _this.refs.packageMessage.textContent = 'Version ' + packageVersion + ' is not the latest version available for this package, but it\'s the latest that is compatible with your version of Atom.';
          }

          _this.installablePack = pack;
          _this.hasCompatibleVersion = true;
        } else {
          _this.hasCompatibleVersion = false;
          _this.refs.versionValue.classList.add('text-error');
          _this.refs.packageMessage.classList.add('text-error');
          _this.refs.packageMessage.insertAdjacentText('beforeend', 'There\'s no version of this package that is compatible with your Atom version. The version must satisfy ' + _this.pack.engines.atom + '.');
          console.error('No available version compatible with the installed Atom version: ' + atom.getVersion());
        }

        callback();
      });
    }
  }, {
    key: 'handleButtonEvents',
    value: function handleButtonEvents(options) {
      var _this2 = this;

      if (options && options.onSettingsView) {
        this.refs.settingsButton.style.display = 'none';
      } else {
        (function () {
          var clickHandler = function clickHandler(event) {
            event.stopPropagation();
            _this2.settingsView.showPanel(_this2.pack.name, { back: options ? options.back : null, pack: _this2.pack });
          };

          _this2.element.addEventListener('click', clickHandler);
          _this2.disposables.add(new _atom.Disposable(function () {
            _this2.element.removeEventListener('click', clickHandler);
          }));

          _this2.refs.settingsButton.addEventListener('click', clickHandler);
          _this2.disposables.add(new _atom.Disposable(function () {
            _this2.refs.settingsButton.removeEventListener('click', clickHandler);
          }));
        })();
      }

      var installButtonClickHandler = function installButtonClickHandler(event) {
        event.stopPropagation();
        _this2.install();
      };
      this.refs.installButton.addEventListener('click', installButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.installButton.removeEventListener('click', installButtonClickHandler);
      }));

      var uninstallButtonClickHandler = function uninstallButtonClickHandler(event) {
        event.stopPropagation();
        _this2.uninstall();
      };
      this.refs.uninstallButton.addEventListener('click', uninstallButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.uninstallButton.removeEventListener('click', uninstallButtonClickHandler);
      }));

      var installAlternativeButtonClickHandler = function installAlternativeButtonClickHandler(event) {
        event.stopPropagation();
        _this2.installAlternative();
      };
      this.refs.installAlternativeButton.addEventListener('click', installAlternativeButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.installAlternativeButton.removeEventListener('click', installAlternativeButtonClickHandler);
      }));

      var updateButtonClickHandler = function updateButtonClickHandler(event) {
        event.stopPropagation();
        _this2.update().then(function () {
          var buttons = [{
            text: 'Restart',
            onDidClick: function onDidClick() {
              return atom.restartApplication();
            }
          }];

          var oldVersion = '';
          var newVersion = '';

          if (_this2.pack.apmInstallSource && _this2.pack.apmInstallSource.type === 'git') {
            oldVersion = _this2.pack.apmInstallSource.sha.substr(0, 8);
            newVersion = '' + _this2.pack.latestSha.substr(0, 8);
          } else if (_this2.pack.version && _this2.pack.latestVersion) {
            oldVersion = _this2.pack.version;
            newVersion = _this2.pack.latestVersion;
          }

          var detail = '';
          if (oldVersion && newVersion) {
            detail = oldVersion + ' -> ' + newVersion;
          }

          atom.notifications.addSuccess('Restart Atom to complete the update of `' + _this2.pack.name + '`.', {
            dismissable: true, buttons: buttons, detail: detail
          });
        });
      };
      this.refs.updateButton.addEventListener('click', updateButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.updateButton.removeEventListener('click', updateButtonClickHandler);
      }));

      var packageNameClickHandler = function packageNameClickHandler(event) {
        event.stopPropagation();
        var packageType = _this2.pack.theme ? 'themes' : 'packages';
        _electron.shell.openExternal('https://atom.io/' + packageType + '/' + _this2.pack.name);
      };
      this.refs.packageName.addEventListener('click', packageNameClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.packageName.removeEventListener('click', packageNameClickHandler);
      }));

      var enablementButtonClickHandler = function enablementButtonClickHandler(event) {
        event.stopPropagation();
        event.preventDefault();
        if (_this2.isDisabled()) {
          atom.packages.enablePackage(_this2.pack.name);
        } else {
          atom.packages.disablePackage(_this2.pack.name);
        }
      };
      this.refs.enablementButton.addEventListener('click', enablementButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.enablementButton.removeEventListener('click', enablementButtonClickHandler);
      }));

      var packageMessageClickHandler = function packageMessageClickHandler(event) {
        var target = event.target.closest('a');
        if (target) {
          event.stopPropagation();
          event.preventDefault();
          if (target.href && target.href.startsWith('atom:')) {
            atom.workspace.open(target.href);
          }
        }
      };
      this.refs.packageMessage.addEventListener('click', packageMessageClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.packageMessage.removeEventListener('click', packageMessageClickHandler);
      }));
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'loadCachedMetadata',
    value: function loadCachedMetadata() {
      var _this3 = this;

      this.client.avatar((0, _utils.ownerFromRepository)(this.pack.repository), function (err, avatarPath) {
        if (!err && avatarPath) {
          _this3.refs.avatar.src = 'file://' + avatarPath;
        }
      });

      this.client['package'](this.pack.name, function (err, data) {
        // We don't need to actually handle the error here, we can just skip
        // showing the download count if there's a problem.
        if (!err) {
          if (data == null) {
            data = {};
          }

          if (_this3.pack.apmInstallSource && _this3.pack.apmInstallSource.type === 'git') {
            _this3.refs.downloadIcon.classList.remove('icon-cloud-download');
            _this3.refs.downloadIcon.classList.add('icon-git-branch');
            _this3.refs.downloadCount.textContent = _this3.pack.apmInstallSource.sha.substr(0, 8);
          } else {
            _this3.refs.stargazerCount.textContent = data.stargazers_count ? data.stargazers_count.toLocaleString() : '';
            _this3.refs.downloadCount.textContent = data.downloads ? data.downloads.toLocaleString() : '';
          }
        }
      });
    }
  }, {
    key: 'updateInterfaceState',
    value: function updateInterfaceState() {
      this.refs.versionValue.textContent = (this.installablePack ? this.installablePack.version : null) || this.pack.version;
      if (this.pack.apmInstallSource && this.pack.apmInstallSource.type === 'git') {
        this.refs.downloadCount.textContent = this.pack.apmInstallSource.sha.substr(0, 8);
      }

      this.updateSettingsState();
      this.updateInstalledState();
      this.updateDisabledState();
      this.updateDeprecatedState();
    }
  }, {
    key: 'updateSettingsState',
    value: function updateSettingsState() {
      if (this.hasSettings() && !this.onSettingsView) {
        this.refs.settingsButton.style.display = '';
      } else {
        this.refs.settingsButton.style.display = 'none';
      }
    }

    // Section: disabled state updates

  }, {
    key: 'updateDisabledState',
    value: function updateDisabledState() {
      if (this.isDisabled()) {
        this.displayDisabledState();
      } else if (this.element.classList.contains('disabled')) {
        this.displayEnabledState();
      }
    }
  }, {
    key: 'displayEnabledState',
    value: function displayEnabledState() {
      this.element.classList.remove('disabled');
      if (this.type === 'theme') {
        this.refs.enablementButton.style.display = 'none';
      }
      this.refs.enablementButton.querySelector('.disable-text').textContent = 'Disable';
      this.refs.enablementButton.classList.add('icon-playback-pause');
      this.refs.enablementButton.classList.remove('icon-playback-play');
      this.refs.statusIndicator.classList.remove('is-disabled');
    }
  }, {
    key: 'displayDisabledState',
    value: function displayDisabledState() {
      this.element.classList.add('disabled');
      this.refs.enablementButton.querySelector('.disable-text').textContent = 'Enable';
      this.refs.enablementButton.classList.add('icon-playback-play');
      this.refs.enablementButton.classList.remove('icon-playback-pause');
      this.refs.statusIndicator.classList.add('is-disabled');
      if (this.isDeprecated()) {
        this.refs.enablementButton.disabled = true;
      } else {
        this.refs.enablementButton.disabled = false;
      }
    }

    // Section: installed state updates

  }, {
    key: 'updateInstalledState',
    value: function updateInstalledState() {
      if (this.isInstalled()) {
        this.displayInstalledState();
      } else {
        this.displayNotInstalledState();
      }
    }
  }, {
    key: 'displayInstalledState',
    value: function displayInstalledState() {
      if (this.newVersion || this.newSha) {
        this.refs.updateButtonGroup.style.display = '';
        if (this.newVersion) {
          this.refs.updateButton.textContent = 'Update to ' + this.newVersion;
        } else if (this.newSha) {
          this.refs.updateButton.textContent = 'Update to ' + this.newSha.substr(0, 8);
        }
      } else {
        this.refs.updateButtonGroup.style.display = 'none';
      }

      this.refs.installButtonGroup.style.display = 'none';
      this.refs.installAlternativeButtonGroup.style.display = 'none';
      this.refs.packageActionButtonGroup.style.display = '';
      this.refs.uninstallButton.style.display = '';
    }
  }, {
    key: 'displayNotInstalledState',
    value: function displayNotInstalledState() {
      var _this4 = this;

      this.refs.uninstallButton.style.display = 'none';
      var atomVersion = this.packageManager.normalizeVersion(atom.getVersion());
      if (!this.packageManager.satisfiesVersion(atomVersion, this.pack)) {
        this.hasCompatibleVersion = false;
        this.setNotInstalledStateButtons();
        this.locateCompatiblePackageVersion(function () {
          _this4.setNotInstalledStateButtons();
        });
      } else {
        this.setNotInstalledStateButtons();
      }
    }
  }, {
    key: 'setNotInstalledStateButtons',
    value: function setNotInstalledStateButtons() {
      if (!this.hasCompatibleVersion) {
        this.refs.installButtonGroup.style.display = 'none';
        this.refs.updateButtonGroup.style.display = 'none';
      } else if (this.newVersion || this.newSha) {
        this.refs.updateButtonGroup.style.display = '';
        this.refs.installButtonGroup.style.display = 'none';
      } else {
        this.refs.updateButtonGroup.style.display = 'none';
        this.refs.installButtonGroup.style.display = '';
      }
      this.refs.installAlternativeButtonGroup.style.display = 'none';
      this.refs.packageActionButtonGroup.style.display = 'none';
    }

    // Section: deprecated state updates

  }, {
    key: 'updateDeprecatedState',
    value: function updateDeprecatedState() {
      if (this.isDeprecated()) {
        this.displayDeprecatedState();
      } else if (this.element.classList.contains('deprecated')) {
        this.displayUndeprecatedState();
      }
    }
  }, {
    key: 'displayStats',
    value: function displayStats(options) {
      if (options && options.stats && options.stats.downloads) {
        this.refs.packageDownloads.style.display = '';
      } else {
        this.refs.packageDownloads.style.display = 'none';
      }

      if (options && options.stats && options.stats.stars) {
        this.refs.packageStars.style.display = '';
      } else {
        this.refs.packageStars.style.display = 'none';
      }
    }
  }, {
    key: 'displayUndeprecatedState',
    value: function displayUndeprecatedState() {
      this.element.classList.remove('deprecated');
      this.refs.packageMessage.classList.remove('text-warning');
      this.refs.packageMessage.textContent = '';
    }
  }, {
    key: 'displayDeprecatedState',
    value: function displayDeprecatedState() {
      this.element.classList.add('deprecated');
      this.refs.settingsButton.disabled = true;

      var info = this.getDeprecatedPackageMetadata();
      this.refs.packageMessage.classList.add('text-warning');

      var message = null;
      if (info && info.hasDeprecations) {
        message = this.getDeprecationMessage(this.newVersion);
      } else if (info && info.hasAlternative && info.alternative === 'core') {
        message = info.message != null ? info.message : 'The features in `' + this.pack.name + '` have been added to core.';
        message += ' Please uninstall this package.';
        this.refs.settingsButton.remove();
        this.refs.enablementButton.remove();
      } else if (info && info.hasAlternative && info.alternative) {
        var alt = info.alternative;
        var isInstalled = this.isInstalled();
        if (isInstalled && this.packageManager.isPackageInstalled(alt)) {
          message = '`' + this.pack.name + '` has been replaced by `' + alt + '` which is already installed. Please uninstall this package.';
          this.refs.settingsButton.remove();
          this.refs.enablementButton.remove();
        } else if (isInstalled) {
          message = '`' + this.pack.name + '` has been replaced by [`' + alt + '`](atom://config/install/package:' + alt + ').';
          this.refs.installAlternativeButton.textContent = 'Install ' + alt;
          this.refs.installAlternativeButtonGroup.style.display = '';
          this.refs.packageActionButtonGroup.style.display = '';
          this.refs.settingsButton.remove();
          this.refs.enablementButton.remove();
        } else {
          message = '`' + this.pack.name + '` has been replaced by [`' + alt + '`](atom://config/install/package:' + alt + ').';
          this.refs.installButtonGroup.style.display = 'none';
          this.refs.installAlternativeButtonGroup.style.display = 'none';
          this.refs.packageActionButtonGroup.style.display = 'none';
        }
      }

      if (message != null) {
        if (marked == null) {
          marked = require('marked');
        }

        this.refs.packageMessage.innerHTML = marked(message);
      }
    }
  }, {
    key: 'displayGitPackageInstallInformation',
    value: function displayGitPackageInstallInformation() {
      this.refs.metaUserContainer.remove();
      this.refs.statsContainer.remove();
      var gitUrlInfo = this.pack.gitUrlInfo;

      if (gitUrlInfo['default'] === 'shortcut') {
        this.refs.packageDescription.textContent = gitUrlInfo.https();
      } else {
        this.refs.packageDescription.textContent = gitUrlInfo.toString();
      }
      this.refs.installButton.classList.remove('icon-cloud-download');
      this.refs.installButton.classList.add('icon-git-commit');
      this.refs.updateButton.classList.remove('icon-cloud-download');
      this.refs.updateButton.classList.add('icon-git-commit');
    }
  }, {
    key: 'displayAvailableUpdate',
    value: function displayAvailableUpdate(newVersion) {
      this.newVersion = newVersion;
      this.updateInterfaceState();
    }
  }, {
    key: 'getDeprecationMessage',
    value: function getDeprecationMessage(newVersion) {
      var info = this.getDeprecatedPackageMetadata();
      if (!info || !info.hasDeprecations) {
        return;
      }

      if (newVersion) {
        if (this.isDeprecated(newVersion)) {
          return 'An update to `v' + newVersion + '` is available but still contains deprecations.';
        } else {
          return 'An update to `v' + newVersion + '` is available without deprecations.';
        }
      } else {
        if (this.isInstalled()) {
          return info.message != null ? info.message : 'This package has not been loaded due to using deprecated APIs. There is no update available.';
        } else {
          return 'This package has deprecations and is not installable.';
        }
      }
    }
  }, {
    key: 'handlePackageEvents',
    value: function handlePackageEvents() {
      var _this5 = this;

      this.disposables.add(atom.packages.onDidDeactivatePackage(function (pack) {
        if (pack.name === _this5.pack.name) {
          _this5.updateDisabledState();
        }
      }));

      this.disposables.add(atom.packages.onDidActivatePackage(function (pack) {
        if (pack.name === _this5.pack.name) {
          _this5.updateDisabledState();
        }
      }));

      this.disposables.add(atom.config.onDidChange('core.disabledPackages', function () {
        _this5.updateDisabledState();
      }));

      this.subscribeToPackageEvent('package-installing theme-installing', function () {
        _this5.updateInterfaceState();
        _this5.refs.installButton.disabled = true;
        _this5.refs.installButton.classList.add('is-installing');
      });

      this.subscribeToPackageEvent('package-updating theme-updating', function () {
        _this5.updateInterfaceState();
        _this5.refs.updateButton.disabled = true;
        _this5.refs.updateButton.classList.add('is-installing');
      });

      this.subscribeToPackageEvent('package-installing-alternative', function () {
        _this5.updateInterfaceState();
        _this5.refs.installAlternativeButton.disabled = true;
        _this5.refs.installAlternativeButton.classList.add('is-installing');
      });

      this.subscribeToPackageEvent('package-uninstalling theme-uninstalling', function () {
        _this5.updateInterfaceState();
        _this5.refs.enablementButton.disabled = true;
        _this5.refs.uninstallButton.disabled = true;
        _this5.refs.uninstallButton.classList.add('is-uninstalling');
      });

      this.subscribeToPackageEvent('package-installed package-install-failed theme-installed theme-install-failed', function () {
        var loadedPack = atom.packages.getLoadedPackage(_this5.pack.name);
        var version = loadedPack && loadedPack.metadata ? loadedPack.metadata.version : null;
        if (version) {
          _this5.pack.version = version;
        }
        _this5.refs.installButton.disabled = false;
        _this5.refs.installButton.classList.remove('is-installing');
        _this5.updateInterfaceState();
      });

      this.subscribeToPackageEvent('package-updated theme-updated', function () {
        var loadedPack = atom.packages.getLoadedPackage(_this5.pack.name);
        var metadata = loadedPack ? loadedPack.metadata : null;
        if (metadata && metadata.version) {
          _this5.pack.version = metadata.version;
        }

        if (metadata && metadata.apmInstallSource) {
          _this5.pack.apmInstallSource = metadata.apmInstallSource;
        }

        _this5.newVersion = null;
        _this5.newSha = null;
        _this5.refs.updateButton.disabled = false;
        _this5.refs.updateButton.classList.remove('is-installing');
        _this5.updateInterfaceState();
      });

      this.subscribeToPackageEvent('package-update-failed theme-update-failed', function () {
        _this5.refs.updateButton.disabled = false;
        _this5.refs.updateButton.classList.remove('is-installing');
        _this5.updateInterfaceState();
      });

      this.subscribeToPackageEvent('package-uninstalled package-uninstall-failed theme-uninstalled theme-uninstall-failed', function () {
        _this5.newVersion = null;
        _this5.newSha = null;
        _this5.refs.enablementButton.disabled = false;
        _this5.refs.uninstallButton.disabled = false;
        _this5.refs.uninstallButton.classList.remove('is-uninstalling');
        _this5.updateInterfaceState();
      });

      this.subscribeToPackageEvent('package-installed-alternative package-install-alternative-failed', function () {
        _this5.refs.installAlternativeButton.disabled = false;
        _this5.refs.installAlternativeButton.classList.remove('is-installing');
        _this5.updateInterfaceState();
      });
    }
  }, {
    key: 'isInstalled',
    value: function isInstalled() {
      return this.packageManager.isPackageInstalled(this.pack.name);
    }
  }, {
    key: 'isDisabled',
    value: function isDisabled() {
      return atom.packages.isPackageDisabled(this.pack.name);
    }
  }, {
    key: 'isDeprecated',
    value: function isDeprecated(version) {
      var packVersion = version != null ? version : this.pack.version;
      return atom.packages.isDeprecatedPackage(this.pack.name, packVersion);
    }
  }, {
    key: 'getDeprecatedPackageMetadata',
    value: function getDeprecatedPackageMetadata() {
      return atom.packages.getDeprecatedPackageMetadata(this.pack.name);
    }
  }, {
    key: 'hasSettings',
    value: function hasSettings() {
      return this.packageManager.packageHasSettings(this.pack.name);
    }
  }, {
    key: 'subscribeToPackageEvent',
    value: function subscribeToPackageEvent(event, callback) {
      var _this6 = this;

      this.disposables.add(this.packageManager.on(event, function (_ref) {
        var pack = _ref.pack;
        var error = _ref.error;

        if (pack.pack != null) {
          pack = pack.pack;
        }

        var packageName = pack.name;
        if (packageName === _this6.pack.name) {
          callback(pack, error);
        }
      }));
    }

    /*
    Section: Methods that should be on a Package model
    */

  }, {
    key: 'install',
    value: function install() {
      var _this7 = this;

      this.packageManager.install(this.installablePack != null ? this.installablePack : this.pack, function (error) {
        if (error != null) {
          console.error('Installing ' + _this7.type + ' ' + _this7.pack.name + ' failed', error.stack != null ? error.stack : error, error.stderr);
        } else {
          // if a package was disabled before installing it, re-enable it
          if (_this7.isDisabled()) {
            atom.packages.enablePackage(_this7.pack.name);
          }
        }
      });
    }
  }, {
    key: 'update',
    value: function update() {
      var _this8 = this;

      if (!this.newVersion && !this.newSha) {
        return Promise.resolve();
      }

      var pack = this.installablePack != null ? this.installablePack : this.pack;
      var version = this.newVersion ? 'v' + this.newVersion : '#' + this.newSha.substr(0, 8);
      return new Promise(function (resolve, reject) {
        _this8.packageManager.update(pack, _this8.newVersion, function (error) {
          if (error != null) {
            atom.assert(false, 'Package update failed', function (assertionError) {
              assertionError.metadata = {
                type: _this8.type,
                name: pack.name,
                version: version,
                errorMessage: error.message,
                errorStack: error.stack,
                errorStderr: error.stderr
              };
            });
            console.error('Updating ' + _this8.type + ' ' + pack.name + ' to ' + version + ' failed:\n', error, error.stderr != null ? error.stderr : '');
            reject(error);
          } else {
            resolve();
          }
        });
      });
    }
  }, {
    key: 'uninstall',
    value: function uninstall() {
      var _this9 = this;

      this.packageManager.uninstall(this.pack, function (error) {
        if (error != null) {
          console.error('Uninstalling ' + _this9.type + ' ' + _this9.pack.name + ' failed', error.stack != null ? error.stack : error, error.stderr);
        }
      });
    }
  }, {
    key: 'installAlternative',
    value: function installAlternative() {
      var _this10 = this;

      var metadata = this.getDeprecatedPackageMetadata();
      var loadedPack = atom.packages.getLoadedPackage(metadata ? metadata.alternative : null);
      if (!metadata || !metadata.hasAlternative || metadata.alternative === 'core' || loadedPack) {
        return;
      }

      this.packageManager.installAlternative(this.pack, metadata.alternative, function (error, _ref2) {
        var pack = _ref2.pack;
        var alternative = _ref2.alternative;

        if (error != null) {
          console.error('Installing alternative `' + alternative + '` ' + _this10.type + ' for ' + _this10.pack.name + ' failed', error.stack != null ? error.stack : error, error.stderr);
        }
      });
    }
  }]);

  return PackageCard;
})();

exports['default'] = PackageCard;
module.exports = exports['default'];
/* A transparent gif so there is no "broken border" */
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL3NldHRpbmdzLXZpZXcvbGliL3BhY2thZ2UtY2FyZC5qcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7O29CQUc4QyxNQUFNOzt3QkFDaEMsVUFBVTs7b0JBQ2IsTUFBTTs7OztxQkFFVyxTQUFTOztBQUUzQyxJQUFJLE1BQU0sR0FBRyxJQUFJLENBQUE7O0lBRUksV0FBVztBQUNsQixXQURPLFdBQVcsQ0FDakIsSUFBSSxFQUFFLFlBQVksRUFBRSxjQUFjLEVBQWdCO1FBQWQsT0FBTyx5REFBRyxFQUFFOzswQkFEMUMsV0FBVzs7QUFFNUIsUUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLENBQUE7QUFDaEIsUUFBSSxDQUFDLFlBQVksR0FBRyxZQUFZLENBQUE7QUFDaEMsUUFBSSxDQUFDLGNBQWMsR0FBRyxjQUFjLENBQUE7QUFDcEMsUUFBSSxDQUFDLFdBQVcsR0FBRywrQkFBeUIsQ0FBQTs7Ozs7O0FBTTVDLFFBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQyxTQUFTLEVBQUUsQ0FBQTtBQUM3QyxRQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxHQUFHLE9BQU8sR0FBRyxTQUFTLENBQUE7QUFDakQsUUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQTtBQUMxQixRQUFJLENBQUMsY0FBYyxHQUFHLE9BQU8sQ0FBQyxjQUFjLENBQUE7O0FBRTVDLFFBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLEtBQUssSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUU7QUFDakQsVUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQTtLQUMxQzs7QUFFRCxRQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLEtBQUssS0FBSyxFQUFFO0FBQzNFLFVBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLEtBQUssSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUU7QUFDMUQsWUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQTtPQUNsQztLQUNGOzs7QUFHRCxRQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRTtBQUNsQixhQUFPLENBQUMsS0FBSyxHQUFHLEVBQUMsU0FBUyxFQUFFLElBQUksRUFBQyxDQUFBO0tBQ2xDOztBQUVELHNCQUFLLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQTs7QUFFckIsUUFBSSxDQUFDLFlBQVksQ0FBQyxPQUFPLENBQUMsQ0FBQTtBQUMxQixRQUFJLENBQUMsbUJBQW1CLEVBQUUsQ0FBQTtBQUMxQixRQUFJLENBQUMsa0JBQWtCLENBQUMsT0FBTyxDQUFDLENBQUE7QUFDaEMsUUFBSSxDQUFDLGtCQUFrQixFQUFFLENBQUE7OztBQUd6QixRQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssT0FBTyxFQUFFO0FBQ3pCLFVBQUksQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLE1BQU0sRUFBRSxDQUFBO0FBQ2xDLFVBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxFQUFFLENBQUE7S0FDcEM7O0FBRUQsUUFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEVBQUU7QUFDbEQsVUFBSSxDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLEVBQUUsQ0FBQTtBQUNyQyxVQUFJLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxNQUFNLEVBQUUsQ0FBQTtLQUNuQzs7QUFFRCxRQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUU7QUFDcEMsVUFBSSxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQTtLQUNuRDs7QUFFRCxRQUFJLENBQUMsb0JBQW9CLEdBQUcsSUFBSSxDQUFBO0FBQ2hDLFFBQUksQ0FBQyxvQkFBb0IsRUFBRSxDQUFBO0dBQzVCOztlQXZEa0IsV0FBVzs7V0F5RHZCLGtCQUFHO0FBQ1IsVUFBTSxXQUFXLEdBQUcsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUEsSUFBSyxFQUFFLENBQUE7QUFDaEcsVUFBTSxLQUFLLEdBQUcsZ0NBQW9CLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUE7QUFDdkQsVUFBTSxXQUFXLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXLElBQUksRUFBRSxDQUFBOztBQUUvQyxhQUNFOztVQUFLLFNBQVMsRUFBQyx1QkFBdUI7UUFDcEM7O1lBQUssR0FBRyxFQUFDLGdCQUFnQixFQUFDLFNBQVMsRUFBQyxrQkFBa0I7VUFDcEQ7O2NBQU0sR0FBRyxFQUFDLGNBQWMsRUFBQyxTQUFTLEVBQUMsWUFBWTtZQUM3QyxnQ0FBTSxHQUFHLEVBQUMsZUFBZSxFQUFDLFNBQVMsRUFBQyxnQkFBZ0IsR0FBRztZQUN2RCxnQ0FBTSxHQUFHLEVBQUMsZ0JBQWdCLEVBQUMsU0FBUyxFQUFDLE9BQU8sR0FBRztXQUMxQztVQUVQOztjQUFNLEdBQUcsRUFBQyxrQkFBa0IsRUFBQyxTQUFTLEVBQUMsWUFBWTtZQUNqRCxnQ0FBTSxHQUFHLEVBQUMsY0FBYyxFQUFDLFNBQVMsRUFBQywwQkFBMEIsR0FBRztZQUNoRSxnQ0FBTSxHQUFHLEVBQUMsZUFBZSxFQUFDLFNBQVMsRUFBQyxPQUFPLEdBQUc7V0FDekM7U0FDSDtRQUVOOztZQUFLLFNBQVMsRUFBQyxNQUFNO1VBQ25COztjQUFJLFNBQVMsRUFBQyxXQUFXO1lBQ3ZCOztnQkFBRyxTQUFTLEVBQUMsY0FBYyxFQUFDLEdBQUcsRUFBQyxhQUFhO2NBQUUsV0FBVzthQUFLO1lBQy9EOztnQkFBTSxTQUFTLEVBQUMsaUJBQWlCO2NBQy9COztrQkFBTSxHQUFHLEVBQUMsY0FBYyxFQUFDLFNBQVMsRUFBQyxPQUFPO2dCQUFFLE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQztlQUFRO2FBQ3hFO1lBRVA7O2dCQUFNLFNBQVMsRUFBQyxrREFBa0Q7O2FBQWtCO1dBQ2pGO1VBQ0w7O2NBQU0sR0FBRyxFQUFDLG9CQUFvQixFQUFDLFNBQVMsRUFBQyxxQkFBcUI7WUFBRSxXQUFXO1dBQVE7VUFDbkYsK0JBQUssR0FBRyxFQUFDLGdCQUFnQixFQUFDLFNBQVMsRUFBQyxpQkFBaUIsR0FBRztTQUNwRDtRQUVOOztZQUFLLFNBQVMsRUFBQyxNQUFNO1VBQ25COztjQUFLLEdBQUcsRUFBQyxtQkFBbUIsRUFBQyxTQUFTLEVBQUMsV0FBVztZQUNoRDs7Z0JBQUcsR0FBRyxFQUFDLFlBQVksRUFBQyxJQUFJLDZCQUEyQixLQUFLLEFBQUc7Y0FFekQsK0JBQUssR0FBRyxFQUFDLFFBQVEsRUFBQyxTQUFTLEVBQUMsUUFBUSxFQUFDLEdBQUcsRUFBQyxnRkFBZ0YsR0FBRzthQUMxSDtZQUNKOztnQkFBRyxHQUFHLEVBQUMsV0FBVyxFQUFDLFNBQVMsRUFBQyxRQUFRLEVBQUMsSUFBSSw2QkFBMkIsS0FBSyxBQUFHO2NBQUUsS0FBSzthQUFLO1dBQ3JGO1VBQ047O2NBQUssU0FBUyxFQUFDLGVBQWU7WUFDNUI7O2dCQUFLLFNBQVMsRUFBQyxhQUFhO2NBQzFCOztrQkFBSyxHQUFHLEVBQUMsbUJBQW1CLEVBQUMsU0FBUyxFQUFDLFdBQVc7Z0JBQ2hEOztvQkFBUSxJQUFJLEVBQUMsUUFBUSxFQUFDLFNBQVMsRUFBQyxzREFBc0QsRUFBQyxHQUFHLEVBQUMsY0FBYzs7aUJBQWdCO2VBQ3JIO2NBQ047O2tCQUFLLEdBQUcsRUFBQywrQkFBK0IsRUFBQyxTQUFTLEVBQUMsV0FBVztnQkFDNUQ7O29CQUFRLElBQUksRUFBQyxRQUFRLEVBQUMsU0FBUyxFQUFDLHNEQUFzRCxFQUFDLEdBQUcsRUFBQywwQkFBMEI7O2lCQUE2QjtlQUM5STtjQUNOOztrQkFBSyxHQUFHLEVBQUMsb0JBQW9CLEVBQUMsU0FBUyxFQUFDLFdBQVc7Z0JBQ2pEOztvQkFBUSxJQUFJLEVBQUMsUUFBUSxFQUFDLFNBQVMsRUFBQyxzREFBc0QsRUFBQyxHQUFHLEVBQUMsZUFBZTs7aUJBQWlCO2VBQ3ZIO2NBQ047O2tCQUFLLEdBQUcsRUFBQywwQkFBMEIsRUFBQyxTQUFTLEVBQUMsV0FBVztnQkFDdkQ7O29CQUFRLElBQUksRUFBQyxRQUFRLEVBQUMsU0FBUyxFQUFDLDZCQUE2QixFQUFDLEdBQUcsRUFBQyxnQkFBZ0I7O2lCQUFrQjtnQkFDcEc7O29CQUFRLElBQUksRUFBQyxRQUFRLEVBQUMsU0FBUyxFQUFDLHlDQUF5QyxFQUFDLEdBQUcsRUFBQyxpQkFBaUI7O2lCQUFtQjtnQkFDbEg7O29CQUFRLElBQUksRUFBQyxRQUFRLEVBQUMsU0FBUyxFQUFDLHlDQUF5QyxFQUFDLEdBQUcsRUFBQyxrQkFBa0I7a0JBQzlGOztzQkFBTSxTQUFTLEVBQUMsY0FBYzs7bUJBQWU7aUJBQ3RDO2dCQUNULGtDQUFRLElBQUksRUFBQyxRQUFRLEVBQUMsU0FBUyxFQUFDLHNCQUFzQixFQUFDLFFBQVEsRUFBQyxJQUFJLEVBQUMsR0FBRyxFQUFDLGlCQUFpQixHQUFHO2VBQ3pGO2FBQ0Y7V0FDRjtTQUNGO09BQ0YsQ0FDUDtLQUNGOzs7V0FFOEIsd0NBQUMsUUFBUSxFQUFFOzs7QUFDeEMsVUFBSSxDQUFDLGNBQWMsQ0FBQyw0QkFBNEIsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxVQUFDLEdBQUcsRUFBRSxJQUFJLEVBQUs7QUFDOUUsWUFBSSxHQUFHLElBQUksSUFBSSxFQUFFO0FBQ2YsaUJBQU8sQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUE7U0FDbkI7O0FBRUQsWUFBTSxjQUFjLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQTs7Ozs7QUFLbkMsWUFBSSxjQUFjLEVBQUU7QUFDbEIsZ0JBQUssSUFBSSxDQUFDLFlBQVksQ0FBQyxXQUFXLEdBQUcsY0FBYyxDQUFBO0FBQ25ELGNBQUksY0FBYyxLQUFLLE1BQUssSUFBSSxDQUFDLE9BQU8sRUFBRTtBQUN4QyxrQkFBSyxJQUFJLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUE7QUFDcEQsa0JBQUssSUFBSSxDQUFDLGNBQWMsQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFBO0FBQ3RELGtCQUFLLElBQUksQ0FBQyxjQUFjLENBQUMsV0FBVyxnQkFBYyxjQUFjLDhIQUEwSCxDQUFBO1dBQzNMOztBQUVELGdCQUFLLGVBQWUsR0FBRyxJQUFJLENBQUE7QUFDM0IsZ0JBQUssb0JBQW9CLEdBQUcsSUFBSSxDQUFBO1NBQ2pDLE1BQU07QUFDTCxnQkFBSyxvQkFBb0IsR0FBRyxLQUFLLENBQUE7QUFDakMsZ0JBQUssSUFBSSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLFlBQVksQ0FBQyxDQUFBO0FBQ2xELGdCQUFLLElBQUksQ0FBQyxjQUFjLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxZQUFZLENBQUMsQ0FBQTtBQUNwRCxnQkFBSyxJQUFJLENBQUMsY0FBYyxDQUFDLGtCQUFrQixDQUN6QyxXQUFXLCtHQUMrRixNQUFLLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxPQUNqSSxDQUFBO0FBQ0QsaUJBQU8sQ0FBQyxLQUFLLHVFQUFxRSxJQUFJLENBQUMsVUFBVSxFQUFFLENBQUcsQ0FBQTtTQUN2Rzs7QUFFRCxnQkFBUSxFQUFFLENBQUE7T0FDWCxDQUFDLENBQUE7S0FDSDs7O1dBRWtCLDRCQUFDLE9BQU8sRUFBRTs7O0FBQzNCLFVBQUksT0FBTyxJQUFJLE9BQU8sQ0FBQyxjQUFjLEVBQUU7QUFDckMsWUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7T0FDaEQsTUFBTTs7QUFDTCxjQUFNLFlBQVksR0FBRyxTQUFmLFlBQVksQ0FBSSxLQUFLLEVBQUs7QUFDOUIsaUJBQUssQ0FBQyxlQUFlLEVBQUUsQ0FBQTtBQUN2QixtQkFBSyxZQUFZLENBQUMsU0FBUyxDQUFDLE9BQUssSUFBSSxDQUFDLElBQUksRUFBRSxFQUFDLElBQUksRUFBRSxPQUFPLEdBQUcsT0FBTyxDQUFDLElBQUksR0FBRyxJQUFJLEVBQUUsSUFBSSxFQUFFLE9BQUssSUFBSSxFQUFDLENBQUMsQ0FBQTtXQUNwRyxDQUFBOztBQUVELGlCQUFLLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUUsWUFBWSxDQUFDLENBQUE7QUFDcEQsaUJBQUssV0FBVyxDQUFDLEdBQUcsQ0FBQyxxQkFBZSxZQUFNO0FBQUUsbUJBQUssT0FBTyxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxZQUFZLENBQUMsQ0FBQTtXQUFFLENBQUMsQ0FBQyxDQUFBOztBQUV2RyxpQkFBSyxJQUFJLENBQUMsY0FBYyxDQUFDLGdCQUFnQixDQUFDLE9BQU8sRUFBRSxZQUFZLENBQUMsQ0FBQTtBQUNoRSxpQkFBSyxXQUFXLENBQUMsR0FBRyxDQUFDLHFCQUFlLFlBQU07QUFBRSxtQkFBSyxJQUFJLENBQUMsY0FBYyxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxZQUFZLENBQUMsQ0FBQTtXQUFFLENBQUMsQ0FBQyxDQUFBOztPQUNwSDs7QUFFRCxVQUFNLHlCQUF5QixHQUFHLFNBQTVCLHlCQUF5QixDQUFJLEtBQUssRUFBSztBQUMzQyxhQUFLLENBQUMsZUFBZSxFQUFFLENBQUE7QUFDdkIsZUFBSyxPQUFPLEVBQUUsQ0FBQTtPQUNmLENBQUE7QUFDRCxVQUFJLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUUseUJBQXlCLENBQUMsQ0FBQTtBQUM1RSxVQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxxQkFBZSxZQUFNO0FBQUUsZUFBSyxJQUFJLENBQUMsYUFBYSxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSx5QkFBeUIsQ0FBQyxDQUFBO09BQUUsQ0FBQyxDQUFDLENBQUE7O0FBRS9ILFVBQU0sMkJBQTJCLEdBQUcsU0FBOUIsMkJBQTJCLENBQUksS0FBSyxFQUFLO0FBQzdDLGFBQUssQ0FBQyxlQUFlLEVBQUUsQ0FBQTtBQUN2QixlQUFLLFNBQVMsRUFBRSxDQUFBO09BQ2pCLENBQUE7QUFDRCxVQUFJLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUUsMkJBQTJCLENBQUMsQ0FBQTtBQUNoRixVQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxxQkFBZSxZQUFNO0FBQUUsZUFBSyxJQUFJLENBQUMsZUFBZSxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSwyQkFBMkIsQ0FBQyxDQUFBO09BQUUsQ0FBQyxDQUFDLENBQUE7O0FBRW5JLFVBQU0sb0NBQW9DLEdBQUcsU0FBdkMsb0NBQW9DLENBQUksS0FBSyxFQUFLO0FBQ3RELGFBQUssQ0FBQyxlQUFlLEVBQUUsQ0FBQTtBQUN2QixlQUFLLGtCQUFrQixFQUFFLENBQUE7T0FDMUIsQ0FBQTtBQUNELFVBQUksQ0FBQyxJQUFJLENBQUMsd0JBQXdCLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxFQUFFLG9DQUFvQyxDQUFDLENBQUE7QUFDbEcsVUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMscUJBQWUsWUFBTTtBQUFFLGVBQUssSUFBSSxDQUFDLHdCQUF3QixDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxvQ0FBb0MsQ0FBQyxDQUFBO09BQUUsQ0FBQyxDQUFDLENBQUE7O0FBRXJKLFVBQU0sd0JBQXdCLEdBQUcsU0FBM0Isd0JBQXdCLENBQUksS0FBSyxFQUFLO0FBQzFDLGFBQUssQ0FBQyxlQUFlLEVBQUUsQ0FBQTtBQUN2QixlQUFLLE1BQU0sRUFBRSxDQUFDLElBQUksQ0FBQyxZQUFNO0FBQ3ZCLGNBQU0sT0FBTyxHQUFHLENBQUM7QUFDZixnQkFBSSxFQUFFLFNBQVM7QUFDZixzQkFBVSxFQUFDLHNCQUFHO0FBQUUscUJBQU8sSUFBSSxDQUFDLGtCQUFrQixFQUFFLENBQUE7YUFBRTtXQUNuRCxDQUFDLENBQUE7O0FBRUYsY0FBSSxVQUFVLEdBQUcsRUFBRSxDQUFBO0FBQ25CLGNBQUksVUFBVSxHQUFHLEVBQUUsQ0FBQTs7QUFFbkIsY0FBSSxPQUFLLElBQUksQ0FBQyxnQkFBZ0IsSUFBSSxPQUFLLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLEtBQUssS0FBSyxFQUFFO0FBQzNFLHNCQUFVLEdBQUcsT0FBSyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUE7QUFDeEQsc0JBQVUsUUFBTSxPQUFLLElBQUksQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQUFBRSxDQUFBO1dBQ25ELE1BQU0sSUFBSSxPQUFLLElBQUksQ0FBQyxPQUFPLElBQUksT0FBSyxJQUFJLENBQUMsYUFBYSxFQUFFO0FBQ3ZELHNCQUFVLEdBQUcsT0FBSyxJQUFJLENBQUMsT0FBTyxDQUFBO0FBQzlCLHNCQUFVLEdBQUcsT0FBSyxJQUFJLENBQUMsYUFBYSxDQUFBO1dBQ3JDOztBQUVELGNBQUksTUFBTSxHQUFHLEVBQUUsQ0FBQTtBQUNmLGNBQUksVUFBVSxJQUFJLFVBQVUsRUFBRTtBQUM1QixrQkFBTSxHQUFNLFVBQVUsWUFBTyxVQUFVLEFBQUUsQ0FBQTtXQUMxQzs7QUFFRCxjQUFJLENBQUMsYUFBYSxDQUFDLFVBQVUsOENBQTZDLE9BQUssSUFBSSxDQUFDLElBQUksU0FBTztBQUM3Rix1QkFBVyxFQUFFLElBQUksRUFBRSxPQUFPLEVBQVAsT0FBTyxFQUFFLE1BQU0sRUFBTixNQUFNO1dBQ25DLENBQUMsQ0FBQTtTQUNILENBQUMsQ0FBQTtPQUNILENBQUE7QUFDRCxVQUFJLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUUsd0JBQXdCLENBQUMsQ0FBQTtBQUMxRSxVQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxxQkFBZSxZQUFNO0FBQUUsZUFBSyxJQUFJLENBQUMsWUFBWSxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSx3QkFBd0IsQ0FBQyxDQUFBO09BQUUsQ0FBQyxDQUFDLENBQUE7O0FBRTdILFVBQU0sdUJBQXVCLEdBQUcsU0FBMUIsdUJBQXVCLENBQUksS0FBSyxFQUFLO0FBQ3pDLGFBQUssQ0FBQyxlQUFlLEVBQUUsQ0FBQTtBQUN2QixZQUFNLFdBQVcsR0FBRyxPQUFLLElBQUksQ0FBQyxLQUFLLEdBQUcsUUFBUSxHQUFHLFVBQVUsQ0FBQTtBQUMzRCx3QkFBTSxZQUFZLHNCQUFvQixXQUFXLFNBQUksT0FBSyxJQUFJLENBQUMsSUFBSSxDQUFHLENBQUE7T0FDdkUsQ0FBQTtBQUNELFVBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLGdCQUFnQixDQUFDLE9BQU8sRUFBRSx1QkFBdUIsQ0FBQyxDQUFBO0FBQ3hFLFVBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLHFCQUFlLFlBQU07QUFBRSxlQUFLLElBQUksQ0FBQyxXQUFXLENBQUMsbUJBQW1CLENBQUMsT0FBTyxFQUFFLHVCQUF1QixDQUFDLENBQUE7T0FBRSxDQUFDLENBQUMsQ0FBQTs7QUFFM0gsVUFBTSw0QkFBNEIsR0FBRyxTQUEvQiw0QkFBNEIsQ0FBSSxLQUFLLEVBQUs7QUFDOUMsYUFBSyxDQUFDLGVBQWUsRUFBRSxDQUFBO0FBQ3ZCLGFBQUssQ0FBQyxjQUFjLEVBQUUsQ0FBQTtBQUN0QixZQUFJLE9BQUssVUFBVSxFQUFFLEVBQUU7QUFDckIsY0FBSSxDQUFDLFFBQVEsQ0FBQyxhQUFhLENBQUMsT0FBSyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUE7U0FDNUMsTUFBTTtBQUNMLGNBQUksQ0FBQyxRQUFRLENBQUMsY0FBYyxDQUFDLE9BQUssSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFBO1NBQzdDO09BQ0YsQ0FBQTtBQUNELFVBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxFQUFFLDRCQUE0QixDQUFDLENBQUE7QUFDbEYsVUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMscUJBQWUsWUFBTTtBQUFFLGVBQUssSUFBSSxDQUFDLGdCQUFnQixDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSw0QkFBNEIsQ0FBQyxDQUFBO09BQUUsQ0FBQyxDQUFDLENBQUE7O0FBRXJJLFVBQU0sMEJBQTBCLEdBQUcsU0FBN0IsMEJBQTBCLENBQUksS0FBSyxFQUFLO0FBQzVDLFlBQU0sTUFBTSxHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFBO0FBQ3hDLFlBQUksTUFBTSxFQUFFO0FBQ1YsZUFBSyxDQUFDLGVBQWUsRUFBRSxDQUFBO0FBQ3ZCLGVBQUssQ0FBQyxjQUFjLEVBQUUsQ0FBQTtBQUN0QixjQUFJLE1BQU0sQ0FBQyxJQUFJLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLEVBQUU7QUFDbEQsZ0JBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQTtXQUNqQztTQUNGO09BQ0YsQ0FBQTtBQUNELFVBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLGdCQUFnQixDQUFDLE9BQU8sRUFBRSwwQkFBMEIsQ0FBQyxDQUFBO0FBQzlFLFVBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLHFCQUFlLFlBQU07QUFBRSxlQUFLLElBQUksQ0FBQyxjQUFjLENBQUMsbUJBQW1CLENBQUMsT0FBTyxFQUFFLDBCQUEwQixDQUFDLENBQUE7T0FBRSxDQUFDLENBQUMsQ0FBQTtLQUNsSTs7O1dBRU8sbUJBQUc7QUFDVCxVQUFJLENBQUMsV0FBVyxDQUFDLE9BQU8sRUFBRSxDQUFBO0FBQzFCLGFBQU8sa0JBQUssT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFBO0tBQzFCOzs7V0FFa0IsOEJBQUc7OztBQUNwQixVQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxnQ0FBb0IsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsRUFBRSxVQUFDLEdBQUcsRUFBRSxVQUFVLEVBQUs7QUFDakYsWUFBSSxDQUFDLEdBQUcsSUFBSSxVQUFVLEVBQUU7QUFDdEIsaUJBQUssSUFBSSxDQUFDLE1BQU0sQ0FBQyxHQUFHLGVBQWEsVUFBVSxBQUFFLENBQUE7U0FDOUM7T0FDRixDQUFDLENBQUE7O0FBRUYsVUFBSSxDQUFDLE1BQU0sV0FBUSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLFVBQUMsR0FBRyxFQUFFLElBQUksRUFBSzs7O0FBR2pELFlBQUksQ0FBQyxHQUFHLEVBQUU7QUFDUixjQUFJLElBQUksSUFBSSxJQUFJLEVBQUU7QUFDaEIsZ0JBQUksR0FBRyxFQUFFLENBQUE7V0FDVjs7QUFFRCxjQUFJLE9BQUssSUFBSSxDQUFDLGdCQUFnQixJQUFJLE9BQUssSUFBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksS0FBSyxLQUFLLEVBQUU7QUFDM0UsbUJBQUssSUFBSSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLHFCQUFxQixDQUFDLENBQUE7QUFDOUQsbUJBQUssSUFBSSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUE7QUFDdkQsbUJBQUssSUFBSSxDQUFDLGFBQWEsQ0FBQyxXQUFXLEdBQUcsT0FBSyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUE7V0FDbEYsTUFBTTtBQUNMLG1CQUFLLElBQUksQ0FBQyxjQUFjLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsY0FBYyxFQUFFLEdBQUcsRUFBRSxDQUFBO0FBQzFHLG1CQUFLLElBQUksQ0FBQyxhQUFhLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxjQUFjLEVBQUUsR0FBRyxFQUFFLENBQUE7V0FDNUY7U0FDRjtPQUNGLENBQUMsQ0FBQTtLQUNIOzs7V0FFb0IsZ0NBQUc7QUFDdEIsVUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsV0FBVyxHQUFHLENBQUMsSUFBSSxDQUFDLGVBQWUsR0FBRyxJQUFJLENBQUMsZUFBZSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUEsSUFBSyxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQTtBQUN0SCxVQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLEtBQUssS0FBSyxFQUFFO0FBQzNFLFlBQUksQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFBO09BQ2xGOztBQUVELFVBQUksQ0FBQyxtQkFBbUIsRUFBRSxDQUFBO0FBQzFCLFVBQUksQ0FBQyxvQkFBb0IsRUFBRSxDQUFBO0FBQzNCLFVBQUksQ0FBQyxtQkFBbUIsRUFBRSxDQUFBO0FBQzFCLFVBQUksQ0FBQyxxQkFBcUIsRUFBRSxDQUFBO0tBQzdCOzs7V0FFbUIsK0JBQUc7QUFDckIsVUFBSSxJQUFJLENBQUMsV0FBVyxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxFQUFFO0FBQzlDLFlBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsRUFBRSxDQUFBO09BQzVDLE1BQU07QUFDTCxZQUFJLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQTtPQUNoRDtLQUNGOzs7Ozs7V0FJbUIsK0JBQUc7QUFDckIsVUFBSSxJQUFJLENBQUMsVUFBVSxFQUFFLEVBQUU7QUFDckIsWUFBSSxDQUFDLG9CQUFvQixFQUFFLENBQUE7T0FDNUIsTUFBTSxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUMsRUFBRTtBQUN0RCxZQUFJLENBQUMsbUJBQW1CLEVBQUUsQ0FBQTtPQUMzQjtLQUNGOzs7V0FFbUIsK0JBQUc7QUFDckIsVUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxDQUFBO0FBQ3pDLFVBQUksSUFBSSxDQUFDLElBQUksS0FBSyxPQUFPLEVBQUU7QUFDekIsWUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQTtPQUNsRDtBQUNELFVBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsYUFBYSxDQUFDLGVBQWUsQ0FBQyxDQUFDLFdBQVcsR0FBRyxTQUFTLENBQUE7QUFDakYsVUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLHFCQUFxQixDQUFDLENBQUE7QUFDL0QsVUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLG9CQUFvQixDQUFDLENBQUE7QUFDakUsVUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQTtLQUMxRDs7O1dBRW9CLGdDQUFHO0FBQ3RCLFVBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsQ0FBQTtBQUN0QyxVQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGFBQWEsQ0FBQyxlQUFlLENBQUMsQ0FBQyxXQUFXLEdBQUcsUUFBUSxDQUFBO0FBQ2hGLFVBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFBO0FBQzlELFVBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxxQkFBcUIsQ0FBQyxDQUFBO0FBQ2xFLFVBQUksQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsYUFBYSxDQUFDLENBQUE7QUFDdEQsVUFBSSxJQUFJLENBQUMsWUFBWSxFQUFFLEVBQUU7QUFDdkIsWUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFBO09BQzNDLE1BQU07QUFDTCxZQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUE7T0FDNUM7S0FDRjs7Ozs7O1dBSW9CLGdDQUFHO0FBQ3RCLFVBQUksSUFBSSxDQUFDLFdBQVcsRUFBRSxFQUFFO0FBQ3RCLFlBQUksQ0FBQyxxQkFBcUIsRUFBRSxDQUFBO09BQzdCLE1BQU07QUFDTCxZQUFJLENBQUMsd0JBQXdCLEVBQUUsQ0FBQTtPQUNoQztLQUNGOzs7V0FFcUIsaUNBQUc7QUFDdkIsVUFBSSxJQUFJLENBQUMsVUFBVSxJQUFJLElBQUksQ0FBQyxNQUFNLEVBQUU7QUFDbEMsWUFBSSxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQTtBQUM5QyxZQUFJLElBQUksQ0FBQyxVQUFVLEVBQUU7QUFDbkIsY0FBSSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsV0FBVyxrQkFBZ0IsSUFBSSxDQUFDLFVBQVUsQUFBRSxDQUFBO1NBQ3BFLE1BQU0sSUFBSSxJQUFJLENBQUMsTUFBTSxFQUFFO0FBQ3RCLGNBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLFdBQVcsa0JBQWdCLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQUFBRSxDQUFBO1NBQzdFO09BQ0YsTUFBTTtBQUNMLFlBQUksQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7T0FDbkQ7O0FBRUQsVUFBSSxDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQTtBQUNuRCxVQUFJLENBQUMsSUFBSSxDQUFDLDZCQUE2QixDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFBO0FBQzlELFVBQUksQ0FBQyxJQUFJLENBQUMsd0JBQXdCLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxFQUFFLENBQUE7QUFDckQsVUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxFQUFFLENBQUE7S0FDN0M7OztXQUV3QixvQ0FBRzs7O0FBQzFCLFVBQUksQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFBO0FBQ2hELFVBQU0sV0FBVyxHQUFHLElBQUksQ0FBQyxjQUFjLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRSxDQUFDLENBQUE7QUFDM0UsVUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsZ0JBQWdCLENBQUMsV0FBVyxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsRUFBRTtBQUNqRSxZQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFBO0FBQ2pDLFlBQUksQ0FBQywyQkFBMkIsRUFBRSxDQUFBO0FBQ2xDLFlBQUksQ0FBQyw4QkFBOEIsQ0FBQyxZQUFNO0FBQUUsaUJBQUssMkJBQTJCLEVBQUUsQ0FBQTtTQUFFLENBQUMsQ0FBQTtPQUNsRixNQUFNO0FBQ0wsWUFBSSxDQUFDLDJCQUEyQixFQUFFLENBQUE7T0FDbkM7S0FDRjs7O1dBRTJCLHVDQUFHO0FBQzdCLFVBQUksQ0FBQyxJQUFJLENBQUMsb0JBQW9CLEVBQUU7QUFDOUIsWUFBSSxDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQTtBQUNuRCxZQUFJLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFBO09BQ25ELE1BQU0sSUFBSSxJQUFJLENBQUMsVUFBVSxJQUFJLElBQUksQ0FBQyxNQUFNLEVBQUU7QUFDekMsWUFBSSxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQTtBQUM5QyxZQUFJLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFBO09BQ3BELE1BQU07QUFDTCxZQUFJLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFBO0FBQ2xELFlBQUksQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxFQUFFLENBQUE7T0FDaEQ7QUFDRCxVQUFJLENBQUMsSUFBSSxDQUFDLDZCQUE2QixDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFBO0FBQzlELFVBQUksQ0FBQyxJQUFJLENBQUMsd0JBQXdCLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7S0FDMUQ7Ozs7OztXQUlxQixpQ0FBRztBQUN2QixVQUFJLElBQUksQ0FBQyxZQUFZLEVBQUUsRUFBRTtBQUN2QixZQUFJLENBQUMsc0JBQXNCLEVBQUUsQ0FBQTtPQUM5QixNQUFNLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLFlBQVksQ0FBQyxFQUFFO0FBQ3hELFlBQUksQ0FBQyx3QkFBd0IsRUFBRSxDQUFBO09BQ2hDO0tBQ0Y7OztXQUVZLHNCQUFDLE9BQU8sRUFBRTtBQUNyQixVQUFJLE9BQU8sSUFBSSxPQUFPLENBQUMsS0FBSyxJQUFJLE9BQU8sQ0FBQyxLQUFLLENBQUMsU0FBUyxFQUFFO0FBQ3ZELFlBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxFQUFFLENBQUE7T0FDOUMsTUFBTTtBQUNMLFlBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7T0FDbEQ7O0FBRUQsVUFBSSxPQUFPLElBQUksT0FBTyxDQUFDLEtBQUssSUFBSSxPQUFPLENBQUMsS0FBSyxDQUFDLEtBQUssRUFBRTtBQUNuRCxZQUFJLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQTtPQUMxQyxNQUFNO0FBQ0wsWUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7T0FDOUM7S0FDRjs7O1dBRXdCLG9DQUFHO0FBQzFCLFVBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsQ0FBQTtBQUMzQyxVQUFJLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLGNBQWMsQ0FBQyxDQUFBO0FBQ3pELFVBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLFdBQVcsR0FBRyxFQUFFLENBQUE7S0FDMUM7OztXQUVzQixrQ0FBRztBQUN4QixVQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsWUFBWSxDQUFDLENBQUE7QUFDeEMsVUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQTs7QUFFeEMsVUFBTSxJQUFJLEdBQUcsSUFBSSxDQUFDLDRCQUE0QixFQUFFLENBQUE7QUFDaEQsVUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQTs7QUFFdEQsVUFBSSxPQUFPLEdBQUcsSUFBSSxDQUFBO0FBQ2xCLFVBQUksSUFBSSxJQUFJLElBQUksQ0FBQyxlQUFlLEVBQUU7QUFDaEMsZUFBTyxHQUFHLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUE7T0FDdEQsTUFBTSxJQUFJLElBQUksSUFBSSxJQUFJLENBQUMsY0FBYyxJQUFJLElBQUksQ0FBQyxXQUFXLEtBQUssTUFBTSxFQUFFO0FBQ3JFLGVBQU8sR0FBRyxJQUFJLENBQUMsT0FBTyxJQUFJLElBQUksR0FBRyxJQUFJLENBQUMsT0FBTyx5QkFBd0IsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLCtCQUE2QixDQUFBO0FBQ2hILGVBQU8sSUFBSSxpQ0FBaUMsQ0FBQTtBQUM1QyxZQUFJLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxNQUFNLEVBQUUsQ0FBQTtBQUNqQyxZQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLE1BQU0sRUFBRSxDQUFBO09BQ3BDLE1BQU0sSUFBSSxJQUFJLElBQUksSUFBSSxDQUFDLGNBQWMsSUFBSSxJQUFJLENBQUMsV0FBVyxFQUFFO0FBQzFELFlBQU0sR0FBRyxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUE7QUFDNUIsWUFBTSxXQUFXLEdBQUcsSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFBO0FBQ3RDLFlBQUksV0FBVyxJQUFJLElBQUksQ0FBQyxjQUFjLENBQUMsa0JBQWtCLENBQUMsR0FBRyxDQUFDLEVBQUU7QUFDOUQsaUJBQU8sU0FBUSxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksZ0NBQTZCLEdBQUcsaUVBQStELENBQUE7QUFDNUgsY0FBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsTUFBTSxFQUFFLENBQUE7QUFDakMsY0FBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLEVBQUUsQ0FBQTtTQUNwQyxNQUFNLElBQUksV0FBVyxFQUFFO0FBQ3RCLGlCQUFPLFNBQVEsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLGlDQUE4QixHQUFHLHlDQUFxQyxHQUFHLE9BQUksQ0FBQTtBQUMxRyxjQUFJLENBQUMsSUFBSSxDQUFDLHdCQUF3QixDQUFDLFdBQVcsZ0JBQWMsR0FBRyxBQUFFLENBQUE7QUFDakUsY0FBSSxDQUFDLElBQUksQ0FBQyw2QkFBNkIsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQTtBQUMxRCxjQUFJLENBQUMsSUFBSSxDQUFDLHdCQUF3QixDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsRUFBRSxDQUFBO0FBQ3JELGNBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLE1BQU0sRUFBRSxDQUFBO0FBQ2pDLGNBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxFQUFFLENBQUE7U0FDcEMsTUFBTTtBQUNMLGlCQUFPLFNBQVEsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLGlDQUE4QixHQUFHLHlDQUFxQyxHQUFHLE9BQUksQ0FBQTtBQUMxRyxjQUFJLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFBO0FBQ25ELGNBQUksQ0FBQyxJQUFJLENBQUMsNkJBQTZCLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7QUFDOUQsY0FBSSxDQUFDLElBQUksQ0FBQyx3QkFBd0IsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQTtTQUMxRDtPQUNGOztBQUVELFVBQUksT0FBTyxJQUFJLElBQUksRUFBRTtBQUNuQixZQUFJLE1BQU0sSUFBSSxJQUFJLEVBQUU7QUFDbEIsZ0JBQU0sR0FBRyxPQUFPLENBQUMsUUFBUSxDQUFDLENBQUE7U0FDM0I7O0FBRUQsWUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsU0FBUyxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQTtPQUNyRDtLQUNGOzs7V0FFbUMsK0NBQUc7QUFDckMsVUFBSSxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsQ0FBQTtBQUNwQyxVQUFJLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxNQUFNLEVBQUUsQ0FBQTtVQUMxQixVQUFVLEdBQUksSUFBSSxDQUFDLElBQUksQ0FBdkIsVUFBVTs7QUFDakIsVUFBSSxVQUFVLFdBQVEsS0FBSyxVQUFVLEVBQUU7QUFDckMsWUFBSSxDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxXQUFXLEdBQUcsVUFBVSxDQUFDLEtBQUssRUFBRSxDQUFBO09BQzlELE1BQU07QUFDTCxZQUFJLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLFdBQVcsR0FBRyxVQUFVLENBQUMsUUFBUSxFQUFFLENBQUE7T0FDakU7QUFDRCxVQUFJLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLHFCQUFxQixDQUFDLENBQUE7QUFDL0QsVUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFBO0FBQ3hELFVBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMscUJBQXFCLENBQUMsQ0FBQTtBQUM5RCxVQUFJLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUE7S0FDeEQ7OztXQUVzQixnQ0FBQyxVQUFVLEVBQUU7QUFDbEMsVUFBSSxDQUFDLFVBQVUsR0FBRyxVQUFVLENBQUE7QUFDNUIsVUFBSSxDQUFDLG9CQUFvQixFQUFFLENBQUE7S0FDNUI7OztXQUVxQiwrQkFBQyxVQUFVLEVBQUU7QUFDakMsVUFBTSxJQUFJLEdBQUcsSUFBSSxDQUFDLDRCQUE0QixFQUFFLENBQUE7QUFDaEQsVUFBSSxDQUFDLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLEVBQUU7QUFDbEMsZUFBTTtPQUNQOztBQUVELFVBQUksVUFBVSxFQUFFO0FBQ2QsWUFBSSxJQUFJLENBQUMsWUFBWSxDQUFDLFVBQVUsQ0FBQyxFQUFFO0FBQ2pDLHFDQUEwQixVQUFVLHFEQUFrRDtTQUN2RixNQUFNO0FBQ0wscUNBQTBCLFVBQVUsMENBQXVDO1NBQzVFO09BQ0YsTUFBTTtBQUNMLFlBQUksSUFBSSxDQUFDLFdBQVcsRUFBRSxFQUFFO0FBQ3RCLGlCQUFPLElBQUksQ0FBQyxPQUFPLElBQUksSUFBSSxHQUFHLElBQUksQ0FBQyxPQUFPLEdBQUcsOEZBQThGLENBQUE7U0FDNUksTUFBTTtBQUNMLGlCQUFPLHVEQUF1RCxDQUFBO1NBQy9EO09BQ0Y7S0FDRjs7O1dBRW1CLCtCQUFHOzs7QUFDckIsVUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFDLElBQUksRUFBSztBQUNsRSxZQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssT0FBSyxJQUFJLENBQUMsSUFBSSxFQUFFO0FBQ2hDLGlCQUFLLG1CQUFtQixFQUFFLENBQUE7U0FDM0I7T0FDRixDQUFDLENBQUMsQ0FBQTs7QUFFSCxVQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLG9CQUFvQixDQUFDLFVBQUMsSUFBSSxFQUFLO0FBQ2hFLFlBQUksSUFBSSxDQUFDLElBQUksS0FBSyxPQUFLLElBQUksQ0FBQyxJQUFJLEVBQUU7QUFDaEMsaUJBQUssbUJBQW1CLEVBQUUsQ0FBQTtTQUMzQjtPQUNGLENBQUMsQ0FBQyxDQUFBOztBQUVILFVBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsV0FBVyxDQUFDLHVCQUF1QixFQUFFLFlBQU07QUFDMUUsZUFBSyxtQkFBbUIsRUFBRSxDQUFBO09BQzNCLENBQUMsQ0FBQyxDQUFBOztBQUVILFVBQUksQ0FBQyx1QkFBdUIsQ0FBQyxxQ0FBcUMsRUFBRSxZQUFNO0FBQ3hFLGVBQUssb0JBQW9CLEVBQUUsQ0FBQTtBQUMzQixlQUFLLElBQUksQ0FBQyxhQUFhLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQTtBQUN2QyxlQUFLLElBQUksQ0FBQyxhQUFhLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxlQUFlLENBQUMsQ0FBQTtPQUN2RCxDQUFDLENBQUE7O0FBRUYsVUFBSSxDQUFDLHVCQUF1QixDQUFDLGlDQUFpQyxFQUFFLFlBQU07QUFDcEUsZUFBSyxvQkFBb0IsRUFBRSxDQUFBO0FBQzNCLGVBQUssSUFBSSxDQUFDLFlBQVksQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFBO0FBQ3RDLGVBQUssSUFBSSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFBO09BQ3RELENBQUMsQ0FBQTs7QUFFRixVQUFJLENBQUMsdUJBQXVCLENBQUMsZ0NBQWdDLEVBQUUsWUFBTTtBQUNuRSxlQUFLLG9CQUFvQixFQUFFLENBQUE7QUFDM0IsZUFBSyxJQUFJLENBQUMsd0JBQXdCLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQTtBQUNsRCxlQUFLLElBQUksQ0FBQyx3QkFBd0IsQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFBO09BQ2xFLENBQUMsQ0FBQTs7QUFFRixVQUFJLENBQUMsdUJBQXVCLENBQUMseUNBQXlDLEVBQUUsWUFBTTtBQUM1RSxlQUFLLG9CQUFvQixFQUFFLENBQUE7QUFDM0IsZUFBSyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQTtBQUMxQyxlQUFLLElBQUksQ0FBQyxlQUFlLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQTtBQUN6QyxlQUFLLElBQUksQ0FBQyxlQUFlLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFBO09BQzNELENBQUMsQ0FBQTs7QUFFRixVQUFJLENBQUMsdUJBQXVCLENBQUMsK0VBQStFLEVBQUUsWUFBTTtBQUNsSCxZQUFNLFVBQVUsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLGdCQUFnQixDQUFDLE9BQUssSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFBO0FBQ2pFLFlBQU0sT0FBTyxHQUFHLFVBQVUsSUFBSSxVQUFVLENBQUMsUUFBUSxHQUFHLFVBQVUsQ0FBQyxRQUFRLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQTtBQUN0RixZQUFJLE9BQU8sRUFBRTtBQUNYLGlCQUFLLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFBO1NBQzVCO0FBQ0QsZUFBSyxJQUFJLENBQUMsYUFBYSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUE7QUFDeEMsZUFBSyxJQUFJLENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsZUFBZSxDQUFDLENBQUE7QUFDekQsZUFBSyxvQkFBb0IsRUFBRSxDQUFBO09BQzVCLENBQUMsQ0FBQTs7QUFFRixVQUFJLENBQUMsdUJBQXVCLENBQUMsK0JBQStCLEVBQUUsWUFBTTtBQUNsRSxZQUFNLFVBQVUsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLGdCQUFnQixDQUFDLE9BQUssSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFBO0FBQ2pFLFlBQU0sUUFBUSxHQUFHLFVBQVUsR0FBRyxVQUFVLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQTtBQUN4RCxZQUFJLFFBQVEsSUFBSSxRQUFRLENBQUMsT0FBTyxFQUFFO0FBQ2hDLGlCQUFLLElBQUksQ0FBQyxPQUFPLEdBQUcsUUFBUSxDQUFDLE9BQU8sQ0FBQTtTQUNyQzs7QUFFRCxZQUFJLFFBQVEsSUFBSSxRQUFRLENBQUMsZ0JBQWdCLEVBQUU7QUFDekMsaUJBQUssSUFBSSxDQUFDLGdCQUFnQixHQUFHLFFBQVEsQ0FBQyxnQkFBZ0IsQ0FBQTtTQUN2RDs7QUFFRCxlQUFLLFVBQVUsR0FBRyxJQUFJLENBQUE7QUFDdEIsZUFBSyxNQUFNLEdBQUcsSUFBSSxDQUFBO0FBQ2xCLGVBQUssSUFBSSxDQUFDLFlBQVksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFBO0FBQ3ZDLGVBQUssSUFBSSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLGVBQWUsQ0FBQyxDQUFBO0FBQ3hELGVBQUssb0JBQW9CLEVBQUUsQ0FBQTtPQUM1QixDQUFDLENBQUE7O0FBRUYsVUFBSSxDQUFDLHVCQUF1QixDQUFDLDJDQUEyQyxFQUFFLFlBQU07QUFDOUUsZUFBSyxJQUFJLENBQUMsWUFBWSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUE7QUFDdkMsZUFBSyxJQUFJLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsZUFBZSxDQUFDLENBQUE7QUFDeEQsZUFBSyxvQkFBb0IsRUFBRSxDQUFBO09BQzVCLENBQUMsQ0FBQTs7QUFFRixVQUFJLENBQUMsdUJBQXVCLENBQUMsdUZBQXVGLEVBQUUsWUFBTTtBQUMxSCxlQUFLLFVBQVUsR0FBRyxJQUFJLENBQUE7QUFDdEIsZUFBSyxNQUFNLEdBQUcsSUFBSSxDQUFBO0FBQ2xCLGVBQUssSUFBSSxDQUFDLGdCQUFnQixDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUE7QUFDM0MsZUFBSyxJQUFJLENBQUMsZUFBZSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUE7QUFDMUMsZUFBSyxJQUFJLENBQUMsZUFBZSxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsaUJBQWlCLENBQUMsQ0FBQTtBQUM3RCxlQUFLLG9CQUFvQixFQUFFLENBQUE7T0FDNUIsQ0FBQyxDQUFBOztBQUVGLFVBQUksQ0FBQyx1QkFBdUIsQ0FBQyxrRUFBa0UsRUFBRSxZQUFNO0FBQ3JHLGVBQUssSUFBSSxDQUFDLHdCQUF3QixDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUE7QUFDbkQsZUFBSyxJQUFJLENBQUMsd0JBQXdCLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxlQUFlLENBQUMsQ0FBQTtBQUNwRSxlQUFLLG9CQUFvQixFQUFFLENBQUE7T0FDNUIsQ0FBQyxDQUFBO0tBQ0g7OztXQUVXLHVCQUFHO0FBQ2IsYUFBTyxJQUFJLENBQUMsY0FBYyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUE7S0FDOUQ7OztXQUVVLHNCQUFHO0FBQ1osYUFBTyxJQUFJLENBQUMsUUFBUSxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUE7S0FDdkQ7OztXQUVZLHNCQUFDLE9BQU8sRUFBRTtBQUNyQixVQUFNLFdBQVcsR0FBRyxPQUFPLElBQUksSUFBSSxHQUFHLE9BQU8sR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQTtBQUNqRSxhQUFPLElBQUksQ0FBQyxRQUFRLENBQUMsbUJBQW1CLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsV0FBVyxDQUFDLENBQUE7S0FDdEU7OztXQUU0Qix3Q0FBRztBQUM5QixhQUFPLElBQUksQ0FBQyxRQUFRLENBQUMsNEJBQTRCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQTtLQUNsRTs7O1dBRVcsdUJBQUc7QUFDYixhQUFPLElBQUksQ0FBQyxjQUFjLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQTtLQUM5RDs7O1dBRXVCLGlDQUFDLEtBQUssRUFBRSxRQUFRLEVBQUU7OztBQUN4QyxVQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLEVBQUUsQ0FBQyxLQUFLLEVBQUUsVUFBQyxJQUFhLEVBQUs7WUFBakIsSUFBSSxHQUFMLElBQWEsQ0FBWixJQUFJO1lBQUUsS0FBSyxHQUFaLElBQWEsQ0FBTixLQUFLOztBQUM5RCxZQUFJLElBQUksQ0FBQyxJQUFJLElBQUksSUFBSSxFQUFFO0FBQ3JCLGNBQUksR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFBO1NBQ2pCOztBQUVELFlBQU0sV0FBVyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUE7QUFDN0IsWUFBSSxXQUFXLEtBQUssT0FBSyxJQUFJLENBQUMsSUFBSSxFQUFFO0FBQ2xDLGtCQUFRLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxDQUFBO1NBQ3RCO09BQ0YsQ0FBQyxDQUFDLENBQUE7S0FDSjs7Ozs7Ozs7V0FNTyxtQkFBRzs7O0FBQ1QsVUFBSSxDQUFDLGNBQWMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLGVBQWUsSUFBSSxJQUFJLEdBQUcsSUFBSSxDQUFDLGVBQWUsR0FBRyxJQUFJLENBQUMsSUFBSSxFQUFFLFVBQUMsS0FBSyxFQUFLO0FBQ3RHLFlBQUksS0FBSyxJQUFJLElBQUksRUFBRTtBQUNqQixpQkFBTyxDQUFDLEtBQUssaUJBQWUsT0FBSyxJQUFJLFNBQUksT0FBSyxJQUFJLENBQUMsSUFBSSxjQUFXLEtBQUssQ0FBQyxLQUFLLElBQUksSUFBSSxHQUFHLEtBQUssQ0FBQyxLQUFLLEdBQUcsS0FBSyxFQUFFLEtBQUssQ0FBQyxNQUFNLENBQUMsQ0FBQTtTQUMzSCxNQUFNOztBQUVMLGNBQUksT0FBSyxVQUFVLEVBQUUsRUFBRTtBQUNyQixnQkFBSSxDQUFDLFFBQVEsQ0FBQyxhQUFhLENBQUMsT0FBSyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUE7V0FDNUM7U0FDRjtPQUNGLENBQUMsQ0FBQTtLQUNIOzs7V0FFTSxrQkFBRzs7O0FBQ1IsVUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFO0FBQ3BDLGVBQU8sT0FBTyxDQUFDLE9BQU8sRUFBRSxDQUFBO09BQ3pCOztBQUVELFVBQU0sSUFBSSxHQUFHLElBQUksQ0FBQyxlQUFlLElBQUksSUFBSSxHQUFHLElBQUksQ0FBQyxlQUFlLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQTtBQUM1RSxVQUFNLE9BQU8sR0FBRyxJQUFJLENBQUMsVUFBVSxTQUFPLElBQUksQ0FBQyxVQUFVLFNBQVMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxBQUFFLENBQUE7QUFDeEYsYUFBTyxJQUFJLE9BQU8sQ0FBQyxVQUFDLE9BQU8sRUFBRSxNQUFNLEVBQUs7QUFDdEMsZUFBSyxjQUFjLENBQUMsTUFBTSxDQUFDLElBQUksRUFBRSxPQUFLLFVBQVUsRUFBRSxVQUFBLEtBQUssRUFBSTtBQUN6RCxjQUFJLEtBQUssSUFBSSxJQUFJLEVBQUU7QUFDakIsZ0JBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxFQUFFLHVCQUF1QixFQUFFLFVBQUEsY0FBYyxFQUFJO0FBQzVELDRCQUFjLENBQUMsUUFBUSxHQUFHO0FBQ3hCLG9CQUFJLEVBQUUsT0FBSyxJQUFJO0FBQ2Ysb0JBQUksRUFBRSxJQUFJLENBQUMsSUFBSTtBQUNmLHVCQUFPLEVBQVAsT0FBTztBQUNQLDRCQUFZLEVBQUUsS0FBSyxDQUFDLE9BQU87QUFDM0IsMEJBQVUsRUFBRSxLQUFLLENBQUMsS0FBSztBQUN2QiwyQkFBVyxFQUFFLEtBQUssQ0FBQyxNQUFNO2VBQzFCLENBQUE7YUFDRixDQUFDLENBQUE7QUFDRixtQkFBTyxDQUFDLEtBQUssZUFBYSxPQUFLLElBQUksU0FBSSxJQUFJLENBQUMsSUFBSSxZQUFPLE9BQU8saUJBQWMsS0FBSyxFQUFFLEtBQUssQ0FBQyxNQUFNLElBQUksSUFBSSxHQUFHLEtBQUssQ0FBQyxNQUFNLEdBQUcsRUFBRSxDQUFDLENBQUE7QUFDNUgsa0JBQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQTtXQUNkLE1BQU07QUFDTCxtQkFBTyxFQUFFLENBQUE7V0FDVjtTQUNGLENBQUMsQ0FBQTtPQUNILENBQUMsQ0FBQTtLQUNIOzs7V0FFUyxxQkFBRzs7O0FBQ1gsVUFBSSxDQUFDLGNBQWMsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxVQUFDLEtBQUssRUFBSztBQUNsRCxZQUFJLEtBQUssSUFBSSxJQUFJLEVBQUU7QUFDakIsaUJBQU8sQ0FBQyxLQUFLLG1CQUFpQixPQUFLLElBQUksU0FBSSxPQUFLLElBQUksQ0FBQyxJQUFJLGNBQVcsS0FBSyxDQUFDLEtBQUssSUFBSSxJQUFJLEdBQUcsS0FBSyxDQUFDLEtBQUssR0FBRyxLQUFLLEVBQUUsS0FBSyxDQUFDLE1BQU0sQ0FBQyxDQUFBO1NBQzdIO09BQ0YsQ0FBQyxDQUFBO0tBQ0g7OztXQUVrQiw4QkFBRzs7O0FBQ3BCLFVBQU0sUUFBUSxHQUFHLElBQUksQ0FBQyw0QkFBNEIsRUFBRSxDQUFBO0FBQ3BELFVBQU0sVUFBVSxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsZ0JBQWdCLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLENBQUE7QUFDekYsVUFBSSxDQUFDLFFBQVEsSUFBSSxDQUFDLFFBQVEsQ0FBQyxjQUFjLElBQUksUUFBUSxDQUFDLFdBQVcsS0FBSyxNQUFNLElBQUksVUFBVSxFQUFFO0FBQzFGLGVBQU07T0FDUDs7QUFFRCxVQUFJLENBQUMsY0FBYyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsUUFBUSxDQUFDLFdBQVcsRUFBRSxVQUFDLEtBQUssRUFBRSxLQUFtQixFQUFLO1lBQXZCLElBQUksR0FBTCxLQUFtQixDQUFsQixJQUFJO1lBQUUsV0FBVyxHQUFsQixLQUFtQixDQUFaLFdBQVc7O0FBQ2hHLFlBQUksS0FBSyxJQUFJLElBQUksRUFBRTtBQUNqQixpQkFBTyxDQUFDLEtBQUssOEJBQTZCLFdBQVcsVUFBTSxRQUFLLElBQUksYUFBUSxRQUFLLElBQUksQ0FBQyxJQUFJLGNBQVcsS0FBSyxDQUFDLEtBQUssSUFBSSxJQUFJLEdBQUcsS0FBSyxDQUFDLEtBQUssR0FBRyxLQUFLLEVBQUUsS0FBSyxDQUFDLE1BQU0sQ0FBQyxDQUFBO1NBQzlKO09BQ0YsQ0FBQyxDQUFBO0tBQ0g7OztTQXpzQmtCLFdBQVc7OztxQkFBWCxXQUFXIiwiZmlsZSI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL3NldHRpbmdzLXZpZXcvbGliL3BhY2thZ2UtY2FyZC5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8qKiBAYmFiZWwgKi9cbi8qKiBAanN4IGV0Y2guZG9tICovXG5cbmltcG9ydCB7Q29tcG9zaXRlRGlzcG9zYWJsZSwgRGlzcG9zYWJsZX0gZnJvbSAnYXRvbSdcbmltcG9ydCB7c2hlbGx9IGZyb20gJ2VsZWN0cm9uJ1xuaW1wb3J0IGV0Y2ggZnJvbSAnZXRjaCdcblxuaW1wb3J0IHtvd25lckZyb21SZXBvc2l0b3J5fSBmcm9tICcuL3V0aWxzJ1xuXG5sZXQgbWFya2VkID0gbnVsbFxuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBQYWNrYWdlQ2FyZCB7XG4gIGNvbnN0cnVjdG9yIChwYWNrLCBzZXR0aW5nc1ZpZXcsIHBhY2thZ2VNYW5hZ2VyLCBvcHRpb25zID0ge30pIHtcbiAgICB0aGlzLnBhY2sgPSBwYWNrXG4gICAgdGhpcy5zZXR0aW5nc1ZpZXcgPSBzZXR0aW5nc1ZpZXdcbiAgICB0aGlzLnBhY2thZ2VNYW5hZ2VyID0gcGFja2FnZU1hbmFnZXJcbiAgICB0aGlzLmRpc3Bvc2FibGVzID0gbmV3IENvbXBvc2l0ZURpc3Bvc2FibGUoKVxuXG4gICAgLy8gSXQgbWlnaHQgYmUgdXNlZnVsIHRvIGVpdGhlciB3cmFwIHRoaXMucGFjayBpbiBhIGNsYXNzIHRoYXQgaGFzIGFcbiAgICAvLyA6OnZhbGlkYXRlIG1ldGhvZCwgb3IgYWRkIGEgbWV0aG9kIGhlcmUuIEF0IHRoZSBtb21lbnQgSSB0aGluayBhbGwgY2FzZXNcbiAgICAvLyBvZiBtYWxmb3JtZWQgcGFja2FnZSBtZXRhZGF0YSBhcmUgaGFuZGxlZCBoZXJlIGFuZCBpbiA6OmNvbnRlbnQgYnV0IGJlbHRcbiAgICAvLyBhbmQgc3VzcGVuZGVycywgeW91IGtub3dcbiAgICB0aGlzLmNsaWVudCA9IHRoaXMucGFja2FnZU1hbmFnZXIuZ2V0Q2xpZW50KClcbiAgICB0aGlzLnR5cGUgPSB0aGlzLnBhY2sudGhlbWUgPyAndGhlbWUnIDogJ3BhY2thZ2UnXG4gICAgdGhpcy5uYW1lID0gdGhpcy5wYWNrLm5hbWVcbiAgICB0aGlzLm9uU2V0dGluZ3NWaWV3ID0gb3B0aW9ucy5vblNldHRpbmdzVmlld1xuXG4gICAgaWYgKHRoaXMucGFjay5sYXRlc3RWZXJzaW9uICE9PSB0aGlzLnBhY2sudmVyc2lvbikge1xuICAgICAgdGhpcy5uZXdWZXJzaW9uID0gdGhpcy5wYWNrLmxhdGVzdFZlcnNpb25cbiAgICB9XG5cbiAgICBpZiAodGhpcy5wYWNrLmFwbUluc3RhbGxTb3VyY2UgJiYgdGhpcy5wYWNrLmFwbUluc3RhbGxTb3VyY2UudHlwZSA9PT0gJ2dpdCcpIHtcbiAgICAgIGlmICh0aGlzLnBhY2suYXBtSW5zdGFsbFNvdXJjZS5zaGEgIT09IHRoaXMucGFjay5sYXRlc3RTaGEpIHtcbiAgICAgICAgdGhpcy5uZXdTaGEgPSB0aGlzLnBhY2subGF0ZXN0U2hhXG4gICAgICB9XG4gICAgfVxuXG4gICAgLy8gRGVmYXVsdCB0byBkaXNwbGF5aW5nIHRoZSBkb3dubG9hZCBjb3VudFxuICAgIGlmICghb3B0aW9ucy5zdGF0cykge1xuICAgICAgb3B0aW9ucy5zdGF0cyA9IHtkb3dubG9hZHM6IHRydWV9XG4gICAgfVxuXG4gICAgZXRjaC5pbml0aWFsaXplKHRoaXMpXG5cbiAgICB0aGlzLmRpc3BsYXlTdGF0cyhvcHRpb25zKVxuICAgIHRoaXMuaGFuZGxlUGFja2FnZUV2ZW50cygpXG4gICAgdGhpcy5oYW5kbGVCdXR0b25FdmVudHMob3B0aW9ucylcbiAgICB0aGlzLmxvYWRDYWNoZWRNZXRhZGF0YSgpXG5cbiAgICAvLyB0aGVtZXMgaGF2ZSBubyBzdGF0dXMgYW5kIGNhbm5vdCBiZSBkaXMvZW5hYmxlZFxuICAgIGlmICh0aGlzLnR5cGUgPT09ICd0aGVtZScpIHtcbiAgICAgIHRoaXMucmVmcy5zdGF0dXNJbmRpY2F0b3IucmVtb3ZlKClcbiAgICAgIHRoaXMucmVmcy5lbmFibGVtZW50QnV0dG9uLnJlbW92ZSgpXG4gICAgfVxuXG4gICAgaWYgKGF0b20ucGFja2FnZXMuaXNCdW5kbGVkUGFja2FnZSh0aGlzLnBhY2submFtZSkpIHtcbiAgICAgIHRoaXMucmVmcy5pbnN0YWxsQnV0dG9uR3JvdXAucmVtb3ZlKClcbiAgICAgIHRoaXMucmVmcy51bmluc3RhbGxCdXR0b24ucmVtb3ZlKClcbiAgICB9XG5cbiAgICBpZiAoIXRoaXMubmV3VmVyc2lvbiAmJiAhdGhpcy5uZXdTaGEpIHtcbiAgICAgIHRoaXMucmVmcy51cGRhdGVCdXR0b25Hcm91cC5zdHlsZS5kaXNwbGF5ID0gJ25vbmUnXG4gICAgfVxuXG4gICAgdGhpcy5oYXNDb21wYXRpYmxlVmVyc2lvbiA9IHRydWVcbiAgICB0aGlzLnVwZGF0ZUludGVyZmFjZVN0YXRlKClcbiAgfVxuXG4gIHJlbmRlciAoKSB7XG4gICAgY29uc3QgZGlzcGxheU5hbWUgPSAodGhpcy5wYWNrLmdpdFVybEluZm8gPyB0aGlzLnBhY2suZ2l0VXJsSW5mby5wcm9qZWN0IDogdGhpcy5wYWNrLm5hbWUpIHx8ICcnXG4gICAgY29uc3Qgb3duZXIgPSBvd25lckZyb21SZXBvc2l0b3J5KHRoaXMucGFjay5yZXBvc2l0b3J5KVxuICAgIGNvbnN0IGRlc2NyaXB0aW9uID0gdGhpcy5wYWNrLmRlc2NyaXB0aW9uIHx8ICcnXG5cbiAgICByZXR1cm4gKFxuICAgICAgPGRpdiBjbGFzc05hbWU9J3BhY2thZ2UtY2FyZCBjb2wtbGctOCc+XG4gICAgICAgIDxkaXYgcmVmPSdzdGF0c0NvbnRhaW5lcicgY2xhc3NOYW1lPSdzdGF0cyBwdWxsLXJpZ2h0Jz5cbiAgICAgICAgICA8c3BhbiByZWY9J3BhY2thZ2VTdGFycycgY2xhc3NOYW1lPSdzdGF0cy1pdGVtJz5cbiAgICAgICAgICAgIDxzcGFuIHJlZj0nc3RhcmdhemVySWNvbicgY2xhc3NOYW1lPSdpY29uIGljb24tc3RhcicgLz5cbiAgICAgICAgICAgIDxzcGFuIHJlZj0nc3RhcmdhemVyQ291bnQnIGNsYXNzTmFtZT0ndmFsdWUnIC8+XG4gICAgICAgICAgPC9zcGFuPlxuXG4gICAgICAgICAgPHNwYW4gcmVmPSdwYWNrYWdlRG93bmxvYWRzJyBjbGFzc05hbWU9J3N0YXRzLWl0ZW0nPlxuICAgICAgICAgICAgPHNwYW4gcmVmPSdkb3dubG9hZEljb24nIGNsYXNzTmFtZT0naWNvbiBpY29uLWNsb3VkLWRvd25sb2FkJyAvPlxuICAgICAgICAgICAgPHNwYW4gcmVmPSdkb3dubG9hZENvdW50JyBjbGFzc05hbWU9J3ZhbHVlJyAvPlxuICAgICAgICAgIDwvc3Bhbj5cbiAgICAgICAgPC9kaXY+XG5cbiAgICAgICAgPGRpdiBjbGFzc05hbWU9J2JvZHknPlxuICAgICAgICAgIDxoNCBjbGFzc05hbWU9J2NhcmQtbmFtZSc+XG4gICAgICAgICAgICA8YSBjbGFzc05hbWU9J3BhY2thZ2UtbmFtZScgcmVmPSdwYWNrYWdlTmFtZSc+e2Rpc3BsYXlOYW1lfTwvYT5cbiAgICAgICAgICAgIDxzcGFuIGNsYXNzTmFtZT0ncGFja2FnZS12ZXJzaW9uJz5cbiAgICAgICAgICAgICAgPHNwYW4gcmVmPSd2ZXJzaW9uVmFsdWUnIGNsYXNzTmFtZT0ndmFsdWUnPntTdHJpbmcodGhpcy5wYWNrLnZlcnNpb24pfTwvc3Bhbj5cbiAgICAgICAgICAgIDwvc3Bhbj5cblxuICAgICAgICAgICAgPHNwYW4gY2xhc3NOYW1lPSdkZXByZWNhdGlvbi1iYWRnZSBoaWdobGlnaHQtd2FybmluZyBpbmxpbmUtYmxvY2snPkRlcHJlY2F0ZWQ8L3NwYW4+XG4gICAgICAgICAgPC9oND5cbiAgICAgICAgICA8c3BhbiByZWY9J3BhY2thZ2VEZXNjcmlwdGlvbicgY2xhc3NOYW1lPSdwYWNrYWdlLWRlc2NyaXB0aW9uJz57ZGVzY3JpcHRpb259PC9zcGFuPlxuICAgICAgICAgIDxkaXYgcmVmPSdwYWNrYWdlTWVzc2FnZScgY2xhc3NOYW1lPSdwYWNrYWdlLW1lc3NhZ2UnIC8+XG4gICAgICAgIDwvZGl2PlxuXG4gICAgICAgIDxkaXYgY2xhc3NOYW1lPSdtZXRhJz5cbiAgICAgICAgICA8ZGl2IHJlZj0nbWV0YVVzZXJDb250YWluZXInIGNsYXNzTmFtZT0nbWV0YS11c2VyJz5cbiAgICAgICAgICAgIDxhIHJlZj0nYXZhdGFyTGluaycgaHJlZj17YGh0dHBzOi8vYXRvbS5pby91c2Vycy8ke293bmVyfWB9PlxuICAgICAgICAgICAgICB7LyogQSB0cmFuc3BhcmVudCBnaWYgc28gdGhlcmUgaXMgbm8gXCJicm9rZW4gYm9yZGVyXCIgKi99XG4gICAgICAgICAgICAgIDxpbWcgcmVmPSdhdmF0YXInIGNsYXNzTmFtZT0nYXZhdGFyJyBzcmM9J2RhdGE6aW1hZ2UvZ2lmO2Jhc2U2NCxSMGxHT0RsaEFRQUJBSUFBQUFBQUFQLy8veUg1QkFFQUFBQUFMQUFBQUFBQkFBRUFBQUlCUkFBNycgLz5cbiAgICAgICAgICAgIDwvYT5cbiAgICAgICAgICAgIDxhIHJlZj0nbG9naW5MaW5rJyBjbGFzc05hbWU9J2F1dGhvcicgaHJlZj17YGh0dHBzOi8vYXRvbS5pby91c2Vycy8ke293bmVyfWB9Pntvd25lcn08L2E+XG4gICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgPGRpdiBjbGFzc05hbWU9J21ldGEtY29udHJvbHMnPlxuICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9J2J0bi10b29sYmFyJz5cbiAgICAgICAgICAgICAgPGRpdiByZWY9J3VwZGF0ZUJ1dHRvbkdyb3VwJyBjbGFzc05hbWU9J2J0bi1ncm91cCc+XG4gICAgICAgICAgICAgICAgPGJ1dHRvbiB0eXBlPSdidXR0b24nIGNsYXNzTmFtZT0nYnRuIGJ0bi1pbmZvIGljb24gaWNvbi1jbG91ZC1kb3dubG9hZCBpbnN0YWxsLWJ1dHRvbicgcmVmPSd1cGRhdGVCdXR0b24nPlVwZGF0ZTwvYnV0dG9uPlxuICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgPGRpdiByZWY9J2luc3RhbGxBbHRlcm5hdGl2ZUJ1dHRvbkdyb3VwJyBjbGFzc05hbWU9J2J0bi1ncm91cCc+XG4gICAgICAgICAgICAgICAgPGJ1dHRvbiB0eXBlPSdidXR0b24nIGNsYXNzTmFtZT0nYnRuIGJ0bi1pbmZvIGljb24gaWNvbi1jbG91ZC1kb3dubG9hZCBpbnN0YWxsLWJ1dHRvbicgcmVmPSdpbnN0YWxsQWx0ZXJuYXRpdmVCdXR0b24nPkluc3RhbGwgQWx0ZXJuYXRpdmU8L2J1dHRvbj5cbiAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgIDxkaXYgcmVmPSdpbnN0YWxsQnV0dG9uR3JvdXAnIGNsYXNzTmFtZT0nYnRuLWdyb3VwJz5cbiAgICAgICAgICAgICAgICA8YnV0dG9uIHR5cGU9J2J1dHRvbicgY2xhc3NOYW1lPSdidG4gYnRuLWluZm8gaWNvbiBpY29uLWNsb3VkLWRvd25sb2FkIGluc3RhbGwtYnV0dG9uJyByZWY9J2luc3RhbGxCdXR0b24nPkluc3RhbGw8L2J1dHRvbj5cbiAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgIDxkaXYgcmVmPSdwYWNrYWdlQWN0aW9uQnV0dG9uR3JvdXAnIGNsYXNzTmFtZT0nYnRuLWdyb3VwJz5cbiAgICAgICAgICAgICAgICA8YnV0dG9uIHR5cGU9J2J1dHRvbicgY2xhc3NOYW1lPSdidG4gaWNvbiBpY29uLWdlYXIgc2V0dGluZ3MnIHJlZj0nc2V0dGluZ3NCdXR0b24nPlNldHRpbmdzPC9idXR0b24+XG4gICAgICAgICAgICAgICAgPGJ1dHRvbiB0eXBlPSdidXR0b24nIGNsYXNzTmFtZT0nYnRuIGljb24gaWNvbi10cmFzaGNhbiB1bmluc3RhbGwtYnV0dG9uJyByZWY9J3VuaW5zdGFsbEJ1dHRvbic+VW5pbnN0YWxsPC9idXR0b24+XG4gICAgICAgICAgICAgICAgPGJ1dHRvbiB0eXBlPSdidXR0b24nIGNsYXNzTmFtZT0nYnRuIGljb24gaWNvbi1wbGF5YmFjay1wYXVzZSBlbmFibGVtZW50JyByZWY9J2VuYWJsZW1lbnRCdXR0b24nPlxuICAgICAgICAgICAgICAgICAgPHNwYW4gY2xhc3NOYW1lPSdkaXNhYmxlLXRleHQnPkRpc2FibGU8L3NwYW4+XG4gICAgICAgICAgICAgICAgPC9idXR0b24+XG4gICAgICAgICAgICAgICAgPGJ1dHRvbiB0eXBlPSdidXR0b24nIGNsYXNzTmFtZT0nYnRuIHN0YXR1cy1pbmRpY2F0b3InIHRhYkluZGV4PSctMScgcmVmPSdzdGF0dXNJbmRpY2F0b3InIC8+XG4gICAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgPC9kaXY+XG4gICAgICAgIDwvZGl2PlxuICAgICAgPC9kaXY+XG4gICAgKVxuICB9XG5cbiAgbG9jYXRlQ29tcGF0aWJsZVBhY2thZ2VWZXJzaW9uIChjYWxsYmFjaykge1xuICAgIHRoaXMucGFja2FnZU1hbmFnZXIubG9hZENvbXBhdGlibGVQYWNrYWdlVmVyc2lvbih0aGlzLnBhY2submFtZSwgKGVyciwgcGFjaykgPT4ge1xuICAgICAgaWYgKGVyciAhPSBudWxsKSB7XG4gICAgICAgIGNvbnNvbGUuZXJyb3IoZXJyKVxuICAgICAgfVxuXG4gICAgICBjb25zdCBwYWNrYWdlVmVyc2lvbiA9IHBhY2sudmVyc2lvblxuXG4gICAgICAvLyBBIGNvbXBhdGlibGUgdmVyc2lvbiBleGlzdCwgd2UgYWN0aXZhdGUgdGhlIGluc3RhbGwgYnV0dG9uIGFuZFxuICAgICAgLy8gc2V0IHRoaXMuaW5zdGFsbGFibGVQYWNrIHNvIHRoYXQgdGhlIGluc3RhbGwgYWN0aW9uIGluc3RhbGxzIHRoZVxuICAgICAgLy8gY29tcGF0aWJsZSB2ZXJzaW9uIG9mIHRoZSBwYWNrYWdlLlxuICAgICAgaWYgKHBhY2thZ2VWZXJzaW9uKSB7XG4gICAgICAgIHRoaXMucmVmcy52ZXJzaW9uVmFsdWUudGV4dENvbnRlbnQgPSBwYWNrYWdlVmVyc2lvblxuICAgICAgICBpZiAocGFja2FnZVZlcnNpb24gIT09IHRoaXMucGFjay52ZXJzaW9uKSB7XG4gICAgICAgICAgdGhpcy5yZWZzLnZlcnNpb25WYWx1ZS5jbGFzc0xpc3QuYWRkKCd0ZXh0LXdhcm5pbmcnKVxuICAgICAgICAgIHRoaXMucmVmcy5wYWNrYWdlTWVzc2FnZS5jbGFzc0xpc3QuYWRkKCd0ZXh0LXdhcm5pbmcnKVxuICAgICAgICAgIHRoaXMucmVmcy5wYWNrYWdlTWVzc2FnZS50ZXh0Q29udGVudCA9IGBWZXJzaW9uICR7cGFja2FnZVZlcnNpb259IGlzIG5vdCB0aGUgbGF0ZXN0IHZlcnNpb24gYXZhaWxhYmxlIGZvciB0aGlzIHBhY2thZ2UsIGJ1dCBpdCdzIHRoZSBsYXRlc3QgdGhhdCBpcyBjb21wYXRpYmxlIHdpdGggeW91ciB2ZXJzaW9uIG9mIEF0b20uYFxuICAgICAgICB9XG5cbiAgICAgICAgdGhpcy5pbnN0YWxsYWJsZVBhY2sgPSBwYWNrXG4gICAgICAgIHRoaXMuaGFzQ29tcGF0aWJsZVZlcnNpb24gPSB0cnVlXG4gICAgICB9IGVsc2Uge1xuICAgICAgICB0aGlzLmhhc0NvbXBhdGlibGVWZXJzaW9uID0gZmFsc2VcbiAgICAgICAgdGhpcy5yZWZzLnZlcnNpb25WYWx1ZS5jbGFzc0xpc3QuYWRkKCd0ZXh0LWVycm9yJylcbiAgICAgICAgdGhpcy5yZWZzLnBhY2thZ2VNZXNzYWdlLmNsYXNzTGlzdC5hZGQoJ3RleHQtZXJyb3InKVxuICAgICAgICB0aGlzLnJlZnMucGFja2FnZU1lc3NhZ2UuaW5zZXJ0QWRqYWNlbnRUZXh0KFxuICAgICAgICAgICdiZWZvcmVlbmQnLFxuICAgICAgICAgIGBUaGVyZSdzIG5vIHZlcnNpb24gb2YgdGhpcyBwYWNrYWdlIHRoYXQgaXMgY29tcGF0aWJsZSB3aXRoIHlvdXIgQXRvbSB2ZXJzaW9uLiBUaGUgdmVyc2lvbiBtdXN0IHNhdGlzZnkgJHt0aGlzLnBhY2suZW5naW5lcy5hdG9tfS5gXG4gICAgICAgIClcbiAgICAgICAgY29uc29sZS5lcnJvcihgTm8gYXZhaWxhYmxlIHZlcnNpb24gY29tcGF0aWJsZSB3aXRoIHRoZSBpbnN0YWxsZWQgQXRvbSB2ZXJzaW9uOiAke2F0b20uZ2V0VmVyc2lvbigpfWApXG4gICAgICB9XG5cbiAgICAgIGNhbGxiYWNrKClcbiAgICB9KVxuICB9XG5cbiAgaGFuZGxlQnV0dG9uRXZlbnRzIChvcHRpb25zKSB7XG4gICAgaWYgKG9wdGlvbnMgJiYgb3B0aW9ucy5vblNldHRpbmdzVmlldykge1xuICAgICAgdGhpcy5yZWZzLnNldHRpbmdzQnV0dG9uLnN0eWxlLmRpc3BsYXkgPSAnbm9uZSdcbiAgICB9IGVsc2Uge1xuICAgICAgY29uc3QgY2xpY2tIYW5kbGVyID0gKGV2ZW50KSA9PiB7XG4gICAgICAgIGV2ZW50LnN0b3BQcm9wYWdhdGlvbigpXG4gICAgICAgIHRoaXMuc2V0dGluZ3NWaWV3LnNob3dQYW5lbCh0aGlzLnBhY2submFtZSwge2JhY2s6IG9wdGlvbnMgPyBvcHRpb25zLmJhY2sgOiBudWxsLCBwYWNrOiB0aGlzLnBhY2t9KVxuICAgICAgfVxuXG4gICAgICB0aGlzLmVsZW1lbnQuYWRkRXZlbnRMaXN0ZW5lcignY2xpY2snLCBjbGlja0hhbmRsZXIpXG4gICAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChuZXcgRGlzcG9zYWJsZSgoKSA9PiB7IHRoaXMuZWxlbWVudC5yZW1vdmVFdmVudExpc3RlbmVyKCdjbGljaycsIGNsaWNrSGFuZGxlcikgfSkpXG5cbiAgICAgIHRoaXMucmVmcy5zZXR0aW5nc0J1dHRvbi5hZGRFdmVudExpc3RlbmVyKCdjbGljaycsIGNsaWNrSGFuZGxlcilcbiAgICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKG5ldyBEaXNwb3NhYmxlKCgpID0+IHsgdGhpcy5yZWZzLnNldHRpbmdzQnV0dG9uLnJlbW92ZUV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgY2xpY2tIYW5kbGVyKSB9KSlcbiAgICB9XG5cbiAgICBjb25zdCBpbnN0YWxsQnV0dG9uQ2xpY2tIYW5kbGVyID0gKGV2ZW50KSA9PiB7XG4gICAgICBldmVudC5zdG9wUHJvcGFnYXRpb24oKVxuICAgICAgdGhpcy5pbnN0YWxsKClcbiAgICB9XG4gICAgdGhpcy5yZWZzLmluc3RhbGxCdXR0b24uYWRkRXZlbnRMaXN0ZW5lcignY2xpY2snLCBpbnN0YWxsQnV0dG9uQ2xpY2tIYW5kbGVyKVxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKG5ldyBEaXNwb3NhYmxlKCgpID0+IHsgdGhpcy5yZWZzLmluc3RhbGxCdXR0b24ucmVtb3ZlRXZlbnRMaXN0ZW5lcignY2xpY2snLCBpbnN0YWxsQnV0dG9uQ2xpY2tIYW5kbGVyKSB9KSlcblxuICAgIGNvbnN0IHVuaW5zdGFsbEJ1dHRvbkNsaWNrSGFuZGxlciA9IChldmVudCkgPT4ge1xuICAgICAgZXZlbnQuc3RvcFByb3BhZ2F0aW9uKClcbiAgICAgIHRoaXMudW5pbnN0YWxsKClcbiAgICB9XG4gICAgdGhpcy5yZWZzLnVuaW5zdGFsbEJ1dHRvbi5hZGRFdmVudExpc3RlbmVyKCdjbGljaycsIHVuaW5zdGFsbEJ1dHRvbkNsaWNrSGFuZGxlcilcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChuZXcgRGlzcG9zYWJsZSgoKSA9PiB7IHRoaXMucmVmcy51bmluc3RhbGxCdXR0b24ucmVtb3ZlRXZlbnRMaXN0ZW5lcignY2xpY2snLCB1bmluc3RhbGxCdXR0b25DbGlja0hhbmRsZXIpIH0pKVxuXG4gICAgY29uc3QgaW5zdGFsbEFsdGVybmF0aXZlQnV0dG9uQ2xpY2tIYW5kbGVyID0gKGV2ZW50KSA9PiB7XG4gICAgICBldmVudC5zdG9wUHJvcGFnYXRpb24oKVxuICAgICAgdGhpcy5pbnN0YWxsQWx0ZXJuYXRpdmUoKVxuICAgIH1cbiAgICB0aGlzLnJlZnMuaW5zdGFsbEFsdGVybmF0aXZlQnV0dG9uLmFkZEV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgaW5zdGFsbEFsdGVybmF0aXZlQnV0dG9uQ2xpY2tIYW5kbGVyKVxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKG5ldyBEaXNwb3NhYmxlKCgpID0+IHsgdGhpcy5yZWZzLmluc3RhbGxBbHRlcm5hdGl2ZUJ1dHRvbi5yZW1vdmVFdmVudExpc3RlbmVyKCdjbGljaycsIGluc3RhbGxBbHRlcm5hdGl2ZUJ1dHRvbkNsaWNrSGFuZGxlcikgfSkpXG5cbiAgICBjb25zdCB1cGRhdGVCdXR0b25DbGlja0hhbmRsZXIgPSAoZXZlbnQpID0+IHtcbiAgICAgIGV2ZW50LnN0b3BQcm9wYWdhdGlvbigpXG4gICAgICB0aGlzLnVwZGF0ZSgpLnRoZW4oKCkgPT4ge1xuICAgICAgICBjb25zdCBidXR0b25zID0gW3tcbiAgICAgICAgICB0ZXh0OiAnUmVzdGFydCcsXG4gICAgICAgICAgb25EaWRDbGljayAoKSB7IHJldHVybiBhdG9tLnJlc3RhcnRBcHBsaWNhdGlvbigpIH1cbiAgICAgICAgfV1cblxuICAgICAgICBsZXQgb2xkVmVyc2lvbiA9ICcnXG4gICAgICAgIGxldCBuZXdWZXJzaW9uID0gJydcblxuICAgICAgICBpZiAodGhpcy5wYWNrLmFwbUluc3RhbGxTb3VyY2UgJiYgdGhpcy5wYWNrLmFwbUluc3RhbGxTb3VyY2UudHlwZSA9PT0gJ2dpdCcpIHtcbiAgICAgICAgICBvbGRWZXJzaW9uID0gdGhpcy5wYWNrLmFwbUluc3RhbGxTb3VyY2Uuc2hhLnN1YnN0cigwLCA4KVxuICAgICAgICAgIG5ld1ZlcnNpb24gPSBgJHt0aGlzLnBhY2subGF0ZXN0U2hhLnN1YnN0cigwLCA4KX1gXG4gICAgICAgIH0gZWxzZSBpZiAodGhpcy5wYWNrLnZlcnNpb24gJiYgdGhpcy5wYWNrLmxhdGVzdFZlcnNpb24pIHtcbiAgICAgICAgICBvbGRWZXJzaW9uID0gdGhpcy5wYWNrLnZlcnNpb25cbiAgICAgICAgICBuZXdWZXJzaW9uID0gdGhpcy5wYWNrLmxhdGVzdFZlcnNpb25cbiAgICAgICAgfVxuXG4gICAgICAgIGxldCBkZXRhaWwgPSAnJ1xuICAgICAgICBpZiAob2xkVmVyc2lvbiAmJiBuZXdWZXJzaW9uKSB7XG4gICAgICAgICAgZGV0YWlsID0gYCR7b2xkVmVyc2lvbn0gLT4gJHtuZXdWZXJzaW9ufWBcbiAgICAgICAgfVxuXG4gICAgICAgIGF0b20ubm90aWZpY2F0aW9ucy5hZGRTdWNjZXNzKGBSZXN0YXJ0IEF0b20gdG8gY29tcGxldGUgdGhlIHVwZGF0ZSBvZiBcXGAke3RoaXMucGFjay5uYW1lfVxcYC5gLCB7XG4gICAgICAgICAgZGlzbWlzc2FibGU6IHRydWUsIGJ1dHRvbnMsIGRldGFpbFxuICAgICAgICB9KVxuICAgICAgfSlcbiAgICB9XG4gICAgdGhpcy5yZWZzLnVwZGF0ZUJ1dHRvbi5hZGRFdmVudExpc3RlbmVyKCdjbGljaycsIHVwZGF0ZUJ1dHRvbkNsaWNrSGFuZGxlcilcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChuZXcgRGlzcG9zYWJsZSgoKSA9PiB7IHRoaXMucmVmcy51cGRhdGVCdXR0b24ucmVtb3ZlRXZlbnRMaXN0ZW5lcignY2xpY2snLCB1cGRhdGVCdXR0b25DbGlja0hhbmRsZXIpIH0pKVxuXG4gICAgY29uc3QgcGFja2FnZU5hbWVDbGlja0hhbmRsZXIgPSAoZXZlbnQpID0+IHtcbiAgICAgIGV2ZW50LnN0b3BQcm9wYWdhdGlvbigpXG4gICAgICBjb25zdCBwYWNrYWdlVHlwZSA9IHRoaXMucGFjay50aGVtZSA/ICd0aGVtZXMnIDogJ3BhY2thZ2VzJ1xuICAgICAgc2hlbGwub3BlbkV4dGVybmFsKGBodHRwczovL2F0b20uaW8vJHtwYWNrYWdlVHlwZX0vJHt0aGlzLnBhY2submFtZX1gKVxuICAgIH1cbiAgICB0aGlzLnJlZnMucGFja2FnZU5hbWUuYWRkRXZlbnRMaXN0ZW5lcignY2xpY2snLCBwYWNrYWdlTmFtZUNsaWNrSGFuZGxlcilcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChuZXcgRGlzcG9zYWJsZSgoKSA9PiB7IHRoaXMucmVmcy5wYWNrYWdlTmFtZS5yZW1vdmVFdmVudExpc3RlbmVyKCdjbGljaycsIHBhY2thZ2VOYW1lQ2xpY2tIYW5kbGVyKSB9KSlcblxuICAgIGNvbnN0IGVuYWJsZW1lbnRCdXR0b25DbGlja0hhbmRsZXIgPSAoZXZlbnQpID0+IHtcbiAgICAgIGV2ZW50LnN0b3BQcm9wYWdhdGlvbigpXG4gICAgICBldmVudC5wcmV2ZW50RGVmYXVsdCgpXG4gICAgICBpZiAodGhpcy5pc0Rpc2FibGVkKCkpIHtcbiAgICAgICAgYXRvbS5wYWNrYWdlcy5lbmFibGVQYWNrYWdlKHRoaXMucGFjay5uYW1lKVxuICAgICAgfSBlbHNlIHtcbiAgICAgICAgYXRvbS5wYWNrYWdlcy5kaXNhYmxlUGFja2FnZSh0aGlzLnBhY2submFtZSlcbiAgICAgIH1cbiAgICB9XG4gICAgdGhpcy5yZWZzLmVuYWJsZW1lbnRCdXR0b24uYWRkRXZlbnRMaXN0ZW5lcignY2xpY2snLCBlbmFibGVtZW50QnV0dG9uQ2xpY2tIYW5kbGVyKVxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKG5ldyBEaXNwb3NhYmxlKCgpID0+IHsgdGhpcy5yZWZzLmVuYWJsZW1lbnRCdXR0b24ucmVtb3ZlRXZlbnRMaXN0ZW5lcignY2xpY2snLCBlbmFibGVtZW50QnV0dG9uQ2xpY2tIYW5kbGVyKSB9KSlcblxuICAgIGNvbnN0IHBhY2thZ2VNZXNzYWdlQ2xpY2tIYW5kbGVyID0gKGV2ZW50KSA9PiB7XG4gICAgICBjb25zdCB0YXJnZXQgPSBldmVudC50YXJnZXQuY2xvc2VzdCgnYScpXG4gICAgICBpZiAodGFyZ2V0KSB7XG4gICAgICAgIGV2ZW50LnN0b3BQcm9wYWdhdGlvbigpXG4gICAgICAgIGV2ZW50LnByZXZlbnREZWZhdWx0KClcbiAgICAgICAgaWYgKHRhcmdldC5ocmVmICYmIHRhcmdldC5ocmVmLnN0YXJ0c1dpdGgoJ2F0b206JykpIHtcbiAgICAgICAgICBhdG9tLndvcmtzcGFjZS5vcGVuKHRhcmdldC5ocmVmKVxuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuICAgIHRoaXMucmVmcy5wYWNrYWdlTWVzc2FnZS5hZGRFdmVudExpc3RlbmVyKCdjbGljaycsIHBhY2thZ2VNZXNzYWdlQ2xpY2tIYW5kbGVyKVxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKG5ldyBEaXNwb3NhYmxlKCgpID0+IHsgdGhpcy5yZWZzLnBhY2thZ2VNZXNzYWdlLnJlbW92ZUV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgcGFja2FnZU1lc3NhZ2VDbGlja0hhbmRsZXIpIH0pKVxuICB9XG5cbiAgZGVzdHJveSAoKSB7XG4gICAgdGhpcy5kaXNwb3NhYmxlcy5kaXNwb3NlKClcbiAgICByZXR1cm4gZXRjaC5kZXN0cm95KHRoaXMpXG4gIH1cblxuICBsb2FkQ2FjaGVkTWV0YWRhdGEgKCkge1xuICAgIHRoaXMuY2xpZW50LmF2YXRhcihvd25lckZyb21SZXBvc2l0b3J5KHRoaXMucGFjay5yZXBvc2l0b3J5KSwgKGVyciwgYXZhdGFyUGF0aCkgPT4ge1xuICAgICAgaWYgKCFlcnIgJiYgYXZhdGFyUGF0aCkge1xuICAgICAgICB0aGlzLnJlZnMuYXZhdGFyLnNyYyA9IGBmaWxlOi8vJHthdmF0YXJQYXRofWBcbiAgICAgIH1cbiAgICB9KVxuXG4gICAgdGhpcy5jbGllbnQucGFja2FnZSh0aGlzLnBhY2submFtZSwgKGVyciwgZGF0YSkgPT4ge1xuICAgICAgLy8gV2UgZG9uJ3QgbmVlZCB0byBhY3R1YWxseSBoYW5kbGUgdGhlIGVycm9yIGhlcmUsIHdlIGNhbiBqdXN0IHNraXBcbiAgICAgIC8vIHNob3dpbmcgdGhlIGRvd25sb2FkIGNvdW50IGlmIHRoZXJlJ3MgYSBwcm9ibGVtLlxuICAgICAgaWYgKCFlcnIpIHtcbiAgICAgICAgaWYgKGRhdGEgPT0gbnVsbCkge1xuICAgICAgICAgIGRhdGEgPSB7fVxuICAgICAgICB9XG5cbiAgICAgICAgaWYgKHRoaXMucGFjay5hcG1JbnN0YWxsU291cmNlICYmIHRoaXMucGFjay5hcG1JbnN0YWxsU291cmNlLnR5cGUgPT09ICdnaXQnKSB7XG4gICAgICAgICAgdGhpcy5yZWZzLmRvd25sb2FkSWNvbi5jbGFzc0xpc3QucmVtb3ZlKCdpY29uLWNsb3VkLWRvd25sb2FkJylcbiAgICAgICAgICB0aGlzLnJlZnMuZG93bmxvYWRJY29uLmNsYXNzTGlzdC5hZGQoJ2ljb24tZ2l0LWJyYW5jaCcpXG4gICAgICAgICAgdGhpcy5yZWZzLmRvd25sb2FkQ291bnQudGV4dENvbnRlbnQgPSB0aGlzLnBhY2suYXBtSW5zdGFsbFNvdXJjZS5zaGEuc3Vic3RyKDAsIDgpXG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgdGhpcy5yZWZzLnN0YXJnYXplckNvdW50LnRleHRDb250ZW50ID0gZGF0YS5zdGFyZ2F6ZXJzX2NvdW50ID8gZGF0YS5zdGFyZ2F6ZXJzX2NvdW50LnRvTG9jYWxlU3RyaW5nKCkgOiAnJ1xuICAgICAgICAgIHRoaXMucmVmcy5kb3dubG9hZENvdW50LnRleHRDb250ZW50ID0gZGF0YS5kb3dubG9hZHMgPyBkYXRhLmRvd25sb2Fkcy50b0xvY2FsZVN0cmluZygpIDogJydcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH0pXG4gIH1cblxuICB1cGRhdGVJbnRlcmZhY2VTdGF0ZSAoKSB7XG4gICAgdGhpcy5yZWZzLnZlcnNpb25WYWx1ZS50ZXh0Q29udGVudCA9ICh0aGlzLmluc3RhbGxhYmxlUGFjayA/IHRoaXMuaW5zdGFsbGFibGVQYWNrLnZlcnNpb24gOiBudWxsKSB8fCB0aGlzLnBhY2sudmVyc2lvblxuICAgIGlmICh0aGlzLnBhY2suYXBtSW5zdGFsbFNvdXJjZSAmJiB0aGlzLnBhY2suYXBtSW5zdGFsbFNvdXJjZS50eXBlID09PSAnZ2l0Jykge1xuICAgICAgdGhpcy5yZWZzLmRvd25sb2FkQ291bnQudGV4dENvbnRlbnQgPSB0aGlzLnBhY2suYXBtSW5zdGFsbFNvdXJjZS5zaGEuc3Vic3RyKDAsIDgpXG4gICAgfVxuXG4gICAgdGhpcy51cGRhdGVTZXR0aW5nc1N0YXRlKClcbiAgICB0aGlzLnVwZGF0ZUluc3RhbGxlZFN0YXRlKClcbiAgICB0aGlzLnVwZGF0ZURpc2FibGVkU3RhdGUoKVxuICAgIHRoaXMudXBkYXRlRGVwcmVjYXRlZFN0YXRlKClcbiAgfVxuXG4gIHVwZGF0ZVNldHRpbmdzU3RhdGUgKCkge1xuICAgIGlmICh0aGlzLmhhc1NldHRpbmdzKCkgJiYgIXRoaXMub25TZXR0aW5nc1ZpZXcpIHtcbiAgICAgIHRoaXMucmVmcy5zZXR0aW5nc0J1dHRvbi5zdHlsZS5kaXNwbGF5ID0gJydcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5yZWZzLnNldHRpbmdzQnV0dG9uLnN0eWxlLmRpc3BsYXkgPSAnbm9uZSdcbiAgICB9XG4gIH1cblxuICAvLyBTZWN0aW9uOiBkaXNhYmxlZCBzdGF0ZSB1cGRhdGVzXG5cbiAgdXBkYXRlRGlzYWJsZWRTdGF0ZSAoKSB7XG4gICAgaWYgKHRoaXMuaXNEaXNhYmxlZCgpKSB7XG4gICAgICB0aGlzLmRpc3BsYXlEaXNhYmxlZFN0YXRlKClcbiAgICB9IGVsc2UgaWYgKHRoaXMuZWxlbWVudC5jbGFzc0xpc3QuY29udGFpbnMoJ2Rpc2FibGVkJykpIHtcbiAgICAgIHRoaXMuZGlzcGxheUVuYWJsZWRTdGF0ZSgpXG4gICAgfVxuICB9XG5cbiAgZGlzcGxheUVuYWJsZWRTdGF0ZSAoKSB7XG4gICAgdGhpcy5lbGVtZW50LmNsYXNzTGlzdC5yZW1vdmUoJ2Rpc2FibGVkJylcbiAgICBpZiAodGhpcy50eXBlID09PSAndGhlbWUnKSB7XG4gICAgICB0aGlzLnJlZnMuZW5hYmxlbWVudEJ1dHRvbi5zdHlsZS5kaXNwbGF5ID0gJ25vbmUnXG4gICAgfVxuICAgIHRoaXMucmVmcy5lbmFibGVtZW50QnV0dG9uLnF1ZXJ5U2VsZWN0b3IoJy5kaXNhYmxlLXRleHQnKS50ZXh0Q29udGVudCA9ICdEaXNhYmxlJ1xuICAgIHRoaXMucmVmcy5lbmFibGVtZW50QnV0dG9uLmNsYXNzTGlzdC5hZGQoJ2ljb24tcGxheWJhY2stcGF1c2UnKVxuICAgIHRoaXMucmVmcy5lbmFibGVtZW50QnV0dG9uLmNsYXNzTGlzdC5yZW1vdmUoJ2ljb24tcGxheWJhY2stcGxheScpXG4gICAgdGhpcy5yZWZzLnN0YXR1c0luZGljYXRvci5jbGFzc0xpc3QucmVtb3ZlKCdpcy1kaXNhYmxlZCcpXG4gIH1cblxuICBkaXNwbGF5RGlzYWJsZWRTdGF0ZSAoKSB7XG4gICAgdGhpcy5lbGVtZW50LmNsYXNzTGlzdC5hZGQoJ2Rpc2FibGVkJylcbiAgICB0aGlzLnJlZnMuZW5hYmxlbWVudEJ1dHRvbi5xdWVyeVNlbGVjdG9yKCcuZGlzYWJsZS10ZXh0JykudGV4dENvbnRlbnQgPSAnRW5hYmxlJ1xuICAgIHRoaXMucmVmcy5lbmFibGVtZW50QnV0dG9uLmNsYXNzTGlzdC5hZGQoJ2ljb24tcGxheWJhY2stcGxheScpXG4gICAgdGhpcy5yZWZzLmVuYWJsZW1lbnRCdXR0b24uY2xhc3NMaXN0LnJlbW92ZSgnaWNvbi1wbGF5YmFjay1wYXVzZScpXG4gICAgdGhpcy5yZWZzLnN0YXR1c0luZGljYXRvci5jbGFzc0xpc3QuYWRkKCdpcy1kaXNhYmxlZCcpXG4gICAgaWYgKHRoaXMuaXNEZXByZWNhdGVkKCkpIHtcbiAgICAgIHRoaXMucmVmcy5lbmFibGVtZW50QnV0dG9uLmRpc2FibGVkID0gdHJ1ZVxuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLnJlZnMuZW5hYmxlbWVudEJ1dHRvbi5kaXNhYmxlZCA9IGZhbHNlXG4gICAgfVxuICB9XG5cbiAgLy8gU2VjdGlvbjogaW5zdGFsbGVkIHN0YXRlIHVwZGF0ZXNcblxuICB1cGRhdGVJbnN0YWxsZWRTdGF0ZSAoKSB7XG4gICAgaWYgKHRoaXMuaXNJbnN0YWxsZWQoKSkge1xuICAgICAgdGhpcy5kaXNwbGF5SW5zdGFsbGVkU3RhdGUoKVxuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLmRpc3BsYXlOb3RJbnN0YWxsZWRTdGF0ZSgpXG4gICAgfVxuICB9XG5cbiAgZGlzcGxheUluc3RhbGxlZFN0YXRlICgpIHtcbiAgICBpZiAodGhpcy5uZXdWZXJzaW9uIHx8IHRoaXMubmV3U2hhKSB7XG4gICAgICB0aGlzLnJlZnMudXBkYXRlQnV0dG9uR3JvdXAuc3R5bGUuZGlzcGxheSA9ICcnXG4gICAgICBpZiAodGhpcy5uZXdWZXJzaW9uKSB7XG4gICAgICAgIHRoaXMucmVmcy51cGRhdGVCdXR0b24udGV4dENvbnRlbnQgPSBgVXBkYXRlIHRvICR7dGhpcy5uZXdWZXJzaW9ufWBcbiAgICAgIH0gZWxzZSBpZiAodGhpcy5uZXdTaGEpIHtcbiAgICAgICAgdGhpcy5yZWZzLnVwZGF0ZUJ1dHRvbi50ZXh0Q29udGVudCA9IGBVcGRhdGUgdG8gJHt0aGlzLm5ld1NoYS5zdWJzdHIoMCwgOCl9YFxuICAgICAgfVxuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLnJlZnMudXBkYXRlQnV0dG9uR3JvdXAuc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgIH1cblxuICAgIHRoaXMucmVmcy5pbnN0YWxsQnV0dG9uR3JvdXAuc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgIHRoaXMucmVmcy5pbnN0YWxsQWx0ZXJuYXRpdmVCdXR0b25Hcm91cC5zdHlsZS5kaXNwbGF5ID0gJ25vbmUnXG4gICAgdGhpcy5yZWZzLnBhY2thZ2VBY3Rpb25CdXR0b25Hcm91cC5zdHlsZS5kaXNwbGF5ID0gJydcbiAgICB0aGlzLnJlZnMudW5pbnN0YWxsQnV0dG9uLnN0eWxlLmRpc3BsYXkgPSAnJ1xuICB9XG5cbiAgZGlzcGxheU5vdEluc3RhbGxlZFN0YXRlICgpIHtcbiAgICB0aGlzLnJlZnMudW5pbnN0YWxsQnV0dG9uLnN0eWxlLmRpc3BsYXkgPSAnbm9uZSdcbiAgICBjb25zdCBhdG9tVmVyc2lvbiA9IHRoaXMucGFja2FnZU1hbmFnZXIubm9ybWFsaXplVmVyc2lvbihhdG9tLmdldFZlcnNpb24oKSlcbiAgICBpZiAoIXRoaXMucGFja2FnZU1hbmFnZXIuc2F0aXNmaWVzVmVyc2lvbihhdG9tVmVyc2lvbiwgdGhpcy5wYWNrKSkge1xuICAgICAgdGhpcy5oYXNDb21wYXRpYmxlVmVyc2lvbiA9IGZhbHNlXG4gICAgICB0aGlzLnNldE5vdEluc3RhbGxlZFN0YXRlQnV0dG9ucygpXG4gICAgICB0aGlzLmxvY2F0ZUNvbXBhdGlibGVQYWNrYWdlVmVyc2lvbigoKSA9PiB7IHRoaXMuc2V0Tm90SW5zdGFsbGVkU3RhdGVCdXR0b25zKCkgfSlcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5zZXROb3RJbnN0YWxsZWRTdGF0ZUJ1dHRvbnMoKVxuICAgIH1cbiAgfVxuXG4gIHNldE5vdEluc3RhbGxlZFN0YXRlQnV0dG9ucyAoKSB7XG4gICAgaWYgKCF0aGlzLmhhc0NvbXBhdGlibGVWZXJzaW9uKSB7XG4gICAgICB0aGlzLnJlZnMuaW5zdGFsbEJ1dHRvbkdyb3VwLnN0eWxlLmRpc3BsYXkgPSAnbm9uZSdcbiAgICAgIHRoaXMucmVmcy51cGRhdGVCdXR0b25Hcm91cC5zdHlsZS5kaXNwbGF5ID0gJ25vbmUnXG4gICAgfSBlbHNlIGlmICh0aGlzLm5ld1ZlcnNpb24gfHwgdGhpcy5uZXdTaGEpIHtcbiAgICAgIHRoaXMucmVmcy51cGRhdGVCdXR0b25Hcm91cC5zdHlsZS5kaXNwbGF5ID0gJydcbiAgICAgIHRoaXMucmVmcy5pbnN0YWxsQnV0dG9uR3JvdXAuc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLnJlZnMudXBkYXRlQnV0dG9uR3JvdXAuc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgICAgdGhpcy5yZWZzLmluc3RhbGxCdXR0b25Hcm91cC5zdHlsZS5kaXNwbGF5ID0gJydcbiAgICB9XG4gICAgdGhpcy5yZWZzLmluc3RhbGxBbHRlcm5hdGl2ZUJ1dHRvbkdyb3VwLnN0eWxlLmRpc3BsYXkgPSAnbm9uZSdcbiAgICB0aGlzLnJlZnMucGFja2FnZUFjdGlvbkJ1dHRvbkdyb3VwLnN0eWxlLmRpc3BsYXkgPSAnbm9uZSdcbiAgfVxuXG4gIC8vIFNlY3Rpb246IGRlcHJlY2F0ZWQgc3RhdGUgdXBkYXRlc1xuXG4gIHVwZGF0ZURlcHJlY2F0ZWRTdGF0ZSAoKSB7XG4gICAgaWYgKHRoaXMuaXNEZXByZWNhdGVkKCkpIHtcbiAgICAgIHRoaXMuZGlzcGxheURlcHJlY2F0ZWRTdGF0ZSgpXG4gICAgfSBlbHNlIGlmICh0aGlzLmVsZW1lbnQuY2xhc3NMaXN0LmNvbnRhaW5zKCdkZXByZWNhdGVkJykpIHtcbiAgICAgIHRoaXMuZGlzcGxheVVuZGVwcmVjYXRlZFN0YXRlKClcbiAgICB9XG4gIH1cblxuICBkaXNwbGF5U3RhdHMgKG9wdGlvbnMpIHtcbiAgICBpZiAob3B0aW9ucyAmJiBvcHRpb25zLnN0YXRzICYmIG9wdGlvbnMuc3RhdHMuZG93bmxvYWRzKSB7XG4gICAgICB0aGlzLnJlZnMucGFja2FnZURvd25sb2Fkcy5zdHlsZS5kaXNwbGF5ID0gJydcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5yZWZzLnBhY2thZ2VEb3dubG9hZHMuc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgIH1cblxuICAgIGlmIChvcHRpb25zICYmIG9wdGlvbnMuc3RhdHMgJiYgb3B0aW9ucy5zdGF0cy5zdGFycykge1xuICAgICAgdGhpcy5yZWZzLnBhY2thZ2VTdGFycy5zdHlsZS5kaXNwbGF5ID0gJydcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5yZWZzLnBhY2thZ2VTdGFycy5zdHlsZS5kaXNwbGF5ID0gJ25vbmUnXG4gICAgfVxuICB9XG5cbiAgZGlzcGxheVVuZGVwcmVjYXRlZFN0YXRlICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuY2xhc3NMaXN0LnJlbW92ZSgnZGVwcmVjYXRlZCcpXG4gICAgdGhpcy5yZWZzLnBhY2thZ2VNZXNzYWdlLmNsYXNzTGlzdC5yZW1vdmUoJ3RleHQtd2FybmluZycpXG4gICAgdGhpcy5yZWZzLnBhY2thZ2VNZXNzYWdlLnRleHRDb250ZW50ID0gJydcbiAgfVxuXG4gIGRpc3BsYXlEZXByZWNhdGVkU3RhdGUgKCkge1xuICAgIHRoaXMuZWxlbWVudC5jbGFzc0xpc3QuYWRkKCdkZXByZWNhdGVkJylcbiAgICB0aGlzLnJlZnMuc2V0dGluZ3NCdXR0b24uZGlzYWJsZWQgPSB0cnVlXG5cbiAgICBjb25zdCBpbmZvID0gdGhpcy5nZXREZXByZWNhdGVkUGFja2FnZU1ldGFkYXRhKClcbiAgICB0aGlzLnJlZnMucGFja2FnZU1lc3NhZ2UuY2xhc3NMaXN0LmFkZCgndGV4dC13YXJuaW5nJylcblxuICAgIGxldCBtZXNzYWdlID0gbnVsbFxuICAgIGlmIChpbmZvICYmIGluZm8uaGFzRGVwcmVjYXRpb25zKSB7XG4gICAgICBtZXNzYWdlID0gdGhpcy5nZXREZXByZWNhdGlvbk1lc3NhZ2UodGhpcy5uZXdWZXJzaW9uKVxuICAgIH0gZWxzZSBpZiAoaW5mbyAmJiBpbmZvLmhhc0FsdGVybmF0aXZlICYmIGluZm8uYWx0ZXJuYXRpdmUgPT09ICdjb3JlJykge1xuICAgICAgbWVzc2FnZSA9IGluZm8ubWVzc2FnZSAhPSBudWxsID8gaW5mby5tZXNzYWdlIDogYFRoZSBmZWF0dXJlcyBpbiBcXGAke3RoaXMucGFjay5uYW1lfVxcYCBoYXZlIGJlZW4gYWRkZWQgdG8gY29yZS5gXG4gICAgICBtZXNzYWdlICs9ICcgUGxlYXNlIHVuaW5zdGFsbCB0aGlzIHBhY2thZ2UuJ1xuICAgICAgdGhpcy5yZWZzLnNldHRpbmdzQnV0dG9uLnJlbW92ZSgpXG4gICAgICB0aGlzLnJlZnMuZW5hYmxlbWVudEJ1dHRvbi5yZW1vdmUoKVxuICAgIH0gZWxzZSBpZiAoaW5mbyAmJiBpbmZvLmhhc0FsdGVybmF0aXZlICYmIGluZm8uYWx0ZXJuYXRpdmUpIHtcbiAgICAgIGNvbnN0IGFsdCA9IGluZm8uYWx0ZXJuYXRpdmVcbiAgICAgIGNvbnN0IGlzSW5zdGFsbGVkID0gdGhpcy5pc0luc3RhbGxlZCgpXG4gICAgICBpZiAoaXNJbnN0YWxsZWQgJiYgdGhpcy5wYWNrYWdlTWFuYWdlci5pc1BhY2thZ2VJbnN0YWxsZWQoYWx0KSkge1xuICAgICAgICBtZXNzYWdlID0gYFxcYCR7dGhpcy5wYWNrLm5hbWV9XFxgIGhhcyBiZWVuIHJlcGxhY2VkIGJ5IFxcYCR7YWx0fVxcYCB3aGljaCBpcyBhbHJlYWR5IGluc3RhbGxlZC4gUGxlYXNlIHVuaW5zdGFsbCB0aGlzIHBhY2thZ2UuYFxuICAgICAgICB0aGlzLnJlZnMuc2V0dGluZ3NCdXR0b24ucmVtb3ZlKClcbiAgICAgICAgdGhpcy5yZWZzLmVuYWJsZW1lbnRCdXR0b24ucmVtb3ZlKClcbiAgICAgIH0gZWxzZSBpZiAoaXNJbnN0YWxsZWQpIHtcbiAgICAgICAgbWVzc2FnZSA9IGBcXGAke3RoaXMucGFjay5uYW1lfVxcYCBoYXMgYmVlbiByZXBsYWNlZCBieSBbXFxgJHthbHR9XFxgXShhdG9tOi8vY29uZmlnL2luc3RhbGwvcGFja2FnZToke2FsdH0pLmBcbiAgICAgICAgdGhpcy5yZWZzLmluc3RhbGxBbHRlcm5hdGl2ZUJ1dHRvbi50ZXh0Q29udGVudCA9IGBJbnN0YWxsICR7YWx0fWBcbiAgICAgICAgdGhpcy5yZWZzLmluc3RhbGxBbHRlcm5hdGl2ZUJ1dHRvbkdyb3VwLnN0eWxlLmRpc3BsYXkgPSAnJ1xuICAgICAgICB0aGlzLnJlZnMucGFja2FnZUFjdGlvbkJ1dHRvbkdyb3VwLnN0eWxlLmRpc3BsYXkgPSAnJ1xuICAgICAgICB0aGlzLnJlZnMuc2V0dGluZ3NCdXR0b24ucmVtb3ZlKClcbiAgICAgICAgdGhpcy5yZWZzLmVuYWJsZW1lbnRCdXR0b24ucmVtb3ZlKClcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIG1lc3NhZ2UgPSBgXFxgJHt0aGlzLnBhY2submFtZX1cXGAgaGFzIGJlZW4gcmVwbGFjZWQgYnkgW1xcYCR7YWx0fVxcYF0oYXRvbTovL2NvbmZpZy9pbnN0YWxsL3BhY2thZ2U6JHthbHR9KS5gXG4gICAgICAgIHRoaXMucmVmcy5pbnN0YWxsQnV0dG9uR3JvdXAuc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgICAgICB0aGlzLnJlZnMuaW5zdGFsbEFsdGVybmF0aXZlQnV0dG9uR3JvdXAuc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgICAgICB0aGlzLnJlZnMucGFja2FnZUFjdGlvbkJ1dHRvbkdyb3VwLnN0eWxlLmRpc3BsYXkgPSAnbm9uZSdcbiAgICAgIH1cbiAgICB9XG5cbiAgICBpZiAobWVzc2FnZSAhPSBudWxsKSB7XG4gICAgICBpZiAobWFya2VkID09IG51bGwpIHtcbiAgICAgICAgbWFya2VkID0gcmVxdWlyZSgnbWFya2VkJylcbiAgICAgIH1cblxuICAgICAgdGhpcy5yZWZzLnBhY2thZ2VNZXNzYWdlLmlubmVySFRNTCA9IG1hcmtlZChtZXNzYWdlKVxuICAgIH1cbiAgfVxuXG4gIGRpc3BsYXlHaXRQYWNrYWdlSW5zdGFsbEluZm9ybWF0aW9uICgpIHtcbiAgICB0aGlzLnJlZnMubWV0YVVzZXJDb250YWluZXIucmVtb3ZlKClcbiAgICB0aGlzLnJlZnMuc3RhdHNDb250YWluZXIucmVtb3ZlKClcbiAgICBjb25zdCB7Z2l0VXJsSW5mb30gPSB0aGlzLnBhY2tcbiAgICBpZiAoZ2l0VXJsSW5mby5kZWZhdWx0ID09PSAnc2hvcnRjdXQnKSB7XG4gICAgICB0aGlzLnJlZnMucGFja2FnZURlc2NyaXB0aW9uLnRleHRDb250ZW50ID0gZ2l0VXJsSW5mby5odHRwcygpXG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMucmVmcy5wYWNrYWdlRGVzY3JpcHRpb24udGV4dENvbnRlbnQgPSBnaXRVcmxJbmZvLnRvU3RyaW5nKClcbiAgICB9XG4gICAgdGhpcy5yZWZzLmluc3RhbGxCdXR0b24uY2xhc3NMaXN0LnJlbW92ZSgnaWNvbi1jbG91ZC1kb3dubG9hZCcpXG4gICAgdGhpcy5yZWZzLmluc3RhbGxCdXR0b24uY2xhc3NMaXN0LmFkZCgnaWNvbi1naXQtY29tbWl0JylcbiAgICB0aGlzLnJlZnMudXBkYXRlQnV0dG9uLmNsYXNzTGlzdC5yZW1vdmUoJ2ljb24tY2xvdWQtZG93bmxvYWQnKVxuICAgIHRoaXMucmVmcy51cGRhdGVCdXR0b24uY2xhc3NMaXN0LmFkZCgnaWNvbi1naXQtY29tbWl0JylcbiAgfVxuXG4gIGRpc3BsYXlBdmFpbGFibGVVcGRhdGUgKG5ld1ZlcnNpb24pIHtcbiAgICB0aGlzLm5ld1ZlcnNpb24gPSBuZXdWZXJzaW9uXG4gICAgdGhpcy51cGRhdGVJbnRlcmZhY2VTdGF0ZSgpXG4gIH1cblxuICBnZXREZXByZWNhdGlvbk1lc3NhZ2UgKG5ld1ZlcnNpb24pIHtcbiAgICBjb25zdCBpbmZvID0gdGhpcy5nZXREZXByZWNhdGVkUGFja2FnZU1ldGFkYXRhKClcbiAgICBpZiAoIWluZm8gfHwgIWluZm8uaGFzRGVwcmVjYXRpb25zKSB7XG4gICAgICByZXR1cm5cbiAgICB9XG5cbiAgICBpZiAobmV3VmVyc2lvbikge1xuICAgICAgaWYgKHRoaXMuaXNEZXByZWNhdGVkKG5ld1ZlcnNpb24pKSB7XG4gICAgICAgIHJldHVybiBgQW4gdXBkYXRlIHRvIFxcYHYke25ld1ZlcnNpb259XFxgIGlzIGF2YWlsYWJsZSBidXQgc3RpbGwgY29udGFpbnMgZGVwcmVjYXRpb25zLmBcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIHJldHVybiBgQW4gdXBkYXRlIHRvIFxcYHYke25ld1ZlcnNpb259XFxgIGlzIGF2YWlsYWJsZSB3aXRob3V0IGRlcHJlY2F0aW9ucy5gXG4gICAgICB9XG4gICAgfSBlbHNlIHtcbiAgICAgIGlmICh0aGlzLmlzSW5zdGFsbGVkKCkpIHtcbiAgICAgICAgcmV0dXJuIGluZm8ubWVzc2FnZSAhPSBudWxsID8gaW5mby5tZXNzYWdlIDogJ1RoaXMgcGFja2FnZSBoYXMgbm90IGJlZW4gbG9hZGVkIGR1ZSB0byB1c2luZyBkZXByZWNhdGVkIEFQSXMuIFRoZXJlIGlzIG5vIHVwZGF0ZSBhdmFpbGFibGUuJ1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgcmV0dXJuICdUaGlzIHBhY2thZ2UgaGFzIGRlcHJlY2F0aW9ucyBhbmQgaXMgbm90IGluc3RhbGxhYmxlLidcbiAgICAgIH1cbiAgICB9XG4gIH1cblxuICBoYW5kbGVQYWNrYWdlRXZlbnRzICgpIHtcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChhdG9tLnBhY2thZ2VzLm9uRGlkRGVhY3RpdmF0ZVBhY2thZ2UoKHBhY2spID0+IHtcbiAgICAgIGlmIChwYWNrLm5hbWUgPT09IHRoaXMucGFjay5uYW1lKSB7XG4gICAgICAgIHRoaXMudXBkYXRlRGlzYWJsZWRTdGF0ZSgpXG4gICAgICB9XG4gICAgfSkpXG5cbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChhdG9tLnBhY2thZ2VzLm9uRGlkQWN0aXZhdGVQYWNrYWdlKChwYWNrKSA9PiB7XG4gICAgICBpZiAocGFjay5uYW1lID09PSB0aGlzLnBhY2submFtZSkge1xuICAgICAgICB0aGlzLnVwZGF0ZURpc2FibGVkU3RhdGUoKVxuICAgICAgfVxuICAgIH0pKVxuXG4gICAgdGhpcy5kaXNwb3NhYmxlcy5hZGQoYXRvbS5jb25maWcub25EaWRDaGFuZ2UoJ2NvcmUuZGlzYWJsZWRQYWNrYWdlcycsICgpID0+IHtcbiAgICAgIHRoaXMudXBkYXRlRGlzYWJsZWRTdGF0ZSgpXG4gICAgfSkpXG5cbiAgICB0aGlzLnN1YnNjcmliZVRvUGFja2FnZUV2ZW50KCdwYWNrYWdlLWluc3RhbGxpbmcgdGhlbWUtaW5zdGFsbGluZycsICgpID0+IHtcbiAgICAgIHRoaXMudXBkYXRlSW50ZXJmYWNlU3RhdGUoKVxuICAgICAgdGhpcy5yZWZzLmluc3RhbGxCdXR0b24uZGlzYWJsZWQgPSB0cnVlXG4gICAgICB0aGlzLnJlZnMuaW5zdGFsbEJ1dHRvbi5jbGFzc0xpc3QuYWRkKCdpcy1pbnN0YWxsaW5nJylcbiAgICB9KVxuXG4gICAgdGhpcy5zdWJzY3JpYmVUb1BhY2thZ2VFdmVudCgncGFja2FnZS11cGRhdGluZyB0aGVtZS11cGRhdGluZycsICgpID0+IHtcbiAgICAgIHRoaXMudXBkYXRlSW50ZXJmYWNlU3RhdGUoKVxuICAgICAgdGhpcy5yZWZzLnVwZGF0ZUJ1dHRvbi5kaXNhYmxlZCA9IHRydWVcbiAgICAgIHRoaXMucmVmcy51cGRhdGVCdXR0b24uY2xhc3NMaXN0LmFkZCgnaXMtaW5zdGFsbGluZycpXG4gICAgfSlcblxuICAgIHRoaXMuc3Vic2NyaWJlVG9QYWNrYWdlRXZlbnQoJ3BhY2thZ2UtaW5zdGFsbGluZy1hbHRlcm5hdGl2ZScsICgpID0+IHtcbiAgICAgIHRoaXMudXBkYXRlSW50ZXJmYWNlU3RhdGUoKVxuICAgICAgdGhpcy5yZWZzLmluc3RhbGxBbHRlcm5hdGl2ZUJ1dHRvbi5kaXNhYmxlZCA9IHRydWVcbiAgICAgIHRoaXMucmVmcy5pbnN0YWxsQWx0ZXJuYXRpdmVCdXR0b24uY2xhc3NMaXN0LmFkZCgnaXMtaW5zdGFsbGluZycpXG4gICAgfSlcblxuICAgIHRoaXMuc3Vic2NyaWJlVG9QYWNrYWdlRXZlbnQoJ3BhY2thZ2UtdW5pbnN0YWxsaW5nIHRoZW1lLXVuaW5zdGFsbGluZycsICgpID0+IHtcbiAgICAgIHRoaXMudXBkYXRlSW50ZXJmYWNlU3RhdGUoKVxuICAgICAgdGhpcy5yZWZzLmVuYWJsZW1lbnRCdXR0b24uZGlzYWJsZWQgPSB0cnVlXG4gICAgICB0aGlzLnJlZnMudW5pbnN0YWxsQnV0dG9uLmRpc2FibGVkID0gdHJ1ZVxuICAgICAgdGhpcy5yZWZzLnVuaW5zdGFsbEJ1dHRvbi5jbGFzc0xpc3QuYWRkKCdpcy11bmluc3RhbGxpbmcnKVxuICAgIH0pXG5cbiAgICB0aGlzLnN1YnNjcmliZVRvUGFja2FnZUV2ZW50KCdwYWNrYWdlLWluc3RhbGxlZCBwYWNrYWdlLWluc3RhbGwtZmFpbGVkIHRoZW1lLWluc3RhbGxlZCB0aGVtZS1pbnN0YWxsLWZhaWxlZCcsICgpID0+IHtcbiAgICAgIGNvbnN0IGxvYWRlZFBhY2sgPSBhdG9tLnBhY2thZ2VzLmdldExvYWRlZFBhY2thZ2UodGhpcy5wYWNrLm5hbWUpXG4gICAgICBjb25zdCB2ZXJzaW9uID0gbG9hZGVkUGFjayAmJiBsb2FkZWRQYWNrLm1ldGFkYXRhID8gbG9hZGVkUGFjay5tZXRhZGF0YS52ZXJzaW9uIDogbnVsbFxuICAgICAgaWYgKHZlcnNpb24pIHtcbiAgICAgICAgdGhpcy5wYWNrLnZlcnNpb24gPSB2ZXJzaW9uXG4gICAgICB9XG4gICAgICB0aGlzLnJlZnMuaW5zdGFsbEJ1dHRvbi5kaXNhYmxlZCA9IGZhbHNlXG4gICAgICB0aGlzLnJlZnMuaW5zdGFsbEJ1dHRvbi5jbGFzc0xpc3QucmVtb3ZlKCdpcy1pbnN0YWxsaW5nJylcbiAgICAgIHRoaXMudXBkYXRlSW50ZXJmYWNlU3RhdGUoKVxuICAgIH0pXG5cbiAgICB0aGlzLnN1YnNjcmliZVRvUGFja2FnZUV2ZW50KCdwYWNrYWdlLXVwZGF0ZWQgdGhlbWUtdXBkYXRlZCcsICgpID0+IHtcbiAgICAgIGNvbnN0IGxvYWRlZFBhY2sgPSBhdG9tLnBhY2thZ2VzLmdldExvYWRlZFBhY2thZ2UodGhpcy5wYWNrLm5hbWUpXG4gICAgICBjb25zdCBtZXRhZGF0YSA9IGxvYWRlZFBhY2sgPyBsb2FkZWRQYWNrLm1ldGFkYXRhIDogbnVsbFxuICAgICAgaWYgKG1ldGFkYXRhICYmIG1ldGFkYXRhLnZlcnNpb24pIHtcbiAgICAgICAgdGhpcy5wYWNrLnZlcnNpb24gPSBtZXRhZGF0YS52ZXJzaW9uXG4gICAgICB9XG5cbiAgICAgIGlmIChtZXRhZGF0YSAmJiBtZXRhZGF0YS5hcG1JbnN0YWxsU291cmNlKSB7XG4gICAgICAgIHRoaXMucGFjay5hcG1JbnN0YWxsU291cmNlID0gbWV0YWRhdGEuYXBtSW5zdGFsbFNvdXJjZVxuICAgICAgfVxuXG4gICAgICB0aGlzLm5ld1ZlcnNpb24gPSBudWxsXG4gICAgICB0aGlzLm5ld1NoYSA9IG51bGxcbiAgICAgIHRoaXMucmVmcy51cGRhdGVCdXR0b24uZGlzYWJsZWQgPSBmYWxzZVxuICAgICAgdGhpcy5yZWZzLnVwZGF0ZUJ1dHRvbi5jbGFzc0xpc3QucmVtb3ZlKCdpcy1pbnN0YWxsaW5nJylcbiAgICAgIHRoaXMudXBkYXRlSW50ZXJmYWNlU3RhdGUoKVxuICAgIH0pXG5cbiAgICB0aGlzLnN1YnNjcmliZVRvUGFja2FnZUV2ZW50KCdwYWNrYWdlLXVwZGF0ZS1mYWlsZWQgdGhlbWUtdXBkYXRlLWZhaWxlZCcsICgpID0+IHtcbiAgICAgIHRoaXMucmVmcy51cGRhdGVCdXR0b24uZGlzYWJsZWQgPSBmYWxzZVxuICAgICAgdGhpcy5yZWZzLnVwZGF0ZUJ1dHRvbi5jbGFzc0xpc3QucmVtb3ZlKCdpcy1pbnN0YWxsaW5nJylcbiAgICAgIHRoaXMudXBkYXRlSW50ZXJmYWNlU3RhdGUoKVxuICAgIH0pXG5cbiAgICB0aGlzLnN1YnNjcmliZVRvUGFja2FnZUV2ZW50KCdwYWNrYWdlLXVuaW5zdGFsbGVkIHBhY2thZ2UtdW5pbnN0YWxsLWZhaWxlZCB0aGVtZS11bmluc3RhbGxlZCB0aGVtZS11bmluc3RhbGwtZmFpbGVkJywgKCkgPT4ge1xuICAgICAgdGhpcy5uZXdWZXJzaW9uID0gbnVsbFxuICAgICAgdGhpcy5uZXdTaGEgPSBudWxsXG4gICAgICB0aGlzLnJlZnMuZW5hYmxlbWVudEJ1dHRvbi5kaXNhYmxlZCA9IGZhbHNlXG4gICAgICB0aGlzLnJlZnMudW5pbnN0YWxsQnV0dG9uLmRpc2FibGVkID0gZmFsc2VcbiAgICAgIHRoaXMucmVmcy51bmluc3RhbGxCdXR0b24uY2xhc3NMaXN0LnJlbW92ZSgnaXMtdW5pbnN0YWxsaW5nJylcbiAgICAgIHRoaXMudXBkYXRlSW50ZXJmYWNlU3RhdGUoKVxuICAgIH0pXG5cbiAgICB0aGlzLnN1YnNjcmliZVRvUGFja2FnZUV2ZW50KCdwYWNrYWdlLWluc3RhbGxlZC1hbHRlcm5hdGl2ZSBwYWNrYWdlLWluc3RhbGwtYWx0ZXJuYXRpdmUtZmFpbGVkJywgKCkgPT4ge1xuICAgICAgdGhpcy5yZWZzLmluc3RhbGxBbHRlcm5hdGl2ZUJ1dHRvbi5kaXNhYmxlZCA9IGZhbHNlXG4gICAgICB0aGlzLnJlZnMuaW5zdGFsbEFsdGVybmF0aXZlQnV0dG9uLmNsYXNzTGlzdC5yZW1vdmUoJ2lzLWluc3RhbGxpbmcnKVxuICAgICAgdGhpcy51cGRhdGVJbnRlcmZhY2VTdGF0ZSgpXG4gICAgfSlcbiAgfVxuXG4gIGlzSW5zdGFsbGVkICgpIHtcbiAgICByZXR1cm4gdGhpcy5wYWNrYWdlTWFuYWdlci5pc1BhY2thZ2VJbnN0YWxsZWQodGhpcy5wYWNrLm5hbWUpXG4gIH1cblxuICBpc0Rpc2FibGVkICgpIHtcbiAgICByZXR1cm4gYXRvbS5wYWNrYWdlcy5pc1BhY2thZ2VEaXNhYmxlZCh0aGlzLnBhY2submFtZSlcbiAgfVxuXG4gIGlzRGVwcmVjYXRlZCAodmVyc2lvbikge1xuICAgIGNvbnN0IHBhY2tWZXJzaW9uID0gdmVyc2lvbiAhPSBudWxsID8gdmVyc2lvbiA6IHRoaXMucGFjay52ZXJzaW9uXG4gICAgcmV0dXJuIGF0b20ucGFja2FnZXMuaXNEZXByZWNhdGVkUGFja2FnZSh0aGlzLnBhY2submFtZSwgcGFja1ZlcnNpb24pXG4gIH1cblxuICBnZXREZXByZWNhdGVkUGFja2FnZU1ldGFkYXRhICgpIHtcbiAgICByZXR1cm4gYXRvbS5wYWNrYWdlcy5nZXREZXByZWNhdGVkUGFja2FnZU1ldGFkYXRhKHRoaXMucGFjay5uYW1lKVxuICB9XG5cbiAgaGFzU2V0dGluZ3MgKCkge1xuICAgIHJldHVybiB0aGlzLnBhY2thZ2VNYW5hZ2VyLnBhY2thZ2VIYXNTZXR0aW5ncyh0aGlzLnBhY2submFtZSlcbiAgfVxuXG4gIHN1YnNjcmliZVRvUGFja2FnZUV2ZW50IChldmVudCwgY2FsbGJhY2spIHtcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZCh0aGlzLnBhY2thZ2VNYW5hZ2VyLm9uKGV2ZW50LCAoe3BhY2ssIGVycm9yfSkgPT4ge1xuICAgICAgaWYgKHBhY2sucGFjayAhPSBudWxsKSB7XG4gICAgICAgIHBhY2sgPSBwYWNrLnBhY2tcbiAgICAgIH1cblxuICAgICAgY29uc3QgcGFja2FnZU5hbWUgPSBwYWNrLm5hbWVcbiAgICAgIGlmIChwYWNrYWdlTmFtZSA9PT0gdGhpcy5wYWNrLm5hbWUpIHtcbiAgICAgICAgY2FsbGJhY2socGFjaywgZXJyb3IpXG4gICAgICB9XG4gICAgfSkpXG4gIH1cblxuICAvKlxuICBTZWN0aW9uOiBNZXRob2RzIHRoYXQgc2hvdWxkIGJlIG9uIGEgUGFja2FnZSBtb2RlbFxuICAqL1xuXG4gIGluc3RhbGwgKCkge1xuICAgIHRoaXMucGFja2FnZU1hbmFnZXIuaW5zdGFsbCh0aGlzLmluc3RhbGxhYmxlUGFjayAhPSBudWxsID8gdGhpcy5pbnN0YWxsYWJsZVBhY2sgOiB0aGlzLnBhY2ssIChlcnJvcikgPT4ge1xuICAgICAgaWYgKGVycm9yICE9IG51bGwpIHtcbiAgICAgICAgY29uc29sZS5lcnJvcihgSW5zdGFsbGluZyAke3RoaXMudHlwZX0gJHt0aGlzLnBhY2submFtZX0gZmFpbGVkYCwgZXJyb3Iuc3RhY2sgIT0gbnVsbCA/IGVycm9yLnN0YWNrIDogZXJyb3IsIGVycm9yLnN0ZGVycilcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIC8vIGlmIGEgcGFja2FnZSB3YXMgZGlzYWJsZWQgYmVmb3JlIGluc3RhbGxpbmcgaXQsIHJlLWVuYWJsZSBpdFxuICAgICAgICBpZiAodGhpcy5pc0Rpc2FibGVkKCkpIHtcbiAgICAgICAgICBhdG9tLnBhY2thZ2VzLmVuYWJsZVBhY2thZ2UodGhpcy5wYWNrLm5hbWUpXG4gICAgICAgIH1cbiAgICAgIH1cbiAgICB9KVxuICB9XG5cbiAgdXBkYXRlICgpIHtcbiAgICBpZiAoIXRoaXMubmV3VmVyc2lvbiAmJiAhdGhpcy5uZXdTaGEpIHtcbiAgICAgIHJldHVybiBQcm9taXNlLnJlc29sdmUoKVxuICAgIH1cblxuICAgIGNvbnN0IHBhY2sgPSB0aGlzLmluc3RhbGxhYmxlUGFjayAhPSBudWxsID8gdGhpcy5pbnN0YWxsYWJsZVBhY2sgOiB0aGlzLnBhY2tcbiAgICBjb25zdCB2ZXJzaW9uID0gdGhpcy5uZXdWZXJzaW9uID8gYHYke3RoaXMubmV3VmVyc2lvbn1gIDogYCMke3RoaXMubmV3U2hhLnN1YnN0cigwLCA4KX1gXG4gICAgcmV0dXJuIG5ldyBQcm9taXNlKChyZXNvbHZlLCByZWplY3QpID0+IHtcbiAgICAgIHRoaXMucGFja2FnZU1hbmFnZXIudXBkYXRlKHBhY2ssIHRoaXMubmV3VmVyc2lvbiwgZXJyb3IgPT4ge1xuICAgICAgICBpZiAoZXJyb3IgIT0gbnVsbCkge1xuICAgICAgICAgIGF0b20uYXNzZXJ0KGZhbHNlLCAnUGFja2FnZSB1cGRhdGUgZmFpbGVkJywgYXNzZXJ0aW9uRXJyb3IgPT4ge1xuICAgICAgICAgICAgYXNzZXJ0aW9uRXJyb3IubWV0YWRhdGEgPSB7XG4gICAgICAgICAgICAgIHR5cGU6IHRoaXMudHlwZSxcbiAgICAgICAgICAgICAgbmFtZTogcGFjay5uYW1lLFxuICAgICAgICAgICAgICB2ZXJzaW9uLFxuICAgICAgICAgICAgICBlcnJvck1lc3NhZ2U6IGVycm9yLm1lc3NhZ2UsXG4gICAgICAgICAgICAgIGVycm9yU3RhY2s6IGVycm9yLnN0YWNrLFxuICAgICAgICAgICAgICBlcnJvclN0ZGVycjogZXJyb3Iuc3RkZXJyXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfSlcbiAgICAgICAgICBjb25zb2xlLmVycm9yKGBVcGRhdGluZyAke3RoaXMudHlwZX0gJHtwYWNrLm5hbWV9IHRvICR7dmVyc2lvbn0gZmFpbGVkOlxcbmAsIGVycm9yLCBlcnJvci5zdGRlcnIgIT0gbnVsbCA/IGVycm9yLnN0ZGVyciA6ICcnKVxuICAgICAgICAgIHJlamVjdChlcnJvcilcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICByZXNvbHZlKClcbiAgICAgICAgfVxuICAgICAgfSlcbiAgICB9KVxuICB9XG5cbiAgdW5pbnN0YWxsICgpIHtcbiAgICB0aGlzLnBhY2thZ2VNYW5hZ2VyLnVuaW5zdGFsbCh0aGlzLnBhY2ssIChlcnJvcikgPT4ge1xuICAgICAgaWYgKGVycm9yICE9IG51bGwpIHtcbiAgICAgICAgY29uc29sZS5lcnJvcihgVW5pbnN0YWxsaW5nICR7dGhpcy50eXBlfSAke3RoaXMucGFjay5uYW1lfSBmYWlsZWRgLCBlcnJvci5zdGFjayAhPSBudWxsID8gZXJyb3Iuc3RhY2sgOiBlcnJvciwgZXJyb3Iuc3RkZXJyKVxuICAgICAgfVxuICAgIH0pXG4gIH1cblxuICBpbnN0YWxsQWx0ZXJuYXRpdmUgKCkge1xuICAgIGNvbnN0IG1ldGFkYXRhID0gdGhpcy5nZXREZXByZWNhdGVkUGFja2FnZU1ldGFkYXRhKClcbiAgICBjb25zdCBsb2FkZWRQYWNrID0gYXRvbS5wYWNrYWdlcy5nZXRMb2FkZWRQYWNrYWdlKG1ldGFkYXRhID8gbWV0YWRhdGEuYWx0ZXJuYXRpdmUgOiBudWxsKVxuICAgIGlmICghbWV0YWRhdGEgfHwgIW1ldGFkYXRhLmhhc0FsdGVybmF0aXZlIHx8IG1ldGFkYXRhLmFsdGVybmF0aXZlID09PSAnY29yZScgfHwgbG9hZGVkUGFjaykge1xuICAgICAgcmV0dXJuXG4gICAgfVxuXG4gICAgdGhpcy5wYWNrYWdlTWFuYWdlci5pbnN0YWxsQWx0ZXJuYXRpdmUodGhpcy5wYWNrLCBtZXRhZGF0YS5hbHRlcm5hdGl2ZSwgKGVycm9yLCB7cGFjaywgYWx0ZXJuYXRpdmV9KSA9PiB7XG4gICAgICBpZiAoZXJyb3IgIT0gbnVsbCkge1xuICAgICAgICBjb25zb2xlLmVycm9yKGBJbnN0YWxsaW5nIGFsdGVybmF0aXZlIFxcYCR7YWx0ZXJuYXRpdmV9XFxgICR7dGhpcy50eXBlfSBmb3IgJHt0aGlzLnBhY2submFtZX0gZmFpbGVkYCwgZXJyb3Iuc3RhY2sgIT0gbnVsbCA/IGVycm9yLnN0YWNrIDogZXJyb3IsIGVycm9yLnN0ZGVycilcbiAgICAgIH1cbiAgICB9KVxuICB9XG59XG4iXX0=