(function() {
  var CSON, FunctionsURL, Promise, functionsPromise, path, request, sanitizeFunc;

  path = require('path');

  request = require('request');

  Promise = require('bluebird');

  CSON = require('season');

  FunctionsURL = 'https://raw.githubusercontent.com/less/less-docs/master/content/functions/data/functions.json';

  functionsPromise = new Promise(function(resolve) {
    return request({
      json: true,
      url: FunctionsURL
    }, function(error, response, properties) {
      if (error != null) {
        console.error(error.message);
        resolve(null);
      }
      if (response.statusCode !== 200) {
        console.error("Request failed: " + response.statusCode);
        resolve(null);
      }
      return resolve(properties);
    });
  });

  functionsPromise.then(function(results) {
    var builtins, config, configPath, func, functionType, functions, i, len, suggestions;
    suggestions = [];
    for (functionType in results) {
      functions = results[functionType];
      for (i = 0, len = functions.length; i < len; i++) {
        func = functions[i];
        suggestions.push({
          type: 'function',
          rightLabel: 'Less Builtin',
          snippet: sanitizeFunc(func.example),
          description: func.description,
          descriptionMoreURL: "http://lesscss.org/functions/#" + functionType + "-" + func.name
        });
      }
    }
    configPath = path.join(__dirname, 'settings', 'language-less.cson');
    config = CSON.readFileSync(configPath);
    builtins = config['.source.css.less .meta.property-value'].autocomplete.symbols.builtins;
    builtins.suggestions = suggestions;
    return CSON.writeFileSync(configPath, config);
  });

  sanitizeFunc = function(functionExample) {
    var argsRe;
    functionExample = functionExample.replace(';', '');
    functionExample = functionExample.replace(/\[, /g, ', [');
    functionExample = functionExample.replace(/\,] /g, '], ');
    argsRe = /\(([^\)]+)\)/;
    functionExample = functionExample.replace(argsRe, function(args) {
      var arg, index;
      args = argsRe.exec(args)[1];
      args = args.split(',');
      args = (function() {
        var i, len, results1;
        results1 = [];
        for (index = i = 0, len = args.length; i < len; index = ++i) {
          arg = args[index];
          results1.push("${" + (index + 1) + ":" + (arg.trim()) + "}");
        }
        return results1;
      })();
      return "(" + (args.join(', ')) + ")${" + (index + 1) + ":;}";
    });
    return functionExample + "$0";
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
