Object.defineProperty(exports, '__esModule', {
  value: true
});
exports.activate = activate;
exports.deactivate = deactivate;
exports.consumeStatusBar = consumeStatusBar;
exports.deserializeIncompatiblePackagesComponent = deserializeIncompatiblePackagesComponent;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/** @babel */

var _atom = require('atom');

var _viewUri = require('./view-uri');

var _viewUri2 = _interopRequireDefault(_viewUri);

var disposables = null;

function activate() {
  disposables = new _atom.CompositeDisposable();

  disposables.add(atom.workspace.addOpener(function (uri) {
    if (uri === _viewUri2['default']) {
      return deserializeIncompatiblePackagesComponent();
    }
  }));

  disposables.add(atom.commands.add('atom-workspace', {
    'incompatible-packages:view': function incompatiblePackagesView() {
      atom.workspace.open(_viewUri2['default']);
    }
  }));
}

function deactivate() {
  disposables.dispose();
}

function consumeStatusBar(statusBar) {
  var incompatibleCount = 0;
  for (var pack of atom.packages.getLoadedPackages()) {
    if (!pack.isCompatible()) incompatibleCount++;
  }

  if (incompatibleCount > 0) {
    (function () {
      var icon = createIcon(incompatibleCount);
      var tile = statusBar.addRightTile({ item: icon, priority: 200 });
      icon.element.addEventListener('click', function () {
        atom.commands.dispatch(icon.element, 'incompatible-packages:view');
      });
      disposables.add(new _atom.Disposable(function () {
        return tile.destroy();
      }));
    })();
  }
}

function deserializeIncompatiblePackagesComponent() {
  var IncompatiblePackagesComponent = require('./incompatible-packages-component');
  return new IncompatiblePackagesComponent(atom.packages);
}

function createIcon(count) {
  var StatusIconComponent = require('./status-icon-component');
  return new StatusIconComponent({ count: count });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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