"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _moment = _interopRequireDefault(require("moment"));

var _classnames = _interopRequireDefault(require("classnames"));

var _nodeEmoji = require("node-emoji");

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _commitView = _interopRequireDefault(require("./commit-view"));

var _timeago = _interopRequireDefault(require("./timeago"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class RecentCommitView extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "undoLastCommit", event => {
      event.stopPropagation();
      this.props.undoLastCommit();
    });

    this.refRoot = new _refHolder["default"]();
  }

  componentDidMount() {
    if (this.props.isSelected) {
      this.refRoot.map(root => root.scrollIntoViewIfNeeded(false));
    }
  }

  componentDidUpdate(prevProps) {
    if (this.props.isSelected && !prevProps.isSelected) {
      this.refRoot.map(root => root.scrollIntoViewIfNeeded(false));
    }
  }

  render() {
    const authorMoment = (0, _moment["default"])(this.props.commit.getAuthorDate() * 1000);
    const fullMessage = this.props.commit.getFullMessage();
    return _react["default"].createElement("li", {
      ref: this.refRoot.setter,
      className: (0, _classnames["default"])('github-RecentCommit', {
        'most-recent': this.props.isMostRecent,
        'is-selected': this.props.isSelected
      }),
      onClick: this.props.openCommit
    }, this.renderAuthors(), _react["default"].createElement("span", {
      className: "github-RecentCommit-message",
      title: (0, _nodeEmoji.emojify)(fullMessage)
    }, (0, _nodeEmoji.emojify)(this.props.commit.getMessageSubject())), this.props.isMostRecent && _react["default"].createElement("button", {
      className: "btn github-RecentCommit-undoButton",
      onClick: this.undoLastCommit
    }, "Undo"), _react["default"].createElement(_timeago["default"], {
      className: "github-RecentCommit-time",
      type: "time",
      displayStyle: "short",
      time: authorMoment,
      title: authorMoment.format('MMM Do, YYYY')
    }));
  }

  renderAuthor(email) {
    const match = email.match(/^(\d+)\+[^@]+@users.noreply.github.com$/);
    let avatarUrl;

    if (match) {
      avatarUrl = 'https://avatars.githubusercontent.com/u/' + match[1] + '?s=32';
    } else {
      avatarUrl = 'https://avatars.githubusercontent.com/u/e?email=' + encodeURIComponent(email) + '&s=32';
    }

    return _react["default"].createElement("img", {
      className: "github-RecentCommit-avatar",
      key: email,
      src: avatarUrl,
      title: email,
      alt: `${email}'s avatar'`
    });
  }

  renderAuthors() {
    const coAuthorEmails = this.props.commit.getCoAuthors().map(author => author.email);
    const authorEmails = [this.props.commit.getAuthorEmail(), ...coAuthorEmails];
    return _react["default"].createElement("span", {
      className: "github-RecentCommit-authors"
    }, authorEmails.map(this.renderAuthor));
  }

}

_defineProperty(RecentCommitView, "propTypes", {
  commit: _propTypes["default"].object.isRequired,
  undoLastCommit: _propTypes["default"].func.isRequired,
  isMostRecent: _propTypes["default"].bool.isRequired,
  openCommit: _propTypes["default"].func.isRequired,
  isSelected: _propTypes["default"].bool.isRequired
});

class RecentCommitsView extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "openSelectedCommit", () => this.props.openCommit({
      sha: this.props.selectedCommitSha,
      preserveFocus: false
    }));

    this.refRoot = new _refHolder["default"]();
  }

  setFocus(focus) {
    if (focus === this.constructor.focus.RECENT_COMMIT) {
      return this.refRoot.map(element => {
        element.focus();
        return true;
      }).getOr(false);
    }

    return false;
  }

  getFocus(element) {
    return this.refRoot.map(e => e.contains(element)).getOr(false) ? this.constructor.focus.RECENT_COMMIT : null;
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-RecentCommits",
      tabIndex: "-1",
      ref: this.refRoot.setter
    }, _react["default"].createElement(_commands["default"], {
      registry: this.props.commands,
      target: this.refRoot
    }, _react["default"].createElement(_commands.Command, {
      command: "core:move-down",
      callback: this.props.selectNextCommit
    }), _react["default"].createElement(_commands.Command, {
      command: "core:move-up",
      callback: this.props.selectPreviousCommit
    }), _react["default"].createElement(_commands.Command, {
      command: "github:dive",
      callback: this.openSelectedCommit
    })), this.renderCommits());
  }

  renderCommits() {
    if (this.props.commits.length === 0) {
      if (this.props.isLoading) {
        return _react["default"].createElement("div", {
          className: "github-RecentCommits-message"
        }, "Recent commits");
      } else {
        return _react["default"].createElement("div", {
          className: "github-RecentCommits-message"
        }, "Make your first commit");
      }
    } else {
      return _react["default"].createElement("ul", {
        className: "github-RecentCommits-list"
      }, this.props.commits.map((commit, i) => {
        return _react["default"].createElement(RecentCommitView, {
          key: commit.getSha(),
          isMostRecent: i === 0,
          commit: commit,
          undoLastCommit: this.props.undoLastCommit,
          openCommit: () => this.props.openCommit({
            sha: commit.getSha(),
            preserveFocus: true
          }),
          isSelected: this.props.selectedCommitSha === commit.getSha()
        });
      }));
    }
  }

  advanceFocusFrom(focus) {
    if (focus === this.constructor.focus.RECENT_COMMIT) {
      return Promise.resolve(this.constructor.focus.RECENT_COMMIT);
    }

    return Promise.resolve(null);
  }

  retreatFocusFrom(focus) {
    if (focus === this.constructor.focus.RECENT_COMMIT) {
      return Promise.resolve(_commitView["default"].lastFocus);
    }

    return Promise.resolve(null);
  }

}

exports["default"] = RecentCommitsView;

_defineProperty(RecentCommitsView, "propTypes", {
  // Model state
  commits: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  selectedCommitSha: _propTypes["default"].string.isRequired,
  // Atom environment
  commands: _propTypes["default"].object.isRequired,
  // Action methods
  undoLastCommit: _propTypes["default"].func.isRequired,
  openCommit: _propTypes["default"].func.isRequired,
  selectNextCommit: _propTypes["default"].func.isRequired,
  selectPreviousCommit: _propTypes["default"].func.isRequired
});

_defineProperty(RecentCommitsView, "focus", {
  RECENT_COMMIT: Symbol('recent_commit')
});

_defineProperty(RecentCommitsView, "firstFocus", RecentCommitsView.focus.RECENT_COMMIT);

_defineProperty(RecentCommitsView, "lastFocus", RecentCommitsView.focus.RECENT_COMMIT);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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