"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _accordion = _interopRequireDefault(require("./accordion"));

var _timeago = _interopRequireDefault(require("./timeago"));

var _statusDonutChart = _interopRequireDefault(require("./status-donut-chart"));

var _checkSuitesAccumulator = _interopRequireDefault(require("../containers/accumulators/check-suites-accumulator"));

var _queryErrorTile = _interopRequireDefault(require("./query-error-tile"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishListView extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "renderReviewsButton", () => {
      if (!this.props.needReviewsButton || this.props.issueishes.length < 1) {
        return null;
      }

      return _react["default"].createElement("button", {
        className: "btn btn-primary btn-sm github-IssueishList-openReviewsButton",
        onClick: this.openReviews
      }, "See reviews");
    });

    _defineProperty(this, "openReviews", e => {
      e.stopPropagation();
      this.props.openReviews(this.props.issueishes[0]);
    });

    _defineProperty(this, "renderIssueish", issueish => {
      return _react["default"].createElement(_checkSuitesAccumulator["default"], {
        commit: issueish.getLatestCommit()
      }, ({
        runsBySuite
      }) => {
        issueish.setCheckRuns(runsBySuite);
        return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement("img", {
          className: "github-IssueishList-item github-IssueishList-item--avatar",
          src: issueish.getAuthorAvatarURL(32),
          title: issueish.getAuthorLogin(),
          alt: issueish.getAuthorLogin()
        }), _react["default"].createElement("span", {
          className: "github-IssueishList-item github-IssueishList-item--title"
        }, issueish.getTitle()), _react["default"].createElement("span", {
          className: "github-IssueishList-item github-IssueishList-item--number"
        }, "#", issueish.getNumber()), this.renderStatusSummary(issueish.getStatusCounts()), _react["default"].createElement(_timeago["default"], {
          time: issueish.getCreatedAt(),
          displayStyle: "short",
          className: "github-IssueishList-item github-IssueishList-item--age"
        }), _react["default"].createElement(_octicon["default"], {
          icon: "ellipses",
          className: "github-IssueishList-item github-IssueishList-item--menu",
          onClick: event => this.showActionsMenu(event, issueish)
        }));
      });
    });

    _defineProperty(this, "renderLoadingTile", () => {
      return _react["default"].createElement("div", {
        className: "github-IssueishList-loading"
      }, "Loading");
    });

    _defineProperty(this, "renderEmptyTile", () => {
      if (this.props.error) {
        return _react["default"].createElement(_queryErrorTile["default"], {
          error: this.props.error
        });
      }

      if (this.props.emptyComponent) {
        const EmptyComponent = this.props.emptyComponent;
        return _react["default"].createElement(EmptyComponent, null);
      }

      return null;
    });

    _defineProperty(this, "renderMoreTile", () => {
      /* eslint-disable jsx-a11y/anchor-is-valid */
      if (this.props.onMoreClick) {
        return _react["default"].createElement("div", {
          className: "github-IssueishList-more"
        }, _react["default"].createElement("a", {
          onClick: this.props.onMoreClick
        }, "More..."));
      }

      return null;
    });
  }

  render() {
    return _react["default"].createElement(_accordion["default"], {
      leftTitle: this.props.title,
      isLoading: this.props.isLoading,
      results: this.props.issueishes,
      total: this.props.total,
      loadingComponent: this.renderLoadingTile,
      emptyComponent: this.renderEmptyTile,
      moreComponent: this.renderMoreTile,
      reviewsButton: this.renderReviewsButton,
      onClickItem: this.props.onIssueishClick
    }, this.renderIssueish);
  }

  showActionsMenu(event, issueish) {
    event.preventDefault();
    event.stopPropagation();
    this.props.showActionsMenu(issueish);
  }

  renderStatusSummary(statusCounts) {
    if (['success', 'failure', 'pending'].every(kind => statusCounts[kind] === 0)) {
      return _react["default"].createElement(_octicon["default"], {
        className: "github-IssueishList-item github-IssueishList-item--status",
        icon: "dash"
      });
    }

    if (statusCounts.success > 0 && statusCounts.failure === 0 && statusCounts.pending === 0) {
      return _react["default"].createElement(_octicon["default"], {
        className: "github-IssueishList-item github-IssueishList-item--status",
        icon: "check"
      });
    }

    if (statusCounts.success === 0 && statusCounts.failure > 0 && statusCounts.pending === 0) {
      return _react["default"].createElement(_octicon["default"], {
        className: "github-IssueishList-item github-IssueishList-item--status",
        icon: "x"
      });
    }

    return _react["default"].createElement(_statusDonutChart["default"], _extends({}, statusCounts, {
      className: "github-IssueishList-item github-IssueishList-item--status"
    }));
  }

}

exports["default"] = IssueishListView;

_defineProperty(IssueishListView, "propTypes", {
  title: _propTypes["default"].string.isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  total: _propTypes["default"].number.isRequired,
  issueishes: _propTypes["default"].arrayOf(_propTypes2.IssueishPropType).isRequired,
  repository: _propTypes["default"].shape({
    defaultBranchRef: _propTypes["default"].shape({
      prefix: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired
    })
  }),
  needReviewsButton: _propTypes["default"].bool,
  onIssueishClick: _propTypes["default"].func.isRequired,
  onMoreClick: _propTypes["default"].func,
  openReviews: _propTypes["default"].func.isRequired,
  openOnGitHub: _propTypes["default"].func.isRequired,
  showActionsMenu: _propTypes["default"].func.isRequired,
  emptyComponent: _propTypes["default"].func,
  error: _propTypes["default"].object
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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