"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GithubLoginView extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'handleLoginClick', 'handleCancelTokenClick', 'handleSubmitTokenClick', 'handleSubmitToken', 'handleTokenChange');
    this.state = {
      loggingIn: false,
      token: ''
    };
  }

  render() {
    let subview;

    if (this.state.loggingIn) {
      subview = this.renderTokenInput();
    } else {
      subview = this.renderLogin();
    }

    return _react["default"].createElement("div", {
      className: "github-GithubLoginView"
    }, subview);
  }

  renderLogin() {
    return _react["default"].createElement("div", {
      className: "github-GithubLoginView-Subview"
    }, _react["default"].createElement("div", {
      className: "github-GitHub-LargeIcon icon icon-mark-github"
    }), _react["default"].createElement("h1", null, "Log in to GitHub"), this.props.children, _react["default"].createElement("button", {
      onClick: this.handleLoginClick,
      className: "btn btn-primary icon icon-octoface"
    }, "Login"));
  }

  renderTokenInput() {
    return _react["default"].createElement("form", {
      className: "github-GithubLoginView-Subview",
      onSubmit: this.handleSubmitToken
    }, _react["default"].createElement("div", {
      className: "github-GitHub-LargeIcon icon icon-mark-github"
    }), _react["default"].createElement("h1", null, "Enter Token"), _react["default"].createElement("ol", null, _react["default"].createElement("li", null, "Visit ", _react["default"].createElement("a", {
      href: "https://github.atom.io/login"
    }, "github.atom.io/login"), " to generate an authentication token."), _react["default"].createElement("li", null, "Enter the token below:")), _react["default"].createElement("input", {
      type: "text",
      className: "input-text native-key-bindings",
      placeholder: "Enter your token...",
      value: this.state.token,
      onChange: this.handleTokenChange
    }), _react["default"].createElement("ul", null, _react["default"].createElement("li", null, _react["default"].createElement("button", {
      type: "button",
      onClick: this.handleCancelTokenClick,
      className: "btn icon icon-remove-close"
    }, "Cancel")), _react["default"].createElement("li", null, _react["default"].createElement("button", {
      type: "submit",
      onClick: this.handleSubmitTokenClick,
      className: "btn btn-primary icon icon-check"
    }, "Login"))));
  }

  handleLoginClick() {
    this.setState({
      loggingIn: true
    });
  }

  handleCancelTokenClick(e) {
    e.preventDefault();
    this.setState({
      loggingIn: false
    });
  }

  handleSubmitTokenClick(e) {
    e.preventDefault();
    this.handleSubmitToken();
  }

  handleSubmitToken() {
    this.props.onLogin(this.state.token);
  }

  handleTokenChange(e) {
    this.setState({
      token: e.target.value
    });
  }

}

exports["default"] = GithubLoginView;

_defineProperty(GithubLoginView, "propTypes", {
  children: _propTypes["default"].node,
  onLogin: _propTypes["default"].func
});

_defineProperty(GithubLoginView, "defaultProps", {
  children: _react["default"].createElement("div", {
    className: "initialize-repo-description"
  }, _react["default"].createElement("span", null, "Log in to GitHub to access PR information and more!")),
  onLogin: token => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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