"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _nodeEmoji = require("node-emoji");

var _moment = _interopRequireDefault(require("moment"));

var _multiFilePatchController = _interopRequireDefault(require("../controllers/multi-file-patch-controller"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CommitDetailView extends _react["default"].Component {
  constructor(props) {
    super(props);
    this.refRoot = new _refHolder["default"]();
  }

  render() {
    const commit = this.props.commit;
    return _react["default"].createElement("div", {
      className: "github-CommitDetailView",
      ref: this.refRoot.setter
    }, this.renderCommands(), _react["default"].createElement("div", {
      className: "github-CommitDetailView-header native-key-bindings",
      tabIndex: "-1"
    }, _react["default"].createElement("div", {
      className: "github-CommitDetailView-commit"
    }, _react["default"].createElement("h3", {
      className: "github-CommitDetailView-title"
    }, (0, _nodeEmoji.emojify)(commit.getMessageSubject())), _react["default"].createElement("div", {
      className: "github-CommitDetailView-meta"
    }, this.renderAuthors(), _react["default"].createElement("span", {
      className: "github-CommitDetailView-metaText"
    }, this.getAuthorInfo(), " committed ", this.humanizeTimeSince(commit.getAuthorDate())), _react["default"].createElement("div", {
      className: "github-CommitDetailView-sha"
    }, this.renderDotComLink())), this.renderShowMoreButton(), this.renderCommitMessageBody())), _react["default"].createElement(_multiFilePatchController["default"], _extends({
      multiFilePatch: commit.getMultiFileDiff(),
      surface: this.props.surfaceCommit
    }, this.props)));
  }

  renderCommands() {
    return _react["default"].createElement(_commands["default"], {
      registry: this.props.commands,
      target: this.refRoot
    }, _react["default"].createElement(_commands.Command, {
      command: "github:surface",
      callback: this.props.surfaceCommit
    }));
  }

  renderCommitMessageBody() {
    const collapsed = this.props.messageCollapsible && !this.props.messageOpen;
    return _react["default"].createElement("pre", {
      className: "github-CommitDetailView-moreText"
    }, collapsed ? this.props.commit.abbreviatedBody() : this.props.commit.getMessageBody());
  }

  renderShowMoreButton() {
    if (!this.props.messageCollapsible) {
      return null;
    }

    const buttonText = this.props.messageOpen ? 'Show Less' : 'Show More';
    return _react["default"].createElement("button", {
      className: "github-CommitDetailView-moreButton",
      onClick: this.props.toggleMessage
    }, buttonText);
  }

  humanizeTimeSince(date) {
    return (0, _moment["default"])(date * 1000).fromNow();
  }

  renderDotComLink() {
    const remote = this.props.currentRemote;
    const sha = this.props.commit.getSha();

    if (remote.isGithubRepo() && this.props.isCommitPushed) {
      const repoUrl = `https://github.com/${remote.getOwner()}/${remote.getRepo()}`;
      return _react["default"].createElement("a", {
        href: `${repoUrl}/commit/${sha}`,
        title: `open commit ${sha} on GitHub.com`
      }, sha);
    } else {
      return _react["default"].createElement("span", null, sha);
    }
  }

  getAuthorInfo() {
    const commit = this.props.commit;
    const coAuthorCount = commit.getCoAuthors().length;

    if (coAuthorCount === 0) {
      return commit.getAuthorName();
    } else if (coAuthorCount === 1) {
      return `${commit.getAuthorName()} and ${commit.getCoAuthors()[0].name}`;
    } else {
      return `${commit.getAuthorName()} and ${coAuthorCount} others`;
    }
  }

  renderAuthor(email) {
    const match = email.match(/^(\d+)\+[^@]+@users.noreply.github.com$/);
    let avatarUrl;

    if (match) {
      avatarUrl = 'https://avatars.githubusercontent.com/u/' + match[1] + '?s=32';
    } else {
      avatarUrl = 'https://avatars.githubusercontent.com/u/e?email=' + encodeURIComponent(email) + '&s=32';
    }

    return _react["default"].createElement("img", {
      className: "github-CommitDetailView-avatar github-RecentCommit-avatar",
      key: email,
      src: avatarUrl,
      title: email,
      alt: `${email}'s avatar'`
    });
  }

  renderAuthors() {
    const coAuthorEmails = this.props.commit.getCoAuthors().map(author => author.email);
    const authorEmails = [this.props.commit.getAuthorEmail(), ...coAuthorEmails];
    return _react["default"].createElement("span", {
      className: "github-CommitDetailView-authors github-RecentCommit-authors"
    }, authorEmails.map(this.renderAuthor));
  }

}

exports["default"] = CommitDetailView;

_defineProperty(CommitDetailView, "drilledPropTypes", {
  // Model properties
  repository: _propTypes["default"].object.isRequired,
  commit: _propTypes["default"].object.isRequired,
  currentRemote: _propTypes["default"].object.isRequired,
  isCommitPushed: _propTypes["default"].bool.isRequired,
  itemType: _propTypes["default"].func.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  keymaps: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  // Action functions
  destroy: _propTypes["default"].func.isRequired,
  surfaceCommit: _propTypes["default"].func.isRequired
});

_defineProperty(CommitDetailView, "propTypes", _objectSpread2({}, CommitDetailView.drilledPropTypes, {
  // Controller state
  messageCollapsible: _propTypes["default"].bool.isRequired,
  messageOpen: _propTypes["default"].bool.isRequired,
  // Action functions
  toggleMessage: _propTypes["default"].func.isRequired
}));
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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