"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _atom = require("atom");

var _url = _interopRequireDefault(require("url"));

var _path = _interopRequireDefault(require("path"));

var _atomTextEditor = _interopRequireDefault(require("../atom/atom-text-editor"));

var _autofocus = _interopRequireDefault(require("../autofocus"));

var _dialogView = _interopRequireDefault(require("./dialog-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CloneDialog extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "accept", () => {
      const sourceURL = this.sourceURL.getText();
      const destinationPath = this.destinationPath.getText();

      if (sourceURL === '' || destinationPath === '') {
        return Promise.resolve();
      }

      return this.props.request.accept(sourceURL, destinationPath);
    });

    _defineProperty(this, "didChangeSourceUrl", () => {
      if (!this.destinationPathModified) {
        const name = _path["default"].basename(_url["default"].parse(this.sourceURL.getText()).pathname, '.git') || '';

        if (name.length > 0) {
          const proposedPath = _path["default"].join(this.props.config.get('core.projectHome'), name);

          this.destinationPath.setText(proposedPath);
          this.destinationPathModified = false;
        }
      }

      this.setAcceptEnablement();
    });

    _defineProperty(this, "didChangeDestinationPath", () => {
      this.destinationPathModified = true;
      this.setAcceptEnablement();
    });

    _defineProperty(this, "setAcceptEnablement", () => {
      const enabled = !this.sourceURL.isEmpty() && !this.destinationPath.isEmpty();

      if (enabled !== this.state.acceptEnabled) {
        this.setState({
          acceptEnabled: enabled
        });
      }
    });

    const params = this.props.request.getParams();
    this.sourceURL = new _atom.TextBuffer({
      text: params.sourceURL
    });
    this.destinationPath = new _atom.TextBuffer({
      text: params.destPath || this.props.config.get('core.projectHome')
    });
    this.destinationPathModified = false;
    this.state = {
      acceptEnabled: false
    };
    this.subs = new _eventKit.CompositeDisposable(this.sourceURL.onDidChange(this.didChangeSourceUrl), this.destinationPath.onDidChange(this.didChangeDestinationPath));
    this.autofocus = new _autofocus["default"]();
  }

  render() {
    return _react["default"].createElement(_dialogView["default"], {
      progressMessage: "cloning...",
      acceptEnabled: this.state.acceptEnabled,
      acceptClassNames: "icon icon-repo-clone",
      acceptText: "Clone",
      accept: this.accept,
      cancel: this.props.request.cancel,
      autofocus: this.autofocus,
      inProgress: this.props.inProgress,
      error: this.props.error,
      workspace: this.props.workspace,
      commands: this.props.commands
    }, _react["default"].createElement("label", {
      className: "github-DialogLabel"
    }, "Clone from", _react["default"].createElement(_atomTextEditor["default"], {
      ref: this.autofocus.target,
      className: "github-Clone-sourceURL",
      mini: true,
      readOnly: this.props.inProgress,
      buffer: this.sourceURL
    })), _react["default"].createElement("label", {
      className: "github-DialogLabel"
    }, "To directory", _react["default"].createElement(_atomTextEditor["default"], {
      className: "github-Clone-destinationPath",
      mini: true,
      readOnly: this.props.inProgress,
      buffer: this.destinationPath
    })));
  }

  componentDidMount() {
    this.autofocus.trigger();
  }

}

exports["default"] = CloneDialog;

_defineProperty(CloneDialog, "propTypes", {
  // Model
  request: _propTypes["default"].shape({
    getParams: _propTypes["default"].func.isRequired,
    accept: _propTypes["default"].func.isRequired,
    cancel: _propTypes["default"].func.isRequired
  }).isRequired,
  inProgress: _propTypes["default"].bool,
  error: _propTypes["default"].instanceOf(Error),
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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