"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _electron = require("electron");

var _atom = require("atom");

var _atomTextEditor = _interopRequireDefault(require("../atom/atom-text-editor"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _reporterProxy = require("../reporter-proxy");

var _commands = _interopRequireWildcard(require("../atom/commands"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const {
  Menu,
  MenuItem
} = _electron.remote;

class ActionableReviewView extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "onCancel", () => {
      if (this.buffer.getText() === this.props.originalContent.body) {
        this.setState({
          editing: false
        });
      } else {
        const choice = this.props.confirm({
          message: 'Are you sure you want to discard your unsaved changes?',
          buttons: ['OK', 'Cancel']
        });

        if (choice === 0) {
          this.setState({
            editing: false
          });
        }
      }
    });

    _defineProperty(this, "onSubmitUpdate", async () => {
      const text = this.buffer.getText();

      if (text === this.props.originalContent.body || text === '') {
        this.setState({
          editing: false
        });
        return;
      }

      try {
        await this.props.contentUpdater(this.props.originalContent.id, text);
        this.setState({
          editing: false
        });
      } catch (e) {
        this.buffer.setText(text);
      }
    });

    _defineProperty(this, "reportAbuse", (commentUrl, author) => {
      return new Promise((resolve, reject) => {
        const url = 'https://github.com/contact/report-content?report=' + `${encodeURIComponent(author)}&content_url=${encodeURIComponent(commentUrl)}`;

        _electron.shell.openExternal(url, {}, err => {
          if (err) {
            reject(err);
          } else {
            resolve();
            (0, _reporterProxy.addEvent)('report-abuse', {
              "package": 'github',
              component: this.constructor.name
            });
          }
        });
      });
    });

    _defineProperty(this, "openOnGitHub", url => {
      return new Promise((resolve, reject) => {
        _electron.shell.openExternal(url, {}, err => {
          if (err) {
            reject(err);
          } else {
            resolve();
            (0, _reporterProxy.addEvent)('open-comment-in-browser', {
              "package": 'github',
              component: this.constructor.name
            });
          }
        });
      });
    });

    _defineProperty(this, "showActionsMenu", (event, content, author) => {
      event.preventDefault();
      const menu = this.props.createMenu();

      if (content.viewerCanUpdate) {
        menu.append(this.props.createMenuItem({
          label: 'Edit',
          click: () => this.setState({
            editing: true
          })
        }));
      }

      menu.append(this.props.createMenuItem({
        label: 'Open on GitHub',
        click: () => this.openOnGitHub(content.url)
      }));
      menu.append(this.props.createMenuItem({
        label: 'Report abuse',
        click: () => this.reportAbuse(content.url, author.login)
      }));
      menu.popup(_electron.remote.getCurrentWindow());
    });

    this.refEditor = new _refHolder["default"]();
    this.refRoot = new _refHolder["default"]();
    this.buffer = new _atom.TextBuffer();
    this.state = {
      editing: false
    };
  }

  componentDidUpdate(prevProps, prevState) {
    if (this.state.editing && !prevState.editing) {
      this.buffer.setText(this.props.originalContent.body);
      this.refEditor.map(e => e.getElement().focus());
    }
  }

  render() {
    return this.state.editing ? this.renderEditor() : this.props.render(this.showActionsMenu);
  }

  renderEditor() {
    const className = (0, _classnames["default"])('github-Review-editable', {
      'github-Review-editable--disabled': this.props.isPosting
    });
    return _react["default"].createElement("div", {
      className: className,
      ref: this.refRoot.setter
    }, this.renderCommands(), _react["default"].createElement(_atomTextEditor["default"], {
      buffer: this.buffer,
      lineNumberGutterVisible: false,
      softWrapped: true,
      autoHeight: true,
      readOnly: this.props.isPosting,
      refModel: this.refEditor
    }), _react["default"].createElement("footer", {
      className: "github-Review-editable-footer"
    }, _react["default"].createElement("button", {
      className: "github-Review-editableCancelButton btn btn-sm",
      title: "Cancel editing comment",
      disabled: this.props.isPosting,
      onClick: this.onCancel
    }, "Cancel"), _react["default"].createElement("button", {
      className: "github-Review-updateCommentButton btn btn-sm btn-primary",
      title: "Update comment",
      disabled: this.props.isPosting,
      onClick: this.onSubmitUpdate
    }, "Update comment")));
  }

  renderCommands() {
    return _react["default"].createElement(_commands["default"], {
      registry: this.props.commands,
      target: this.refRoot
    }, _react["default"].createElement(_commands.Command, {
      command: "github:submit-comment",
      callback: this.onSubmitUpdate
    }), _react["default"].createElement(_commands.Command, {
      command: "core:cancel",
      callback: this.onCancel
    }));
  }

}

exports["default"] = ActionableReviewView;

_defineProperty(ActionableReviewView, "propTypes", {
  // Model
  originalContent: _propTypes["default"].object.isRequired,
  isPosting: _propTypes["default"].bool,
  // Atom environment
  commands: _propTypes["default"].object.isRequired,
  confirm: _propTypes["default"].func.isRequired,
  // Action methods
  contentUpdater: _propTypes["default"].func.isRequired,
  createMenu: _propTypes["default"].func,
  createMenuItem: _propTypes["default"].func,
  // Render prop
  render: _propTypes["default"].func.isRequired
});

_defineProperty(ActionableReviewView, "defaultProps", {
  createMenu:
  /* istanbul ignore next */
  () => new Menu(),
  createMenuItem:
  /* istanbul ignore next */
  (...args) => new MenuItem(...args)
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFjdGlvbmFibGUtcmV2aWV3LXZpZXcuanMiXSwibmFtZXMiOlsiTWVudSIsIk1lbnVJdGVtIiwicmVtb3RlIiwiQWN0aW9uYWJsZVJldmlld1ZpZXciLCJSZWFjdCIsIkNvbXBvbmVudCIsImNvbnN0cnVjdG9yIiwicHJvcHMiLCJidWZmZXIiLCJnZXRUZXh0Iiwib3JpZ2luYWxDb250ZW50IiwiYm9keSIsInNldFN0YXRlIiwiZWRpdGluZyIsImNob2ljZSIsImNvbmZpcm0iLCJtZXNzYWdlIiwiYnV0dG9ucyIsInRleHQiLCJjb250ZW50VXBkYXRlciIsImlkIiwiZSIsInNldFRleHQiLCJjb21tZW50VXJsIiwiYXV0aG9yIiwiUHJvbWlzZSIsInJlc29sdmUiLCJyZWplY3QiLCJ1cmwiLCJlbmNvZGVVUklDb21wb25lbnQiLCJzaGVsbCIsIm9wZW5FeHRlcm5hbCIsImVyciIsImNvbXBvbmVudCIsIm5hbWUiLCJldmVudCIsImNvbnRlbnQiLCJwcmV2ZW50RGVmYXVsdCIsIm1lbnUiLCJjcmVhdGVNZW51Iiwidmlld2VyQ2FuVXBkYXRlIiwiYXBwZW5kIiwiY3JlYXRlTWVudUl0ZW0iLCJsYWJlbCIsImNsaWNrIiwib3Blbk9uR2l0SHViIiwicmVwb3J0QWJ1c2UiLCJsb2dpbiIsInBvcHVwIiwiZ2V0Q3VycmVudFdpbmRvdyIsInJlZkVkaXRvciIsIlJlZkhvbGRlciIsInJlZlJvb3QiLCJUZXh0QnVmZmVyIiwic3RhdGUiLCJjb21wb25lbnREaWRVcGRhdGUiLCJwcmV2UHJvcHMiLCJwcmV2U3RhdGUiLCJtYXAiLCJnZXRFbGVtZW50IiwiZm9jdXMiLCJyZW5kZXIiLCJyZW5kZXJFZGl0b3IiLCJzaG93QWN0aW9uc01lbnUiLCJjbGFzc05hbWUiLCJpc1Bvc3RpbmciLCJzZXR0ZXIiLCJyZW5kZXJDb21tYW5kcyIsIm9uQ2FuY2VsIiwib25TdWJtaXRVcGRhdGUiLCJjb21tYW5kcyIsIlByb3BUeXBlcyIsIm9iamVjdCIsImlzUmVxdWlyZWQiLCJib29sIiwiZnVuYyIsImFyZ3MiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7Ozs7Ozs7QUFDQSxNQUFNO0FBQUNBLEVBQUFBLElBQUQ7QUFBT0MsRUFBQUE7QUFBUCxJQUFtQkMsZ0JBQXpCOztBQUVlLE1BQU1DLG9CQUFOLFNBQW1DQyxrQkFBTUMsU0FBekMsQ0FBbUQ7QUF3QmhFQyxFQUFBQSxXQUFXLENBQUNDLEtBQUQsRUFBUTtBQUNqQixVQUFNQSxLQUFOOztBQURpQixzQ0E4RFIsTUFBTTtBQUNmLFVBQUksS0FBS0MsTUFBTCxDQUFZQyxPQUFaLE9BQTBCLEtBQUtGLEtBQUwsQ0FBV0csZUFBWCxDQUEyQkMsSUFBekQsRUFBK0Q7QUFDN0QsYUFBS0MsUUFBTCxDQUFjO0FBQUNDLFVBQUFBLE9BQU8sRUFBRTtBQUFWLFNBQWQ7QUFDRCxPQUZELE1BRU87QUFDTCxjQUFNQyxNQUFNLEdBQUcsS0FBS1AsS0FBTCxDQUFXUSxPQUFYLENBQW1CO0FBQ2hDQyxVQUFBQSxPQUFPLEVBQUUsd0RBRHVCO0FBRWhDQyxVQUFBQSxPQUFPLEVBQUUsQ0FBQyxJQUFELEVBQU8sUUFBUDtBQUZ1QixTQUFuQixDQUFmOztBQUlBLFlBQUlILE1BQU0sS0FBSyxDQUFmLEVBQWtCO0FBQ2hCLGVBQUtGLFFBQUwsQ0FBYztBQUFDQyxZQUFBQSxPQUFPLEVBQUU7QUFBVixXQUFkO0FBQ0Q7QUFDRjtBQUNGLEtBMUVrQjs7QUFBQSw0Q0E0RUYsWUFBWTtBQUMzQixZQUFNSyxJQUFJLEdBQUcsS0FBS1YsTUFBTCxDQUFZQyxPQUFaLEVBQWI7O0FBQ0EsVUFBSVMsSUFBSSxLQUFLLEtBQUtYLEtBQUwsQ0FBV0csZUFBWCxDQUEyQkMsSUFBcEMsSUFBNENPLElBQUksS0FBSyxFQUF6RCxFQUE2RDtBQUMzRCxhQUFLTixRQUFMLENBQWM7QUFBQ0MsVUFBQUEsT0FBTyxFQUFFO0FBQVYsU0FBZDtBQUNBO0FBQ0Q7O0FBRUQsVUFBSTtBQUNGLGNBQU0sS0FBS04sS0FBTCxDQUFXWSxjQUFYLENBQTBCLEtBQUtaLEtBQUwsQ0FBV0csZUFBWCxDQUEyQlUsRUFBckQsRUFBeURGLElBQXpELENBQU47QUFDQSxhQUFLTixRQUFMLENBQWM7QUFBQ0MsVUFBQUEsT0FBTyxFQUFFO0FBQVYsU0FBZDtBQUNELE9BSEQsQ0FHRSxPQUFPUSxDQUFQLEVBQVU7QUFDVixhQUFLYixNQUFMLENBQVljLE9BQVosQ0FBb0JKLElBQXBCO0FBQ0Q7QUFDRixLQXpGa0I7O0FBQUEseUNBMkZMLENBQUNLLFVBQUQsRUFBYUMsTUFBYixLQUF3QjtBQUNwQyxhQUFPLElBQUlDLE9BQUosQ0FBWSxDQUFDQyxPQUFELEVBQVVDLE1BQVYsS0FBcUI7QUFDdEMsY0FBTUMsR0FBRyxHQUFHLHNEQUNULEdBQUVDLGtCQUFrQixDQUFDTCxNQUFELENBQVMsZ0JBQWVLLGtCQUFrQixDQUFDTixVQUFELENBQWEsRUFEOUU7O0FBRUFPLHdCQUFNQyxZQUFOLENBQW1CSCxHQUFuQixFQUF3QixFQUF4QixFQUE0QkksR0FBRyxJQUFJO0FBQ2pDLGNBQUlBLEdBQUosRUFBUztBQUFFTCxZQUFBQSxNQUFNLENBQUNLLEdBQUQsQ0FBTjtBQUFjLFdBQXpCLE1BQStCO0FBQzdCTixZQUFBQSxPQUFPO0FBQ1AseUNBQVMsY0FBVCxFQUF5QjtBQUFDLHlCQUFTLFFBQVY7QUFBb0JPLGNBQUFBLFNBQVMsRUFBRSxLQUFLM0IsV0FBTCxDQUFpQjRCO0FBQWhELGFBQXpCO0FBQ0Q7QUFDRixTQUxEO0FBTUQsT0FUTSxDQUFQO0FBVUQsS0F0R2tCOztBQUFBLDBDQXdHSk4sR0FBRyxJQUFJO0FBQ3BCLGFBQU8sSUFBSUgsT0FBSixDQUFZLENBQUNDLE9BQUQsRUFBVUMsTUFBVixLQUFxQjtBQUN0Q0csd0JBQU1DLFlBQU4sQ0FBbUJILEdBQW5CLEVBQXdCLEVBQXhCLEVBQTRCSSxHQUFHLElBQUk7QUFDakMsY0FBSUEsR0FBSixFQUFTO0FBQUVMLFlBQUFBLE1BQU0sQ0FBQ0ssR0FBRCxDQUFOO0FBQWMsV0FBekIsTUFBK0I7QUFDN0JOLFlBQUFBLE9BQU87QUFDUCx5Q0FBUyx5QkFBVCxFQUFvQztBQUFDLHlCQUFTLFFBQVY7QUFBb0JPLGNBQUFBLFNBQVMsRUFBRSxLQUFLM0IsV0FBTCxDQUFpQjRCO0FBQWhELGFBQXBDO0FBQ0Q7QUFDRixTQUxEO0FBTUQsT0FQTSxDQUFQO0FBUUQsS0FqSGtCOztBQUFBLDZDQW1IRCxDQUFDQyxLQUFELEVBQVFDLE9BQVIsRUFBaUJaLE1BQWpCLEtBQTRCO0FBQzVDVyxNQUFBQSxLQUFLLENBQUNFLGNBQU47QUFFQSxZQUFNQyxJQUFJLEdBQUcsS0FBSy9CLEtBQUwsQ0FBV2dDLFVBQVgsRUFBYjs7QUFFQSxVQUFJSCxPQUFPLENBQUNJLGVBQVosRUFBNkI7QUFDM0JGLFFBQUFBLElBQUksQ0FBQ0csTUFBTCxDQUFZLEtBQUtsQyxLQUFMLENBQVdtQyxjQUFYLENBQTBCO0FBQ3BDQyxVQUFBQSxLQUFLLEVBQUUsTUFENkI7QUFFcENDLFVBQUFBLEtBQUssRUFBRSxNQUFNLEtBQUtoQyxRQUFMLENBQWM7QUFBQ0MsWUFBQUEsT0FBTyxFQUFFO0FBQVYsV0FBZDtBQUZ1QixTQUExQixDQUFaO0FBSUQ7O0FBRUR5QixNQUFBQSxJQUFJLENBQUNHLE1BQUwsQ0FBWSxLQUFLbEMsS0FBTCxDQUFXbUMsY0FBWCxDQUEwQjtBQUNwQ0MsUUFBQUEsS0FBSyxFQUFFLGdCQUQ2QjtBQUVwQ0MsUUFBQUEsS0FBSyxFQUFFLE1BQU0sS0FBS0MsWUFBTCxDQUFrQlQsT0FBTyxDQUFDUixHQUExQjtBQUZ1QixPQUExQixDQUFaO0FBS0FVLE1BQUFBLElBQUksQ0FBQ0csTUFBTCxDQUFZLEtBQUtsQyxLQUFMLENBQVdtQyxjQUFYLENBQTBCO0FBQ3BDQyxRQUFBQSxLQUFLLEVBQUUsY0FENkI7QUFFcENDLFFBQUFBLEtBQUssRUFBRSxNQUFNLEtBQUtFLFdBQUwsQ0FBaUJWLE9BQU8sQ0FBQ1IsR0FBekIsRUFBOEJKLE1BQU0sQ0FBQ3VCLEtBQXJDO0FBRnVCLE9BQTFCLENBQVo7QUFLQVQsTUFBQUEsSUFBSSxDQUFDVSxLQUFMLENBQVc5QyxpQkFBTytDLGdCQUFQLEVBQVg7QUFDRCxLQTFJa0I7O0FBRWpCLFNBQUtDLFNBQUwsR0FBaUIsSUFBSUMscUJBQUosRUFBakI7QUFDQSxTQUFLQyxPQUFMLEdBQWUsSUFBSUQscUJBQUosRUFBZjtBQUNBLFNBQUszQyxNQUFMLEdBQWMsSUFBSTZDLGdCQUFKLEVBQWQ7QUFDQSxTQUFLQyxLQUFMLEdBQWE7QUFBQ3pDLE1BQUFBLE9BQU8sRUFBRTtBQUFWLEtBQWI7QUFDRDs7QUFFRDBDLEVBQUFBLGtCQUFrQixDQUFDQyxTQUFELEVBQVlDLFNBQVosRUFBdUI7QUFDdkMsUUFBSSxLQUFLSCxLQUFMLENBQVd6QyxPQUFYLElBQXNCLENBQUM0QyxTQUFTLENBQUM1QyxPQUFyQyxFQUE4QztBQUM1QyxXQUFLTCxNQUFMLENBQVljLE9BQVosQ0FBb0IsS0FBS2YsS0FBTCxDQUFXRyxlQUFYLENBQTJCQyxJQUEvQztBQUNBLFdBQUt1QyxTQUFMLENBQWVRLEdBQWYsQ0FBbUJyQyxDQUFDLElBQUlBLENBQUMsQ0FBQ3NDLFVBQUYsR0FBZUMsS0FBZixFQUF4QjtBQUNEO0FBQ0Y7O0FBRURDLEVBQUFBLE1BQU0sR0FBRztBQUNQLFdBQU8sS0FBS1AsS0FBTCxDQUFXekMsT0FBWCxHQUFxQixLQUFLaUQsWUFBTCxFQUFyQixHQUEyQyxLQUFLdkQsS0FBTCxDQUFXc0QsTUFBWCxDQUFrQixLQUFLRSxlQUF2QixDQUFsRDtBQUNEOztBQUVERCxFQUFBQSxZQUFZLEdBQUc7QUFDYixVQUFNRSxTQUFTLEdBQUcsNEJBQUcsd0JBQUgsRUFBNkI7QUFBQywwQ0FBb0MsS0FBS3pELEtBQUwsQ0FBVzBEO0FBQWhELEtBQTdCLENBQWxCO0FBRUEsV0FDRTtBQUFLLE1BQUEsU0FBUyxFQUFFRCxTQUFoQjtBQUEyQixNQUFBLEdBQUcsRUFBRSxLQUFLWixPQUFMLENBQWFjO0FBQTdDLE9BQ0csS0FBS0MsY0FBTCxFQURILEVBRUUsZ0NBQUMsMEJBQUQ7QUFDRSxNQUFBLE1BQU0sRUFBRSxLQUFLM0QsTUFEZjtBQUVFLE1BQUEsdUJBQXVCLEVBQUUsS0FGM0I7QUFHRSxNQUFBLFdBQVcsRUFBRSxJQUhmO0FBSUUsTUFBQSxVQUFVLEVBQUUsSUFKZDtBQUtFLE1BQUEsUUFBUSxFQUFFLEtBQUtELEtBQUwsQ0FBVzBELFNBTHZCO0FBTUUsTUFBQSxRQUFRLEVBQUUsS0FBS2Y7QUFOakIsTUFGRixFQVVFO0FBQVEsTUFBQSxTQUFTLEVBQUM7QUFBbEIsT0FDRTtBQUNFLE1BQUEsU0FBUyxFQUFDLCtDQURaO0FBRUUsTUFBQSxLQUFLLEVBQUMsd0JBRlI7QUFHRSxNQUFBLFFBQVEsRUFBRSxLQUFLM0MsS0FBTCxDQUFXMEQsU0FIdkI7QUFJRSxNQUFBLE9BQU8sRUFBRSxLQUFLRztBQUpoQixnQkFERixFQVFFO0FBQ0UsTUFBQSxTQUFTLEVBQUMsMERBRFo7QUFFRSxNQUFBLEtBQUssRUFBQyxnQkFGUjtBQUdFLE1BQUEsUUFBUSxFQUFFLEtBQUs3RCxLQUFMLENBQVcwRCxTQUh2QjtBQUlFLE1BQUEsT0FBTyxFQUFFLEtBQUtJO0FBSmhCLHdCQVJGLENBVkYsQ0FERjtBQTZCRDs7QUFFREYsRUFBQUEsY0FBYyxHQUFHO0FBQ2YsV0FDRSxnQ0FBQyxvQkFBRDtBQUFVLE1BQUEsUUFBUSxFQUFFLEtBQUs1RCxLQUFMLENBQVcrRCxRQUEvQjtBQUF5QyxNQUFBLE1BQU0sRUFBRSxLQUFLbEI7QUFBdEQsT0FDRSxnQ0FBQyxpQkFBRDtBQUFTLE1BQUEsT0FBTyxFQUFDLHVCQUFqQjtBQUF5QyxNQUFBLFFBQVEsRUFBRSxLQUFLaUI7QUFBeEQsTUFERixFQUVFLGdDQUFDLGlCQUFEO0FBQVMsTUFBQSxPQUFPLEVBQUMsYUFBakI7QUFBK0IsTUFBQSxRQUFRLEVBQUUsS0FBS0Q7QUFBOUMsTUFGRixDQURGO0FBTUQ7O0FBcEYrRDs7OztnQkFBN0NqRSxvQixlQUNBO0FBQ2pCO0FBQ0FPLEVBQUFBLGVBQWUsRUFBRTZELHNCQUFVQyxNQUFWLENBQWlCQyxVQUZqQjtBQUdqQlIsRUFBQUEsU0FBUyxFQUFFTSxzQkFBVUcsSUFISjtBQUtqQjtBQUNBSixFQUFBQSxRQUFRLEVBQUVDLHNCQUFVQyxNQUFWLENBQWlCQyxVQU5WO0FBT2pCMUQsRUFBQUEsT0FBTyxFQUFFd0Qsc0JBQVVJLElBQVYsQ0FBZUYsVUFQUDtBQVNqQjtBQUNBdEQsRUFBQUEsY0FBYyxFQUFFb0Qsc0JBQVVJLElBQVYsQ0FBZUYsVUFWZDtBQVdqQmxDLEVBQUFBLFVBQVUsRUFBRWdDLHNCQUFVSSxJQVhMO0FBWWpCakMsRUFBQUEsY0FBYyxFQUFFNkIsc0JBQVVJLElBWlQ7QUFjakI7QUFDQWQsRUFBQUEsTUFBTSxFQUFFVSxzQkFBVUksSUFBVixDQUFlRjtBQWZOLEM7O2dCQURBdEUsb0Isa0JBbUJHO0FBQ3BCb0MsRUFBQUEsVUFBVTtBQUFFO0FBQTJCLFFBQU0sSUFBSXZDLElBQUosRUFEekI7QUFFcEIwQyxFQUFBQSxjQUFjO0FBQUU7QUFBMkIsR0FBQyxHQUFHa0MsSUFBSixLQUFhLElBQUkzRSxRQUFKLENBQWEsR0FBRzJFLElBQWhCO0FBRnBDLEMiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20vb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQgY3ggZnJvbSAnY2xhc3NuYW1lcyc7XG5pbXBvcnQge3JlbW90ZSwgc2hlbGx9IGZyb20gJ2VsZWN0cm9uJztcbmltcG9ydCB7VGV4dEJ1ZmZlcn0gZnJvbSAnYXRvbSc7XG5pbXBvcnQgQXRvbVRleHRFZGl0b3IgZnJvbSAnLi4vYXRvbS9hdG9tLXRleHQtZWRpdG9yJztcbmltcG9ydCBSZWZIb2xkZXIgZnJvbSAnLi4vbW9kZWxzL3JlZi1ob2xkZXInO1xuaW1wb3J0IHthZGRFdmVudH0gZnJvbSAnLi4vcmVwb3J0ZXItcHJveHknO1xuaW1wb3J0IENvbW1hbmRzLCB7Q29tbWFuZH0gZnJvbSAnLi4vYXRvbS9jb21tYW5kcyc7XG5jb25zdCB7TWVudSwgTWVudUl0ZW19ID0gcmVtb3RlO1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBBY3Rpb25hYmxlUmV2aWV3VmlldyBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgLy8gTW9kZWxcbiAgICBvcmlnaW5hbENvbnRlbnQ6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICBpc1Bvc3Rpbmc6IFByb3BUeXBlcy5ib29sLFxuXG4gICAgLy8gQXRvbSBlbnZpcm9ubWVudFxuICAgIGNvbW1hbmRzOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAgY29uZmlybTogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcblxuICAgIC8vIEFjdGlvbiBtZXRob2RzXG4gICAgY29udGVudFVwZGF0ZXI6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgY3JlYXRlTWVudTogUHJvcFR5cGVzLmZ1bmMsXG4gICAgY3JlYXRlTWVudUl0ZW06IFByb3BUeXBlcy5mdW5jLFxuXG4gICAgLy8gUmVuZGVyIHByb3BcbiAgICByZW5kZXI6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gIH1cblxuICBzdGF0aWMgZGVmYXVsdFByb3BzID0ge1xuICAgIGNyZWF0ZU1lbnU6IC8qIGlzdGFuYnVsIGlnbm9yZSBuZXh0ICovICgpID0+IG5ldyBNZW51KCksXG4gICAgY3JlYXRlTWVudUl0ZW06IC8qIGlzdGFuYnVsIGlnbm9yZSBuZXh0ICovICguLi5hcmdzKSA9PiBuZXcgTWVudUl0ZW0oLi4uYXJncyksXG4gIH1cblxuICBjb25zdHJ1Y3Rvcihwcm9wcykge1xuICAgIHN1cGVyKHByb3BzKTtcbiAgICB0aGlzLnJlZkVkaXRvciA9IG5ldyBSZWZIb2xkZXIoKTtcbiAgICB0aGlzLnJlZlJvb3QgPSBuZXcgUmVmSG9sZGVyKCk7XG4gICAgdGhpcy5idWZmZXIgPSBuZXcgVGV4dEJ1ZmZlcigpO1xuICAgIHRoaXMuc3RhdGUgPSB7ZWRpdGluZzogZmFsc2V9O1xuICB9XG5cbiAgY29tcG9uZW50RGlkVXBkYXRlKHByZXZQcm9wcywgcHJldlN0YXRlKSB7XG4gICAgaWYgKHRoaXMuc3RhdGUuZWRpdGluZyAmJiAhcHJldlN0YXRlLmVkaXRpbmcpIHtcbiAgICAgIHRoaXMuYnVmZmVyLnNldFRleHQodGhpcy5wcm9wcy5vcmlnaW5hbENvbnRlbnQuYm9keSk7XG4gICAgICB0aGlzLnJlZkVkaXRvci5tYXAoZSA9PiBlLmdldEVsZW1lbnQoKS5mb2N1cygpKTtcbiAgICB9XG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMuc3RhdGUuZWRpdGluZyA/IHRoaXMucmVuZGVyRWRpdG9yKCkgOiB0aGlzLnByb3BzLnJlbmRlcih0aGlzLnNob3dBY3Rpb25zTWVudSk7XG4gIH1cblxuICByZW5kZXJFZGl0b3IoKSB7XG4gICAgY29uc3QgY2xhc3NOYW1lID0gY3goJ2dpdGh1Yi1SZXZpZXctZWRpdGFibGUnLCB7J2dpdGh1Yi1SZXZpZXctZWRpdGFibGUtLWRpc2FibGVkJzogdGhpcy5wcm9wcy5pc1Bvc3Rpbmd9KTtcblxuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IGNsYXNzTmFtZT17Y2xhc3NOYW1lfSByZWY9e3RoaXMucmVmUm9vdC5zZXR0ZXJ9PlxuICAgICAgICB7dGhpcy5yZW5kZXJDb21tYW5kcygpfVxuICAgICAgICA8QXRvbVRleHRFZGl0b3JcbiAgICAgICAgICBidWZmZXI9e3RoaXMuYnVmZmVyfVxuICAgICAgICAgIGxpbmVOdW1iZXJHdXR0ZXJWaXNpYmxlPXtmYWxzZX1cbiAgICAgICAgICBzb2Z0V3JhcHBlZD17dHJ1ZX1cbiAgICAgICAgICBhdXRvSGVpZ2h0PXt0cnVlfVxuICAgICAgICAgIHJlYWRPbmx5PXt0aGlzLnByb3BzLmlzUG9zdGluZ31cbiAgICAgICAgICByZWZNb2RlbD17dGhpcy5yZWZFZGl0b3J9XG4gICAgICAgIC8+XG4gICAgICAgIDxmb290ZXIgY2xhc3NOYW1lPVwiZ2l0aHViLVJldmlldy1lZGl0YWJsZS1mb290ZXJcIj5cbiAgICAgICAgICA8YnV0dG9uXG4gICAgICAgICAgICBjbGFzc05hbWU9XCJnaXRodWItUmV2aWV3LWVkaXRhYmxlQ2FuY2VsQnV0dG9uIGJ0biBidG4tc21cIlxuICAgICAgICAgICAgdGl0bGU9XCJDYW5jZWwgZWRpdGluZyBjb21tZW50XCJcbiAgICAgICAgICAgIGRpc2FibGVkPXt0aGlzLnByb3BzLmlzUG9zdGluZ31cbiAgICAgICAgICAgIG9uQ2xpY2s9e3RoaXMub25DYW5jZWx9PlxuICAgICAgICAgICAgQ2FuY2VsXG4gICAgICAgICAgPC9idXR0b24+XG4gICAgICAgICAgPGJ1dHRvblxuICAgICAgICAgICAgY2xhc3NOYW1lPVwiZ2l0aHViLVJldmlldy11cGRhdGVDb21tZW50QnV0dG9uIGJ0biBidG4tc20gYnRuLXByaW1hcnlcIlxuICAgICAgICAgICAgdGl0bGU9XCJVcGRhdGUgY29tbWVudFwiXG4gICAgICAgICAgICBkaXNhYmxlZD17dGhpcy5wcm9wcy5pc1Bvc3Rpbmd9XG4gICAgICAgICAgICBvbkNsaWNrPXt0aGlzLm9uU3VibWl0VXBkYXRlfT5cbiAgICAgICAgICAgIFVwZGF0ZSBjb21tZW50XG4gICAgICAgICAgPC9idXR0b24+XG4gICAgICAgIDwvZm9vdGVyPlxuICAgICAgPC9kaXY+XG4gICAgKTtcbiAgfVxuXG4gIHJlbmRlckNvbW1hbmRzKCkge1xuICAgIHJldHVybiAoXG4gICAgICA8Q29tbWFuZHMgcmVnaXN0cnk9e3RoaXMucHJvcHMuY29tbWFuZHN9IHRhcmdldD17dGhpcy5yZWZSb290fT5cbiAgICAgICAgPENvbW1hbmQgY29tbWFuZD1cImdpdGh1YjpzdWJtaXQtY29tbWVudFwiIGNhbGxiYWNrPXt0aGlzLm9uU3VibWl0VXBkYXRlfSAvPlxuICAgICAgICA8Q29tbWFuZCBjb21tYW5kPVwiY29yZTpjYW5jZWxcIiBjYWxsYmFjaz17dGhpcy5vbkNhbmNlbH0gLz5cbiAgICAgIDwvQ29tbWFuZHM+XG4gICAgKTtcbiAgfVxuXG4gIG9uQ2FuY2VsID0gKCkgPT4ge1xuICAgIGlmICh0aGlzLmJ1ZmZlci5nZXRUZXh0KCkgPT09IHRoaXMucHJvcHMub3JpZ2luYWxDb250ZW50LmJvZHkpIHtcbiAgICAgIHRoaXMuc2V0U3RhdGUoe2VkaXRpbmc6IGZhbHNlfSk7XG4gICAgfSBlbHNlIHtcbiAgICAgIGNvbnN0IGNob2ljZSA9IHRoaXMucHJvcHMuY29uZmlybSh7XG4gICAgICAgIG1lc3NhZ2U6ICdBcmUgeW91IHN1cmUgeW91IHdhbnQgdG8gZGlzY2FyZCB5b3VyIHVuc2F2ZWQgY2hhbmdlcz8nLFxuICAgICAgICBidXR0b25zOiBbJ09LJywgJ0NhbmNlbCddLFxuICAgICAgfSk7XG4gICAgICBpZiAoY2hvaWNlID09PSAwKSB7XG4gICAgICAgIHRoaXMuc2V0U3RhdGUoe2VkaXRpbmc6IGZhbHNlfSk7XG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgb25TdWJtaXRVcGRhdGUgPSBhc3luYyAoKSA9PiB7XG4gICAgY29uc3QgdGV4dCA9IHRoaXMuYnVmZmVyLmdldFRleHQoKTtcbiAgICBpZiAodGV4dCA9PT0gdGhpcy5wcm9wcy5vcmlnaW5hbENvbnRlbnQuYm9keSB8fCB0ZXh0ID09PSAnJykge1xuICAgICAgdGhpcy5zZXRTdGF0ZSh7ZWRpdGluZzogZmFsc2V9KTtcbiAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICB0cnkge1xuICAgICAgYXdhaXQgdGhpcy5wcm9wcy5jb250ZW50VXBkYXRlcih0aGlzLnByb3BzLm9yaWdpbmFsQ29udGVudC5pZCwgdGV4dCk7XG4gICAgICB0aGlzLnNldFN0YXRlKHtlZGl0aW5nOiBmYWxzZX0pO1xuICAgIH0gY2F0Y2ggKGUpIHtcbiAgICAgIHRoaXMuYnVmZmVyLnNldFRleHQodGV4dCk7XG4gICAgfVxuICB9XG5cbiAgcmVwb3J0QWJ1c2UgPSAoY29tbWVudFVybCwgYXV0aG9yKSA9PiB7XG4gICAgcmV0dXJuIG5ldyBQcm9taXNlKChyZXNvbHZlLCByZWplY3QpID0+IHtcbiAgICAgIGNvbnN0IHVybCA9ICdodHRwczovL2dpdGh1Yi5jb20vY29udGFjdC9yZXBvcnQtY29udGVudD9yZXBvcnQ9JyArXG4gICAgICAgIGAke2VuY29kZVVSSUNvbXBvbmVudChhdXRob3IpfSZjb250ZW50X3VybD0ke2VuY29kZVVSSUNvbXBvbmVudChjb21tZW50VXJsKX1gO1xuICAgICAgc2hlbGwub3BlbkV4dGVybmFsKHVybCwge30sIGVyciA9PiB7XG4gICAgICAgIGlmIChlcnIpIHsgcmVqZWN0KGVycik7IH0gZWxzZSB7XG4gICAgICAgICAgcmVzb2x2ZSgpO1xuICAgICAgICAgIGFkZEV2ZW50KCdyZXBvcnQtYWJ1c2UnLCB7cGFja2FnZTogJ2dpdGh1YicsIGNvbXBvbmVudDogdGhpcy5jb25zdHJ1Y3Rvci5uYW1lfSk7XG4gICAgICAgIH1cbiAgICAgIH0pO1xuICAgIH0pO1xuICB9XG5cbiAgb3Blbk9uR2l0SHViID0gdXJsID0+IHtcbiAgICByZXR1cm4gbmV3IFByb21pc2UoKHJlc29sdmUsIHJlamVjdCkgPT4ge1xuICAgICAgc2hlbGwub3BlbkV4dGVybmFsKHVybCwge30sIGVyciA9PiB7XG4gICAgICAgIGlmIChlcnIpIHsgcmVqZWN0KGVycik7IH0gZWxzZSB7XG4gICAgICAgICAgcmVzb2x2ZSgpO1xuICAgICAgICAgIGFkZEV2ZW50KCdvcGVuLWNvbW1lbnQtaW4tYnJvd3NlcicsIHtwYWNrYWdlOiAnZ2l0aHViJywgY29tcG9uZW50OiB0aGlzLmNvbnN0cnVjdG9yLm5hbWV9KTtcbiAgICAgICAgfVxuICAgICAgfSk7XG4gICAgfSk7XG4gIH1cblxuICBzaG93QWN0aW9uc01lbnUgPSAoZXZlbnQsIGNvbnRlbnQsIGF1dGhvcikgPT4ge1xuICAgIGV2ZW50LnByZXZlbnREZWZhdWx0KCk7XG5cbiAgICBjb25zdCBtZW51ID0gdGhpcy5wcm9wcy5jcmVhdGVNZW51KCk7XG5cbiAgICBpZiAoY29udGVudC52aWV3ZXJDYW5VcGRhdGUpIHtcbiAgICAgIG1lbnUuYXBwZW5kKHRoaXMucHJvcHMuY3JlYXRlTWVudUl0ZW0oe1xuICAgICAgICBsYWJlbDogJ0VkaXQnLFxuICAgICAgICBjbGljazogKCkgPT4gdGhpcy5zZXRTdGF0ZSh7ZWRpdGluZzogdHJ1ZX0pLFxuICAgICAgfSkpO1xuICAgIH1cblxuICAgIG1lbnUuYXBwZW5kKHRoaXMucHJvcHMuY3JlYXRlTWVudUl0ZW0oe1xuICAgICAgbGFiZWw6ICdPcGVuIG9uIEdpdEh1YicsXG4gICAgICBjbGljazogKCkgPT4gdGhpcy5vcGVuT25HaXRIdWIoY29udGVudC51cmwpLFxuICAgIH0pKTtcblxuICAgIG1lbnUuYXBwZW5kKHRoaXMucHJvcHMuY3JlYXRlTWVudUl0ZW0oe1xuICAgICAgbGFiZWw6ICdSZXBvcnQgYWJ1c2UnLFxuICAgICAgY2xpY2s6ICgpID0+IHRoaXMucmVwb3J0QWJ1c2UoY29udGVudC51cmwsIGF1dGhvci5sb2dpbiksXG4gICAgfSkpO1xuXG4gICAgbWVudS5wb3B1cChyZW1vdGUuZ2V0Q3VycmVudFdpbmRvdygpKTtcbiAgfVxufVxuIl19